set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '43143320',
      62.504111,
      11,
      '1333442',
      1,
      NULL,
      3,
      '04140',
      0.318069,
      '11-17-1993',
      36.084527,
      NULL,
      0,
      3,
      0.749593,
      NULL,
      1.397952,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      NULL,
      3.945109,
      NULL,
      1.040136,
      70,
      12,
      2.342260,
      1.267682,
      NULL,
      NULL,
      3,
      0,
      3.894259,
      NULL,
      NULL,
      1,
      2,
      1,
      3,
      0,
      1,
      0,
      1,
      3,
      2,
      5,
      NULL,
      5,
      1.726300,
      5,
      2,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      1,
      5.323705,
      7.812700,
      8,
      1.314676,
      4,
      NULL,
      9,
      0.249167,
      NULL,
      2.349547,
      NULL,
      NULL,
      4,
      1.658740,
      NULL,
      4,
      NULL,
      0,
      NULL,
      3,
      12.445342,
      226,
      247.962955,
      0,
      5.607172,
      342,
      98.998688,
      0,
      3.551207,
      NULL,
      39,
      NULL,
      3.483526,
      400.411991,
      NULL,
      1.571870,
      1.023412,
      NULL,
      13,
      1.217745,
      2.518489,
      169.254573,
      10.198229,
      2,
      4,
      13.607355,
      9,
      3.796568,
      2.572147,
      NULL,
      NULL,
      0,
      6,
      210.591570,
      40.958166,
      2,
      NULL,
      238.265952,
      12.319030,
      1,
      NULL,
      44,
      0.380021,
      NULL,
      6.079937,
      228,
      3,
      NULL,
      NULL,
      590,
      32.442649,
      3.278368,
      2.764294,
      NULL,
      2.188034,
      3.560920,
      2,
      836.334023,
      2.277574,
      2.324371,
      1,
      39,
      157,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.990021,
      '01030',
      '14003',
      '',
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5,
      0,
      35,
      1.396980,
      NULL,
      0.594768,
      NULL,
      NULL,
      NULL,
      0,
      2.915240,
      1,
      NULL,
      1.376586,
      78,
      1.908005,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      9.072168,
      3.744037,
      7,
      21.332132,
      6.420978,
      0,
      NULL,
      21,
      1.933150,
      4,
      1.030303,
      2.354373,
      9.217109,
      3,
      1,
      8,
      9,
      NULL,
      2,
      4,
      14,
      6.352975,
      12.203455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      NULL,
      2.431730,
      16,
      NULL,
      4,
      NULL,
      16.746197,
      8,
      25.323878,
      NULL,
      19,
      18.697340,
      14,
      0.411648,
      10,
      NULL,
      18,
      4.510147,
      10.435379,
      13.349683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      123,
      107,
      NULL,
      183.520420,
      NULL,
      43.136776,
      NULL,
      152,
      1,
      0,
      0,
      NULL,
      0.250678,
      1.251581,
      1.579663,
      0,
      0.788578,
      0,
      3,
      1,
      1,
      2.618740,
      1.320882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572898,
      0,
      1,
      NULL,
      NULL,
      1.563268,
      1,
      4,
      6,
      6,
      4.159080,
      NULL,
      1.992342,
      6.308580,
      3.769403,
      7,
      7,
      NULL,
      5.554163,
      NULL,
      5.936298,
      2.822518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.320447,
      2,
      5,
      0.320908,
      5.863356,
      NULL,
      1.104212,
      NULL,
      7.087964,
      3,
      3.084145,
      NULL,
      4,
      5,
      2.946369,
      0,
      2,
      3.367005,
      4,
      5,
      7.770480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454075,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.490059,
      0,
      0.747310,
      1,
      0,
      1,
      NULL,
      0.074036,
      0,
      NULL,
      1,
      1.277576,
      0,
      NULL,
      0.652047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143118,
      1.617617,
      0.931936,
      1,
      0,
      0.426727,
      1.202074,
      1.762562,
      7.863251,
      4.071023,
      0,
      0.719483,
      2.691922,
      0,
      0.734644,
      0,
      2,
      1,
      0,
      1.587740,
      0.299459,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.447370,
      0.021981,
      0,
      1,
      0,
      0,
      0.332709,
      NULL,
      1.328689,
      1,
      0.004871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.919831,
      3,
      4,
      3,
      0.624628,
      0.708227,
      8,
      3.401460,
      3,
      NULL,
      7,
      0,
      4.840148,
      3.900842,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0.710659,
      6.716958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206920,
      NULL,
      NULL,
      NULL,
      1.468831,
      5.218776,
      NULL,
      6,
      3,
      NULL,
      NULL,
      6,
      NULL,
      5,
      4,
      3,
      NULL,
      2.511557,
      9.359089,
      5.048509,
      3,
      0.986371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.443672,
      0,
      1.368234,
      1,
      2.550862,
      2,
      NULL,
      3.271184,
      6.312890,
      0,
      0,
      NULL,
      NULL,
      2.356306,
      6,
      1,
      2.635565,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269929,
      0.720591,
      0,
      1,
      1.849243,
      0,
      NULL,
      5.891805,
      2.088303,
      1.711053,
      1.798783,
      0,
      4,
      1,
      NULL,
      NULL,
      4,
      1.175931,
      2.958042,
      7,
      2,
      4.316976,
      1.935435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717091,
      NULL,
      1.498439,
      NULL,
      0,
      1,
      1,
      1.835945,
      1.772961,
      0,
      0,
      1.249292,
      0.742584,
      1,
      NULL,
      0,
      1,
      0.444325,
      1.081482,
      0,
      0,
      0.427012,
      1.347640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.422340,
      NULL,
      1.894771,
      1,
      0,
      0.967852,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1.269119,
      0,
      1,
      0.770509,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      2.415261,
      2.864677,
      5,
      NULL,
      1,
      3.401558,
      0.381620,
      0,
      1.036780,
      2.154434,
      1.122279,
      2,
      3,
      2,
      0,
      2.474271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.406472,
      0.417600,
      NULL,
      1,
      NULL,
      4.041326,
      5.959804,
      2.273297,
      NULL,
      3.360733,
      4.061463,
      3,
      3,
      1,
      NULL,
      3,
      NULL,
      1,
      2,
      2.485344,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.490755,
      NULL,
      2,
      5.222361,
      4.999157,
      1.820013,
      NULL,
      NULL,
      6.763778,
      4.719182,
      0,
      4,
      NULL,
      NULL,
      6.436700,
      4.514015,
      0.599792,
      1,
      6,
      9.641809,
      4,
      5.056507,
      6.274631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029131,
      0.479404,
      2.015561,
      3.766592,
      2,
      2,
      0,
      4.156553,
      8.686014,
      6,
      1.101101,
      1.764633,
      6,
      0,
      7,
      2,
      5.976094,
      3.702564,
      8,
      3,
      NULL,
      6.954133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.357718,
      1.266821,
      0.208108,
      NULL,
      1.849433,
      0.207520,
      0.685920,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.827562,
      0.468422,
      1,
      0.609569,
      0.995884,
      1.887283,
      1,
      0,
      1.412424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981382,
      0,
      1,
      1.075742,
      NULL,
      NULL,
      4,
      5.872932,
      6,
      3,
      5,
      3.092302,
      4.432612,
      2,
      3,
      3,
      1.486059,
      NULL,
      2,
      NULL,
      4.966803,
      3.063242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      4,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      2,
      2,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      5,
      3,
      2,
      NULL,
      4,
      NULL,
      5,
      1,
      5,
      NULL,
      4,
      2,
      4,
      1,
      2,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-1982',
      NULL,
      ' 7-14-1976',
      ' 1-13-2002',
      ' 8- 9-1982',
      '10-23-2000',
      ' 2- 8-2000',
      ' 0- 0-2000',
      ' 3-20-1983',
      ' 0-29-1975',
      '11-22-2003',
      ' 0-28-1976',
      NULL,
      ' 5- 0-1998',
      NULL,
      NULL,
      ' 9- 3-1999',
      ' 9- 6-1990',
      ' 5- 7-1983',
      ' 2-23-1994',
      '11- 1-1982',
      '11-15-1993',
      ' 8- 5-2002',
      ' 0-10-1985',
      ' 5- 6-1995',
      NULL,
      ' 6-26-1978',
      ' 6-21-1990',
      ' 8-21-1994',
      ' 6-25-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-18-2001',
      NULL,
      ' 9-11-1991',
      ' 0-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877357);
commit;
end;
/


