set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41100203',
      0.565247,
      37.912034,
      '0432123',
      6,
      0.009023,
      NULL,
      '31422',
      0.403449,
      ' 6-28-1991',
      90.953178,
      NULL,
      1,
      0,
      NULL,
      1.044920,
      1.927977,
      0,
      0,
      2.622176,
      3,
      1.745883,
      NULL,
      9,
      NULL,
      NULL,
      2.751123,
      NULL,
      0,
      54,
      NULL,
      8,
      0.000710,
      NULL,
      NULL,
      NULL,
      1.736240,
      2,
      NULL,
      NULL,
      4,
      2,
      1,
      3,
      0,
      5,
      0,
      0,
      NULL,
      0,
      1,
      0,
      4,
      NULL,
      6,
      2.017149,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      0,
      NULL,
      1.733601,
      5,
      6,
      4.658611,
      0,
      NULL,
      2,
      5.885507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      40.992111,
      219,
      5.453870,
      2,
      2.255362,
      1322,
      13,
      NULL,
      3,
      138,
      108,
      3,
      0.353777,
      120,
      21.339502,
      0.535467,
      3,
      48.961525,
      268.000883,
      0.326911,
      2,
      NULL,
      393,
      3,
      3.399409,
      200,
      NULL,
      1.229196,
      5.205163,
      45.124098,
      128.066578,
      NULL,
      1,
      206,
      9,
      NULL,
      0,
      117.204194,
      12.532339,
      1,
      NULL,
      150.907482,
      16,
      3,
      NULL,
      162.794755,
      4,
      3,
      2.635949,
      139,
      23.943352,
      0.094620,
      0.711779,
      31,
      1.895400,
      2,
      2.878630,
      71.792340,
      NULL,
      1.535793,
      6,
      106.686995,
      1,
      2,
      NULL,
      54,
      21,
      1.454481,
      2,
      NULL,
      22.990915,
      NULL,
      3,
      280,
      46.684475,
      NULL,
      NULL,
      578,
      3.259761,
      NULL,
      NULL,
      72,
      6.938684,
      0.099071,
      3,
      NULL,
      17,
      3.698620,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '14202',
      NULL,
      '',
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      1.683730,
      '',
      '',
      '',
      0,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.439534,
      NULL,
      0.491348,
      NULL,
      0,
      NULL,
      0.935925,
      NULL,
      1,
      NULL,
      0,
      NULL,
      '11-19-1991',
      NULL,
      11,
      NULL,
      4.930109,
      15,
      4.332355,
      20.624895,
      NULL,
      NULL,
      16.305273,
      9,
      NULL,
      24.035449,
      2.108086,
      0,
      3.711898,
      7.424056,
      1.025298,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4.377950,
      NULL,
      1,
      3.881302,
      3.673888,
      0.053564,
      5,
      4.172193,
      NULL,
      1,
      0,
      NULL,
      14.185412,
      2,
      14,
      14.810028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.611060,
      NULL,
      16.436480,
      NULL,
      18.065036,
      15.686750,
      21.828154,
      2.240094,
      54,
      34.536125,
      NULL,
      22,
      11.280315,
      NULL,
      15.065578,
      3.463976,
      NULL,
      2,
      18,
      4.301772,
      NULL,
      6,
      0,
      14,
      6,
      4.292289,
      NULL,
      9,
      NULL,
      NULL,
      4,
      19.747209,
      9.844203,
      45.429348,
      NULL,
      33,
      29,
      NULL,
      NULL,
      0.702287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      112,
      179.306847,
      32,
      173,
      129.697944,
      0,
      NULL,
      161,
      36,
      66,
      33,
      173.301780,
      184,
      161.209692,
      150,
      164,
      NULL,
      37,
      NULL,
      12.436555,
      101,
      NULL,
      NULL,
      56,
      158.428370,
      41,
      126.698990,
      7,
      190.908917,
      158.743907,
      163.079629,
      NULL,
      172.313847,
      49,
      125,
      23,
      128,
      128,
      8.444765,
      146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.389730,
      4.542261,
      0,
      4.370052,
      4,
      2,
      0.361857,
      0.999484,
      5.943925,
      4,
      5.741265,
      NULL,
      3.700492,
      2.657187,
      3,
      5.025820,
      3.610841,
      NULL,
      4,
      1,
      2.033596,
      1.655486,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      1.390812,
      0.367163,
      0.406899,
      0.353656,
      0.537939,
      1,
      5,
      4,
      4.992814,
      0.801332,
      1.137082,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.059077,
      0.425774,
      1,
      NULL,
      0,
      1,
      2,
      0,
      4,
      0,
      NULL,
      NULL,
      3.739669,
      5.351733,
      0,
      0,
      NULL,
      3.401379,
      3.796392,
      1,
      0.280580,
      1,
      0.802444,
      1.191941,
      1.108647,
      2.763779,
      4,
      5.720654,
      3,
      1,
      2,
      2.886844,
      2,
      2,
      3.567455,
      0.870545,
      1.294243,
      3.587384,
      1.694984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.363930,
      9.226403,
      2,
      1,
      NULL,
      1.424947,
      3,
      NULL,
      NULL,
      NULL,
      5,
      3,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.363088,
      0,
      0,
      0.733392,
      NULL,
      1.329994,
      0.048021,
      1.524187,
      0,
      0.771138,
      1,
      1.259512,
      1,
      1,
      0,
      0.577869,
      0,
      0.082507,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439740,
      0.635245,
      NULL,
      5.715117,
      NULL,
      1.698215,
      0,
      0,
      NULL,
      NULL,
      2.587702,
      1.223849,
      0.311443,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.786942,
      1.583225,
      NULL,
      0,
      NULL,
      0.288943,
      1.408621,
      1,
      0.509306,
      NULL,
      0.303095,
      1,
      NULL,
      NULL,
      0,
      1.284864,
      0,
      1.064626,
      1.085353,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.288775,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1.958332,
      NULL,
      0.374538,
      NULL,
      0,
      0,
      0,
      1.052935,
      0.596355,
      1,
      1,
      0.691168,
      0.255016,
      3.079054,
      0.086137,
      0,
      4.024927,
      NULL,
      3,
      4,
      3.440891,
      2.459365,
      2,
      0,
      NULL,
      4.265213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980729,
      3,
      NULL,
      3.302932,
      7.167673,
      6,
      7,
      2.676418,
      7,
      3.408362,
      0,
      6,
      7,
      1,
      6.070087,
      0.979895,
      3,
      4,
      0.517047,
      5.830442,
      3.835857,
      0.752310,
      0.444493,
      3.604896,
      NULL,
      2.875102,
      NULL,
      3,
      5.435677,
      NULL,
      2.892389,
      7.468706,
      NULL,
      2,
      2.624914,
      NULL,
      3,
      NULL,
      0.937980,
      5.600582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.217170,
      2,
      3,
      5.716518,
      NULL,
      3.222673,
      NULL,
      3.542254,
      2,
      1,
      NULL,
      3,
      9.529837,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      4,
      3.221384,
      NULL,
      NULL,
      5.254034,
      7.841735,
      3,
      1.143339,
      9,
      5,
      NULL,
      NULL,
      2,
      3,
      1,
      3,
      1.805831,
      0,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.232843,
      NULL,
      1.775367,
      NULL,
      0.780007,
      1.334433,
      2.523011,
      0.732151,
      0,
      1,
      1,
      0.763979,
      3,
      1.758767,
      1.267549,
      1,
      0,
      1,
      0.673078,
      0.507903,
      3,
      NULL,
      0.520178,
      2,
      3.030618,
      4.803652,
      3,
      NULL,
      NULL,
      2.033952,
      5,
      2.384989,
      1.374632,
      4.850904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.880635,
      0.533333,
      1.262606,
      0.752401,
      NULL,
      1.438137,
      2,
      3,
      1.468280,
      1.399856,
      NULL,
      1,
      0,
      0.931040,
      1.548704,
      1,
      1,
      NULL,
      1.202942,
      1,
      0,
      3,
      0,
      0,
      2,
      1.702951,
      2.905024,
      1.935256,
      0.986501,
      NULL,
      3.573403,
      NULL,
      NULL,
      3.953460,
      1.992263,
      1.850388,
      1.347362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180144,
      1.301640,
      1,
      0.795020,
      3.209033,
      4.299118,
      0.135688,
      0,
      0.017614,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1.027086,
      1,
      0.849136,
      NULL,
      NULL,
      1,
      1.215998,
      0.433352,
      0,
      1,
      0,
      NULL,
      NULL,
      1.826257,
      1,
      2,
      3.987374,
      2,
      NULL,
      3,
      1,
      1.664403,
      NULL,
      1.043159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.655214,
      1,
      1,
      1.160577,
      NULL,
      0.849263,
      1.538648,
      NULL,
      0.332451,
      NULL,
      0.306108,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.625719,
      1,
      1,
      1.129573,
      1,
      NULL,
      0,
      0,
      0,
      0.343580,
      1.504815,
      1.781102,
      1.113522,
      0.444132,
      0.575743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453661,
      NULL,
      1.617255,
      2,
      5.208960,
      1.607245,
      NULL,
      2.921951,
      3,
      5.176050,
      3,
      3,
      1.308743,
      3.664346,
      0,
      0,
      3.973379,
      NULL,
      1.886471,
      2.341043,
      0.440084,
      0.688379,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.735855,
      3.218297,
      3,
      3,
      1,
      1,
      1.093505,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.685073,
      2.133851,
      3,
      2.044149,
      1.731921,
      1,
      4.210344,
      4.879080,
      5.184313,
      4,
      1.584259,
      NULL,
      2,
      2,
      5,
      0,
      NULL,
      2,
      2.268859,
      0,
      2,
      0,
      NULL,
      0,
      3.684290,
      NULL,
      0.761502,
      5.389740,
      NULL,
      4,
      4,
      2,
      1,
      1.789564,
      2.598850,
      4.554813,
      4.721131,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.843279,
      5,
      2,
      NULL,
      4.895399,
      0.018156,
      3,
      0,
      6,
      6.979190,
      NULL,
      0.470289,
      3,
      0.713424,
      5,
      0.031961,
      0.456460,
      4.116105,
      5.396846,
      4,
      3,
      0,
      3.185335,
      0,
      0,
      0.276560,
      1,
      5,
      2.695448,
      3,
      0.904580,
      0,
      2,
      2,
      4,
      NULL,
      0.213637,
      5.063562,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.514537,
      1,
      6.815914,
      1.491596,
      6,
      1.837038,
      3,
      3,
      NULL,
      2,
      NULL,
      7.736271,
      NULL,
      7.843373,
      1,
      4,
      NULL,
      3.705722,
      NULL,
      NULL,
      0.642652,
      4,
      4.278354,
      3,
      2.335884,
      4,
      0.173689,
      NULL,
      5,
      NULL,
      5,
      NULL,
      2.207530,
      0,
      5,
      1,
      1,
      0.320613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655551,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1.865340,
      0,
      NULL,
      0,
      1.986522,
      1.976602,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1.450358,
      0,
      NULL,
      NULL,
      0.875462,
      1,
      1.738544,
      1.155172,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.616158,
      5.760303,
      5.504043,
      1,
      0.172585,
      2,
      NULL,
      NULL,
      0,
      4,
      5.508721,
      3.015094,
      NULL,
      3.802913,
      3,
      2.516685,
      NULL,
      1.063429,
      2,
      3.642438,
      1,
      2,
      3.353815,
      0.744579,
      0.991642,
      1.576096,
      2,
      2,
      5.267476,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      0,
      0,
      1,
      3,
      5,
      0,
      0,
      3,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      5,
      5,
      2,
      5,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      3,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      NULL,
      0,
      1,
      1,
      2,
      3,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      2,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      7,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1,
      1,
      3,
      3,
      3,
      2,
      0,
      4,
      NULL,
      0,
      4,
      3,
      2,
      2,
      NULL,
      3,
      3,
      2,
      6,
      0,
      4,
      5,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-16-1977',
      ' 4- 4-1999',
      '10-11-1996',
      ' 0-12-1994',
      ' 6-25-1995',
      ' 7- 4-1997',
      ' 1-19-1974',
      ' 9-22-2001',
      ' 6-24-1985',
      ' 8- 5-1989',
      ' 2- 9-1994',
      ' 0- 9-1993',
      ' 8-15-1992',
      ' 6-21-1993',
      ' 6- 8-1995',
      ' 1-16-2003',
      ' 9- 5-1991',
      ' 7- 4-1999',
      ' 2- 9-1994',
      NULL,
      ' 4- 3-1977',
      ' 4-24-1983',
      '10-23-1991',
      NULL,
      '11-24-1977',
      ' 9- 4-2001',
      ' 0-12-1974',
      ' 4-29-1986',
      ' 2- 5-1991',
      NULL,
      NULL,
      '10-10-1995',
      ' 2-17-1995',
      ' 7-10-1974',
      '11- 7-1980',
      NULL,
      ' 8-29-2000',
      NULL,
      ' 7-21-1982',
      '11- 2-1995',
      NULL,
      ' 7-16-1989',
      ' 7- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 8-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652091);
commit;
end;
/


