set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '3244022',
      3,
      2.775238,
      1,
      '11210',
      2,
      ' 3- 3-1977',
      32,
      NULL,
      0.963422,
      0,
      0.804179,
      0,
      1,
      1,
      0.368417,
      0,
      0.169995,
      0,
      1,
      5,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058220,
      NULL,
      NULL,
      2.777950,
      0,
      1,
      NULL,
      NULL,
      2,
      5,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      8,
      1.580758,
      3,
      5.942741,
      0,
      0.427080,
      1.287003,
      NULL,
      1.893046,
      NULL,
      8,
      12,
      18,
      NULL,
      NULL,
      3.410443,
      5,
      NULL,
      0,
      3.388083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      15.620137,
      NULL,
      0.808470,
      0,
      2.363369,
      61,
      3.058134,
      NULL,
      2,
      155,
      4.040117,
      1,
      1,
      4.628822,
      3.905785,
      3,
      0.156203,
      29,
      2,
      NULL,
      4,
      193.149242,
      2.818457,
      3.216473,
      3.039591,
      NULL,
      NULL,
      3,
      5.331419,
      214.790652,
      NULL,
      1,
      2.752264,
      370,
      NULL,
      NULL,
      0,
      46,
      NULL,
      0.478480,
      2.772970,
      943,
      14.692040,
      2.855519,
      0,
      211,
      25.226643,
      2.355482,
      3.053423,
      224.625998,
      1,
      3.555949,
      3.077750,
      118.209667,
      15,
      1.692637,
      9.975313,
      NULL,
      37.431945,
      0.876325,
      2,
      140,
      NULL,
      1.829100,
      5,
      172,
      NULL,
      NULL,
      0,
      180,
      37,
      3.859755,
      NULL,
      157.244721,
      32.669919,
      0.940276,
      3,
      NULL,
      34,
      2,
      3.461093,
      43,
      2.005415,
      0,
      0.871273,
      1.088315,
      NULL,
      0.772020,
      4.754991,
      392,
      151.774598,
      3,
      8.906489,
      40.535797,
      NULL,
      NULL,
      2.065107,
      NULL,
      NULL,
      1.794663,
      4,
      75.923516,
      87,
      2.361771,
      2.580481,
      43.111600,
      35,
      NULL,
      2,
      808.529719,
      NULL,
      0,
      0,
      61.935591,
      83,
      0.434942,
      1,
      142,
      NULL,
      NULL,
      NULL,
      NULL,
      177.936829,
      0.840958,
      NULL,
      96.789353,
      156.948451,
      3,
      0.128231,
      163.103610,
      NULL,
      1.237001,
      1,
      133,
      152,
      1.210078,
      6.881881,
      NULL,
      332,
      NULL,
      4.182613,
      139,
      417,
      1,
      NULL,
      NULL,
      NULL,
      1.411712,
      NULL,
      185,
      630.058868,
      1.163506,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.124755,
      '03130',
      '10342',
      '',
      '',
      NULL,
      NULL,
      1.161329,
      '',
      '',
      NULL,
      1.346349,
      '',
      '',
      NULL,
      5,
      1.383645,
      NULL,
      0,
      2454.187530,
      NULL,
      NULL,
      1.564831,
      NULL,
      1.698484,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      438,
      NULL,
      NULL,
      ' 4- 4-1983',
      2,
      NULL,
      6,
      2.061990,
      15.756994,
      6,
      NULL,
      0,
      2.824819,
      NULL,
      3.241154,
      0.089094,
      8,
      11,
      7,
      1.709983,
      NULL,
      6.489781,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2,
      52.769055,
      3,
      3.048249,
      8,
      23.536609,
      28.267204,
      8.337421,
      2,
      3,
      NULL,
      44.795414,
      NULL,
      NULL,
      12,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104,
      21,
      23,
      NULL,
      59.496938,
      92.328877,
      132.032903,
      10.089855,
      108,
      5,
      NULL,
      NULL,
      43,
      5,
      44.553134,
      121,
      NULL,
      150.025595,
      107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.611071,
      NULL,
      NULL,
      7.199136,
      6,
      1,
      7,
      3,
      0,
      3,
      2.121009,
      4.392281,
      0,
      4,
      1.947307,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      2.630127,
      NULL,
      NULL,
      1.045829,
      0,
      2.050062,
      4,
      5,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.912290,
      2.116964,
      1,
      5,
      NULL,
      8.501495,
      0,
      1.810390,
      0.324803,
      3.502495,
      5,
      1.243397,
      0,
      NULL,
      5.836966,
      6.509026,
      1.809527,
      0,
      2.853022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438685,
      NULL,
      1,
      2.030440,
      5.855030,
      1,
      3,
      7.400572,
      4,
      3.774165,
      9,
      NULL,
      NULL,
      6.604416,
      1,
      6.215485,
      NULL,
      3,
      9.454038,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.651901,
      5.602861,
      NULL,
      8.661817,
      2.195160,
      2.763658,
      NULL,
      5,
      5,
      6,
      NULL,
      7.563822,
      7,
      3.256306,
      4.930985,
      NULL,
      NULL,
      5.969682,
      7.856678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.630437,
      4,
      3,
      5.494555,
      1,
      0,
      0,
      1,
      6.913859,
      4.468477,
      5.960304,
      0.808401,
      8.419638,
      5.505441,
      2.989151,
      9.007506,
      0,
      7,
      9,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      7,
      NULL,
      NULL,
      3.479455,
      7,
      0,
      7,
      0.524447,
      3.149139,
      0.560995,
      NULL,
      NULL,
      1.575136,
      3.800218,
      2.660919,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      5,
      2,
      NULL,
      4.475124,
      5,
      2.430561,
      4,
      2.414587,
      6,
      5,
      7,
      NULL,
      5,
      2.206275,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.856683,
      0.261879,
      NULL,
      4,
      NULL,
      5.647509,
      NULL,
      0,
      5,
      4,
      6,
      3.314172,
      7,
      7.402314,
      NULL,
      2,
      6.023306,
      7,
      5.499934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824349,
      1.859375,
      NULL,
      1.377264,
      0,
      NULL,
      0.358584,
      1.652045,
      7.903737,
      NULL,
      2.835042,
      5,
      1,
      0,
      5,
      NULL,
      5.079379,
      NULL,
      0.864004,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.975782,
      NULL,
      0,
      0,
      1.572089,
      1,
      NULL,
      0.393432,
      1.935261,
      1.367043,
      1,
      1.290754,
      1.148368,
      1,
      1.318564,
      1.232877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.859768,
      NULL,
      1.019450,
      0.386037,
      1.494493,
      1,
      0,
      0.441533,
      1.362031,
      0.485137,
      0.657848,
      0,
      1,
      0,
      1.920145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966885,
      0,
      NULL,
      1,
      NULL,
      1.981230,
      0.623504,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0.013329,
      NULL,
      NULL,
      1.045287,
      0.605219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.654346,
      6,
      2.949118,
      NULL,
      NULL,
      0.931911,
      0,
      5.854923,
      4,
      5,
      NULL,
      7,
      2.237001,
      NULL,
      3,
      9,
      0.610487,
      6,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351912,
      2,
      0,
      NULL,
      0.127045,
      7.806979,
      4.757591,
      NULL,
      6,
      4,
      1.826183,
      9,
      NULL,
      4.385829,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157490,
      1.852508,
      1,
      0,
      0,
      0.460536,
      0.612490,
      0.852092,
      1,
      1.059613,
      NULL,
      1.532862,
      0,
      0.484164,
      0.902925,
      NULL,
      NULL,
      1,
      NULL,
      1.227530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562028,
      1,
      1,
      1.575103,
      NULL,
      NULL,
      0,
      1,
      1.208060,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.510359,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      2,
      1,
      3,
      1,
      3,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      5,
      1,
      0,
      1,
      3,
      3,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-13-1990',
      ' 5- 1-1997',
      NULL,
      ' 5- 1-2002',
      NULL,
      ' 4- 4-1988',
      ' 4-27-1980',
      NULL,
      ' 3-15-1986',
      NULL,
      ' 8-23-2000',
      ' 8- 1-1977',
      NULL,
      ' 3-20-1994',
      ' 0-21-1994',
      ' 5-13-1974',
      '10-28-1983',
      ' 0-20-1990',
      '10- 4-1982',
      ' 1-18-1993',
      ' 5-22-1985',
      ' 5-13-1998',
      ' 8-24-1992',
      '10-15-1998',
      ' 7- 2-1991',
      ' 7-25-1991',
      ' 9- 5-1999',
      ' 2-22-1976',
      ' 6- 9-1981',
      NULL,
      ' 0- 7-2002',
      NULL,
      NULL,
      '10-28-1992',
      '10-11-2003',
      NULL,
      NULL,
      ' 8-10-1996',
      ' 3-19-2002',
      ' 4- 3-1979',
      NULL,
      ' 1-20-1998',
      ' 6- 9-1993',
      ' 5- 8-1988',
      ' 5-16-1975',
      ' 8- 4-1980',
      ' 7-11-1998',
      NULL,
      ' 6-23-1999',
      ' 7-25-1976',
      ' 0-10-1990',
      ' 9-24-1990',
      ' 2-11-1984',
      ' 9-26-1988',
      ' 6-26-1992',
      NULL,
      NULL,
      '11-23-2003',
      NULL,
      '11-27-1981',
      NULL,
      ' 2-15-1993',
      ' 5-17-1997',
      ' 0-22-1978',
      ' 7- 8-1978',
      ' 6-20-1998',
      ' 6-21-1974',
      ' 0-13-1974',
      ' 7-10-1974',
      ' 9-11-1978',
      ' 6-27-1984',
      ' 6- 0-1978',
      NULL,
      NULL,
      ' 3-10-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-14-1975',
      NULL,
      NULL,
      ' 7-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


