set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908405';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '4434114',
      1,
      2,
      3,
      '11242',
      3,
      ' 4-14-1989',
      20.960537,
      NULL,
      1.856951,
      NULL,
      1,
      0,
      1.251707,
      1,
      NULL,
      2.235512,
      3.088961,
      3,
      1.070922,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      40.385542,
      13.460849,
      4.471445,
      3,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      5.994427,
      NULL,
      5.565307,
      2,
      NULL,
      0.342699,
      0.572785,
      1,
      3,
      2,
      13,
      17.305942,
      5,
      7,
      7.711817,
      2,
      7.473603,
      3,
      8,
      0.437672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      62.547320,
      3,
      NULL,
      NULL,
      0,
      50,
      18617,
      15.812926,
      1,
      67,
      NULL,
      1,
      0.264619,
      NULL,
      15682,
      NULL,
      2,
      142,
      9840,
      3,
      NULL,
      417.796358,
      1684,
      2,
      0.798708,
      160,
      73,
      2,
      2,
      470,
      1168,
      3.744701,
      2,
      NULL,
      11,
      0.536768,
      9.068774,
      378.194513,
      NULL,
      0.878124,
      9.316264,
      770.085010,
      0,
      0.024340,
      0,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      231,
      0,
      7.420785,
      1293,
      148.650310,
      1,
      5,
      1367,
      99.162353,
      2.572327,
      1,
      18.874809,
      31,
      1.281513,
      1.150895,
      214.787546,
      4.800899,
      0,
      6.130980,
      282.391692,
      3.617392,
      1,
      3,
      66,
      32.230414,
      3,
      6,
      199,
      60,
      0.223594,
      0.741516,
      176.007980,
      182,
      0,
      NULL,
      67.785800,
      57.465930,
      2,
      6.792247,
      16.863272,
      426.514109,
      1,
      3.965428,
      84.193762,
      NULL,
      0.917660,
      1,
      50.008960,
      240,
      2.815212,
      7,
      NULL,
      324.727352,
      2.128457,
      NULL,
      15,
      532,
      1,
      NULL,
      68.026994,
      125.715234,
      0.909082,
      3.478740,
      53.486067,
      280.866744,
      NULL,
      0,
      194.646390,
      576,
      NULL,
      NULL,
      120.974786,
      NULL,
      3.071445,
      2.537007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '22312',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      2,
      '41031',
      '',
      NULL,
      0,
      NULL,
      NULL,
      3.406884,
      1348.731750,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.524178,
      NULL,
      1.547392,
      NULL,
      0.131870,
      NULL,
      5.844562,
      254.667252,
      0.455493,
      NULL,
      ' 1- 2-1993',
      5.417007,
      NULL,
      10,
      7.242920,
      3,
      NULL,
      15.696433,
      22,
      NULL,
      10,
      15.656388,
      7.334288,
      24.793310,
      2,
      5.972895,
      2.432810,
      10.526301,
      5,
      4.426745,
      17.746897,
      21,
      3,
      2,
      4,
      18,
      2,
      0.556189,
      1.691157,
      9.045151,
      8.452856,
      NULL,
      9.240147,
      17,
      7,
      8,
      4.424021,
      7,
      14.261217,
      4.476773,
      NULL,
      NULL,
      NULL,
      12.804030,
      6,
      2,
      NULL,
      NULL,
      7,
      7.082024,
      12,
      0,
      0.167388,
      18.186341,
      6.335851,
      15,
      NULL,
      NULL,
      18.120877,
      6.222240,
      NULL,
      26.957441,
      31.995846,
      20,
      28.495103,
      9,
      10,
      18,
      NULL,
      NULL,
      3,
      10,
      12,
      NULL,
      25,
      15.313657,
      16.668605,
      8,
      NULL,
      12.473896,
      23,
      NULL,
      6.830764,
      12,
      19.621043,
      20,
      26,
      15.106253,
      6.758837,
      6.260940,
      7.762842,
      NULL,
      26.587683,
      6,
      15,
      28,
      NULL,
      10.432824,
      19,
      NULL,
      20.005540,
      20.181607,
      19.554705,
      NULL,
      22.746814,
      89.884808,
      110.028310,
      23.516647,
      81,
      45.378951,
      155,
      NULL,
      NULL,
      55.396086,
      95.178861,
      18,
      101,
      123,
      145,
      153.224747,
      NULL,
      NULL,
      109,
      46,
      137.754000,
      102,
      44,
      76,
      43,
      42,
      126.923041,
      NULL,
      NULL,
      45.013128,
      14,
      127.248667,
      NULL,
      23.526919,
      38.124940,
      139.431820,
      26,
      NULL,
      130.380426,
      78,
      174,
      118,
      NULL,
      108.039462,
      NULL,
      NULL,
      162.703562,
      28,
      27,
      NULL,
      6,
      7.805222,
      157.065071,
      1,
      1.646628,
      4,
      NULL,
      1.609864,
      6,
      2,
      2.336054,
      4,
      4.846232,
      NULL,
      3.570920,
      6,
      1,
      5.981388,
      NULL,
      1.073470,
      8.209169,
      2,
      2,
      5,
      5.231573,
      7,
      6.124991,
      4.118635,
      NULL,
      6,
      0,
      NULL,
      1.771195,
      2.201486,
      5.551529,
      4,
      4.957155,
      NULL,
      9,
      2.830646,
      1,
      1,
      0.168665,
      NULL,
      8,
      3.098489,
      2.428292,
      1,
      11.298648,
      0,
      2.033008,
      8.455482,
      NULL,
      1.220883,
      4,
      NULL,
      0.813133,
      NULL,
      0,
      3.083395,
      5,
      1.381120,
      5.983914,
      0.286100,
      NULL,
      3.019196,
      4,
      1.249820,
      0.536104,
      3.794328,
      8,
      3,
      0.633873,
      1,
      9.105112,
      NULL,
      NULL,
      0.123806,
      NULL,
      1,
      NULL,
      NULL,
      4,
      6.362896,
      5,
      7.403966,
      7.110329,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4.260097,
      8,
      6.936794,
      NULL,
      5,
      7,
      4.126692,
      6,
      9,
      2,
      2.409343,
      3.492253,
      1.185277,
      0.515780,
      2,
      NULL,
      6,
      2,
      2,
      4.342875,
      NULL,
      4.154266,
      NULL,
      3.122727,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.303543,
      0.824169,
      1.282040,
      2.334369,
      2,
      6.580431,
      2.018071,
      5,
      4.350867,
      1.016936,
      4.070890,
      1,
      NULL,
      4,
      3,
      7.864333,
      NULL,
      0,
      4,
      4,
      5.285969,
      NULL,
      3,
      6,
      3.377471,
      NULL,
      3,
      1.269189,
      NULL,
      4,
      1.783347,
      6,
      1,
      3,
      1.499144,
      1,
      NULL,
      2.265232,
      2.893776,
      3.132256,
      0,
      NULL,
      NULL,
      2,
      1.367817,
      4.421237,
      1,
      5,
      NULL,
      0,
      4.047402,
      NULL,
      3,
      6.314321,
      NULL,
      0.216079,
      3.109429,
      7.577482,
      2.386545,
      4,
      5.622258,
      6.326664,
      0.782663,
      7,
      NULL,
      6.928942,
      NULL,
      6,
      4.360865,
      NULL,
      5,
      4.713515,
      2,
      4,
      0,
      4.452219,
      1,
      1.504257,
      5.161166,
      2.770913,
      0.783397,
      5,
      1,
      NULL,
      NULL,
      5,
      1.553708,
      NULL,
      NULL,
      4.007806,
      4.633379,
      1,
      2.673061,
      3,
      3,
      NULL,
      3,
      7,
      NULL,
      3,
      1,
      1,
      3.705056,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.632137,
      4,
      NULL,
      1,
      3,
      0,
      2.142475,
      3.287962,
      6,
      0.263240,
      5,
      0.976941,
      6,
      NULL,
      7,
      NULL,
      3.608693,
      3,
      2.845767,
      5,
      4.371070,
      0,
      5,
      1.744195,
      5,
      5,
      NULL,
      7,
      2,
      1.608656,
      NULL,
      7.233087,
      NULL,
      NULL,
      0.567857,
      2,
      0,
      0.584364,
      2,
      0,
      0,
      0.161200,
      0.018851,
      NULL,
      9,
      NULL,
      NULL,
      0,
      2.011382,
      7.330373,
      3,
      1,
      8,
      2,
      NULL,
      6,
      9.689229,
      7.048108,
      4.070255,
      NULL,
      3,
      0,
      1,
      0.704721,
      NULL,
      0,
      3.288612,
      7,
      NULL,
      8,
      1,
      2,
      2.766890,
      0.124021,
      7.930406,
      5,
      1,
      6.513793,
      3.599681,
      4.821052,
      5,
      NULL,
      3,
      1.309156,
      NULL,
      NULL,
      3.616616,
      3,
      2.475250,
      6,
      7,
      4.031196,
      0,
      2,
      9,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      2,
      9,
      1.253301,
      8.654640,
      1.027732,
      9,
      3,
      0,
      7,
      2.175505,
      0.679259,
      7.759469,
      7.683034,
      8.768461,
      6,
      NULL,
      4.569318,
      NULL,
      7.193857,
      2,
      7.305133,
      6,
      4,
      6,
      2.628901,
      0,
      9,
      4.852265,
      3,
      10,
      6,
      3,
      1,
      0,
      1,
      5,
      2.550519,
      4.979536,
      4.847384,
      NULL,
      0,
      NULL,
      5,
      2,
      7.851467,
      0,
      1,
      5.709486,
      NULL,
      0.161596,
      1,
      2.552029,
      7.207933,
      0.573669,
      NULL,
      6.662745,
      6.432677,
      NULL,
      7,
      NULL,
      4,
      2,
      2.254576,
      0.735861,
      1,
      4,
      0.116246,
      5.986279,
      5,
      0,
      0,
      1.203502,
      4.289562,
      7.290461,
      5,
      7,
      NULL,
      7.386244,
      5,
      NULL,
      3.540629,
      1,
      3,
      0,
      1.972750,
      NULL,
      2.475448,
      0.427873,
      1.046222,
      4.905915,
      1,
      6,
      1,
      2.611181,
      6,
      7,
      NULL,
      2.607422,
      NULL,
      1.366184,
      1.867704,
      3,
      1.455618,
      3,
      NULL,
      0,
      0.839635,
      2,
      2.162764,
      4.378958,
      NULL,
      4,
      0,
      2,
      4.046801,
      3.161614,
      7.467850,
      7.657071,
      7.428958,
      6,
      2.525787,
      4,
      0,
      NULL,
      0,
      4,
      1.425936,
      NULL,
      NULL,
      11.652458,
      3,
      8.889744,
      2.692798,
      5.032494,
      8.684227,
      6,
      NULL,
      1,
      1,
      1.507796,
      1,
      0,
      1,
      1.235663,
      1,
      0.895672,
      1,
      1,
      1,
      1.021237,
      0.182721,
      0.385483,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      3,
      1,
      1.131732,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.447010,
      0.570445,
      3,
      2,
      0.364464,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4,
      0,
      0.450774,
      1.612763,
      NULL,
      1.648896,
      NULL,
      0.008871,
      1,
      0,
      1.935208,
      0,
      0.006078,
      0,
      1.637053,
      1.051431,
      1.840136,
      1,
      0,
      1.227655,
      0.202625,
      1.270010,
      0,
      NULL,
      0.840050,
      NULL,
      1.020381,
      NULL,
      1.403984,
      0,
      NULL,
      0.460685,
      0,
      0,
      1,
      0.832382,
      NULL,
      0,
      0.560260,
      0,
      0.244222,
      1.416849,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.806532,
      1.164440,
      0,
      NULL,
      0,
      1,
      1,
      3,
      1,
      2.365793,
      2,
      3.064737,
      0,
      1,
      NULL,
      1.865381,
      NULL,
      NULL,
      2,
      1.825634,
      3.645708,
      2.262847,
      1,
      3,
      0,
      1.543845,
      0.654017,
      2,
      2.850933,
      1,
      NULL,
      1,
      2,
      NULL,
      2,
      2.614582,
      1.715544,
      0.486331,
      0.893150,
      1.528424,
      2.207595,
      1.642662,
      3,
      3.905983,
      1,
      0.638024,
      3,
      3.449619,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.333674,
      NULL,
      1,
      0.623116,
      NULL,
      1,
      0.287547,
      0,
      NULL,
      NULL,
      1.990633,
      NULL,
      0,
      1,
      NULL,
      1.279657,
      NULL,
      1,
      1.610628,
      1,
      0.404887,
      0,
      0.594724,
      1,
      NULL,
      NULL,
      1.700022,
      1.404530,
      NULL,
      0.677815,
      0.873476,
      1.734692,
      1,
      1,
      0.433124,
      0.335143,
      0.545891,
      NULL,
      0.289736,
      NULL,
      NULL,
      1.836655,
      1,
      0,
      NULL,
      1,
      1,
      1.921679,
      0,
      1.855215,
      0.888898,
      NULL,
      1,
      0,
      0.506372,
      3,
      5.348246,
      0.389361,
      0.986219,
      NULL,
      5.280213,
      NULL,
      0.882869,
      4,
      3,
      5.196430,
      3.509601,
      3.292175,
      2.763646,
      NULL,
      0,
      0,
      NULL,
      6,
      NULL,
      0,
      7,
      6.820760,
      NULL,
      5.621459,
      0,
      6,
      3.755530,
      2.625313,
      4,
      1,
      7.483330,
      7,
      5,
      8,
      NULL,
      0,
      3.979366,
      1,
      7,
      NULL,
      2,
      NULL,
      5.630671,
      3,
      NULL,
      NULL,
      NULL,
      9.201632,
      1.669356,
      7.156128,
      0.582799,
      NULL,
      NULL,
      5.684291,
      4.686803,
      6,
      NULL,
      2.402777,
      2.818328,
      NULL,
      3.969930,
      9.642664,
      2,
      NULL,
      0,
      4.002897,
      2,
      1.455588,
      6,
      2.182557,
      1.415642,
      1,
      0.800256,
      3,
      NULL,
      9.444681,
      5,
      4.393468,
      3.063337,
      1,
      NULL,
      3,
      NULL,
      NULL,
      7,
      4,
      5,
      4,
      3.732477,
      0.282981,
      NULL,
      7,
      4,
      NULL,
      0.550663,
      4,
      2.986798,
      0.028079,
      6.295452,
      7,
      3.848154,
      3.648819,
      NULL,
      1.247556,
      NULL,
      1,
      1.057190,
      0,
      NULL,
      0.820102,
      0.639093,
      0,
      1,
      0,
      1,
      0.409924,
      1.010738,
      0.069958,
      NULL,
      1.239166,
      1,
      1,
      0.622432,
      NULL,
      0.512686,
      NULL,
      0.526757,
      1.169769,
      0,
      1.447241,
      0.888264,
      0.562572,
      0,
      0,
      0.037455,
      NULL,
      NULL,
      0.960054,
      1.181518,
      1.635750,
      0,
      0,
      1,
      NULL,
      1.550593,
      NULL,
      NULL,
      1.512375,
      0.340670,
      1,
      1.642529,
      NULL,
      0,
      0.189796,
      1.529032,
      2.602676,
      NULL,
      NULL,
      3,
      3.446189,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      3.326368,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.676313,
      2.675285,
      3,
      2,
      1,
      2,
      2,
      NULL,
      0,
      3.053684,
      1.944729,
      3.476015,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      3,
      2.992004,
      NULL,
      0,
      NULL,
      3,
      3.347731,
      0.046018,
      2.942706,
      1.826731,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      1,
      3,
      0,
      0,
      3,
      NULL,
      0,
      3,
      1,
      0,
      3,
      1,
      NULL,
      1,
      2,
      2,
      1,
      2,
      3,
      3,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      4,
      3,
      NULL,
      3,
      5,
      3,
      4,
      0,
      5,
      0,
      4,
      1,
      NULL,
      5,
      4,
      2,
      4,
      4,
      NULL,
      0,
      4,
      3,
      4,
      3,
      4,
      5,
      NULL,
      5,
      NULL,
      0,
      5,
      4,
      4,
      1,
      5,
      2,
      2,
      2,
      7,
      NULL,
      2,
      3,
      4,
      4,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      5,
      3,
      3,
      2,
      4,
      1,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      1,
      1,
      3,
      0,
      1,
      1,
      2,
      1,
      5,
      1,
      3,
      3,
      3,
      1,
      3,
      1,
      3,
      NULL,
      3,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      0.422751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-14-1975',
      NULL,
      NULL,
      NULL,
      ' 2-12-1974',
      ' 8-10-1993',
      ' 4- 7-1989',
      ' 8-26-1989',
      ' 6-21-1994',
      ' 3-18-1981',
      NULL,
      NULL,
      ' 0-20-1981',
      NULL,
      ' 8-12-1977',
      '11-19-1977',
      ' 6-13-1978',
      NULL,
      '10-16-1999',
      ' 3-26-1985',
      NULL,
      ' 4- 9-1982',
      NULL,
      ' 7- 1-1986',
      '10-26-1999',
      ' 0-22-1992',
      NULL,
      ' 7-20-1980',
      NULL,
      ' 3- 8-1995',
      ' 9- 5-1993',
      NULL,
      NULL,
      ' 6- 5-2003',
      ' 9-25-1999',
      ' 6-21-1997',
      NULL,
      ' 4- 6-1990',
      ' 3- 8-1979',
      ' 8- 6-2002',
      ' 7-25-1981',
      '10-11-1974',
      ' 2-23-1976',
      ' 9- 6-1989',
      ' 1-10-1983',
      '11-29-1975',
      ' 5- 8-1985',
      ' 8-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-24-1974',
      NULL,
      NULL,
      ' 7-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


