set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7127190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '12212114',
      25,
      65,
      '4211201',
      1,
      0,
      3,
      '03311',
      0,
      '11-20-1999',
      84,
      NULL,
      5,
      0,
      2,
      NULL,
      0,
      0,
      1,
      0,
      0.618973,
      2,
      0.766977,
      0,
      3,
      NULL,
      3.540108,
      NULL,
      1,
      75,
      3,
      5.617112,
      0,
      NULL,
      0,
      5.590842,
      NULL,
      0.228322,
      NULL,
      NULL,
      NULL,
      4,
      5,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      3,
      3,
      NULL,
      5.230760,
      NULL,
      9,
      7,
      0.455476,
      1,
      3.830822,
      0.488711,
      0,
      0,
      1,
      1.696004,
      3.775246,
      0,
      1.828225,
      4,
      2,
      NULL,
      0.788241,
      2,
      1.165354,
      32,
      '10-25-1988',
      26.993225,
      1.915986,
      0.776649,
      NULL,
      3,
      2,
      NULL,
      6,
      36,
      169,
      59,
      NULL,
      1.476863,
      121,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      1.438628,
      1.084035,
      713.869886,
      324,
      NULL,
      0,
      596,
      100.907026,
      3,
      NULL,
      NULL,
      3.220589,
      NULL,
      3.902404,
      NULL,
      14,
      1.917714,
      2.288444,
      845,
      0.068670,
      NULL,
      NULL,
      693.643117,
      NULL,
      3.371999,
      3.630824,
      475.349894,
      133,
      NULL,
      NULL,
      381.091670,
      137.789498,
      3,
      7,
      24,
      4.888771,
      1,
      1,
      160,
      3.459066,
      1,
      9,
      173.023729,
      NULL,
      2.396117,
      9,
      171.338866,
      96,
      NULL,
      2,
      208,
      23,
      2,
      0,
      NULL,
      227.274799,
      1.486387,
      6,
      156.300722,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      3.896623,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      2.939333,
      209.092414,
      150.215211,
      0,
      1.983903,
      135,
      NULL,
      0,
      NULL,
      154,
      7.834744,
      2,
      3.330151,
      326,
      NULL,
      0,
      2.151313,
      NULL,
      159,
      2,
      6.412505,
      98.052191,
      NULL,
      3.270672,
      0.151329,
      219,
      233.878277,
      0,
      NULL,
      732,
      114.432548,
      1.572837,
      0,
      584.186387,
      398.422071,
      0.600726,
      NULL,
      154,
      296.145047,
      1.585144,
      3,
      878,
      345.723780,
      2.265545,
      1.647165,
      110.556917,
      18,
      0.006377,
      NULL,
      5,
      14,
      2.056332,
      3,
      74,
      NULL,
      3,
      4,
      89.681715,
      132,
      0.056256,
      NULL,
      NULL,
      595,
      1,
      NULL,
      144.315197,
      277,
      3.164887,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '24121',
      NULL,
      '',
      '',
      '',
      '',
      1.118552,
      '',
      '',
      '',
      0.627446,
      '',
      '',
      NULL,
      1,
      1,
      NULL,
      2.199234,
      591.988117,
      0.807436,
      NULL,
      0.431242,
      NULL,
      0.097093,
      NULL,
      0,
      NULL,
      1.767667,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.921121,
      NULL,
      ' 6- 7-1981',
      0,
      8,
      13.236407,
      4.392754,
      17.965124,
      7,
      NULL,
      5.280573,
      NULL,
      11,
      25.926767,
      2.267079,
      17,
      8.601375,
      15,
      1,
      5.212622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.164753,
      30.973082,
      1.544608,
      5,
      4.418078,
      22,
      NULL,
      3.302363,
      13.199005,
      1.291774,
      NULL,
      NULL,
      6,
      18,
      NULL,
      NULL,
      10,
      4.092718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      139,
      25,
      NULL,
      174.849651,
      28.294046,
      NULL,
      39,
      186.448038,
      NULL,
      103.763636,
      NULL,
      188.702032,
      NULL,
      2,
      4.294973,
      4.857598,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8,
      2,
      6,
      8.356210,
      5.165384,
      NULL,
      0.692154,
      6,
      8,
      2,
      8.327498,
      NULL,
      NULL,
      2,
      4.334575,
      3.022434,
      0.157808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1.013685,
      NULL,
      0,
      NULL,
      5,
      NULL,
      7,
      0.017391,
      6.493208,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378922,
      4,
      1.678108,
      5,
      3.898695,
      5.431184,
      0.570924,
      0,
      NULL,
      0.612855,
      NULL,
      0,
      7.544094,
      2,
      4.867728,
      NULL,
      4,
      3.253260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.691277,
      NULL,
      3,
      NULL,
      2.503636,
      2,
      8,
      3,
      0.199806,
      5.432536,
      7,
      1,
      4.184492,
      4.532657,
      NULL,
      4,
      6.249159,
      0.076317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.467199,
      NULL,
      5.010404,
      NULL,
      0,
      8.022175,
      6,
      0.967036,
      3.097279,
      NULL,
      2.058435,
      NULL,
      2,
      2.732320,
      1.488427,
      4,
      NULL,
      6.420417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617149,
      4,
      NULL,
      6,
      6.925741,
      5.391255,
      1,
      6,
      6.350089,
      NULL,
      0,
      0.228032,
      9.257907,
      0.505943,
      7.748209,
      NULL,
      4.236782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1.384977,
      8,
      2,
      5,
      5,
      6,
      1,
      3,
      NULL,
      8.865134,
      0,
      2,
      1,
      0.041739,
      2.201857,
      2.562567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.031029,
      3.725112,
      3.940652,
      6.922047,
      2.089049,
      1.488204,
      NULL,
      NULL,
      3,
      4,
      NULL,
      2,
      6.874132,
      0.028748,
      0.244273,
      6.745869,
      7,
      2.555233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261264,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.369819,
      1.172336,
      NULL,
      1.084540,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315637,
      1,
      1.527518,
      1.130130,
      1.660426,
      0.130311,
      1.887285,
      0.942862,
      NULL,
      1,
      1.873607,
      1.395614,
      0,
      4,
      5.057738,
      NULL,
      3.772636,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497773,
      1,
      1.841149,
      1.538694,
      NULL,
      1.176374,
      NULL,
      1,
      1,
      0.901465,
      1,
      0.882967,
      0.101219,
      1,
      0.468915,
      0.720728,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012130,
      5.617582,
      4.434316,
      0,
      4.415502,
      2.450654,
      0,
      1.728677,
      1,
      NULL,
      0.853299,
      0,
      NULL,
      3,
      NULL,
      0.420571,
      0,
      0.199756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.005162,
      5.558055,
      5.938325,
      4.037167,
      1,
      1,
      0.972858,
      4,
      0.928938,
      1.310514,
      1.468179,
      7.522220,
      1.538328,
      2,
      0.055722,
      1,
      1.935301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482493,
      0,
      3,
      5,
      2.714504,
      1.715895,
      1.407285,
      NULL,
      6,
      7,
      3.674580,
      5,
      3,
      5,
      8,
      8.039719,
      2.988793,
      6.466827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      6,
      1.847003,
      3,
      2.097188,
      2.566848,
      0,
      NULL,
      NULL,
      7.780481,
      2,
      NULL,
      9,
      NULL,
      8.872087,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.985545,
      0,
      1.646207,
      1.228603,
      NULL,
      0.886491,
      NULL,
      0.896834,
      0.138541,
      NULL,
      0.287982,
      NULL,
      0,
      1,
      NULL,
      0,
      0.982468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745833,
      1.550679,
      0.662336,
      4,
      NULL,
      NULL,
      0,
      0.370352,
      NULL,
      1,
      0,
      1,
      1.932068,
      0,
      NULL,
      0,
      1.520411,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      4,
      4,
      0,
      3,
      NULL,
      5,
      3,
      4,
      0,
      2,
      5,
      3,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      2,
      2,
      1,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1980',
      ' 2- 1-1991',
      ' 9- 9-1998',
      NULL,
      NULL,
      NULL,
      ' 7-13-2003',
      NULL,
      ' 2-24-1997',
      '10-13-1975',
      NULL,
      ' 6-18-1996',
      '10-27-1987',
      '10- 2-1995',
      ' 4-10-2003',
      ' 3-23-1986',
      NULL,
      ' 6-23-1978',
      '10-25-1992',
      '10-18-1993',
      ' 9-12-1975',
      ' 6- 4-1975',
      ' 9-17-1974',
      ' 4-11-1995',
      NULL,
      '10-14-1978',
      NULL,
      NULL,
      ' 4-23-1995',
      ' 2-13-1974',
      ' 1- 5-1983',
      NULL,
      NULL,
      ' 7-24-1981',
      ' 7-27-1987',
      ' 3-16-1982',
      ' 7- 2-1992',
      ' 1-18-1985',
      '11-23-1983',
      NULL,
      ' 0- 5-1990',
      ' 0-25-1998',
      ' 8-15-1994',
      '10-14-2001',
      ' 7-20-1974',
      ' 2-24-1978',
      ' 9-18-1993',
      ' 1- 9-1986',
      NULL,
      ' 3-13-1992',
      ' 4- 5-1989',
      ' 4- 9-1982',
      NULL,
      ' 1-16-2002',
      ' 6-18-1979',
      NULL,
      ' 2-14-1979',
      ' 9-29-2000',
      ' 4-10-1988',
      ' 6- 2-1997',
      NULL,
      NULL,
      NULL,
      ' 1- 0-1991',
      NULL,
      ' 9- 8-1978',
      '10- 6-1997',
      ' 6- 3-1979',
      ' 6-25-1974',
      NULL,
      ' 1-14-1980',
      ' 0-11-1974',
      NULL,
      ' 3-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


