set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311844';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '1',
      68.764608,
      4,
      '4313304',
      NULL,
      1,
      3,
      '41023',
      1.550163,
      NULL,
      NULL,
      NULL,
      1.577842,
      3,
      3,
      NULL,
      0.663525,
      1.446875,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.937946,
      15,
      4,
      NULL,
      1.129364,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      2,
      3,
      0,
      NULL,
      7,
      3,
      NULL,
      4,
      0,
      0.131823,
      3,
      0,
      NULL,
      0.493374,
      1.716538,
      3,
      2,
      3,
      4,
      1,
      0,
      5.079413,
      NULL,
      1.938054,
      1,
      9,
      1.158251,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      4,
      NULL,
      2,
      NULL,
      438.153414,
      152,
      NULL,
      2.293160,
      344.829577,
      69,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      2.652825,
      2.861232,
      387,
      1,
      0.804599,
      2,
      213.792412,
      21,
      3,
      NULL,
      95,
      20.067172,
      3.124867,
      1,
      125.560446,
      728,
      0.750058,
      1.372788,
      86.614224,
      3.344830,
      3.522704,
      NULL,
      235.145512,
      213.284034,
      3,
      0,
      228.606252,
      2.073593,
      2,
      2.169909,
      81,
      1174.078810,
      1.155858,
      2.524444,
      74.205242,
      3,
      NULL,
      1,
      339,
      209,
      1.027867,
      3,
      NULL,
      NULL,
      3.426194,
      0,
      NULL,
      3.900880,
      1.420017,
      1,
      1269,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13014',
      '04324',
      '02230',
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '4011',
      NULL,
      '',
      4,
      1.516192,
      NULL,
      3,
      18.307504,
      0.359818,
      NULL,
      0,
      NULL,
      3,
      522.860566,
      0,
      NULL,
      0,
      606,
      0.574629,
      NULL,
      0,
      101.895912,
      NULL,
      NULL,
      ' 7-21-1986',
      3.711598,
      1,
      6,
      8,
      2,
      NULL,
      3,
      NULL,
      10,
      13.046781,
      2,
      1,
      8,
      10.334652,
      7.638536,
      12.512248,
      19.133829,
      0.814719,
      2.617485,
      NULL,
      12,
      18,
      4,
      NULL,
      7.671666,
      15,
      7,
      NULL,
      NULL,
      9,
      13,
      23.440072,
      NULL,
      2.687633,
      7.313314,
      10.995928,
      12,
      10,
      1.641478,
      0,
      7.450165,
      7.225217,
      NULL,
      13.904085,
      2,
      7.340155,
      12.066624,
      6,
      18.660048,
      11,
      5,
      10.072869,
      21.904325,
      4,
      NULL,
      16,
      10.771468,
      14,
      9.007153,
      23.614812,
      1,
      0,
      9,
      39.192868,
      3,
      NULL,
      1,
      11.426054,
      0.760233,
      41.161768,
      NULL,
      NULL,
      18,
      2,
      24.289350,
      17.375984,
      30,
      NULL,
      6.947653,
      32,
      1.777773,
      0,
      NULL,
      23.552494,
      1.390139,
      8,
      2,
      17.870951,
      3.020374,
      NULL,
      29.298477,
      13,
      20,
      3.569475,
      31,
      26,
      NULL,
      52.982797,
      3.816317,
      NULL,
      0,
      4,
      27,
      5,
      124.741291,
      166,
      44.557108,
      NULL,
      56,
      66.251281,
      100.096566,
      42,
      10,
      115,
      53.403841,
      NULL,
      8,
      162,
      155,
      56.224246,
      123.573507,
      36.941873,
      81.874810,
      NULL,
      32,
      NULL,
      14,
      102,
      142.780942,
      NULL,
      45,
      108.557805,
      30,
      118.203232,
      NULL,
      126,
      73.960626,
      27.602871,
      177,
      121,
      3,
      48.834550,
      0.712524,
      0,
      0.308942,
      1.999767,
      2.562318,
      0.875675,
      1,
      2.730642,
      1,
      5.752035,
      NULL,
      2.838589,
      5,
      NULL,
      1.715453,
      0.431180,
      0.185267,
      1.148373,
      NULL,
      1,
      5.565874,
      5.971956,
      4,
      1,
      NULL,
      NULL,
      4.596075,
      NULL,
      1.655855,
      4,
      NULL,
      NULL,
      0,
      2,
      2.579852,
      1,
      NULL,
      NULL,
      1,
      2.466773,
      5,
      NULL,
      NULL,
      1.197124,
      NULL,
      4,
      6.867318,
      6,
      6.108744,
      NULL,
      4,
      6.712638,
      NULL,
      2,
      5,
      0.434399,
      2,
      5.408817,
      NULL,
      NULL,
      NULL,
      3,
      1.585253,
      7.331685,
      3,
      3.631137,
      1,
      5.489575,
      NULL,
      0.064917,
      2.670501,
      2.561990,
      1,
      5.984528,
      5,
      NULL,
      6.139480,
      1.808836,
      0,
      4.850076,
      2.231767,
      1,
      1,
      8,
      1,
      9.796275,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      8.427612,
      2.267887,
      6.203987,
      NULL,
      1,
      NULL,
      4.350601,
      1,
      0,
      NULL,
      6.233807,
      3.686875,
      9,
      NULL,
      NULL,
      8.468328,
      NULL,
      5.126717,
      0,
      1,
      4.870226,
      7.678545,
      3,
      5,
      2.670682,
      0.943102,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.093281,
      0,
      0,
      1.317351,
      1,
      1,
      1.638164,
      1,
      1.243855,
      1.496249,
      1.670882,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.251987,
      0,
      1,
      1,
      NULL,
      0.694154,
      0.334329,
      1,
      1,
      NULL,
      1.494979,
      1.556944,
      0.750727,
      NULL,
      1.914970,
      1.872885,
      1.452950,
      1,
      NULL,
      1,
      1.872909,
      1.873276,
      NULL,
      0,
      1.274959,
      1.058699,
      1,
      1,
      0.346289,
      0,
      1.909306,
      0,
      NULL,
      0.287912,
      3,
      0,
      0.257176,
      2.110589,
      0,
      5,
      1,
      5.040045,
      1.588823,
      3.258200,
      4.268407,
      1,
      NULL,
      NULL,
      3,
      4.847860,
      NULL,
      NULL,
      4,
      4,
      0.822359,
      3.649712,
      0.475678,
      0,
      3,
      NULL,
      5.268629,
      2.318345,
      4,
      5.814313,
      0.325879,
      4,
      1,
      2,
      1,
      NULL,
      1,
      0,
      5,
      NULL,
      4.324494,
      2.877404,
      5.525041,
      3.494252,
      1,
      3.014986,
      2.235806,
      NULL,
      0.624683,
      NULL,
      1.573057,
      0,
      NULL,
      4.387528,
      NULL,
      2.181044,
      NULL,
      0.857613,
      NULL,
      7.101913,
      2.645735,
      0.488244,
      2,
      4.512753,
      7.512154,
      NULL,
      NULL,
      NULL,
      1.502220,
      0.139772,
      3.041178,
      NULL,
      0,
      0,
      4.672116,
      0.463008,
      0,
      4,
      3,
      3,
      1,
      7.576445,
      NULL,
      6,
      4.855818,
      5.367259,
      NULL,
      NULL,
      3,
      1,
      0,
      7.702763,
      NULL,
      3.245431,
      1.623879,
      NULL,
      NULL,
      6.198280,
      7.976749,
      NULL,
      NULL,
      4,
      1.181836,
      NULL,
      NULL,
      1,
      5,
      1.971583,
      NULL,
      6,
      NULL,
      6,
      5.111902,
      6.103609,
      1.008528,
      6,
      NULL,
      7.222486,
      4.484155,
      2,
      3,
      7.405799,
      2,
      7,
      5,
      5.009525,
      7.302028,
      4,
      2.839408,
      6,
      0.209595,
      5.520729,
      6,
      NULL,
      7.454539,
      4.930749,
      1,
      6,
      3.349327,
      NULL,
      NULL,
      5,
      NULL,
      6.395696,
      NULL,
      4.494048,
      6.211876,
      7.387416,
      6.738718,
      7.841121,
      4.261019,
      NULL,
      0,
      0.907869,
      2.896213,
      0,
      6,
      2.846071,
      8.281359,
      NULL,
      4.376709,
      NULL,
      NULL,
      1,
      5.910551,
      0.864835,
      NULL,
      NULL,
      1.350847,
      3.780001,
      0,
      5,
      0.675675,
      3.241197,
      2,
      4.355676,
      6.037051,
      3,
      0,
      3.646286,
      3.410192,
      0.846589,
      0,
      0,
      6.802739,
      5,
      NULL,
      7.327027,
      0.654868,
      3,
      3,
      3.024781,
      NULL,
      0,
      3.170320,
      NULL,
      7.393441,
      7.937321,
      5.252556,
      7,
      NULL,
      NULL,
      NULL,
      5.344019,
      0.644333,
      1.647084,
      NULL,
      0,
      2.546317,
      4,
      0,
      5.310596,
      NULL,
      NULL,
      NULL,
      7.451890,
      0.552872,
      2.713307,
      0.117841,
      3,
      6,
      2,
      0,
      5,
      0.228339,
      5.566115,
      NULL,
      7,
      6.604214,
      6,
      2,
      NULL,
      NULL,
      4,
      4.646439,
      3,
      6.120070,
      0,
      0.751522,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      7.684082,
      3.608017,
      7,
      3,
      5.030198,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.009776,
      1,
      1.215384,
      0.714868,
      2.605626,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.366124,
      1,
      4.396499,
      2,
      5,
      NULL,
      1,
      4,
      2.072190,
      1,
      2.100245,
      1.204544,
      4.208654,
      4,
      2.742166,
      3,
      3,
      4,
      7,
      3,
      7.814038,
      2.489877,
      NULL,
      4.528725,
      4,
      3.408761,
      5,
      3,
      2.791130,
      1.091866,
      2.306083,
      2,
      0,
      5,
      3,
      2,
      2,
      0,
      1.482647,
      0.447835,
      0.733475,
      0.072621,
      1.055379,
      1,
      0,
      1,
      NULL,
      0.476189,
      0,
      0,
      1.174504,
      0,
      1,
      NULL,
      1.333024,
      1,
      1,
      0,
      1,
      0.138609,
      0.401936,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.937447,
      1,
      1,
      0,
      1.545355,
      0.716363,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0.329950,
      0,
      1.945437,
      1.480665,
      1,
      NULL,
      0,
      1,
      1.376067,
      1,
      0.242734,
      0.251550,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0.968359,
      0,
      0,
      1.618620,
      0.913531,
      1.173355,
      0.433031,
      NULL,
      0,
      0,
      1,
      0.710345,
      0,
      1,
      1.450495,
      0.339096,
      1.312626,
      NULL,
      NULL,
      1.045640,
      0,
      NULL,
      1.688314,
      1.856146,
      1.425197,
      1.698806,
      0.252316,
      0,
      0.045933,
      1.702374,
      1.612009,
      1,
      0.573985,
      NULL,
      1.842127,
      0.578445,
      1.929434,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.850430,
      0.409247,
      1,
      NULL,
      0.623339,
      NULL,
      5,
      0.317668,
      NULL,
      5.682692,
      3,
      3.663059,
      8.588670,
      NULL,
      8,
      2.820479,
      4,
      3.580606,
      4,
      0,
      1,
      4,
      4,
      3,
      5.802078,
      7,
      3.103081,
      0,
      1.512474,
      1.607728,
      1,
      1.840167,
      0,
      0.828210,
      0.792164,
      1.936873,
      0,
      1,
      0,
      1,
      0.779139,
      0,
      0,
      0.133485,
      0,
      1.171309,
      1.323430,
      1,
      1.993198,
      NULL,
      1.787457,
      1,
      1,
      0,
      1.360338,
      0.183995,
      1,
      1.478603,
      NULL,
      NULL,
      1.777640,
      1,
      4.683023,
      1,
      5,
      NULL,
      0,
      1.532084,
      3,
      NULL,
      NULL,
      2,
      1.129526,
      NULL,
      1.424583,
      0,
      NULL,
      0.194502,
      9.029388,
      NULL,
      NULL,
      3,
      3,
      5,
      2.893485,
      1,
      3,
      3,
      3,
      3,
      0,
      4.607488,
      NULL,
      2,
      4.919772,
      4.940605,
      0,
      0.333515,
      2,
      NULL,
      7,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.737396,
      NULL,
      0.345062,
      NULL,
      3.832722,
      2,
      3,
      6,
      6.078542,
      5,
      7.627142,
      0,
      4,
      NULL,
      3,
      NULL,
      2,
      1.841803,
      6,
      6,
      NULL,
      NULL,
      6,
      NULL,
      3.562416,
      9.053328,
      NULL,
      8,
      2,
      NULL,
      NULL,
      1,
      8,
      NULL,
      3,
      6.798898,
      NULL,
      NULL,
      2,
      11.528533,
      NULL,
      NULL,
      4,
      8,
      9,
      3.282901,
      NULL,
      9,
      NULL,
      1.433356,
      0,
      NULL,
      0.235607,
      0.084999,
      NULL,
      2,
      NULL,
      2,
      0,
      1.940909,
      0,
      0,
      NULL,
      NULL,
      3.232960,
      6,
      4,
      6.454989,
      5,
      NULL,
      7.968796,
      3,
      NULL,
      0.539051,
      0,
      4,
      4.028397,
      3,
      NULL,
      4.018989,
      3,
      4,
      5.582017,
      4.999926,
      5,
      4,
      3.231503,
      7,
      7.007384,
      NULL,
      1,
      0.106141,
      5,
      0,
      2,
      6,
      NULL,
      3.528885,
      3,
      7.933545,
      3,
      0.430088,
      NULL,
      0.945423,
      1,
      0,
      0.722334,
      1,
      1,
      NULL,
      1.121265,
      1,
      1.542506,
      0,
      NULL,
      1.350196,
      1,
      1.854296,
      NULL,
      0.083156,
      1.217129,
      1,
      0,
      1,
      0.508375,
      1,
      1,
      1.074441,
      NULL,
      0.103474,
      0,
      0.035226,
      0,
      0.410226,
      1,
      NULL,
      1,
      1,
      0,
      0.525187,
      0.999844,
      1.778367,
      1.252485,
      1,
      NULL,
      0,
      1.364720,
      1.973665,
      1,
      1,
      1.687328,
      1.944177,
      0,
      1.651342,
      0,
      0.892001,
      NULL,
      8.247935,
      7.198554,
      0.427165,
      5.958530,
      4,
      0,
      8,
      NULL,
      4.864880,
      1,
      7,
      0,
      6,
      7.060958,
      5.733956,
      4.530294,
      NULL,
      6.152422,
      7.231088,
      0.443619,
      3.736438,
      0,
      1,
      1.716106,
      1.717482,
      NULL,
      1.161423,
      0.758216,
      0,
      0.191327,
      0.437204,
      NULL,
      NULL,
      0.756155,
      0,
      0.428629,
      1.430818,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1.064404,
      1.528821,
      2,
      6,
      0,
      7,
      1,
      2,
      0,
      NULL,
      1,
      1,
      0,
      7,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      5,
      0,
      2,
      1,
      3,
      NULL,
      1,
      1,
      7,
      1,
      3,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      6,
      0,
      7,
      NULL,
      1,
      1,
      1,
      3,
      0,
      NULL,
      0,
      5,
      0,
      2,
      0,
      3,
      2,
      NULL,
      0,
      0,
      2,
      2,
      NULL,
      5,
      3,
      2,
      1,
      0,
      2,
      1,
      2,
      5,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0,
      1,
      1,
      0,
      3,
      NULL,
      5,
      NULL,
      5,
      2,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-29-1984',
      ' 0-23-1998',
      ' 3-11-1975',
      NULL,
      ' 8-14-2000',
      ' 8- 2-1994',
      ' 5-18-1984',
      ' 1- 5-1996',
      ' 0- 9-1984',
      NULL,
      ' 3- 0-1994',
      NULL,
      '10- 7-1980',
      ' 5- 2-2001',
      NULL,
      ' 0- 2-1988',
      ' 1-27-1982',
      ' 8-29-2001',
      ' 7-24-2001',
      '11- 9-1983',
      ' 5- 3-1991',
      ' 9- 2-1991',
      NULL,
      NULL,
      ' 7-17-1978',
      NULL,
      ' 6-13-1997',
      NULL,
      NULL,
      NULL,
      ' 0-17-1980',
      NULL,
      ' 4-27-1999',
      '11-11-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-1984',
      NULL,
      ' 6-15-1976',
      '10- 5-1998',
      NULL,
      ' 8-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019056);
commit;
end;
/


