set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835115';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '2240131',
      1,
      0.693218,
      2,
      '22222',
      2,
      ' 3- 2-1984',
      NULL,
      NULL,
      0.317110,
      2,
      2.797847,
      1,
      1.389028,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.909481,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.747607,
      0,
      1.057886,
      5.510479,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      0,
      1,
      4,
      4,
      0,
      6.746107,
      1,
      9.606970,
      4,
      NULL,
      0.799533,
      NULL,
      1,
      3,
      9,
      17,
      9,
      5,
      2,
      3,
      NULL,
      1,
      3,
      1.250375,
      0.476918,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080686,
      NULL,
      1,
      0,
      NULL,
      4.891932,
      5,
      6.269971,
      NULL,
      9421,
      7,
      1.020487,
      297.440718,
      13382.280414,
      7,
      3,
      NULL,
      10498,
      2,
      15.535381,
      NULL,
      6544,
      2,
      9.196267,
      213.912019,
      11582,
      NULL,
      16,
      241,
      11692,
      0,
      11,
      NULL,
      60,
      2,
      NULL,
      160,
      62.400310,
      0.128260,
      3.036272,
      229,
      202.566451,
      1.326178,
      1.633117,
      486,
      163,
      NULL,
      NULL,
      249.368627,
      1,
      NULL,
      3,
      332,
      NULL,
      NULL,
      1,
      102,
      459,
      3,
      NULL,
      119,
      32,
      3.822000,
      7.728417,
      111,
      35.608892,
      1,
      0.524040,
      1,
      69.347613,
      2.306622,
      3.530746,
      73,
      228.213524,
      NULL,
      4,
      174.008241,
      142,
      1.608921,
      1.377617,
      45,
      NULL,
      1,
      NULL,
      NULL,
      41.694546,
      3,
      7,
      53,
      NULL,
      2,
      5,
      1294.774772,
      NULL,
      0.855296,
      1.861293,
      NULL,
      29,
      NULL,
      1,
      95.658168,
      NULL,
      2,
      2.184191,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      182.282437,
      0,
      7.050106,
      93,
      35.833346,
      1.948258,
      1.204432,
      NULL,
      174,
      0,
      5,
      5,
      332,
      3,
      4,
      NULL,
      NULL,
      3,
      7.893766,
      152,
      559.249774,
      3.338474,
      0.633633,
      139,
      108.793513,
      0,
      0.594471,
      79,
      503.459080,
      2.645511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.225570,
      '33401',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      3.925608,
      '13122',
      '',
      '',
      5,
      6.252202,
      NULL,
      NULL,
      54.457843,
      0,
      NULL,
      0,
      NULL,
      0.890488,
      NULL,
      0.621530,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.678602,
      NULL,
      0.430156,
      NULL,
      ' 1-28-1975',
      3.748264,
      11,
      6,
      9,
      2,
      NULL,
      0.739259,
      8,
      8,
      NULL,
      13,
      1,
      NULL,
      12.220637,
      0,
      5.710010,
      12,
      15.721805,
      6,
      11,
      7.685228,
      NULL,
      3,
      16.088474,
      NULL,
      4.210237,
      9,
      NULL,
      19,
      5,
      16.064383,
      14.057877,
      7.434223,
      3,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.786135,
      31.592869,
      2,
      2.349932,
      3.804913,
      0.055269,
      1,
      3.888771,
      3,
      3,
      3,
      NULL,
      1.914015,
      3,
      3.024398,
      NULL,
      3.199094,
      1,
      0.350663,
      2.312560,
      3.765407,
      2.297373,
      0,
      NULL,
      2,
      3,
      31.007993,
      30,
      5,
      29.235801,
      3.662740,
      4.676679,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.339774,
      96,
      47.756994,
      122,
      116,
      135,
      125.558136,
      52.706990,
      39.902117,
      142.865980,
      130.167275,
      27.896485,
      71.337906,
      132.482460,
      NULL,
      134,
      17,
      2,
      75.493915,
      NULL,
      NULL,
      114,
      89.214407,
      43,
      9,
      170,
      69,
      18,
      166.704476,
      136.213809,
      125.431310,
      155.541503,
      126,
      172.961902,
      87.776412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.757066,
      NULL,
      NULL,
      2,
      2.707617,
      2,
      6.568600,
      NULL,
      2.246654,
      NULL,
      7,
      2,
      NULL,
      0,
      9,
      1,
      5.829582,
      0.403464,
      0.747265,
      6,
      1,
      4.272832,
      2,
      4,
      8.689261,
      5,
      NULL,
      4.590488,
      7.917348,
      1,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0.550727,
      3.395434,
      NULL,
      0.042806,
      6,
      0.761253,
      5,
      0,
      7,
      1,
      4.710904,
      0,
      NULL,
      3,
      3.175559,
      0,
      4.332740,
      NULL,
      4,
      1.700132,
      NULL,
      6.170187,
      1,
      NULL,
      3.705775,
      NULL,
      7,
      6,
      NULL,
      2,
      5.029709,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164314,
      1,
      2.411112,
      NULL,
      0.117251,
      0.564002,
      7.970965,
      0.233293,
      3,
      0,
      1,
      1.934123,
      7,
      NULL,
      7.598226,
      1.383468,
      NULL,
      NULL,
      9.690852,
      0,
      NULL,
      3.576573,
      2,
      2,
      4.906534,
      NULL,
      5.621255,
      5.981948,
      NULL,
      NULL,
      9,
      2.254198,
      NULL,
      5.513096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089928,
      0.651897,
      0.993716,
      3.165971,
      2,
      3.643098,
      3,
      3,
      0,
      3,
      3,
      2.797623,
      5,
      3,
      5,
      2.282318,
      0.110074,
      3.587487,
      0.727171,
      NULL,
      1.718377,
      3.401033,
      4.684626,
      0,
      0.046956,
      1.108459,
      2.621074,
      0,
      3.601378,
      1,
      4,
      0.086839,
      0.752629,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.266697,
      9,
      3.303325,
      6,
      1,
      5.992641,
      2,
      6.205260,
      0.187134,
      9.132369,
      NULL,
      3,
      NULL,
      9.564136,
      1.173877,
      6,
      3,
      5,
      0,
      9.300884,
      4,
      NULL,
      0.861732,
      4,
      2,
      NULL,
      1,
      0,
      5.220114,
      4.425137,
      5.271722,
      NULL,
      7.411487,
      5.582040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054449,
      2,
      11.146893,
      2.906245,
      4.350729,
      8.747077,
      5,
      1,
      1.503689,
      NULL,
      2.892071,
      9.470450,
      NULL,
      NULL,
      1,
      4,
      8,
      NULL,
      6,
      3.736051,
      0,
      1,
      6.353900,
      6.510666,
      3.626055,
      0.315417,
      NULL,
      3,
      NULL,
      NULL,
      10,
      0,
      NULL,
      5.776287,
      0.770230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.451294,
      3.296456,
      NULL,
      0,
      7,
      NULL,
      5,
      2,
      5,
      2,
      NULL,
      0,
      7.418768,
      NULL,
      7,
      NULL,
      2,
      NULL,
      5,
      7,
      6.265235,
      NULL,
      8,
      7.639203,
      5,
      5.941543,
      7,
      4,
      2.040081,
      7.272034,
      NULL,
      0.055965,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.062340,
      2.800764,
      NULL,
      5.375831,
      1,
      7,
      4,
      NULL,
      2,
      3,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.762237,
      1.731870,
      2.377290,
      9.243382,
      4.674485,
      3,
      1.716165,
      4,
      6,
      NULL,
      NULL,
      0,
      1,
      1,
      6,
      1.565571,
      1.043445,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504523,
      2,
      4.854638,
      2.108164,
      NULL,
      3.913265,
      NULL,
      3.614122,
      NULL,
      0.842721,
      2.998176,
      NULL,
      2,
      0.241891,
      6.082265,
      3.487386,
      4.008198,
      0,
      NULL,
      0,
      4.175626,
      0,
      5.059361,
      2.516482,
      2,
      NULL,
      6.247199,
      3,
      7,
      2,
      1.688671,
      4.028989,
      4.305995,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431374,
      2,
      NULL,
      NULL,
      7,
      NULL,
      5.195202,
      0,
      1.204406,
      2.489937,
      8.715410,
      1.854106,
      4.567869,
      0.139934,
      6,
      0,
      NULL,
      0.447950,
      9,
      1,
      9.320589,
      3.958289,
      0.280841,
      2,
      2,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884086,
      1,
      0,
      NULL,
      0.751877,
      NULL,
      0,
      NULL,
      NULL,
      2.041488,
      0.784856,
      0.744738,
      1,
      1.475841,
      NULL,
      0,
      1.155010,
      3,
      1,
      1,
      0,
      1.532198,
      1,
      3.665809,
      NULL,
      3.898807,
      0,
      3,
      0.444367,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.433146,
      1,
      1.770865,
      1.292547,
      0,
      1.819565,
      1.201704,
      0.951713,
      1,
      1.332659,
      0,
      0,
      0,
      0.149945,
      NULL,
      0,
      0.823601,
      NULL,
      NULL,
      NULL,
      0.663041,
      0,
      0.001450,
      0.581540,
      0.712425,
      1,
      0.395916,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.073898,
      0.683003,
      1,
      0.335800,
      NULL,
      1.363272,
      0,
      1,
      NULL,
      0.467470,
      0.044907,
      0,
      0.176207,
      NULL,
      1,
      0,
      1.336958,
      0.422175,
      0.142931,
      1.542166,
      NULL,
      0,
      1,
      0,
      1,
      0.424212,
      0,
      0,
      NULL,
      0.652437,
      1.966426,
      0.589316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.187781,
      3.577516,
      1.326108,
      1.798464,
      9,
      0,
      2,
      NULL,
      6,
      3,
      9,
      NULL,
      6.393292,
      1,
      6.995285,
      NULL,
      0,
      NULL,
      NULL,
      2.254369,
      9,
      NULL,
      NULL,
      6.867370,
      5,
      NULL,
      5,
      4.895299,
      0.481696,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.411804,
      1,
      5.429218,
      NULL,
      5.686787,
      NULL,
      3,
      5,
      NULL,
      4,
      6,
      0,
      8.680580,
      1.404645,
      9,
      0.383434,
      6,
      1,
      10.053651,
      7,
      11,
      9,
      2,
      NULL,
      11.794570,
      7.911186,
      8,
      7.417214,
      8.823590,
      6,
      5,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237099,
      0,
      0,
      1,
      0.378497,
      NULL,
      0,
      0,
      0.277177,
      0.300611,
      1,
      1.950438,
      NULL,
      0.253590,
      0,
      NULL,
      0.877361,
      1.430513,
      NULL,
      0.857080,
      1,
      0,
      NULL,
      1.729368,
      0.343317,
      0,
      1.045396,
      0,
      0.027744,
      0.689196,
      0.186470,
      0,
      0,
      1.332078,
      1.143242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.068490,
      0.914395,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.079877,
      NULL,
      0,
      1.891210,
      NULL,
      0,
      0,
      0,
      0.651310,
      0,
      0.737813,
      1,
      1,
      1.737588,
      0,
      1.509787,
      NULL,
      0.144609,
      NULL,
      0.926954,
      0.650912,
      0.790921,
      1.142821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      4,
      2,
      2,
      2,
      1,
      1,
      5,
      2,
      2,
      1,
      2,
      2,
      0,
      1,
      4,
      2,
      NULL,
      2,
      NULL,
      NULL,
      5,
      0,
      4,
      3,
      NULL,
      0,
      2,
      1,
      NULL,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-22-1994',
      NULL,
      ' 8-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-19-1988',
      ' 5- 2-1977',
      NULL,
      NULL,
      ' 7-26-1977',
      '11-28-1995',
      ' 7-23-1989',
      NULL,
      NULL,
      '10- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-15-1979',
      ' 2-16-1978',
      ' 9- 3-1992',
      ' 1- 9-1994',
      '10-25-2000',
      ' 7-26-1981',
      NULL,
      NULL,
      '10-22-1983',
      ' 6- 0-1986',
      ' 2-19-1994',
      ' 3-12-2001',
      '10- 5-1984',
      ' 3-19-1994',
      ' 0-20-1988',
      NULL,
      ' 0-18-1981',
      ' 2-26-2000',
      ' 0- 7-1995',
      ' 9- 0-2001',
      ' 0-25-1986',
      NULL,
      '11-16-1993',
      ' 7-12-1999',
      NULL,
      ' 8- 5-1992',
      '11-27-1979',
      ' 4- 9-1983',
      ' 2-20-1978',
      ' 1-16-1984',
      ' 9-29-1978',
      ' 6- 4-1975',
      ' 0-21-1996',
      ' 1-12-1994',
      ' 8- 7-1994',
      ' 9-20-1978',
      NULL,
      ' 0- 3-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367311);
commit;
end;
/


