set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      2,
      '22123',
      1,
      ' 7-14-1986',
      50.226171,
      NULL,
      1.374377,
      0,
      3,
      1.188230,
      0,
      1,
      0.772614,
      1,
      NULL,
      0.187289,
      1,
      4,
      NULL,
      NULL,
      1.151134,
      NULL,
      0,
      18,
      11.832502,
      6.403848,
      NULL,
      NULL,
      8.887363,
      4.867010,
      3,
      NULL,
      0,
      2.501676,
      7,
      8,
      0,
      0,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      3,
      0.553047,
      6,
      1,
      NULL,
      1,
      NULL,
      0,
      0.227454,
      3,
      9,
      3.816950,
      0,
      2.539834,
      4,
      7,
      9,
      5.902692,
      5,
      7.486047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      4,
      NULL,
      NULL,
      275.790125,
      8.070368,
      1,
      0.129061,
      NULL,
      149.350151,
      1.773647,
      7,
      NULL,
      24,
      1.729787,
      3,
      598.790632,
      20.703070,
      1,
      NULL,
      NULL,
      52.617295,
      3,
      NULL,
      160,
      18.148875,
      0,
      4.891275,
      132,
      173.298894,
      1.373489,
      4.450975,
      530.059097,
      28,
      2,
      0.608259,
      197.959619,
      106,
      3.991332,
      NULL,
      NULL,
      112,
      2,
      1.689105,
      101,
      112.883868,
      0.848858,
      1,
      NULL,
      325.778343,
      3.330779,
      6,
      97.307702,
      560,
      2,
      NULL,
      NULL,
      471,
      3.929092,
      NULL,
      275.794867,
      554.584475,
      2.154762,
      2.651784,
      49,
      61,
      0.637746,
      6,
      140,
      211.973636,
      0,
      NULL,
      189,
      389,
      0.300126,
      5,
      NULL,
      41,
      3,
      0,
      124.532348,
      419,
      3.670514,
      3.292104,
      140.971017,
      9.002005,
      0,
      0.594955,
      215.887027,
      17.166074,
      2,
      2.104976,
      108,
      NULL,
      NULL,
      5.492808,
      576.237379,
      65.904369,
      3,
      0.083024,
      0,
      24,
      0,
      1,
      575,
      39,
      2,
      5.300078,
      306,
      114.981842,
      3.545417,
      7,
      140.592247,
      0.191065,
      1,
      NULL,
      150.591288,
      196.877184,
      1,
      0.967256,
      514,
      108,
      0.499405,
      0.156718,
      156.209181,
      NULL,
      NULL,
      NULL,
      246.749542,
      NULL,
      0.988416,
      NULL,
      149,
      5,
      2.400674,
      1.239650,
      80.816114,
      155,
      0.218039,
      5,
      13,
      16.763189,
      NULL,
      NULL,
      22.018171,
      90.166393,
      2.175129,
      3,
      336.428492,
      5,
      0.547618,
      3.263236,
      46.535921,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '21104',
      '0202',
      '',
      '',
      NULL,
      '',
      0,
      '24202',
      '',
      '',
      1.770674,
      '',
      '',
      '',
      NULL,
      1,
      19,
      3,
      NULL,
      0.924641,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      1.544528,
      NULL,
      NULL,
      NULL,
      0.941320,
      NULL,
      NULL,
      NULL,
      0.828429,
      NULL,
      NULL,
      NULL,
      2.032595,
      4.237042,
      6.529507,
      13.417115,
      14.656187,
      17.076468,
      NULL,
      7.489153,
      8.624248,
      NULL,
      0,
      1.586273,
      1,
      3.410881,
      3,
      2.925528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      14,
      6,
      6.037835,
      5,
      25,
      18,
      16.750656,
      46,
      25.595133,
      3.284079,
      18,
      3.025463,
      8.131752,
      15.820018,
      23.575948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.962326,
      81,
      170,
      NULL,
      69,
      93,
      103.211453,
      NULL,
      NULL,
      154.956224,
      8.425673,
      0,
      109,
      183.010054,
      154.467369,
      136.359665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.222688,
      3.232576,
      3.356904,
      2.357127,
      0.086254,
      3,
      1.123605,
      NULL,
      3.983469,
      3,
      0.203334,
      NULL,
      3.531226,
      NULL,
      3,
      1.068856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.787701,
      NULL,
      3.427091,
      3.577093,
      6,
      NULL,
      NULL,
      0.787357,
      NULL,
      NULL,
      6.362223,
      1,
      7,
      0.897170,
      3,
      2.660573,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0.821494,
      1.337748,
      1,
      0,
      3.008357,
      1,
      0,
      4,
      5.216434,
      0.764498,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998396,
      1,
      NULL,
      1.515530,
      0.654309,
      0,
      0.632949,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.148484,
      NULL,
      0.887089,
      1.095290,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      5.626527,
      NULL,
      5,
      NULL,
      NULL,
      3,
      3,
      2,
      6,
      4,
      6,
      3.578381,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.689519,
      2.372852,
      6.137036,
      3,
      9.004272,
      1,
      3,
      NULL,
      NULL,
      5,
      5,
      0.845985,
      7.057244,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.259091,
      5.687435,
      1.479016,
      NULL,
      1.522036,
      1.433489,
      1,
      2,
      7,
      0,
      5.847942,
      2.906745,
      8.327440,
      8,
      0.001182,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.310339,
      NULL,
      0.365137,
      2,
      5.349630,
      3.051849,
      6.121865,
      NULL,
      6,
      NULL,
      4.700163,
      0,
      3,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      7.435725,
      0,
      0,
      6.816627,
      5,
      0.638016,
      7.602167,
      3,
      5.906991,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846560,
      1.077226,
      0.879537,
      0,
      0,
      NULL,
      NULL,
      0,
      1.930658,
      NULL,
      NULL,
      1,
      NULL,
      0.873146,
      1,
      0.527540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110223,
      1.529619,
      1.406186,
      0.194088,
      0,
      0,
      1.850669,
      1,
      0.189235,
      NULL,
      0.689117,
      0.883408,
      0,
      0.232441,
      0,
      0,
      1.631164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.019199,
      NULL,
      NULL,
      3.757262,
      2.457632,
      7.994458,
      3,
      4,
      NULL,
      6.524384,
      5,
      NULL,
      8.082640,
      4.020791,
      3.606501,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      8,
      4.299023,
      2.866575,
      1,
      4,
      2,
      NULL,
      3,
      6,
      6.113928,
      3,
      6,
      2,
      3,
      1,
      1.503060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.171640,
      NULL,
      3,
      0,
      NULL,
      2,
      0,
      1,
      4,
      0.917687,
      NULL,
      5,
      8,
      9,
      1.174848,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.582016,
      NULL,
      0,
      2,
      3.960066,
      NULL,
      NULL,
      9.873111,
      NULL,
      8.629039,
      NULL,
      2,
      3.239456,
      3.261849,
      5.998445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.279116,
      1.584252,
      NULL,
      1.507189,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.362864,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.762447,
      NULL,
      NULL,
      2,
      6,
      5.910823,
      0,
      2,
      2.392374,
      5.067346,
      5.025780,
      4,
      0.294185,
      5,
      5.709524,
      3.331060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      4,
      NULL,
      2,
      3,
      3,
      3,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      5,
      0,
      0,
      NULL,
      7,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-1976',
      ' 6-26-1981',
      ' 1-23-1986',
      NULL,
      ' 6- 2-1996',
      ' 1-20-1994',
      ' 4-20-1975',
      ' 1-16-1984',
      ' 5-20-1982',
      ' 0- 8-1976',
      ' 0-23-1987',
      ' 5-19-1988',
      ' 0-19-1978',
      ' 7-20-1980',
      ' 8-29-1984',
      NULL,
      ' 8- 8-1994',
      ' 4- 9-2000',
      ' 3- 2-1983',
      ' 1-15-1983',
      ' 3-13-1977',
      NULL,
      ' 6-23-1982',
      ' 1-18-1982',
      ' 3-10-1983',
      ' 8- 6-1997',
      ' 2- 7-1999',
      NULL,
      NULL,
      '10-22-1983',
      NULL,
      ' 3-15-1994',
      ' 4-28-1994',
      '11- 3-1975',
      ' 0-19-1977',
      NULL,
      ' 8-23-1990',
      ' 4-14-2000',
      ' 6-22-1993',
      ' 7- 5-2000',
      ' 2- 5-1991',
      ' 9-22-1986',
      ' 5- 5-1980',
      ' 9-21-1990',
      ' 8- 3-1975',
      ' 7- 1-1997',
      NULL,
      ' 7-19-1982',
      ' 9- 9-1994',
      ' 4-10-1988',
      ' 2- 2-1992',
      ' 1- 8-1999',
      ' 0-21-1978',
      ' 1-10-1977',
      NULL,
      '11-21-1993',
      NULL,
      ' 5- 0-1982',
      NULL,
      ' 4-18-1994',
      ' 2-10-1995',
      '11-27-1996',
      ' 4- 8-1991',
      ' 7-27-1992',
      ' 6-23-1982',
      ' 2-23-1978',
      ' 2-15-1976',
      '11-19-1981',
      ' 4- 0-1979',
      ' 0- 2-1981',
      '10- 4-1995',
      NULL,
      '10-16-1992',
      ' 1-24-1990',
      ' 7-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-19-1976',
      ' 9-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377714);
commit;
end;
/


