set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '4423301',
      NULL,
      4,
      1,
      '44433',
      NULL,
      ' 7-17-2001',
      4.895018,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.070669,
      NULL,
      NULL,
      3,
      2.014875,
      1.603554,
      4,
      5,
      8,
      3.295261,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      10.219511,
      9.132258,
      3,
      NULL,
      5,
      5,
      9,
      4,
      2,
      6,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      6,
      NULL,
      NULL,
      3,
      1,
      0,
      1.461989,
      0.692181,
      0,
      0,
      NULL,
      6.564693,
      1.704814,
      5,
      2,
      NULL,
      NULL,
      6,
      5,
      2,
      0.713835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941309,
      3,
      NULL,
      2,
      4.006125,
      0,
      NULL,
      121.686894,
      14.703755,
      3,
      9.426391,
      113,
      NULL,
      2.301355,
      3.010858,
      151,
      0,
      0.039047,
      5,
      48.314060,
      7,
      3,
      4.798755,
      NULL,
      19.076519,
      2,
      NULL,
      67,
      112,
      7.396498,
      NULL,
      325,
      NULL,
      0,
      2.576943,
      281.395080,
      NULL,
      NULL,
      1.153748,
      35,
      0,
      2,
      0,
      NULL,
      33.098040,
      0,
      3.794065,
      165.397716,
      NULL,
      1.430048,
      1,
      34.430563,
      NULL,
      1.466633,
      1,
      35.370453,
      4577.578121,
      3.154561,
      1.947950,
      NULL,
      17,
      7.223855,
      3,
      141.643169,
      32.779769,
      2.778600,
      3.729266,
      NULL,
      25,
      7.370920,
      6.864906,
      54.308158,
      24.329767,
      8,
      0.953014,
      67,
      14.598527,
      2.287141,
      9.635609,
      138.014653,
      NULL,
      5,
      NULL,
      26.361258,
      10,
      2,
      2,
      107,
      8,
      1,
      2.091295,
      NULL,
      9.762364,
      0.375539,
      4.725355,
      115.765377,
      6,
      3.340688,
      0,
      NULL,
      123,
      8,
      0.610160,
      NULL,
      NULL,
      2.895802,
      8,
      3,
      6,
      1,
      NULL,
      NULL,
      NULL,
      1.060972,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '01310',
      '',
      '',
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      3,
      105.634928,
      0,
      NULL,
      NULL,
      NULL,
      1.477487,
      NULL,
      1,
      NULL,
      0.031745,
      NULL,
      0.268393,
      NULL,
      1,
      NULL,
      1.372307,
      NULL,
      1.992086,
      NULL,
      ' 4-15-1997',
      4.701598,
      2,
      NULL,
      11.104742,
      6,
      1,
      NULL,
      3.378101,
      0.953254,
      11,
      5,
      2,
      11.535259,
      NULL,
      19.032853,
      4,
      0.629891,
      8,
      7,
      11,
      11.477197,
      2,
      0.820354,
      6.887134,
      12,
      2.835347,
      23.088099,
      5,
      NULL,
      12.150819,
      NULL,
      11.251856,
      14,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.383984,
      24,
      11.445635,
      3,
      20,
      3,
      35.660388,
      1,
      NULL,
      2.037732,
      18,
      18,
      14.568269,
      15,
      36.431480,
      6,
      NULL,
      4,
      24,
      4.640596,
      0,
      8.574884,
      NULL,
      21.972561,
      NULL,
      6.564741,
      24,
      17.391076,
      NULL,
      16,
      12.715667,
      4,
      0.026493,
      45.563978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      NULL,
      39.588980,
      NULL,
      146.147391,
      62.098096,
      111.343670,
      39,
      8,
      172.343088,
      110,
      126.136862,
      48,
      134.187095,
      174,
      70.395048,
      20,
      178,
      142,
      61,
      37.672965,
      38.012564,
      NULL,
      142.174559,
      175.621174,
      4.163034,
      121.900678,
      176.174901,
      107.147358,
      79.540671,
      147,
      23.881372,
      5.606652,
      87.620777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.835015,
      7.979273,
      NULL,
      9,
      7.039963,
      1.937064,
      0,
      2.079210,
      1,
      NULL,
      2,
      0.015510,
      1,
      3,
      NULL,
      NULL,
      NULL,
      6,
      1.943408,
      NULL,
      NULL,
      4,
      0.383632,
      6,
      8,
      3.587660,
      6.455570,
      2,
      6,
      1,
      4,
      5.454672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035266,
      1,
      NULL,
      0.595984,
      1.696322,
      3,
      0,
      0.654717,
      0.972282,
      0.751640,
      NULL,
      0,
      1,
      1,
      1.780054,
      1,
      1.709079,
      1.662409,
      1.845590,
      0.823445,
      NULL,
      NULL,
      1,
      NULL,
      1.203025,
      5.943650,
      4,
      11,
      9,
      10.351936,
      NULL,
      0,
      NULL,
      1.753143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082221,
      1.291727,
      2.694458,
      1,
      7,
      NULL,
      2.229226,
      1,
      0,
      NULL,
      0.151270,
      0.989090,
      NULL,
      0,
      0,
      5,
      7.411476,
      1,
      0,
      2.484149,
      5,
      NULL,
      5,
      2,
      NULL,
      6.331196,
      6,
      NULL,
      NULL,
      4.567629,
      NULL,
      0.305701,
      4.426355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.549363,
      0.845927,
      0,
      1.632122,
      1,
      0.201802,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.652903,
      0,
      NULL,
      NULL,
      0,
      0,
      1.576950,
      0.922974,
      1.830123,
      1,
      1.372617,
      1,
      2.652972,
      3.647047,
      1,
      1,
      0.929677,
      NULL,
      0.572213,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.831769,
      4.004774,
      5,
      4.175933,
      5.135411,
      2.215480,
      1.513131,
      0.532573,
      2,
      4,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.029541,
      5,
      NULL,
      3.127126,
      0,
      4,
      3.898969,
      1.662544,
      NULL,
      1,
      6.805835,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7.886651,
      6.564205,
      5,
      3.847516,
      9.914023,
      NULL,
      0.117459,
      NULL,
      9.579872,
      3,
      NULL,
      NULL,
      1.093514,
      3,
      1,
      5.658141,
      4,
      3.682763,
      6,
      NULL,
      4.290992,
      3,
      2,
      NULL,
      2.863692,
      NULL,
      8.119199,
      5,
      NULL,
      7,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601999,
      NULL,
      0,
      1.148248,
      0.465085,
      1,
      1.472352,
      NULL,
      3,
      2.876920,
      4,
      7.016190,
      0.012344,
      5.138379,
      1.854111,
      1.445306,
      3,
      0,
      NULL,
      4,
      8,
      NULL,
      4,
      1,
      NULL,
      0.289305,
      7,
      9,
      0,
      NULL,
      1.265921,
      2,
      0.149840,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276095,
      5,
      3,
      0,
      0.582841,
      4.442080,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      1.946750,
      5,
      4,
      2,
      3.607082,
      NULL,
      0.325752,
      NULL,
      1,
      NULL,
      3,
      1,
      3,
      4.470189,
      3,
      0.457274,
      3,
      3,
      1.995497,
      4.854225,
      0,
      5.042504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      2.830734,
      0.395281,
      1.321698,
      2.953986,
      1.308856,
      1,
      NULL,
      0.340243,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812553,
      5.194825,
      5,
      4,
      0.084249,
      1,
      2,
      2.218191,
      2,
      3.084797,
      NULL,
      1.174834,
      0.973015,
      4.879881,
      3.445775,
      NULL,
      2.673677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.667828,
      2.496063,
      3.387935,
      3,
      2,
      1,
      3,
      0.096379,
      0,
      1,
      1,
      1.801094,
      0.640043,
      1,
      1.278140,
      1,
      NULL,
      1.376862,
      0,
      1,
      0.883291,
      NULL,
      1.326677,
      0,
      1,
      4,
      4,
      NULL,
      2,
      NULL,
      5,
      2,
      0.731746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290948,
      1,
      1,
      0,
      NULL,
      0.142579,
      1.213122,
      NULL,
      0.313897,
      NULL,
      1.641217,
      1,
      1.275657,
      0,
      1.184136,
      1.235217,
      0.810060,
      1,
      1.255988,
      NULL,
      1,
      0.730626,
      0,
      0,
      1.379400,
      1,
      NULL,
      0.594875,
      0,
      1,
      0.511220,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.837160,
      0.118131,
      0,
      0.522993,
      1.357444,
      1,
      NULL,
      0.120103,
      0.309869,
      1,
      1.700009,
      0.404840,
      0,
      0,
      0,
      NULL,
      1.501309,
      NULL,
      0.692033,
      3.654537,
      3,
      3.836394,
      2,
      1,
      0.153485,
      1,
      1.561050,
      1,
      1.804032,
      1.876791,
      1,
      NULL,
      0.116338,
      1.010722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551042,
      1.548085,
      1.469512,
      1,
      1.189594,
      1,
      NULL,
      0,
      NULL,
      1.086048,
      0,
      1,
      1.736454,
      1.202787,
      1,
      NULL,
      2.703713,
      1.099627,
      2,
      0.774263,
      0,
      1,
      0,
      1.751987,
      0.793707,
      1,
      NULL,
      0.717683,
      0.647141,
      1.081939,
      0.211408,
      0.087952,
      1,
      1.394316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558222,
      2.561847,
      NULL,
      4,
      1,
      3.802065,
      0.912510,
      7.542529,
      2,
      NULL,
      3,
      NULL,
      NULL,
      3.578080,
      0,
      0.567138,
      3,
      NULL,
      4,
      1,
      2,
      4,
      1.379211,
      3.122827,
      6,
      4,
      NULL,
      NULL,
      5,
      0,
      9,
      NULL,
      4,
      1.837282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.127762,
      3,
      4.038866,
      NULL,
      3.695821,
      NULL,
      0.678369,
      5,
      4,
      0.905232,
      NULL,
      4,
      NULL,
      2,
      5,
      0.292406,
      7.860557,
      4,
      0,
      5,
      1.918591,
      4.491847,
      1.020055,
      0.817602,
      3.638078,
      NULL,
      NULL,
      7.927073,
      4,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.104764,
      1,
      NULL,
      0,
      0.479580,
      0.076284,
      0.672085,
      NULL,
      1.809005,
      0.566592,
      0,
      1,
      1.874197,
      NULL,
      1,
      NULL,
      0.305596,
      NULL,
      NULL,
      0.980168,
      1,
      1,
      0.146079,
      1,
      0.268737,
      0,
      0.172038,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.980177,
      1,
      0,
      0,
      1,
      1.065081,
      0.360974,
      NULL,
      0,
      0.637394,
      0,
      1,
      0.052291,
      0.916736,
      1.430084,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      0.092957,
      0.570058,
      0,
      1,
      0,
      NULL,
      0.666527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4,
      3,
      1,
      2,
      0,
      NULL,
      0,
      2,
      5,
      NULL,
      3,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      3,
      3,
      7,
      7,
      NULL,
      2,
      NULL,
      1,
      1,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1993',
      ' 2- 3-1997',
      ' 9-18-2000',
      NULL,
      '11-12-2000',
      ' 9-15-1986',
      ' 8-11-1976',
      ' 2- 7-1983',
      '11-15-1978',
      ' 2- 7-2001',
      ' 9-29-1975',
      ' 2-23-2000',
      ' 4-26-1992',
      ' 7- 8-1977',
      ' 9-15-1997',
      ' 0-24-1981',
      ' 6-24-1995',
      ' 1- 2-1985',
      ' 0-23-1999',
      ' 6- 7-1995',
      NULL,
      NULL,
      ' 5-12-1997',
      NULL,
      ' 1-12-1974',
      '11-27-1978',
      NULL,
      ' 5-10-1981',
      NULL,
      ' 2-10-1983',
      ' 4-24-1977',
      '10- 3-1997',
      NULL,
      '11-21-1979',
      '11-24-1975',
      ' 8-23-1984',
      ' 1- 6-1999',
      ' 8- 7-1996',
      '11- 0-2001',
      ' 2-20-1997',
      ' 3-21-2000',
      ' 2-19-1986',
      ' 7-12-1990',
      ' 4-20-1995',
      ' 2-10-1978',
      ' 5-14-2000',
      ' 1- 2-1991',
      ' 4-17-1989',
      ' 7-15-1986',
      ' 9-21-1996',
      ' 9-21-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


