set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7409886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '1204132',
      0,
      NULL,
      2,
      '10044',
      2.648387,
      ' 1-19-1989',
      NULL,
      NULL,
      NULL,
      0,
      0.649598,
      NULL,
      1.615222,
      3,
      0.659168,
      1,
      0.945878,
      NULL,
      0.201320,
      6,
      NULL,
      NULL,
      1.929109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      4,
      2,
      5,
      2,
      0.977601,
      1.364363,
      0.591934,
      0.913464,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      2,
      6,
      4.277187,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      45.588124,
      NULL,
      24.191656,
      0,
      1,
      174,
      33,
      0,
      NULL,
      166,
      19,
      0,
      8.083484,
      NULL,
      30.047133,
      0.499295,
      4.805201,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      147.317892,
      NULL,
      0.191161,
      0,
      156.843937,
      2,
      3,
      2.178678,
      NULL,
      15.215013,
      2,
      1,
      294,
      296.342266,
      2.556976,
      6,
      162.437925,
      1139.264129,
      2.644308,
      2,
      58,
      13,
      1.139047,
      6.310112,
      440,
      123,
      NULL,
      2.547303,
      123.307610,
      1,
      1,
      0,
      278.791335,
      NULL,
      2,
      0,
      223,
      0,
      0,
      6.492931,
      NULL,
      39,
      0,
      3.516715,
      68,
      16,
      2,
      NULL,
      138,
      NULL,
      NULL,
      NULL,
      54.635478,
      3,
      2.487592,
      0,
      NULL,
      NULL,
      2.500452,
      8,
      199,
      28,
      NULL,
      2.529582,
      9.368250,
      NULL,
      2.519933,
      0,
      NULL,
      14.710432,
      0.140620,
      0.432293,
      158,
      NULL,
      3.042409,
      3,
      72,
      8,
      3.910518,
      3.966583,
      123,
      1.246563,
      1,
      NULL,
      340.690360,
      187,
      1,
      2,
      521.454396,
      454.804695,
      1.262867,
      3.275715,
      157.409816,
      NULL,
      3,
      0.634331,
      693,
      148,
      3,
      2.620362,
      85.526723,
      6,
      3,
      NULL,
      NULL,
      1593,
      1,
      2.445667,
      183,
      7.661458,
      2.486269,
      0,
      NULL,
      12.319040,
      3.486135,
      3.696421,
      54,
      489,
      2.066586,
      2.463002,
      15,
      0.690240,
      NULL,
      1.665799,
      NULL,
      NULL,
      0.590510,
      1.774074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '02440',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      3,
      5,
      NULL,
      2.797962,
      0.590292,
      NULL,
      NULL,
      0.311663,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.309389,
      NULL,
      1,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      18.002369,
      0.096013,
      8.554523,
      NULL,
      0,
      13,
      10.716681,
      8,
      3,
      5,
      11.742954,
      3.531577,
      5.816061,
      NULL,
      9,
      NULL,
      2,
      8.061229,
      NULL,
      9.103692,
      25.450784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043163,
      0,
      8,
      2.722788,
      23.942441,
      27,
      6,
      1.037856,
      0,
      27,
      2.859292,
      0,
      34.730654,
      2,
      21.677033,
      18.790272,
      14,
      17.403406,
      13,
      5.630589,
      10,
      14,
      13,
      8.226735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.864498,
      2,
      31,
      63.982701,
      78.896246,
      165.301157,
      35.291560,
      126.240266,
      NULL,
      67.121992,
      143.600013,
      NULL,
      169.641289,
      NULL,
      174.805088,
      139.237216,
      136.869352,
      4.948187,
      NULL,
      33,
      167.167655,
      46.996240,
      NULL,
      161.326977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.243182,
      8.601346,
      5,
      NULL,
      3.843106,
      7.129371,
      3.887608,
      1,
      NULL,
      2.034115,
      NULL,
      4.541974,
      2,
      3,
      5,
      1,
      3,
      1,
      5.083214,
      0.664994,
      1,
      8.911661,
      3.053654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.660034,
      2,
      NULL,
      1,
      0.074819,
      0,
      5,
      0,
      3.497924,
      NULL,
      7.223181,
      6.300073,
      0,
      0,
      0,
      NULL,
      NULL,
      1.083199,
      6.732813,
      3,
      0.651642,
      NULL,
      0.733856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      1.012498,
      0,
      3.884401,
      NULL,
      NULL,
      NULL,
      3,
      3.241257,
      0,
      3.597029,
      1,
      3,
      0,
      4,
      1.000736,
      NULL,
      1,
      1,
      0.527323,
      NULL,
      1.017419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.343707,
      1,
      NULL,
      0.949529,
      0,
      3.952752,
      5.794524,
      3.438100,
      4.055659,
      3.609673,
      2,
      1,
      5,
      0.450088,
      1.535572,
      1.374602,
      9,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.658204,
      NULL,
      NULL,
      0,
      5,
      0.563310,
      5,
      NULL,
      4,
      0.333900,
      5,
      2.956826,
      5.325664,
      5,
      5,
      0.898147,
      NULL,
      NULL,
      NULL,
      0.251798,
      5.022456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.890955,
      2.035667,
      1.408641,
      3.734675,
      2.499606,
      NULL,
      3,
      2,
      5.987824,
      0.788162,
      5,
      6,
      3,
      4,
      0.664199,
      0.561408,
      3.763197,
      4,
      1,
      4,
      NULL,
      1.548774,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.641624,
      7.380875,
      3,
      7,
      3,
      0.134572,
      4.098045,
      7.703633,
      3.468666,
      0,
      NULL,
      3,
      5,
      1,
      4.057705,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.352509,
      0,
      1,
      0,
      0,
      0.477953,
      0,
      NULL,
      NULL,
      0.590785,
      0.028251,
      1,
      NULL,
      0,
      0,
      NULL,
      0.951617,
      0,
      NULL,
      5.973119,
      0.901248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      0,
      NULL,
      NULL,
      2,
      7.593746,
      4,
      NULL,
      3.130928,
      1,
      NULL,
      6.300814,
      0.729315,
      3,
      NULL,
      NULL,
      4,
      3,
      4.184301,
      1,
      1.769424,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.199429,
      9.714094,
      0,
      1.914186,
      0,
      NULL,
      1,
      4.751885,
      NULL,
      NULL,
      NULL,
      5.872893,
      1,
      4.366213,
      1.031708,
      0.440079,
      NULL,
      NULL,
      1.620550,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015646,
      0,
      2.307716,
      1.367805,
      NULL,
      0.741264,
      0.999585,
      0,
      NULL,
      1.928325,
      0.898710,
      0,
      0,
      NULL,
      5,
      0,
      3,
      1.623436,
      0.152475,
      1.311949,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.293581,
      0,
      1.720382,
      5,
      4,
      NULL,
      NULL,
      2,
      0,
      1,
      0.892224,
      1,
      0.024415,
      1.737013,
      1,
      0.110201,
      0,
      1.388101,
      NULL,
      1,
      0.583280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579782,
      NULL,
      0.330231,
      1.494091,
      1.824551,
      5.916269,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.152167,
      2,
      0.253428,
      0,
      0.873274,
      NULL,
      NULL,
      7,
      NULL,
      0.764462,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.181916,
      4,
      2,
      2.150703,
      3,
      1,
      3.017912,
      NULL,
      NULL,
      2.515687,
      2.078439,
      6,
      NULL,
      4.064743,
      7,
      0,
      8.204791,
      5,
      8.317208,
      1,
      9,
      NULL,
      NULL,
      1.561326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417106,
      3.183464,
      7.585081,
      3.096089,
      6,
      2.206300,
      7,
      NULL,
      1,
      6.494685,
      0,
      0.877183,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      1.900089,
      NULL,
      0,
      1.624712,
      2,
      1.221322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099190,
      NULL,
      5.084838,
      0,
      NULL,
      1,
      1,
      1.787299,
      1,
      0,
      NULL,
      1,
      0,
      0,
      3.942033,
      1,
      2.194530,
      NULL,
      1.527271,
      1,
      1,
      0,
      1,
      1.129649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614597,
      1.816121,
      3.609998,
      NULL,
      1.398809,
      2,
      1.309643,
      0.858667,
      1.161439,
      0,
      1.186121,
      1,
      1.191969,
      1.163213,
      NULL,
      1,
      1.596900,
      1,
      0.197605,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      4,
      1,
      5,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      4,
      3,
      2,
      2,
      0,
      1,
      5,
      2,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-20-1998',
      ' 3-18-1983',
      ' 6-15-2003',
      ' 5- 8-2002',
      ' 0- 1-1977',
      NULL,
      ' 5- 4-1994',
      NULL,
      ' 0-27-1988',
      ' 1- 0-1992',
      ' 4-26-1999',
      ' 9-18-1980',
      NULL,
      NULL,
      ' 1-17-1999',
      ' 6-28-1976',
      ' 7-20-1976',
      ' 7-11-1993',
      '10- 1-1991',
      ' 9-11-1988',
      ' 0-20-1994',
      ' 2-27-1997',
      '10-29-1986',
      ' 3-16-1992',
      ' 3- 9-1976',
      ' 3-23-1992',
      ' 7-18-1978',
      NULL,
      ' 2-18-2003',
      ' 9- 9-1989',
      ' 7-28-2001',
      NULL,
      ' 9-12-1979',
      NULL,
      NULL,
      ' 3- 4-2002',
      ' 3-28-1978',
      ' 5- 3-1998',
      NULL,
      NULL,
      ' 2-19-1992',
      ' 6-25-2001',
      '10-22-2002',
      ' 9-23-2003',
      '10-20-2003',
      ' 1-27-1989',
      NULL,
      '10-10-1985',
      NULL,
      ' 9-18-2000',
      ' 0-19-2003',
      ' 7- 1-1992',
      NULL,
      '10-15-1982',
      ' 0-18-1977',
      ' 3- 9-1990',
      '10-23-1992',
      NULL,
      ' 8-14-2001',
      '11-19-1974',
      NULL,
      NULL,
      ' 1-26-1985',
      ' 3- 7-1983',
      ' 4-15-1993',
      ' 7- 8-1998',
      NULL,
      ' 5-16-1985',
      ' 6- 7-1979',
      NULL,
      ' 3-24-1984',
      ' 4-25-1975',
      '11-21-1985',
      ' 9-28-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


