set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8910324';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '1312342',
      1,
      NULL,
      2,
      '00321',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.710064,
      0.534283,
      1,
      NULL,
      1.061563,
      1,
      0.226910,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168662,
      NULL,
      4,
      4,
      1,
      NULL,
      1,
      9,
      4,
      5,
      2,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      8.207737,
      8,
      8,
      1,
      1.885272,
      0,
      1.246517,
      0,
      0,
      0,
      9.137893,
      0,
      NULL,
      9,
      4,
      8,
      5.794134,
      8,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.648216,
      5,
      0,
      1,
      7,
      3,
      45.224359,
      36,
      NULL,
      1.935201,
      NULL,
      69,
      68,
      NULL,
      2.103324,
      79.277855,
      14.733428,
      3.778607,
      7.661854,
      65.458058,
      170.328650,
      2.577065,
      0.202104,
      NULL,
      3.471537,
      1,
      NULL,
      174,
      1,
      1.021145,
      3.909686,
      383,
      59.563953,
      1,
      1.719067,
      NULL,
      10695,
      3.969862,
      1,
      74,
      5,
      2,
      0.561656,
      NULL,
      15.025970,
      NULL,
      0.384668,
      300.456249,
      8.884519,
      NULL,
      1,
      19,
      9,
      3,
      NULL,
      665.533556,
      7721,
      NULL,
      NULL,
      NULL,
      7.420551,
      3.415070,
      1,
      224.070657,
      57,
      1.873400,
      NULL,
      NULL,
      33.382593,
      1.725059,
      2.527573,
      NULL,
      3,
      0,
      1,
      269,
      99,
      2.171412,
      1.039838,
      158.555447,
      44.732458,
      3.553600,
      2,
      125.175510,
      9837,
      3.036420,
      1.018206,
      98.092388,
      17,
      0,
      NULL,
      409.298906,
      556,
      3,
      2,
      68.956634,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '30324',
      '',
      '',
      '',
      '',
      '',
      3,
      '23003',
      NULL,
      '',
      0.963485,
      '',
      '',
      '',
      2,
      2.309715,
      22,
      NULL,
      1127.735300,
      NULL,
      NULL,
      0.192613,
      NULL,
      0.230517,
      NULL,
      0.653368,
      NULL,
      NULL,
      NULL,
      0.065812,
      NULL,
      0.087556,
      NULL,
      1,
      NULL,
      ' 9- 0-1999',
      0,
      12,
      12,
      11,
      5,
      3,
      NULL,
      4.186420,
      7,
      16,
      NULL,
      0,
      8.233380,
      16,
      0.571169,
      9.537300,
      NULL,
      2,
      NULL,
      9.735772,
      13.110907,
      NULL,
      2,
      8.015543,
      NULL,
      NULL,
      1,
      4,
      NULL,
      6,
      9,
      0,
      1.006717,
      12,
      8.854106,
      2.821985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      45,
      8.604108,
      1,
      NULL,
      2,
      2,
      NULL,
      8,
      NULL,
      43,
      25,
      8.980507,
      NULL,
      3,
      26.819040,
      7,
      2,
      13.455340,
      7.240322,
      7.850061,
      2.694135,
      NULL,
      4.747446,
      16.188332,
      2,
      0,
      12.939971,
      1,
      NULL,
      21,
      29,
      2,
      28,
      2.887853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      122.197639,
      6.496089,
      63.560648,
      130,
      25.707610,
      26,
      7.387203,
      NULL,
      61,
      90.879232,
      NULL,
      103,
      NULL,
      9.773022,
      90.543845,
      49.782347,
      3,
      37,
      NULL,
      84.007355,
      101.440135,
      NULL,
      NULL,
      73,
      50,
      85,
      93,
      128.588657,
      67.186669,
      60,
      5.489538,
      11.040480,
      132,
      148,
      15.214675,
      159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.653322,
      5,
      0.790919,
      5,
      2.799747,
      0,
      0,
      0,
      3.042720,
      3.155599,
      0.391561,
      NULL,
      1,
      6.601325,
      4,
      NULL,
      1.763485,
      3.240866,
      NULL,
      2.978154,
      3,
      2.791619,
      1.746144,
      2.585627,
      1.244626,
      0,
      NULL,
      NULL,
      7.978611,
      0,
      NULL,
      5,
      6,
      1.874644,
      7,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398409,
      1,
      0.821401,
      0.510656,
      1,
      0.774221,
      0.374861,
      NULL,
      1,
      1.208813,
      1,
      0.848292,
      0,
      0,
      0.602640,
      0.428362,
      1,
      0,
      NULL,
      1.626467,
      NULL,
      0,
      1,
      NULL,
      0.864312,
      1.855140,
      1,
      1.172861,
      1.484432,
      0,
      1.496332,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.869453,
      2,
      0,
      NULL,
      0,
      6.864270,
      NULL,
      3,
      NULL,
      0.586363,
      0.283260,
      NULL,
      1.506395,
      0,
      NULL,
      3,
      5,
      3.581688,
      NULL,
      2.117410,
      2,
      4,
      5,
      1.141349,
      NULL,
      1,
      7.939661,
      4.526562,
      3.747136,
      5.184010,
      3,
      1,
      0.094387,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.904735,
      1,
      0,
      1.935050,
      0,
      1,
      0,
      NULL,
      1.958336,
      1.373013,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1.105798,
      0,
      NULL,
      0.611798,
      0.451664,
      0,
      NULL,
      1.374304,
      1,
      0.647611,
      1,
      1.203794,
      NULL,
      NULL,
      NULL,
      1,
      1.219508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.761323,
      0,
      1,
      0.966388,
      1.063272,
      1,
      0.486853,
      1.316550,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1.937135,
      1,
      1,
      0,
      0,
      1,
      1.340236,
      NULL,
      0,
      0.085004,
      0,
      1.972773,
      1,
      1.159701,
      0,
      1.876972,
      0.701920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.843107,
      6.983147,
      7.075106,
      1.885718,
      9.638642,
      NULL,
      1,
      9,
      NULL,
      NULL,
      9.797578,
      6,
      8,
      8.553268,
      4,
      4.776509,
      9.477622,
      9.378915,
      NULL,
      9.903746,
      4,
      8,
      1,
      6,
      3.359372,
      0,
      5,
      1,
      NULL,
      6.874027,
      8,
      6.745289,
      8,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.537727,
      4,
      0,
      6,
      NULL,
      1.657927,
      NULL,
      1,
      2,
      7,
      3,
      NULL,
      6.086038,
      5,
      NULL,
      1.780776,
      NULL,
      7.814880,
      NULL,
      NULL,
      4.914361,
      NULL,
      0,
      NULL,
      0.108675,
      0.523716,
      NULL,
      NULL,
      9.940977,
      2,
      3.388921,
      8.335344,
      1.277608,
      8,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.524648,
      0.876953,
      4,
      NULL,
      3,
      0.703124,
      NULL,
      0.704730,
      2.679415,
      1.426384,
      3.688381,
      3,
      2,
      2.348082,
      1,
      5,
      2,
      5,
      1.646943,
      1.054430,
      1.553954,
      1,
      3.779460,
      2,
      0.794862,
      NULL,
      5,
      4.918671,
      NULL,
      1,
      3,
      4,
      1,
      NULL,
      1.504985,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.501954,
      1.772227,
      0,
      1.110995,
      NULL,
      1.839866,
      NULL,
      1.514179,
      NULL,
      1,
      0.874881,
      1,
      0,
      0,
      1,
      0,
      0,
      1.519203,
      1,
      1.696543,
      0,
      1,
      NULL,
      0,
      0.364582,
      1.519660,
      1,
      0.446055,
      1,
      NULL,
      1.893636,
      1,
      0.626660,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804919,
      0,
      0,
      0,
      1,
      NULL,
      1.568842,
      1,
      1.395228,
      1.925685,
      NULL,
      0,
      1.219789,
      1,
      0,
      NULL,
      0.829367,
      1,
      0,
      1.246768,
      1.453274,
      0.350433,
      0.889838,
      1.325588,
      NULL,
      NULL,
      NULL,
      0,
      1.642699,
      NULL,
      1.396322,
      1,
      0,
      1.892061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445878,
      1.059327,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.494619,
      NULL,
      0.810327,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.151384,
      0,
      1,
      NULL,
      1.759993,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.303203,
      0.328693,
      0.569680,
      0.755722,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1,
      3.739891,
      1.655902,
      0,
      1.934589,
      1.931075,
      1.250002,
      1,
      0,
      1,
      1.530421,
      4.081990,
      5.853421,
      NULL,
      5,
      4.608037,
      NULL,
      3,
      4.159097,
      5.697439,
      0.968983,
      4,
      0,
      1,
      NULL,
      5.031094,
      2.445088,
      2.059161,
      3.029646,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.934172,
      NULL,
      1,
      2,
      4.479328,
      NULL,
      4,
      4.062947,
      0,
      0.974305,
      5.968902,
      5.888484,
      0.770591,
      0,
      1.953555,
      2.761378,
      1.640442,
      0.595145,
      0,
      1,
      1.999096,
      0,
      1.714414,
      0,
      1,
      0.066530,
      1,
      1.526540,
      NULL,
      0.120191,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      7,
      7.124570,
      1.709425,
      1,
      5,
      6,
      4.309069,
      6,
      6,
      6.619537,
      6.050283,
      0.414038,
      5.881099,
      3,
      3,
      NULL,
      3.481154,
      4.794922,
      1.749657,
      NULL,
      5.077449,
      2,
      5,
      NULL,
      1.875987,
      4.315022,
      2.551207,
      0.698965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.941179,
      1.559116,
      4.980106,
      9,
      11.274352,
      0.798926,
      0,
      NULL,
      0.835456,
      5,
      0,
      7.134724,
      8,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      8.507927,
      4,
      NULL,
      1.783333,
      9.896327,
      0,
      7,
      9.913958,
      1.299157,
      0.579384,
      NULL,
      9,
      5,
      6,
      NULL,
      5.917747,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510102,
      0,
      1.670847,
      1,
      NULL,
      NULL,
      0.764527,
      1,
      0.489028,
      0,
      0,
      0,
      0.477289,
      0,
      0.709211,
      0,
      0,
      1.396459,
      1.545490,
      1,
      NULL,
      0.601102,
      1.092952,
      1,
      NULL,
      1,
      1.258506,
      0,
      1.726817,
      0.575469,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.569087,
      3.690022,
      5,
      5,
      NULL,
      3.187790,
      2,
      0.226231,
      0,
      NULL,
      1.430006,
      0,
      1,
      3.702610,
      2,
      1,
      0.276770,
      1.045178,
      1.228478,
      2.215624,
      3.248083,
      NULL,
      3.400472,
      3.345150,
      4.300784,
      4,
      3,
      3,
      NULL,
      5,
      5,
      2,
      NULL,
      4,
      2.917236,
      2.955523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3,
      1,
      3,
      4,
      0,
      1,
      1,
      2,
      2,
      NULL,
      5,
      NULL,
      2,
      3,
      0,
      NULL,
      1,
      2,
      3,
      1,
      2,
      NULL,
      5,
      2,
      2,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1990',
      ' 5- 6-1989',
      NULL,
      ' 8-27-1983',
      ' 1-14-1997',
      ' 9-19-1997',
      NULL,
      '11-19-2002',
      NULL,
      ' 3-26-2000',
      NULL,
      '10- 9-1994',
      NULL,
      ' 1-12-1997',
      NULL,
      ' 4-13-2002',
      NULL,
      ' 7- 2-1996',
      NULL,
      ' 4-29-1983',
      ' 8-20-1996',
      ' 5- 6-1975',
      ' 9- 6-1974',
      ' 3-19-1988',
      '10-18-1990',
      ' 0-19-1999',
      ' 4-19-1984',
      ' 1- 6-1983',
      '10-24-1976',
      NULL,
      ' 2- 6-1975',
      ' 8- 2-1985',
      ' 8-17-1978',
      NULL,
      ' 0-10-1989',
      ' 0-28-1988',
      '10-22-1990',
      ' 7- 7-1979',
      ' 5-25-1993',
      ' 8-12-1978',
      ' 5-12-2003',
      ' 0-19-1996',
      ' 2-15-1988',
      ' 0-10-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-2001',
      ' 0-13-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


