set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923979';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '0041101',
      0,
      3.912233,
      1,
      '04110',
      3.132963,
      '10-20-1978',
      5.094840,
      NULL,
      0.307146,
      2,
      2,
      0,
      1,
      0,
      NULL,
      2,
      0.256249,
      3.247286,
      0.466980,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030510,
      2,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      7,
      NULL,
      5,
      1,
      0,
      NULL,
      0.503521,
      NULL,
      1.183308,
      1,
      2,
      4,
      1,
      0.294965,
      5,
      6,
      5,
      4,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      3,
      11,
      177,
      18643.763331,
      4,
      9.553857,
      264,
      NULL,
      3,
      0.099317,
      66.279276,
      621,
      NULL,
      0,
      637.734230,
      276,
      3,
      2.710684,
      227.871593,
      169.952052,
      0.575800,
      6.037176,
      57,
      3.336806,
      3,
      NULL,
      181,
      121,
      1,
      3.576976,
      303.431341,
      9,
      2.884074,
      3.118869,
      NULL,
      6.468127,
      1.784730,
      0.615307,
      178,
      67,
      3,
      3.804220,
      NULL,
      39.019040,
      NULL,
      NULL,
      15,
      515.726159,
      2,
      2.640143,
      33.515723,
      25.950969,
      2.333904,
      1,
      197.049606,
      203.769643,
      0.141168,
      2,
      120,
      9,
      NULL,
      2,
      669.419717,
      899.969335,
      1.502588,
      3.996003,
      1121.206468,
      737.142974,
      2,
      0.744736,
      1307.548376,
      46,
      2,
      0.791390,
      606.932307,
      7.107285,
      3,
      2.187013,
      320,
      2.473461,
      1.842471,
      NULL,
      24.632946,
      6,
      1,
      9.367909,
      135,
      7.394168,
      3,
      3.994165,
      38,
      NULL,
      2,
      5.529114,
      49.590254,
      NULL,
      3.670597,
      0.338184,
      119.709246,
      36.723349,
      3,
      0.571676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.623850,
      NULL,
      '03004',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      683.874242,
      0.648339,
      NULL,
      1.270940,
      NULL,
      1.392976,
      NULL,
      2.233539,
      11.350068,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      3,
      4.051973,
      0.807487,
      0.895690,
      4,
      5.745016,
      11,
      9,
      1,
      8.311876,
      13,
      4.996079,
      NULL,
      1,
      NULL,
      2.211740,
      14.206717,
      3.090666,
      NULL,
      NULL,
      3.824627,
      17.180777,
      5,
      NULL,
      NULL,
      7,
      1.302514,
      4.617203,
      7.627319,
      11,
      NULL,
      NULL,
      6.259045,
      6.126219,
      9,
      11.873584,
      NULL,
      NULL,
      NULL,
      3.767891,
      17,
      2,
      6.329187,
      2,
      0.322841,
      1,
      12.689077,
      9.698847,
      3.556056,
      5,
      NULL,
      27,
      3,
      18.605099,
      2.345301,
      15.532348,
      2.083817,
      4.804907,
      9.716361,
      5,
      NULL,
      NULL,
      24,
      25.694912,
      30,
      22.932274,
      NULL,
      1,
      13,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      19,
      6,
      27.879467,
      4,
      4,
      6,
      16.188559,
      14.897532,
      6,
      1,
      28.705201,
      14,
      NULL,
      4.668911,
      6.946703,
      NULL,
      17,
      26.505505,
      14.913940,
      7,
      15,
      21,
      9.447654,
      12,
      3.294616,
      18.125118,
      16,
      2,
      113,
      132.670062,
      34.183050,
      33,
      92.720944,
      NULL,
      40,
      NULL,
      139.128171,
      48.849507,
      73.872523,
      78,
      37.933555,
      34,
      44,
      5.609527,
      137,
      79.565673,
      92,
      97.344909,
      50.698472,
      32,
      92,
      26.624342,
      NULL,
      68,
      104,
      37.828933,
      113,
      142.589441,
      75,
      106,
      108.194285,
      62.502859,
      NULL,
      51,
      127,
      138,
      66,
      87.188451,
      142.532900,
      125.813018,
      5,
      117.447992,
      NULL,
      105.222207,
      NULL,
      65.225363,
      64.617963,
      86,
      53.403945,
      50.800040,
      3.490707,
      0.496759,
      4.509610,
      NULL,
      2.004199,
      NULL,
      NULL,
      NULL,
      1,
      5.470514,
      2.471102,
      5.313796,
      3.825616,
      0.145088,
      5,
      3.931024,
      4,
      1,
      4.911415,
      1,
      NULL,
      NULL,
      5,
      2,
      1.850960,
      4.426516,
      NULL,
      2,
      6.478084,
      3.316058,
      4.507714,
      NULL,
      2,
      1.201431,
      3.004761,
      1.821087,
      2,
      NULL,
      0.709947,
      2.550949,
      1,
      2.003057,
      5.737771,
      9,
      5,
      5.784890,
      NULL,
      3.309773,
      1.621148,
      5.742974,
      1.535734,
      0.264139,
      NULL,
      3.672042,
      0,
      1,
      0.375459,
      3.705511,
      3.249368,
      1.711754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      2,
      1,
      3.979590,
      1.227604,
      1,
      1,
      NULL,
      3,
      NULL,
      3,
      0.415170,
      0,
      NULL,
      0.319274,
      2.003932,
      0.507982,
      1,
      0.854561,
      1,
      2,
      1,
      3.787689,
      NULL,
      3.106373,
      1,
      3,
      1.238022,
      0,
      2,
      3.919109,
      NULL,
      0,
      1,
      0.498683,
      0,
      NULL,
      5.826043,
      1,
      3,
      4.857972,
      0,
      0.925291,
      NULL,
      5.891597,
      5.487460,
      2.193097,
      1,
      NULL,
      NULL,
      5.525277,
      5.635171,
      3.116080,
      4,
      4.003000,
      NULL,
      5.291024,
      2.454997,
      0,
      0.819276,
      1.040835,
      1.526227,
      1,
      3.648766,
      NULL,
      NULL,
      6,
      0.400101,
      0,
      1.033060,
      5,
      4,
      5.912996,
      NULL,
      5.191727,
      1,
      6,
      0.152862,
      7.166486,
      3.012349,
      2,
      NULL,
      0,
      5,
      1,
      0,
      NULL,
      0.439931,
      NULL,
      1.702731,
      1.207216,
      2.059348,
      3.073785,
      3,
      NULL,
      3,
      NULL,
      1.371472,
      0.792621,
      4.495623,
      0,
      4.555522,
      NULL,
      3.611448,
      1.134751,
      NULL,
      2,
      3.690345,
      3,
      NULL,
      1,
      5.093363,
      5,
      4.621557,
      NULL,
      0.016587,
      3,
      4,
      1,
      3,
      4.646819,
      2.371100,
      0.316108,
      5.349340,
      NULL,
      0,
      5,
      NULL,
      1,
      3,
      4.399135,
      4,
      2.831537,
      5.792987,
      1.382751,
      5.267799,
      4,
      4,
      5,
      NULL,
      1.518694,
      0,
      3.321280,
      2,
      NULL,
      0.637867,
      NULL,
      2.260521,
      0,
      3.329546,
      0,
      5.727354,
      NULL,
      1,
      7.820234,
      0.880144,
      3,
      NULL,
      2,
      5,
      3.779110,
      2.278738,
      5.841288,
      0,
      4.234412,
      4,
      NULL,
      0,
      0.751251,
      3,
      1.023356,
      NULL,
      5.928120,
      NULL,
      1,
      0.918047,
      NULL,
      5,
      4.925196,
      3.494379,
      6,
      3.310717,
      7,
      1.637686,
      0.620391,
      NULL,
      0.741790,
      4.731084,
      5,
      3,
      4,
      0.680557,
      7.947624,
      0.517328,
      1.223230,
      0,
      1,
      NULL,
      6.931939,
      0,
      NULL,
      2.521731,
      6.224303,
      4,
      3,
      8.859195,
      5.853304,
      3.423441,
      NULL,
      9,
      9.677240,
      6,
      3.766103,
      0.870594,
      2,
      NULL,
      NULL,
      4,
      3,
      9,
      6.879958,
      5,
      NULL,
      2.463865,
      2,
      7.666264,
      1.288562,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168989,
      5,
      5,
      4.920637,
      7,
      5.074692,
      6,
      NULL,
      NULL,
      NULL,
      1,
      3.506873,
      9,
      3,
      4.040109,
      4,
      4.730146,
      0,
      0,
      4.601836,
      6.192292,
      2.344234,
      NULL,
      4,
      9,
      8.153045,
      2.280250,
      6,
      2.001010,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8.594510,
      1.129284,
      6,
      4.600878,
      0,
      6,
      4,
      7,
      3,
      4,
      NULL,
      0.483385,
      4,
      6.350609,
      2.482790,
      8,
      4.371326,
      3.566984,
      NULL,
      9.870389,
      NULL,
      7,
      4.527705,
      2.748766,
      NULL,
      10.620670,
      0,
      4,
      5.052450,
      6,
      0,
      3,
      NULL,
      2.375909,
      1.171919,
      1,
      0.833921,
      1.207157,
      NULL,
      0,
      2.335559,
      4,
      NULL,
      0.560277,
      3,
      5.457541,
      5,
      0,
      2,
      2,
      NULL,
      4,
      0,
      1.037624,
      NULL,
      5.395751,
      0,
      5,
      5,
      5.387816,
      6,
      4,
      0,
      4.562469,
      2.369208,
      NULL,
      4,
      0.082570,
      NULL,
      NULL,
      NULL,
      3.938503,
      NULL,
      1,
      3,
      1,
      2,
      4.054254,
      2,
      2,
      3.640703,
      1,
      4.278397,
      1.738428,
      1.205895,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.602698,
      1,
      1,
      0.586674,
      1.005242,
      0,
      0.593650,
      NULL,
      0.876751,
      NULL,
      1.449839,
      1.119797,
      1.486048,
      0,
      0.721584,
      NULL,
      0,
      1,
      NULL,
      1.905189,
      0.270685,
      0,
      1.090763,
      0,
      0,
      NULL,
      1.834056,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1.325559,
      1,
      NULL,
      1.222842,
      0,
      1.512468,
      0,
      0.298496,
      0.363800,
      0.700583,
      1,
      0,
      0,
      1.996601,
      1.667667,
      0,
      1.737802,
      NULL,
      1.922650,
      0.144033,
      0.163228,
      0.897899,
      NULL,
      0,
      1,
      0.498036,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1.074084,
      1.183567,
      1.062329,
      NULL,
      1.093709,
      0,
      1,
      0,
      1.706354,
      NULL,
      NULL,
      NULL,
      1.665257,
      0,
      0.441974,
      NULL,
      1.296474,
      1.143622,
      0.731172,
      1.668867,
      0,
      1,
      NULL,
      NULL,
      0.924727,
      1,
      0.428016,
      0,
      0.977918,
      1,
      0.311182,
      0.914390,
      0.024110,
      NULL,
      NULL,
      0.169605,
      1.902092,
      NULL,
      0.628517,
      1,
      0.238260,
      0.035001,
      1,
      0.265494,
      NULL,
      1.726852,
      1,
      0.612100,
      1,
      NULL,
      0.413483,
      1.880745,
      0.019120,
      0,
      0,
      1,
      1.113711,
      1.692887,
      0.843730,
      1,
      0.343128,
      1,
      0,
      NULL,
      0.398283,
      NULL,
      1,
      1,
      1.435748,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.081064,
      NULL,
      1,
      1.154501,
      1.960107,
      0.348005,
      1.239209,
      1,
      0.697842,
      8,
      3.432435,
      0,
      3,
      3.318538,
      3.970891,
      NULL,
      0.428645,
      0,
      0.432189,
      2.833981,
      1,
      3,
      1,
      3,
      1.709646,
      1,
      0,
      NULL,
      1.057925,
      NULL,
      NULL,
      3.392759,
      3,
      2.924399,
      NULL,
      2,
      1,
      0.510960,
      NULL,
      NULL,
      0,
      0.859504,
      1.123390,
      2,
      2,
      NULL,
      2.515120,
      0.692608,
      NULL,
      NULL,
      0.924925,
      2,
      1,
      NULL,
      2,
      2,
      0.434777,
      0.647687,
      0,
      0,
      3.703318,
      7,
      3,
      2.515243,
      NULL,
      NULL,
      NULL,
      3.551195,
      NULL,
      3,
      2.916967,
      0,
      1,
      3,
      NULL,
      NULL,
      3,
      2.249146,
      5,
      2.131222,
      4.098087,
      1,
      2.201424,
      0.819104,
      NULL,
      0,
      0,
      5,
      0,
      5,
      2.997991,
      1.756100,
      5,
      3.275496,
      1.490442,
      0.480722,
      NULL,
      NULL,
      3.779424,
      4,
      4.563088,
      5,
      4.886485,
      NULL,
      2,
      NULL,
      2.356933,
      1.228239,
      0,
      4,
      NULL,
      1.655865,
      0.535430,
      7.925039,
      5,
      3,
      4.086999,
      3.827021,
      6.658821,
      2.930082,
      2.310577,
      NULL,
      0,
      1,
      0,
      NULL,
      4.085681,
      5.026980,
      3.266654,
      5,
      NULL,
      0,
      NULL,
      2.414616,
      NULL,
      5,
      1,
      NULL,
      1,
      7.193639,
      1.918755,
      2.328611,
      2,
      NULL,
      1,
      2,
      0.677679,
      2,
      5.065675,
      5,
      0.784227,
      5.043598,
      6.651431,
      8,
      0.350769,
      3.036450,
      1,
      0.261235,
      5,
      NULL,
      5.970885,
      3,
      1,
      0.772843,
      2.621755,
      7,
      2.899059,
      NULL,
      4,
      NULL,
      4,
      7,
      0.351584,
      3,
      3.292404,
      0.813605,
      NULL,
      3.385430,
      NULL,
      NULL,
      5,
      2,
      7,
      3,
      8,
      1,
      4,
      8,
      5.440854,
      4.207360,
      3.192293,
      0.569395,
      6.367579,
      3,
      2,
      1.274657,
      6,
      6,
      2.105236,
      9.503259,
      NULL,
      8,
      9.520384,
      9.857685,
      9.284881,
      5.217280,
      7.752661,
      7,
      8,
      8,
      11,
      9.593886,
      0,
      10,
      1.413914,
      1.590952,
      0.006564,
      0.271421,
      1.919944,
      0.027213,
      0.225522,
      NULL,
      NULL,
      1.660357,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1.146616,
      1,
      0.668249,
      0,
      1,
      0.672402,
      1,
      1,
      0,
      1,
      1,
      1.689097,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.516194,
      0,
      NULL,
      1.570787,
      1,
      1,
      0,
      NULL,
      NULL,
      0.431723,
      0.842885,
      0,
      NULL,
      1,
      0,
      1.815770,
      1.148219,
      0.869276,
      NULL,
      3.461392,
      0,
      NULL,
      NULL,
      1,
      0.629438,
      NULL,
      1.715467,
      3,
      2,
      0,
      NULL,
      2.381769,
      3,
      NULL,
      3.185270,
      3.174632,
      1.587393,
      1,
      NULL,
      0,
      NULL,
      0,
      2.850711,
      0,
      1,
      0.440865,
      2,
      NULL,
      2.715675,
      2,
      0,
      NULL,
      3,
      3.932403,
      2,
      NULL,
      NULL,
      0,
      0.408332,
      NULL,
      1,
      1.375865,
      3.900646,
      2,
      2.604604,
      1.933154,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      2,
      5,
      2,
      NULL,
      1,
      NULL,
      3,
      2,
      2,
      NULL,
      3,
      2,
      3,
      2,
      2,
      NULL,
      1,
      1,
      0,
      3,
      1,
      3,
      0,
      0,
      2,
      3,
      1,
      0,
      1,
      2,
      NULL,
      4,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      3,
      2,
      2,
      3,
      3,
      1,
      3.509816,
      0.733097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1980',
      NULL,
      NULL,
      NULL,
      ' 4- 4-1999',
      ' 8- 5-1983',
      ' 5-14-1990',
      ' 7-20-1996',
      '10-19-1994',
      NULL,
      ' 4- 1-1984',
      ' 3-20-1992',
      ' 9-21-1989',
      ' 2-28-1978',
      ' 4-17-1981',
      ' 1- 9-1979',
      '10-29-1996',
      ' 3-17-1992',
      ' 9- 7-1982',
      ' 2-15-1992',
      ' 6-15-2002',
      NULL,
      ' 5-27-1985',
      NULL,
      ' 3-26-1992',
      NULL,
      '11- 1-2003',
      ' 0- 7-2001',
      NULL,
      ' 9-21-1976',
      ' 0-18-1980',
      ' 1-19-1985',
      ' 5- 5-2001',
      ' 1- 2-1988',
      ' 4- 8-1985',
      ' 5-14-1984',
      NULL,
      ' 7- 0-2002',
      ' 7-21-1997',
      NULL,
      ' 2- 4-1974',
      ' 1-16-1979',
      ' 2-14-1983',
      NULL,
      ' 9-18-1978',
      '10- 3-1978',
      ' 1- 0-1975',
      '10-27-1983',
      '10-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-16-1994',
      '11- 2-1982',
      ' 4-12-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


