set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6403615';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '0221013',
      1,
      0.855763,
      0,
      NULL,
      2,
      ' 6-12-1986',
      NULL,
      NULL,
      1.243826,
      NULL,
      1,
      1,
      1,
      1,
      1,
      3.927817,
      NULL,
      0.326835,
      1.121169,
      NULL,
      NULL,
      NULL,
      NULL,
      3.945663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.831480,
      1.536531,
      1.981088,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      2,
      0,
      1,
      1,
      NULL,
      2.262498,
      0,
      3,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      2.785469,
      NULL,
      0,
      0,
      NULL,
      1,
      2.952928,
      3,
      7.759098,
      2.527723,
      3.882474,
      NULL,
      ' 9-22-1979',
      32.080280,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      0,
      13.847518,
      NULL,
      302.051434,
      3.192122,
      1,
      NULL,
      33.636553,
      2,
      NULL,
      199.031824,
      71.345480,
      0,
      2,
      NULL,
      7,
      3.325572,
      NULL,
      118.908042,
      78.368869,
      3.282832,
      0.156155,
      174,
      419.858088,
      3,
      0.995811,
      162,
      9,
      3.515632,
      NULL,
      127.613647,
      NULL,
      NULL,
      5,
      NULL,
      300,
      NULL,
      5,
      263,
      320.499804,
      0.191726,
      NULL,
      512.656255,
      346.463380,
      1.949240,
      1.408618,
      329,
      410.395669,
      2,
      7,
      394.864723,
      628.034222,
      NULL,
      NULL,
      13,
      145.802244,
      1.053971,
      NULL,
      61,
      13.682259,
      3,
      2.989623,
      190.410374,
      NULL,
      1.443135,
      0.362262,
      576,
      1664,
      0.904553,
      2,
      50.299363,
      155.361391,
      1,
      NULL,
      58,
      6.670294,
      1.684696,
      3.240333,
      213,
      300.622133,
      3,
      2,
      NULL,
      3611.961347,
      3.757168,
      NULL,
      486,
      2294,
      3.192911,
      1.082215,
      278.622956,
      0.353376,
      0,
      9.040353,
      355,
      NULL,
      3,
      9.443413,
      96,
      5,
      3,
      3.453009,
      630,
      3950,
      1.972092,
      5.227468,
      NULL,
      NULL,
      NULL,
      3.839895,
      NULL,
      12.300609,
      2.842400,
      0.310041,
      391,
      NULL,
      3.476292,
      1,
      NULL,
      2.593390,
      NULL,
      2,
      596.319559,
      93.316969,
      2,
      7,
      NULL,
      3,
      3.736934,
      7,
      355.732096,
      251.468563,
      0.790912,
      NULL,
      91,
      3,
      NULL,
      NULL,
      NULL,
      310,
      3.289438,
      1.962755,
      NULL,
      2,
      NULL,
      0,
      210,
      27,
      0,
      6,
      2.247372,
      1836,
      1.484792,
      0,
      618.558377,
      43,
      1.845495,
      4.781882,
      157,
      27,
      2.985368,
      5,
      NULL,
      NULL,
      NULL,
      4,
      337,
      NULL,
      3.638646,
      NULL,
      39.932838,
      NULL,
      3,
      2,
      966,
      514.163714,
      1.479314,
      3,
      57.608631,
      NULL,
      3.073720,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '42134',
      NULL,
      '',
      '',
      '',
      NULL,
      1.271837,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      4,
      NULL,
      15,
      0.940985,
      NULL,
      3,
      8,
      0.805705,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.125189,
      NULL,
      ' 9-23-2000',
      9.287441,
      NULL,
      2.217948,
      0,
      4.610163,
      14,
      NULL,
      NULL,
      NULL,
      15,
      11,
      5.691797,
      NULL,
      0.020181,
      1.326970,
      0,
      14,
      0,
      2.507140,
      6,
      11,
      0,
      1,
      5,
      1,
      13,
      18,
      3,
      16,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      7.856456,
      4,
      8,
      25.337957,
      NULL,
      NULL,
      14,
      18,
      5.879082,
      NULL,
      25,
      NULL,
      0.934569,
      5,
      17.291900,
      NULL,
      3,
      10.381076,
      0,
      3,
      NULL,
      NULL,
      10,
      NULL,
      5,
      6,
      NULL,
      26.170779,
      39.061348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.752887,
      60,
      117,
      NULL,
      17,
      108.580732,
      72,
      71,
      67.767783,
      46.175853,
      6,
      NULL,
      7,
      NULL,
      88.469670,
      4,
      6.723241,
      1.782859,
      169,
      54.221990,
      126,
      24,
      141.452315,
      78.107295,
      99.248854,
      165.231791,
      51,
      99,
      144.917623,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.900962,
      3,
      1.556854,
      4.068338,
      6.764753,
      NULL,
      1,
      2,
      2.340541,
      0.746086,
      1,
      6.626474,
      8,
      0,
      NULL,
      NULL,
      3,
      2.725778,
      NULL,
      0.188452,
      2.904872,
      NULL,
      3,
      3,
      0.333813,
      1,
      3.510576,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.210491,
      1.302155,
      1.317397,
      0,
      1.181483,
      1.801262,
      1.888660,
      0,
      1,
      0.556180,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.496498,
      0.784240,
      NULL,
      0.017269,
      0.593362,
      1,
      1.207410,
      NULL,
      NULL,
      0.062480,
      0.344626,
      0.268271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.595932,
      3,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.520168,
      1.408429,
      2,
      1,
      3.237419,
      5.173833,
      1,
      2.431061,
      7.253617,
      1.724685,
      0,
      3,
      1.860025,
      1.196705,
      3,
      NULL,
      NULL,
      2.638937,
      3.396792,
      4,
      0,
      1.525082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.331100,
      0.920683,
      NULL,
      1,
      0,
      NULL,
      1.523186,
      0.725540,
      1.449937,
      NULL,
      0,
      0.016283,
      0.951062,
      4,
      1.831705,
      0.852881,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.118774,
      1.586210,
      1,
      NULL,
      1,
      0,
      1,
      0.500904,
      NULL,
      1,
      1.792908,
      NULL,
      0.905394,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.162210,
      1,
      0.626255,
      1.486021,
      1,
      NULL,
      0,
      1.750337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.954467,
      NULL,
      5.720385,
      3,
      NULL,
      1.399947,
      3,
      NULL,
      1.700782,
      0,
      2.317851,
      2.341304,
      3.128256,
      2,
      1,
      0.926947,
      3,
      NULL,
      NULL,
      0,
      2,
      2,
      0,
      1,
      2.740331,
      0.909185,
      2.319416,
      0.137982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.219136,
      2,
      3.665977,
      2,
      0.928221,
      2,
      NULL,
      1.395981,
      1,
      3,
      0.187516,
      1.868312,
      1.679877,
      0.763150,
      1.720293,
      1.586366,
      NULL,
      NULL,
      NULL,
      0.907972,
      1,
      0.195698,
      0,
      NULL,
      0,
      0.388721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.278398,
      0.502832,
      1.027520,
      1.992294,
      0.168901,
      0.968943,
      0.692451,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.045260,
      0.167890,
      0.165255,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137886,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0.932875,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.177014,
      1.209375,
      1,
      1.501243,
      0,
      NULL,
      0.026636,
      1.519747,
      1,
      3.204197,
      0.915419,
      1.322499,
      NULL,
      1,
      1.551431,
      0.647226,
      2.690953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.955456,
      0.698893,
      NULL,
      1,
      NULL,
      0.180671,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      0.910436,
      1,
      0.877363,
      1,
      1,
      NULL,
      0,
      0.052753,
      2,
      1,
      0.299641,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480974,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0.973762,
      2.169000,
      2.604420,
      5,
      NULL,
      0.318350,
      0.875178,
      NULL,
      4,
      0.172859,
      NULL,
      2.151495,
      NULL,
      1.974646,
      6,
      4.014987,
      8.895016,
      3,
      NULL,
      0,
      0.050576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.061550,
      NULL,
      4.449784,
      7,
      5,
      0,
      7,
      0.951800,
      1.369481,
      NULL,
      2,
      4.139581,
      1.000923,
      3.657626,
      3.327712,
      NULL,
      3,
      2.744389,
      NULL,
      1.465147,
      1,
      1.763776,
      0,
      1.095228,
      0.822019,
      3,
      4,
      3,
      1.791289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.332348,
      1,
      NULL,
      1,
      1.733053,
      1,
      NULL,
      0.233101,
      0.898535,
      1.762113,
      0.719398,
      1,
      1,
      1,
      0,
      NULL,
      0.697972,
      1.502774,
      0,
      NULL,
      0.121425,
      1.220082,
      NULL,
      0,
      0.054083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.966853,
      0,
      5.852978,
      9.173414,
      0.650048,
      3.786362,
      3,
      NULL,
      NULL,
      1.545669,
      6,
      3,
      2,
      NULL,
      1.604810,
      2,
      2.796634,
      3.937245,
      2.832299,
      5,
      0,
      3,
      3,
      2,
      1.589173,
      5.683539,
      3,
      0,
      2.831437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.004305,
      5.734552,
      2.184927,
      3,
      2.924700,
      NULL,
      1.335103,
      1.414445,
      2,
      2.884368,
      0,
      NULL,
      0,
      3,
      2.183765,
      0.243065,
      3.803400,
      3.383333,
      2,
      0,
      1.199340,
      1.129213,
      NULL,
      NULL,
      2.028595,
      1,
      2.439912,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.968758,
      0,
      0.643930,
      1,
      0,
      0.969374,
      1.392441,
      NULL,
      NULL,
      2,
      5,
      1.772310,
      NULL,
      4,
      1.838715,
      1,
      0.180851,
      3,
      1.405340,
      0,
      NULL,
      1.301499,
      8.323399,
      4,
      NULL,
      1.788436,
      1,
      1.157834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.506731,
      6,
      5,
      0,
      0,
      3.962809,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.469559,
      0.531488,
      3,
      2.362633,
      2.993371,
      0.306772,
      NULL,
      0,
      0,
      1,
      1.912042,
      4.472685,
      5,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      3,
      0,
      NULL,
      3,
      7,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      5,
      4,
      1,
      NULL,
      NULL,
      3,
      6,
      2,
      4,
      5,
      3,
      2,
      2,
      2,
      5,
      NULL,
      3,
      4,
      3,
      1,
      2,
      1,
      0,
      3,
      3,
      1,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1995',
      ' 2- 0-1985',
      NULL,
      ' 6-22-1989',
      ' 4- 5-1997',
      ' 9- 1-1974',
      ' 1-19-1982',
      ' 1- 7-1998',
      ' 7-13-2003',
      ' 8-11-1986',
      ' 7- 7-1983',
      ' 9-17-1984',
      ' 2-29-2002',
      NULL,
      NULL,
      ' 6- 5-1999',
      NULL,
      ' 7-18-1990',
      '10-17-1980',
      ' 7-24-1990',
      ' 0-14-1989',
      ' 3- 2-1981',
      ' 9- 3-1988',
      ' 6-13-1991',
      ' 0- 5-1995',
      '10-16-1999',
      ' 2- 6-2003',
      ' 3- 6-1980',
      ' 0- 5-1990',
      ' 1- 4-1999',
      ' 6- 1-1983',
      NULL,
      NULL,
      '10- 6-1981',
      NULL,
      ' 8-12-1987',
      ' 6- 0-1984',
      NULL,
      NULL,
      ' 8-11-1991',
      ' 5-18-1984',
      ' 3-12-1991',
      ' 5- 2-2001',
      ' 1-22-1999',
      '10-10-1977',
      ' 9- 6-1989',
      '11-11-1982',
      ' 7-25-1989',
      ' 5-25-1993',
      NULL,
      ' 9-10-1984',
      ' 8- 8-1981',
      ' 8-21-1996',
      ' 2-26-1989',
      ' 1-18-1999',
      ' 2- 7-1993',
      '10-24-1994',
      ' 2- 5-1974',
      '10-14-1991',
      ' 7-20-1991',
      ' 7- 2-1991',
      NULL,
      NULL,
      ' 1- 4-1977',
      NULL,
      NULL,
      ' 7-24-1986',
      NULL,
      ' 0-16-1996',
      ' 8-29-1981',
      NULL,
      NULL,
      ' 8- 4-1991',
      ' 0- 8-1975',
      ' 7- 4-1984',
      NULL,
      ' 4- 5-1998',
      NULL,
      NULL,
      NULL,
      '11-14-1996',
      ' 7-16-1988',
      NULL,
      '11-16-1974',
      NULL,
      NULL,
      ' 9-16-1974',
      NULL,
      ' 3- 3-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851970);
commit;
end;
/


