set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7703389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23344314',
      42,
      26.025018,
      '4300144',
      NULL,
      1,
      3,
      '10104',
      4.779882,
      ' 1-18-1991',
      NULL,
      NULL,
      0,
      2,
      2.354887,
      1.832365,
      0.952398,
      NULL,
      0,
      3,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      5,
      1,
      1,
      1,
      1,
      1,
      4,
      1,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      0,
      1.290223,
      0,
      NULL,
      NULL,
      3,
      7,
      2,
      3,
      3,
      1,
      0.922733,
      3,
      3.474739,
      NULL,
      3,
      0.457664,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      36,
      130,
      1120,
      2.607714,
      2.651247,
      0,
      167.464641,
      NULL,
      3.625923,
      137,
      186,
      2,
      NULL,
      168,
      NULL,
      0.683810,
      2.582373,
      NULL,
      NULL,
      0,
      1.586415,
      105,
      NULL,
      0,
      1.658580,
      55.877948,
      NULL,
      3,
      2.183373,
      194,
      45.782298,
      NULL,
      NULL,
      14,
      79.218803,
      2.978091,
      2,
      53.005589,
      1.039265,
      2,
      0.114160,
      60.080069,
      19.252091,
      3,
      3.178094,
      NULL,
      NULL,
      0.420966,
      NULL,
      318.996112,
      2,
      1.307589,
      6.152505,
      162.749962,
      NULL,
      1,
      3.099836,
      54,
      3,
      0.664862,
      NULL,
      86.345734,
      28.295093,
      3,
      2.795447,
      47,
      150,
      0.141850,
      0.871781,
      NULL,
      NULL,
      1.294182,
      3,
      22.116679,
      19.118392,
      2,
      NULL,
      50,
      29.791454,
      NULL,
      5,
      218,
      106.017489,
      0.284172,
      0.018679,
      141,
      NULL,
      3.456304,
      7,
      183.563658,
      NULL,
      NULL,
      1.961941,
      182.340523,
      NULL,
      3,
      0.965507,
      NULL,
      NULL,
      0.174435,
      NULL,
      89.386108,
      NULL,
      5,
      5,
      NULL,
      2,
      1.047541,
      1.193488,
      90,
      NULL,
      1.450424,
      7,
      195,
      344.338485,
      6,
      3,
      106.108295,
      NULL,
      3,
      0.390351,
      63,
      138,
      NULL,
      4,
      516.848103,
      7,
      3.210103,
      2,
      184,
      91,
      9.101545,
      NULL,
      777.221888,
      0.351559,
      1.753858,
      1.315293,
      386.953022,
      814.653882,
      0.169410,
      0.867647,
      143,
      118,
      3,
      0,
      338,
      NULL,
      1.449352,
      1,
      530,
      94,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '02440',
      '',
      '',
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5,
      0,
      NULL,
      NULL,
      954,
      NULL,
      NULL,
      1.683521,
      NULL,
      1.692913,
      NULL,
      0.862309,
      NULL,
      3.599077,
      630,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 5-11-1987',
      24.432040,
      NULL,
      3,
      10.151315,
      23.285060,
      5,
      2,
      7,
      8,
      13,
      NULL,
      6,
      5.827857,
      8.336054,
      0,
      5,
      NULL,
      11,
      7.764886,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.350815,
      23,
      NULL,
      18,
      40.644884,
      2.283696,
      NULL,
      6,
      1.204262,
      2.768597,
      NULL,
      10,
      0,
      NULL,
      14.717301,
      NULL,
      4,
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.295253,
      3.024966,
      3.055434,
      27,
      114.612042,
      43,
      38,
      45,
      71,
      126.201900,
      6,
      141.096085,
      79,
      184.917608,
      2.206601,
      104,
      187,
      NULL,
      161,
      0.176588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.130602,
      5,
      1.219107,
      NULL,
      9.558383,
      1.499511,
      NULL,
      9.501119,
      6.044919,
      0.940318,
      5,
      5.101359,
      8,
      7.004862,
      2.629626,
      3,
      0,
      NULL,
      1.390884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.239004,
      5.823734,
      9,
      8.768344,
      NULL,
      5.583150,
      NULL,
      9.504063,
      3,
      8,
      6.741786,
      5,
      7.751296,
      6,
      1,
      3,
      3.205344,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104098,
      0,
      1,
      NULL,
      0,
      1,
      1.168152,
      0,
      NULL,
      1,
      0,
      1.616550,
      1.392329,
      1,
      0,
      1,
      1.251217,
      NULL,
      0.610486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.807637,
      2.588474,
      1,
      1.929344,
      0,
      NULL,
      NULL,
      1.555258,
      0,
      1.966641,
      0,
      1,
      0.707364,
      NULL,
      0.224575,
      1.639625,
      0,
      0.687931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124927,
      1,
      0,
      NULL,
      0,
      1,
      0.294058,
      1,
      1.426403,
      1.776709,
      0.165122,
      NULL,
      NULL,
      1.288561,
      1,
      NULL,
      1.517632,
      0.948648,
      0.167962,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065253,
      0.696759,
      4.541145,
      NULL,
      4.008558,
      0,
      4.465077,
      1,
      1.557005,
      2,
      5,
      0.131636,
      5.912997,
      5.844491,
      6.453464,
      2.039869,
      NULL,
      NULL,
      1.244482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.798296,
      3.049419,
      0,
      NULL,
      3.089590,
      2,
      5.248884,
      0,
      1,
      4.538319,
      1,
      3,
      7.054800,
      4,
      7.816014,
      1,
      NULL,
      1,
      1.117035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937896,
      NULL,
      NULL,
      2,
      3.739173,
      5.598933,
      2,
      3.386651,
      NULL,
      5.543696,
      4.685626,
      NULL,
      NULL,
      4.109577,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.249187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075154,
      2,
      3,
      0.795792,
      1.672170,
      1.947488,
      NULL,
      1.427473,
      1.627278,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1.063385,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173266,
      NULL,
      0.914634,
      NULL,
      1,
      NULL,
      NULL,
      1.940573,
      0.635390,
      1,
      1.525603,
      NULL,
      0.063948,
      1,
      1,
      0,
      1.257108,
      1.199727,
      0,
      1.834457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.715029,
      0,
      0,
      0.563216,
      0.944195,
      1.104203,
      1.760972,
      0,
      0,
      NULL,
      0,
      NULL,
      0.915638,
      0.563444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.743381,
      1.998565,
      0.392464,
      0,
      0,
      0.790515,
      1,
      NULL,
      1,
      1,
      1.518678,
      1.552248,
      NULL,
      NULL,
      1,
      0.062795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.323436,
      1.055602,
      0.178946,
      NULL,
      0,
      1,
      0.735866,
      1,
      1.398366,
      1,
      NULL,
      NULL,
      1.585373,
      1.558781,
      0,
      1.263664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.159046,
      0,
      2,
      2,
      NULL,
      6,
      2,
      7,
      NULL,
      0,
      9.700118,
      6.667698,
      6,
      NULL,
      6,
      4,
      3,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3.220808,
      0.941004,
      4,
      4.434200,
      2.380905,
      1.539151,
      4,
      4.251513,
      3.177581,
      5,
      NULL,
      3.955619,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314718,
      1,
      0.047375,
      1.921835,
      NULL,
      1,
      1.323251,
      0,
      NULL,
      1.373779,
      2,
      0.873174,
      1.418660,
      1.466710,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.325558,
      1.561953,
      NULL,
      0.895439,
      1,
      1.322503,
      1,
      0,
      NULL,
      0.882678,
      NULL,
      NULL,
      0.632366,
      1,
      NULL,
      NULL,
      0,
      0.164083,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      5,
      5,
      5,
      1,
      4,
      2,
      1,
      6,
      NULL,
      4,
      5,
      3,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      2,
      1,
      4,
      0,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      3,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      5,
      2,
      4,
      0,
      3,
      NULL,
      1,
      2,
      3,
      0,
      2,
      4,
      NULL,
      NULL,
      2,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-16-1982',
      ' 2-24-1990',
      ' 2-18-1977',
      ' 3-18-1980',
      NULL,
      ' 1-29-1985',
      ' 9- 5-1980',
      ' 2-29-1988',
      ' 9- 0-2002',
      ' 7-29-1996',
      ' 8- 7-1978',
      '11-16-1976',
      ' 7-20-1990',
      NULL,
      NULL,
      ' 1-13-1999',
      NULL,
      NULL,
      ' 8- 5-2002',
      ' 5-21-2000',
      ' 9-24-1974',
      '10- 1-1982',
      NULL,
      NULL,
      ' 8-13-1978',
      ' 1-29-1991',
      ' 3-27-1989',
      NULL,
      ' 8-23-2001',
      '10-25-1980',
      NULL,
      ' 2-19-1976',
      NULL,
      ' 4-28-2001',
      ' 9-23-1995',
      NULL,
      NULL,
      ' 2-24-1985',
      NULL,
      ' 2- 4-2000',
      ' 0-20-1978',
      ' 6-13-1995',
      '11-25-1977',
      NULL,
      ' 2-23-1977',
      ' 0-15-1981',
      ' 2-22-1984',
      ' 9-19-1987',
      ' 5-18-1975',
      ' 8-29-1982',
      NULL,
      ' 6- 4-1974',
      ' 1-19-1993',
      ' 9- 1-1976',
      ' 4-20-1994',
      ' 8-16-1993',
      ' 9-29-1979',
      ' 0- 5-1981',
      ' 4- 2-1974',
      ' 8-27-1981',
      ' 3-25-1983',
      ' 0- 4-1998',
      ' 3-12-1979',
      ' 6-13-1982',
      NULL,
      ' 6- 3-1974',
      ' 1-20-1990',
      '10-23-1979',
      ' 7- 5-1976',
      NULL,
      ' 4-19-1974',
      NULL,
      ' 1- 4-1998',
      NULL,
      ' 2-27-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-22-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


