set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '0312320',
      1,
      0,
      0,
      '14221',
      0,
      NULL,
      NULL,
      NULL,
      3.805529,
      NULL,
      1,
      1.321048,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.557740,
      NULL,
      2,
      NULL,
      NULL,
      2.468530,
      NULL,
      NULL,
      10,
      NULL,
      2,
      NULL,
      NULL,
      4,
      6.235513,
      1.475058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      4,
      0.563307,
      4,
      7,
      1,
      0,
      NULL,
      0.506197,
      0.150827,
      2,
      5,
      NULL,
      NULL,
      4.099338,
      NULL,
      0,
      NULL,
      1.951206,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      285.925371,
      NULL,
      2.209493,
      5.300116,
      37,
      11,
      NULL,
      2.004356,
      165.926807,
      21,
      NULL,
      NULL,
      NULL,
      1.218628,
      3,
      NULL,
      66,
      7,
      3.888033,
      3,
      172.291388,
      4,
      0.243067,
      3,
      713,
      96,
      NULL,
      7,
      146,
      NULL,
      NULL,
      3.197194,
      NULL,
      801,
      1.796724,
      NULL,
      233.807682,
      14,
      3.214642,
      8,
      731.834321,
      3934,
      2,
      NULL,
      401,
      5329.935778,
      2.593773,
      2.588116,
      289.640644,
      4067.430593,
      NULL,
      0.563601,
      51.312735,
      3.058052,
      3.793013,
      NULL,
      2.788730,
      NULL,
      NULL,
      NULL,
      735.480112,
      3461,
      1.990295,
      1.828946,
      549.996233,
      NULL,
      1,
      2.659260,
      NULL,
      NULL,
      1.011817,
      3.503985,
      NULL,
      620,
      3.395253,
      4,
      118.886339,
      NULL,
      3,
      3,
      517.769889,
      1195,
      1,
      0.265721,
      NULL,
      NULL,
      3.239303,
      NULL,
      NULL,
      NULL,
      2.218316,
      7.313793,
      126.547331,
      30,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1356,
      2,
      0.130793,
      3.129776,
      1074,
      62.028645,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      49.523021,
      0.367753,
      NULL,
      0.774025,
      7.474973,
      0,
      NULL,
      0.662280,
      NULL,
      1.394341,
      NULL,
      0.797262,
      NULL,
      1.072478,
      NULL,
      0.288911,
      NULL,
      1.006300,
      NULL,
      ' 8-11-1989',
      1,
      4,
      4.466938,
      4,
      3.937100,
      0,
      3.815725,
      0.620430,
      8,
      9.490372,
      3.009305,
      2.618327,
      0,
      4.217371,
      5.502923,
      NULL,
      2.700282,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      7,
      5.029294,
      6.866058,
      2,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.237713,
      11,
      19.175073,
      5.129783,
      57,
      10.541088,
      8.281910,
      28.033207,
      2,
      3.831589,
      2.762038,
      38,
      2,
      13,
      NULL,
      33.782635,
      4,
      39,
      NULL,
      NULL,
      5.293033,
      34.978734,
      59.746988,
      1.503902,
      2.580122,
      5.189673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72,
      12.992610,
      5.016097,
      NULL,
      171,
      36.800171,
      NULL,
      53,
      NULL,
      82.936740,
      130,
      102,
      NULL,
      82.796542,
      NULL,
      164,
      27,
      103,
      183.561223,
      5,
      NULL,
      114.608547,
      140,
      154,
      181.697354,
      9.981279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.708001,
      4,
      NULL,
      NULL,
      1.712601,
      NULL,
      3,
      1.124744,
      1,
      NULL,
      NULL,
      1.826492,
      0,
      3.895333,
      1.989575,
      1.925006,
      NULL,
      2.455045,
      5.787299,
      4.893081,
      2,
      1.054937,
      11,
      NULL,
      3,
      1.967876,
      3.756852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      0,
      2,
      3,
      1.370796,
      0.536953,
      1,
      0.677050,
      1.350315,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4.287507,
      NULL,
      6,
      4.584849,
      4.566297,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.645843,
      2,
      1,
      4,
      NULL,
      3.311178,
      1,
      2,
      0,
      1,
      4.127513,
      1.861776,
      1.025589,
      NULL,
      2.747605,
      8.106168,
      NULL,
      2,
      6,
      4.146000,
      2.660278,
      1.283030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.934187,
      6,
      6.011919,
      4.457819,
      1,
      2.701479,
      NULL,
      0.392833,
      1,
      1.319905,
      2.794845,
      NULL,
      3,
      0,
      4,
      1.764755,
      3,
      2.216341,
      5.125374,
      0,
      6.232896,
      10.019131,
      8,
      10,
      8,
      0.278241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617497,
      1.382118,
      2.928720,
      NULL,
      1,
      1.981410,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.875728,
      1,
      1,
      0.735614,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      6.153341,
      3,
      5.594950,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206207,
      0.487382,
      1,
      1.025058,
      3,
      NULL,
      NULL,
      4,
      0.655354,
      2,
      NULL,
      NULL,
      0.339210,
      2.026784,
      2.713523,
      4,
      1.457132,
      0,
      NULL,
      NULL,
      3,
      6.434614,
      0,
      5,
      0.481911,
      5.644652,
      2.312893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196783,
      1,
      3,
      1,
      1.196230,
      0.891671,
      0.287525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      3,
      5,
      1,
      4.402390,
      2,
      8,
      0,
      3.562155,
      3.740450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.193979,
      NULL,
      3.953995,
      2,
      0.065211,
      0,
      0.499695,
      1,
      1,
      3.989211,
      3,
      2,
      2.824456,
      1.699832,
      0,
      2.594437,
      3,
      NULL,
      0,
      5.878777,
      5,
      6,
      NULL,
      7.537612,
      6,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793557,
      3,
      4,
      0,
      1.769686,
      4,
      NULL,
      0.312496,
      1,
      1,
      0,
      0.371087,
      1,
      NULL,
      0,
      2.710115,
      NULL,
      NULL,
      NULL,
      0,
      3.446491,
      NULL,
      4,
      9.806507,
      9.186218,
      3.898058,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.232666,
      6.171296,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.910408,
      NULL,
      0,
      0.054516,
      0,
      0,
      3,
      NULL,
      1.894736,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.271620,
      2,
      3,
      0.446627,
      1,
      3.740617,
      1,
      5.848305,
      4.303445,
      0.900798,
      NULL,
      NULL,
      0,
      3.359461,
      2,
      1,
      1,
      4,
      0,
      0.366679,
      NULL,
      2.592684,
      NULL,
      1.363289,
      0.532220,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1.127410,
      0.485159,
      1,
      1,
      0.430857,
      NULL,
      1,
      0.635895,
      0.959961,
      NULL,
      0.281738,
      1,
      1.704398,
      0,
      0.165893,
      1,
      NULL,
      1,
      1,
      3,
      1.530041,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.362491,
      1.473839,
      1.349510,
      1.014597,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.340455,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.937662,
      0.196727,
      1.530875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6,
      1.969714,
      2,
      2.965534,
      0,
      NULL,
      2.107666,
      NULL,
      3,
      0,
      0.255382,
      4.650972,
      3,
      7.493667,
      2,
      2.669744,
      3.248728,
      0.044989,
      5,
      11,
      8,
      NULL,
      1.861059,
      6.993007,
      2.165078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.184458,
      2.868876,
      0.108486,
      2,
      NULL,
      0.920792,
      1.912658,
      3.998254,
      1.748269,
      3.077217,
      0,
      2,
      5.664004,
      2,
      5,
      5.738272,
      2.597683,
      0,
      3.404824,
      6.956292,
      1.199533,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.975503,
      2.743960,
      1.199623,
      0.837518,
      1,
      1.280261,
      0.249012,
      0,
      1.899153,
      NULL,
      0.524812,
      0.523401,
      1.183134,
      2,
      0.608970,
      NULL,
      2.471480,
      3,
      1.124693,
      0.453468,
      2.638602,
      0,
      0,
      1.264917,
      1,
      0.843294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.875331,
      0,
      0,
      1.873697,
      NULL,
      1.240735,
      NULL,
      1,
      NULL,
      0.414679,
      1.946232,
      NULL,
      1.166731,
      1.253564,
      1.295646,
      0.336347,
      0,
      1.940906,
      0.137693,
      NULL,
      3,
      2.293201,
      0.503483,
      2,
      1,
      1.116917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      5,
      1,
      3,
      NULL,
      5,
      0,
      3,
      NULL,
      0,
      3,
      3,
      2,
      NULL,
      3,
      4,
      2,
      1,
      3,
      2,
      3,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.462434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1985',
      ' 0-21-2002',
      ' 1-14-1983',
      ' 9-29-1990',
      ' 0-13-1979',
      ' 8-14-1993',
      ' 3- 4-2001',
      ' 0-12-2002',
      ' 3- 2-1975',
      NULL,
      ' 5-10-1977',
      NULL,
      ' 8- 9-1976',
      NULL,
      ' 0- 9-1987',
      ' 2-14-2002',
      ' 0-20-1996',
      ' 3- 0-1986',
      NULL,
      ' 6- 8-1983',
      '11-27-1981',
      ' 2- 7-1993',
      ' 2- 7-1995',
      NULL,
      ' 4-18-1991',
      ' 9-19-1982',
      ' 8-29-1996',
      ' 7-15-2003',
      NULL,
      ' 1-21-1996',
      '10-25-1986',
      NULL,
      ' 1- 8-1995',
      ' 9-13-1992',
      ' 6- 1-1980',
      '10- 0-1991',
      ' 5-10-1990',
      ' 8- 5-1995',
      ' 1-21-1980',
      ' 5- 3-1979',
      ' 6-25-1976',
      ' 3-14-1988',
      ' 1- 6-1994',
      ' 0-12-2001',
      ' 1-13-1975',
      ' 0-29-1983',
      ' 5-22-1993',
      NULL,
      ' 2-27-1978',
      NULL,
      ' 5- 2-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1978',
      ' 2-12-1987',
      ' 1- 4-1987',
      ' 2-12-1976',
      ' 5-19-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


