set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'psych';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332012';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_psych_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '4313323',
      1,
      NULL,
      0,
      NULL,
      2.365058,
      ' 5- 3-1994',
      35.911480,
      NULL,
      0.032900,
      NULL,
      2.154183,
      NULL,
      1,
      1,
      NULL,
      1,
      1.316218,
      3.068125,
      1,
      6,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.704024,
      4,
      NULL,
      2.025391,
      NULL,
      NULL,
      6,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      9,
      6.225593,
      NULL,
      5,
      2,
      0,
      1.878633,
      NULL,
      0.430995,
      1,
      0,
      NULL,
      0,
      1.228333,
      7,
      5.762997,
      NULL,
      4,
      NULL,
      3.481946,
      0.362544,
      5,
      23.475520,
      NULL,
      11.953349,
      3,
      2.062565,
      5,
      2,
      4,
      NULL,
      5,
      17,
      130.326010,
      156.295897,
      3,
      1.328091,
      NULL,
      349,
      0,
      3,
      162.002827,
      276.242693,
      NULL,
      1.471787,
      4.573819,
      NULL,
      1,
      2,
      555,
      122.159427,
      3,
      2.407551,
      189.226742,
      NULL,
      NULL,
      2,
      101,
      NULL,
      2,
      3,
      204,
      37,
      1,
      NULL,
      68.406502,
      304.087879,
      2.915486,
      2,
      732,
      NULL,
      2,
      0.812603,
      538,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      '',
      '',
      '',
      '',
      1.075065,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      1,
      NULL,
      1.200577,
      398.908419,
      0,
      NULL,
      0.938043,
      NULL,
      NULL,
      NULL,
      1.956391,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      ' 5-26-1975',
      NULL,
      5.995396,
      NULL,
      23,
      NULL,
      10,
      NULL,
      3.618453,
      2,
      4,
      0,
      3.633029,
      0.437111,
      3,
      3,
      2,
      1,
      8.499775,
      0.026809,
      1,
      3,
      2.826512,
      NULL,
      13,
      12.238769,
      9.830774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804324,
      17,
      8,
      9,
      26.083631,
      5.908867,
      25,
      9.837088,
      2.660332,
      17.646472,
      1,
      11.968846,
      5,
      31,
      25,
      NULL,
      NULL,
      21.174940,
      NULL,
      3,
      11,
      NULL,
      19.275504,
      12,
      2.653551,
      15.630524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.198822,
      11.216750,
      NULL,
      22,
      43.931517,
      73.816501,
      NULL,
      NULL,
      NULL,
      109.495531,
      NULL,
      118,
      123.665986,
      NULL,
      86.825861,
      116,
      102,
      78,
      124.772937,
      160.591393,
      NULL,
      153.544849,
      124,
      33.736683,
      168,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918835,
      NULL,
      NULL,
      6,
      0.481853,
      2.920140,
      2.946231,
      6,
      7,
      4.100676,
      4,
      4,
      NULL,
      5,
      5.213664,
      1,
      1,
      7,
      NULL,
      5,
      2,
      NULL,
      0.930294,
      0,
      0,
      7.763794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.047024,
      4,
      NULL,
      6,
      NULL,
      1.499001,
      7,
      2.025036,
      0,
      4.502491,
      3.813178,
      NULL,
      NULL,
      3.241156,
      3.608755,
      3,
      0,
      4.738076,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.299465,
      1.451349,
      5,
      9.342528,
      NULL,
      NULL,
      5.723947,
      2.018024,
      2.517037,
      NULL,
      7,
      5.061688,
      5,
      9,
      9.460085,
      2.458655,
      8.139125,
      NULL,
      NULL,
      8,
      5.083444,
      4.568035,
      9,
      2.577651,
      8.573536,
      4.123702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347492,
      1,
      1.999158,
      1.464958,
      0.840249,
      NULL,
      0,
      1,
      0.238232,
      1.301321,
      0,
      1.623496,
      0,
      NULL,
      1.234543,
      0.349341,
      0,
      0,
      1.125358,
      0.374830,
      1.559585,
      NULL,
      NULL,
      0.982288,
      0,
      1.142802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.471426,
      0,
      1.911754,
      0.507106,
      1,
      0.553614,
      1.734580,
      NULL,
      0.302453,
      1.460225,
      1.083467,
      0.949334,
      1,
      0.254473,
      NULL,
      1.894482,
      0.145336,
      0.115205,
      NULL,
      NULL,
      1.763486,
      0.332505,
      0,
      0.122865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112805,
      NULL,
      3.270569,
      NULL,
      2.889726,
      NULL,
      NULL,
      3,
      NULL,
      0.067790,
      3,
      NULL,
      7.859574,
      3.576872,
      1,
      6.894250,
      NULL,
      0.452779,
      5,
      1,
      6.777341,
      6.269289,
      7.808162,
      3.293830,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      5,
      NULL,
      0,
      1,
      0,
      3,
      2.065003,
      1.302749,
      0.615533,
      3.085788,
      NULL,
      2,
      NULL,
      NULL,
      6.113931,
      5,
      NULL,
      6,
      2.212963,
      2.587077,
      4.644928,
      0.181438,
      0.992802,
      5.508784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.847764,
      2,
      0.447585,
      5.848344,
      1.259372,
      0.636774,
      NULL,
      2,
      3.975946,
      0,
      2,
      4.752321,
      2,
      5,
      1.883716,
      5.934817,
      3,
      3.796827,
      4.568826,
      0,
      5,
      0.671412,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073040,
      1,
      0,
      1,
      NULL,
      NULL,
      0.903109,
      1,
      0.312638,
      NULL,
      1.233033,
      1.260021,
      0,
      1.687479,
      0.549073,
      NULL,
      1,
      1,
      0.458628,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825087,
      0.902888,
      0.161459,
      0,
      NULL,
      1,
      1.866255,
      NULL,
      0,
      0.854184,
      0,
      0,
      0,
      0.842279,
      0,
      NULL,
      NULL,
      0,
      1.822680,
      NULL,
      0,
      0,
      0.448915,
      0.088890,
      1.299128,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.647492,
      NULL,
      1,
      0,
      1.188824,
      0,
      1.265887,
      0.665717,
      1,
      0.923779,
      1.719842,
      0.778562,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1.638332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252713,
      0.656546,
      0,
      1.585822,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0.312001,
      1.562641,
      1,
      0,
      0.162236,
      NULL,
      NULL,
      1,
      1.070375,
      0,
      0,
      1,
      2.454082,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.406864,
      1.671643,
      1,
      1,
      0,
      1,
      1.968368,
      0,
      0.735449,
      NULL,
      0,
      NULL,
      0.233040,
      1.613417,
      NULL,
      1,
      1,
      1.625000,
      1.690344,
      0,
      1.925718,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.961087,
      2,
      1.794618,
      5.650139,
      NULL,
      7,
      0.889736,
      3.412084,
      1,
      NULL,
      5.372130,
      5.327150,
      3.916788,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      2,
      5,
      5.223616,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      5.338187,
      1.074469,
      2,
      7,
      NULL,
      4.168841,
      NULL,
      5.247737,
      NULL,
      2.338514,
      1,
      3.037325,
      0.382860,
      7.787382,
      NULL,
      6,
      5.311547,
      NULL,
      NULL,
      NULL,
      6.202671,
      NULL,
      1.550968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691328,
      0,
      NULL,
      1.634270,
      0.274888,
      0.021435,
      NULL,
      1.634388,
      0,
      0.235718,
      NULL,
      NULL,
      1.247341,
      1.883956,
      0.672980,
      NULL,
      0,
      1,
      1,
      0.478758,
      NULL,
      1.727717,
      0,
      0.369277,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.800816,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0.257589,
      NULL,
      0.485392,
      1.086335,
      0,
      0.781344,
      1.145608,
      0,
      0,
      0,
      0.190016,
      0,
      0.426811,
      0.767674,
      1.119745,
      0.805840,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      2,
      3,
      NULL,
      2,
      2,
      1,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      3,
      2,
      5,
      0,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.875680,
      NULL,
      1,
      2,
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      2,
      2,
      3,
      3,
      0,
      0,
      2,
      0,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1983',
      ' 3-11-1986',
      ' 1-22-1978',
      NULL,
      ' 1- 0-1974',
      ' 8-24-1983',
      NULL,
      ' 8- 8-1999',
      ' 7- 3-1981',
      ' 9-22-1982',
      ' 9-21-1995',
      ' 9-13-2003',
      ' 2-19-1990',
      ' 5-17-2000',
      NULL,
      ' 6-28-1994',
      ' 7-24-2000',
      ' 7-16-1989',
      ' 7- 7-1988',
      NULL,
      NULL,
      ' 3-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 5-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


