
--Add psychup
create or replace procedure psychup(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('psychup', 'psychup', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'PU460', 1249, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1151', 1111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU462', 470, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU463', 471, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU464', 472, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU465', 473, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1194', 1154, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#13');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1194', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU461', 1250, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU468', 474, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU469', 475, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU827', 787, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU266', 278, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LEVEL OF SATISFACTION-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 1, 'Very good (Generaly satisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 2, 'Good (Mild satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 3, 'Fair (Moderate disssatisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 4, 'Poor (Very dissatisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 5, 'Very poor (No satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU266', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU267', 279, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LEVEL OF SATISFACTION-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 1, 'Very good (Generaly satisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 2, 'Good (Mild satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 3, 'Fair (Moderate disssatisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 4, 'Poor (Very dissatisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 5, 'Very poor (No satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU267', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU264', 276, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH UNK.');

add_assessment_score(v_id1, owner_id, owner_id, 'PU265', 277, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LEVEL OF SATISFACTION-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 1, 'Very good (Generaly satisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 2, 'Good (Mild satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 3, 'Fair (Moderate disssatisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 4, 'Poor (Very dissatisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 5, 'Very poor (No satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU265', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU262', 274, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU263', 275, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU260', 272, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU261', 273, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU301', 313, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DISCHARGE DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU300', 312, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:ADMIT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU303', 315, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU303', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU303', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU303', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU303', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU303', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU302', 314, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU302', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU305', 317, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:ADMIT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU304', 316, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU304', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU304', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU304', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU304', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU268', 280, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LEVEL OF SATISFACTION-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 1, 'Very good (Generaly satisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 2, 'Good (Mild satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 3, 'Fair (Moderate disssatisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 4, 'Poor (Very dissatisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 5, 'Very poor (No satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU268', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU269', 281, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LEVEL OF SATISFACTION-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 1, 'Very good (Generaly satisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 2, 'Good (Mild satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 3, 'Fair (Moderate disssatisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 4, 'Poor (Very dissatisfied)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 5, 'Very poor (No satisfaction)', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU269', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU45', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP WAS FIRED OR LAID OFF-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU44', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP WAS FIRED OR LAID OFF-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU47', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP WAS FIRED OR LAID OFF-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU46', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP WAS FIRED OR LAID OFF-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU41', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP QUIT A JOB-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU40', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP QUIT A JOB-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU43', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP WAS FIRED OR LAID OFF-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU42', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP QUIT A JOB-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1181', 1141, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#26');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1181', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU467', 1252, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU49', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RETIRED/LEAVE OF ABSENCE-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU48', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP WAS FIRED OR LAID OFF-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1180', 1140, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#25');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1180', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU193', 205, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/RELATIVES-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU358', 370, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1176', 1136, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#21');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1176', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU359', 371, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1101', 1061, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU415', 427, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU414', 426, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU417', 429, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU416', 428, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU411', 423, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU410', 422, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU413', 425, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU412', 424, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU419', 431, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU418', 430, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU949', 909, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU948', 908, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU785', 745, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU309', 321, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU309', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU309', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU309', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU309', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU787', 747, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU153', 165, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/ ASSIGNED ROOMMATE-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU781', 741, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU780', 740, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU783', 743, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU308', 320, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU308', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU308', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU308', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU308', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU308', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU864', 824, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU865', 825, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU866', 826, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU867', 827, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU789', 749, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU788', 748, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU862', 822, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU863', 823, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1170', 1130, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#15');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1170', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1265', 1225, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1265', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1265', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1265', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1265', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU890', 850, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1243', 1203, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#9');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1243', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1243', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1243', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1243', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1155', 1115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU882', 842, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU883', 843, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1025', 985, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU880', 840, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU112', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FATHER-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1171', 1131, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#16');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1171', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU881', 841, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1008', 968, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1009', 969, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1004', 964, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU886', 846, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1006', 966, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1007', 967, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU941', 901, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1001', 961, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1002', 962, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU887', 847, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1185', 1145, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1185', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU884', 844, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1120', 1080, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU885', 845, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1172', 1132, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#17');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1172', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU307', 319, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU307', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU940', 900, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU306', 318, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DISCHARGE DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU951', 911, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU648', 608, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU649', 609, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU523', 511, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU522', 510, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU525', 513, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU524', 512, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU138', 150, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/RELATIVE/STEPPARENT-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU139', 151, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/RELATIVE/STEPPARENT-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU136', 148, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/SIBLINGS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU137', 149, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/RELATIVE/STEPPARENT-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU642', 602, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU135', 147, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/SIBLINGS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU132', 144, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/SIBLINGS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU133', 145, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/SIBLINGS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU130', 142, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN>13YRS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU131', 143, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/SIBLINGS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU443', 455, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1250', 1210, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#16');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1250', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1250', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1250', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1250', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1253', 1213, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#19');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1253', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1253', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1253', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1253', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1252', 1212, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#18');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1252', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1252', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1252', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1252', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1255', 1215, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#21');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1255', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1255', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1255', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1255', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1254', 1214, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#20');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1254', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1254', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1254', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1254', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1257', 1217, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#23');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1257', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1257', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1257', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1257', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1256', 1216, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#22');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1256', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1256', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1256', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1256', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1259', 1219, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#25');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1259', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1259', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1259', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1259', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1258', 1218, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#24');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1258', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1258', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1258', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1258', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1093', 1053, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1092', 1052, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1091', 1051, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1090', 1050, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1097', 1057, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1096', 1056, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU893', 853, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1094', 1054, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU810', 770, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1099', 1059, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1098', 1058, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU575', 1288, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU734', 694, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU735', 695, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU736', 696, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU737', 697, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SECOND RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU731', 691, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU732', 692, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU733', 693, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU738', 698, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU739', 699, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1119', 1079, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU183', 195, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/SPOUSE/MATE-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU182', 194, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/SPOUSE/MATE-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU228', 240, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS WIDOWED-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU180', 192, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/SPOUSE/MATE-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU8', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FACE TO FACE INTERVIEW W/SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'PU9', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PHONE INTERVIEW W/SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELIABILITY MEASUREMENT NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU184', 196, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/SPOUSE/MATE-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU222', 234, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS DIVORCED-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU223', 235, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS WIDOWED-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU637', 597, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU188', 200, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/CHILDREN-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU631', 591, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG ABUSE-NO.EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU630', 590, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ALCOHOL ABUSE-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU224', 236, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS WIDOWED-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU632', 592, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG ABUSE-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU895', 855, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU232', 244, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SEXUAL SATISFACTION-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU754', 714, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1189', 1149, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#8');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1189', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU727', 687, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU755', 715, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1245', 1205, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#11');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1245', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1245', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1245', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1245', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU726', 686, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU725', 685, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1069', 1029, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU724', 684, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU5', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT DIED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1111', 1071, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU759', 719, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1188', 1148, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#7');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1188', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1115', 1075, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1159', 1119, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1159', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU356', 368, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU356', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU356', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU356', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU356', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU356', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU357', 369, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU354', 366, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU355', 367, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU352', 364, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU352', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU352', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU352', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU352', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU352', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU353', 365, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU350', 362, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CURRENT MENSTRUAL STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 1, 'Regular cycle', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 2, 'Irregular cycles/bleeding', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 3, 'Menopause', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 4, 'Surgery', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 5, 'Hormone imbalance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 6, 'Pharmacologic suppression', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 7, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 8, 'Other reason for Amenorrhea', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU350', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU351', 363, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ECT:DURING THIS 6 MONTH PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'PU451', 463, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU450', 462, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:NUMBER OF CHANGES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU6', 18, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DATE OF DEATH');

add_assessment_score(v_id1, owner_id, owner_id, 'PU452', 464, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU987', 947, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU986', 946, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU457', 467, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU456', 466, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1232', 1192, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#25');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1232', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU592', 1293, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU369', 381, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU593', 1294, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU78', 90, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT-HOUSEHOLD DUTIES-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU79', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT-HOUSEHOLD DUTIES-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1117', 1077, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU74', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP REASON FOR NO HOUSEHOLD DUTIES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU75', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT-HOUSEHOLD DUTIES-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU76', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT-HOUSEHOLD DUTIES-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU77', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT-HOUSEHOLD DUTIES-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU70', 82, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANAGEMENT OF INCOME-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 1, 'Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 2, 'Spouse/Mate of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 3, 'Parents of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 4, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 5, 'Legal guardian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 6, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 7, 'Subject with assistance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 8, 'No income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU70', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU71', 83, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANAGEMENT OF INCOME-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 1, 'Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 2, 'Spouse/Mate of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 3, 'Parents of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 4, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 5, 'Legal guardian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 6, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 7, 'Subject with assistance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 8, 'No income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU71', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU72', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANAGEMENT OF INCOME-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU73', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOUSEHOLD DUTIES-PAST 6 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1095', 1055, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1048', 1008, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU598', 1295, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1173', 1133, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#18');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1173', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU833', 793, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU599', 1296, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DATE (MMDDYY) FORM WAS DONE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU816', 776, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU855', 815, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU854', 814, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU857', 817, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU856', 816, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU851', 811, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU850', 810, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU853', 813, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU852', 812, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU914', 874, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU915', 875, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU916', 876, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU917', 877, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU859', 819, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU641', 601, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU912', 872, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU913', 873, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1147', 1107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU832', 792, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU466', 1251, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1184', 1144, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1184', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1130', 1090, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1131', 1091, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1132', 1092, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1057', 1017, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1056', 1016, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU831', 791, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1054', 1014, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1053', 1013, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU220', 232, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS DIVORCED-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1051', 1011, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1050', 1010, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU918', 878, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1187', 1147, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1187', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU799', 759, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU919', 879, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU947', 907, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU192', 204, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/RELATIVES-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1136', 1096, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU946', 906, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1137', 1097, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU945', 905, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1055', 1015, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU3', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP REL OF INFORMANT TO PROBAND');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1138', 1098, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU944', 904, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1128', 1088, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1133', 1093, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU943', 903, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1186', 1146, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1186', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU533', 1274, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1204', 1164, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#23');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1204', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU942', 902, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU671', 631, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU670', 630, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU673', 633, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU672', 632, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU675', 635, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU674', 634, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU677', 637, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU676', 636, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU679', 639, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU678', 638, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU772', 732, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU773', 733, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU774', 734, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU109', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FATHER-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU256', 268, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU777', 737, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU989', 949, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU108', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FATHER-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU874', 834, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU578', 548, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU579', 549, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU576', 546, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU577', 547, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU574', 1287, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1201', 1161, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#20');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1201', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU572', 544, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU573', 545, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU570', 542, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU571', 543, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1228', 1188, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#21');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1228', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1229', 1189, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#22');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1229', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1161', 1121, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1161', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1220', 1180, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#13');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1220', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1221', 1181, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#14');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1221', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1222', 1182, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#15');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1222', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1153', 1113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1224', 1184, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#17');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1224', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1225', 1185, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#18');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1225', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1226', 1186, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#19');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1226', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1227', 1187, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#20');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1227', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU172', 184, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP MOTHER-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU173', 185, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP FATHER-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU170', 182, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP MOTHER-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU171', 183, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP MOTHER-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU176', 188, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP FATHER-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU177', 189, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP FATHER-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU174', 186, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP FATHER-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU175', 187, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP FATHER-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU178', 190, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP FATHER-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU179', 191, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/SPOUSE/MATE-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1271', 1231, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#11');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1271', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1271', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1271', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1271', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU538', 1275, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1149', 1109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU539', 1276, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU499', 495, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU498', 494, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU784', 744, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU495', 493, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU494', 492, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU497', 1262, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU113', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED WITH SPOUSE/MATE-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU491', 1260, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU490', 1259, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU493', 491, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU492', 490, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU253', 265, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU252', 264, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU318', 330, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU318', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU319', 331, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU319', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU319', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU319', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU319', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU319', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU257', 269, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU708', 668, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU255', 267, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU254', 266, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU705', 665, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU704', 664, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU310', 322, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:ADMIT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU258', 270, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU316', 328, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU317', 329, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU703', 663, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU315', 327, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU315', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU315', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU315', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU315', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU30', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STAYED SAME JOB ENTIRE MO.-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU31', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGED JOBS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU32', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGED JOBS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU33', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGED JOBS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU34', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGED JOBS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU35', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGED JOBS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU36', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGED JOBS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU37', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP QUIT A JOB-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU38', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP QUIT A JOB-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU118', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED WITH SPOUSE/MATE-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU782', 742, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU835', 795, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU119', 131, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN<13YRS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU381', 393, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU380', 392, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT INDIV./GROUP THERAPY');

add_assessment_score(v_id1, owner_id, owner_id, 'PU383', 395, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU382', 394, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU385', 397, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU384', 396, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU387', 399, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU386', 398, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF CONTACTS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU389', 401, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU389', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU389', 1, 'Less than 15 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU389', 2, '15-30 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU389', 3, 'Greater than 30 minutes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU388', 400, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU388', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU388', 1, 'Less than 15 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU388', 2, '15-30 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU388', 3, 'Greater than 30 minutes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU910', 870, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU988', 948, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1143', 1103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU340', 352, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU340', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU340', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU340', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU340', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU477', 481, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1142', 1102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU817', 777, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU860', 820, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU830', 790, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1123', 1083, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU861', 821, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU406', 418, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU407', 419, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU404', 416, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU405', 417, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU402', 414, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU403', 415, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU400', 412, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU401', 413, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU958', 918, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU911', 871, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1146', 1106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1178', 1138, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#23');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1178', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1179', 1139, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#24');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1179', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU408', 420, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:GROUP-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU409', 421, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:COUPLE-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU796', 756, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU797', 757, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU794', 754, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU795', 755, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU792', 752, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU793', 753, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU790', 750, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU791', 751, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU811', 771, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU349', 361, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MENSTRUAL STATUS:FEMALE?');

add_assessment_score(v_id1, owner_id, owner_id, 'PU813', 773, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU812', 772, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU815', 775, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU814', 774, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU798', 758, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU348', 360, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TREATMENT DURING PAST 6 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1217', 1177, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#10');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1217', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU746', 706, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU839', 799, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU838', 798, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU868', 828, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1022', 982, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1121', 1081, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU453', 465, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1019', 979, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1018', 978, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU479', 1256, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU481', 483, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1013', 973, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1012', 972, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1011', 971, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1010', 970, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1017', 977, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1016', 976, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1015', 975, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU869', 829, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU925', 885, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU924', 884, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU927', 887, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU926', 886, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU921', 881, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU920', 880, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU923', 883, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU922', 882, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU820', 780, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU929', 889, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU928', 888, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU550', 1279, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1166', 1126, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#11');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1166', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1067', 1027, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU378', 390, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1023', 983, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU379', 391, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU532', 1273, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU891', 851, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU530', 516, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU531', 517, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU536', 520, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU537', 521, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU534', 518, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU535', 519, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU103', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/MOTHER-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU102', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/MOTHER-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU101', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/MOTHER-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU100', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED ALONE-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU107', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FATHER-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU106', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/MOTHER-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU105', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/MOTHER-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU104', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/MOTHER-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU892', 852, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1268', 1228, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#8');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1268', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1268', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1268', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1268', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1269', 1229, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#9');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1269', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1269', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1269', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1269', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1264', 1224, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1264', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1264', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1264', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1264', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU858', 818, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1125', 1085, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1061', 1021, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1260', 1220, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#26');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1260', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1260', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1260', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1260', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1261', 1221, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1261', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1261', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1261', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1261', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1262', 1222, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1262', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1262', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1262', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1262', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU894', 854, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK25');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1234', 1194, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIORS RECORDED BELOW');

add_assessment_score(v_id1, owner_id, owner_id, 'PU786', 746, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1135', 1095, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU488', 488, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1068', 1028, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU80', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT-HOUSEHOLD DUTIES-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1066', 1026, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU370', 382, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1064', 1024, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU489', 489, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1062', 1022, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1063', 1023, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1060', 1020, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU278', 290, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GAS RATING-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU278', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU899', 859, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1059', 1019, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU898', 858, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1112', 1072, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1058', 1018, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU484', 1257, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU217', 229, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS DIVORCED-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU216', 228, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS SEPARATED-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU215', 227, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS SEPARATED-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU214', 226, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS SEPARATED-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU186', 198, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/CHILDREN-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU212', 224, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS SEPARATED-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU211', 223, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS SEPARATED-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU210', 222, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS MARRIED-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU749', 709, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU748', 708, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'PU218', 230, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS DIVORCED-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU587', 1292, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU586', 1291, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU585', 553, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU584', 552, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU583', 551, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU582', 550, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU628', 588, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ALCOHOL ABUSE-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU629', 589, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ALCOHOL ABUSE-CURRENTLY');

add_assessment_score(v_id1, owner_id, owner_id, 'PU626', 586, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DEPRESSED SYND-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU627', 587, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ALCOHOL ABUSE-NO.EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU624', 584, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DEPRESSED SYND-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU625', 585, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DEPRESSED SYND-CURRENTLY');

add_assessment_score(v_id1, owner_id, owner_id, 'PU622', 582, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANIC SYND-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU623', 583, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DEPRESSED SYND-NO.EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU589', 555, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU621', 581, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANIC SYND-CURRENTLY IN EPISODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1266', 1226, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1266', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1266', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1266', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1266', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU185', 197, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/CHILDREN-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU897', 857, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU999', 959, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU455', 1248, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU757', 717, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU221', 233, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS DIVORCED-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1223', 1183, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#16');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1223', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU994', 954, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU741', 701, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU996', 956, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU997', 957, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU990', 950, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU991', 951, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU992', 952, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU740', 700, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU998', 958, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU743', 703, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU681', 641, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU363', 375, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU244', 256, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU448', 460, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECTS JUDGMENT OF OVERALL TX');

add_assessment_score(v_id1, owner_id, owner_id, 'PU449', 461, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHIATRIC MED COMPLIANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU367', 379, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU366', 378, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU365', 377, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU717', 677, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU442', 454, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU442', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU213', 225, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS SEPARATED-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU440', 452, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU440', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU441', 453, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU441', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU446', 458, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECTS JUDGMENT OF ECT TX');

add_assessment_score(v_id1, owner_id, owner_id, 'PU246', 258, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU444', 456, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP REL OF MENTAL HEALTH CONTACTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU445', 457, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECTS JUDGMENT OF SOMATIC TX');

add_assessment_score(v_id1, owner_id, owner_id, 'PU693', 653, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU692', 652, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU691', 651, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU715', 675, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU697', 657, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU696', 656, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU695', 655, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU694', 654, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU240', 252, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECREATIONAL ACTIVITIES-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU699', 659, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU698', 658, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU713', 673, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1286', 1246, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1284', 1244, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#24');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1284', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1284', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1284', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1284', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU59', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FROM UNEMPLOYED TO EMPLOYED-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1282', 1242, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#22');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1282', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1282', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1282', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1282', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU710', 670, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU69', 81, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANAGEMENT OF INCOME-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 1, 'Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 2, 'Spouse/Mate of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 3, 'Parents of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 4, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 5, 'Legal guardian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 6, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 7, 'Subject with assistance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 8, 'No income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU69', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU68', 80, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANAGEMENT OF INCOME-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 1, 'Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 2, 'Spouse/Mate of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 3, 'Parents of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 4, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 5, 'Legal guardian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 6, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 7, 'Subject with assistance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 8, 'No income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU68', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU67', 79, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANAGEMENT OF INCOME-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 1, 'Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 2, 'Spouse/Mate of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 3, 'Parents of subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 4, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 5, 'Legal guardian', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 6, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 7, 'Subject with assistance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 8, 'No income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU67', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU66', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SOURCE OF INCOME-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU65', 77, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SOURCE OF INCOME-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 0, 'Subject employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 1, 'Spouse/Mate employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 2, 'Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 3, 'Dependent Children', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 4, 'Employment and Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 5, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 6, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 7, 'No Income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 8, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU65', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU711', 671, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU63', 75, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SOURCE OF INCOME-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 0, 'Subject employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 1, 'Spouse/Mate employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 2, 'Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 3, 'Dependent Children', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 4, 'Employment and Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 5, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 6, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 7, 'No Income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 8, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU63', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU62', 74, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SOURCE OF INCOME-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 0, 'Subject employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 1, 'Spouse/Mate employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 2, 'Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 3, 'Dependent Children', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 4, 'Employment and Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 5, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 6, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 7, 'No Income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 8, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU62', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU61', 73, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SOURCE OF INCOME-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 0, 'Subject employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 1, 'Spouse/Mate employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 2, 'Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 3, 'Dependent Children', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 4, 'Employment and Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 5, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 6, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 7, 'No Income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 8, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU61', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU60', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FROM UNEMPLOYED TO EMPLOYED-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU984', 944, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU706', 666, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1113', 1073, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1198', 1158, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#17');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1198', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU219', 231, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS DIVORCED-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU836', 796, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1192', 1152, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#11');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1192', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU846', 806, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU847', 807, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU844', 804, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU845', 805, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU842', 802, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU843', 803, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU840', 800, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU841', 801, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU961', 921, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU960', 920, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU963', 923, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU962', 922, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU965', 925, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU964', 924, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU848', 808, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU849', 809, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ANHEDONIA-WK6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1199', 1159, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#18');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1199', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU198', 210, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FRIENDS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU896', 856, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU199', 211, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FRIENDS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU778', 738, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU581', 1290, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU779', 739, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1134', 1094, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1196', 1156, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#15');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1196', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1103', 1063, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU751', 711, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU194', 206, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/RELATIVES-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1020', 980, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1021', 981, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1026', 986, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1027', 987, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1024', 984, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU195', 207, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/RELATIVES-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1028', 988, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1029', 989, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU196', 208, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/RELATIVES-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU197', 209, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FRIENDS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU190', 202, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/CHILDREN-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1197', 1157, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#16');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1197', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU191', 203, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/RELATIVES-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU770', 730, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU620', 580, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANIC SYND-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU771', 731, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU588', 554, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU662', 622, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU663', 623, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU660', 620, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU661', 621, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU666', 626, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU667', 627, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU664', 624, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU665', 625, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU668', 628, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU669', 629, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU521', 1270, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1107', 1067, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU775', 735, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1237', 1197, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1237', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1237', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1237', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1237', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1236', 1196, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1236', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1236', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1236', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1236', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU549', 529, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU548', 528, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1233', 1193, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU776', 736, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1231', 1191, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#24');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1231', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1230', 1190, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#23');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1230', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU543', 525, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU542', 524, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU541', 523, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU540', 522, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU547', 527, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU546', 526, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1239', 1199, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1239', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1239', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1239', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1239', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1100', 1060, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU742', 702, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1148', 1108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1195', 1155, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#14');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1195', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU520', 1269, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1102', 1062, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1193', 1153, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#12');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1193', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FIRST ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SECOND ENTRY NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU149', 161, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/ ASSIGNED ROOMMATE-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU148', 160, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FRIENDS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU147', 159, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FRIENDS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU146', 158, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FRIENDS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU145', 157, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FRIENDS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU144', 156, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FRIENDS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU143', 155, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FRIENDS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU142', 154, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/RELATIVE/STEPPARENT-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU141', 153, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/RELATIVE/STEPPARENT-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU140', 152, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/RELATIVE/STEPPARENT-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU327', 339, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU326', 338, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU325', 337, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU325', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU325', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU325', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU325', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU324', 336, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU324', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU324', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU324', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU324', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU324', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU323', 335, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU323', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU322', 334, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU321', 333, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU320', 332, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU320', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU320', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU320', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU320', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU486', 486, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU487', 487, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1238', 1198, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1238', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1238', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1238', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1238', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU485', 1258, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU482', 484, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU483', 485, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU329', 341, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU329', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU329', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU329', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU329', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU329', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU328', 340, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU328', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU979', 939, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU248', 260, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU249', 261, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU718', 678, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU719', 679, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU716', 676, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU245', 257, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU714', 674, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU247', 259, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU712', 672, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU241', 253, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECREATIONAL ACTIVITIES-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU242', 254, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECREATIONAL ACTIVITIES-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU243', 255, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDE ATTEMPTS IN PAST 6 MOS.');

add_assessment_score(v_id1, owner_id, owner_id, 'PU23', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN EMPLOYMENT-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU22', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN EMPLOYMENT-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU21', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN EMPLOYMENT-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU20', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN EMPLOYMENT-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU27', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STAYED SAME JOB ENTIRE MO.-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU26', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STAYED SAME JOB ENTIRE MO.-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU25', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STAYED SAME JOB ENTIRE MO.-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU24', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN EMPLOYMENT-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1274', 1234, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#14');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1274', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1274', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1274', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1274', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1046', 1006, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU29', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STAYED SAME JOB ENTIRE MO.-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU28', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STAYED SAME JOB ENTIRE MO.-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU545', 1278, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1183', 1143, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1183', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU392', 404, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU392', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU392', 1, 'Less than 15 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU392', 2, '15-30 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU392', 3, 'Greater than 30 minutes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU393', 405, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH 6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU393', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU393', 1, 'Less than 15 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU393', 2, '15-30 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU393', 3, 'Greater than 30 minutes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU390', 402, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU390', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU390', 1, 'Less than 15 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU390', 2, '15-30 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU390', 3, 'Greater than 30 minutes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU391', 403, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU391', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU391', 1, 'Less than 15 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU391', 2, '15-30 minutes', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU391', 3, 'Greater than 30 minutes', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU396', 408, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU397', 409, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU394', 406, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AVE LENGTH OF SESSION-MONTH UNK');

add_assessment_score(v_id1, owner_id, owner_id, 'PU395', 407, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU398', 410, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU399', 411, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:INDIVIDUAL-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU640', 600, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU134', 146, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/SIBLINGS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1190', 1150, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#9');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1190', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU643', 603, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1267', 1227, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#7');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1267', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1267', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1267', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1267', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU644', 604, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU544', 1277, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU978', 938, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU645', 605, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU433', 445, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU433', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU432', 444, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU432', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU431', 443, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU431', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU430', 442, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU430', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU437', 449, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU437', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU436', 448, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH UNKNOWN');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU436', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU435', 447, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU435', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU434', 446, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU434', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU439', 451, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU439', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU438', 450, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:MODE(S)-MONTH 2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 1, 'Somatic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 2, 'Talk', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 3, 'Behavioral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 4, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU438', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1191', 1151, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#10');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1191', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1163', 1123, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#8');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1163', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU808', 768, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU809', 769, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1162', 1122, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#7');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1162', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU802', 762, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU803', 763, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU800', 760, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU801', 761, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU806', 766, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU807', 767, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU804', 764, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU805', 765, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:THOUGHT DISORD.-WK14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU96', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED ALONE-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU97', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED ALONE-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU94', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF DWELLING-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU95', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED ALONE-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU92', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF DWELLING-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU93', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF DWELLING-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU90', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF DWELLING-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU91', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF DWELLING-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1167', 1127, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#12');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1167', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU745', 705, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU970', 930, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU98', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED ALONE-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU99', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED ALONE-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU527', 1272, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU834', 794, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU971', 931, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1165', 1125, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#10');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1165', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU995', 955, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1156', 1116, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1156', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1049', 1009, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1157', 1117, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1157', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU870', 830, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1160', 1120, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1160', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1154', 1114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU975', 935, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1169', 1129, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#14');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1169', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU526', 1271, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU936', 896, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU937', 897, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU934', 894, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU935', 895, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU932', 892, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU933', 893, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU930', 890, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU931', 891, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU993', 953, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU938', 898, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU939', 899, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:ATTENTION-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU478', 1255, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU341', 353, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1141', 1101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU529', 515, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1014', 974, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1263', 1223, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1263', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1263', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1263', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1263', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU973', 933, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU509', 1266, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU508', 1265, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU507', 501, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU506', 500, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU505', 499, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU504', 498, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU503', 1264, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU502', 1263, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU501', 497, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU500', 496, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1279', 1239, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#19');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1279', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1279', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1279', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1279', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1278', 1238, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#18');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1278', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1278', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1278', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1278', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1140', 1100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1273', 1233, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#13');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1273', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1273', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1273', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1273', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1272', 1232, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#12');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1272', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1272', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1272', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1272', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU528', 514, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1270', 1230, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#10');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1270', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1270', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1270', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1270', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1277', 1237, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#17');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1277', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1277', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1277', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1277', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1276', 1236, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#16');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1276', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1276', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1276', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1276', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1275', 1235, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#15');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1275', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1275', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1275', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1275', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1139', 1099, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU744', 704, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1079', 1039, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1078', 1038, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU362', 374, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1075', 1035, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1074', 1034, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1077', 1037, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1076', 1036, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1071', 1031, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU361', 373, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1073', 1033, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1072', 1032, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU646', 606, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU360', 372, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU360', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU360', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU360', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU360', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU360', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1070', 1030, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1203', 1163, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#22');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1203', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU950', 910, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1174', 1134, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#19');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1174', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'TYPE', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF SUBJECT');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 1, 'Proband/Subject', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 2, 'Informant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 3, 'Consensus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 4, 'Blind', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 5, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'TYPE', 6, 'Consensus II', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU200', 212, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FRIENDS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU201', 213, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FRIENDS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU202', 214, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FRIENDS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU203', 215, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CURRENT MARITAL STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 1, 'Single', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 2, 'Married', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 3, 'Living/Opp', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 4, 'Widowed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 5, 'Seperated', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 6, 'Divorced', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU203', 7, 'Living/Same', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU204', 216, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CHANGES IN MARITAL STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU205', 217, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS MARRIED-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU206', 218, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS MARRIED-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU207', 219, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS MARRIED-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU208', 220, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS MARRIED-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU209', 221, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS MARRIED-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU758', 718, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU364', 376, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU364', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU364', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU364', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU364', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU364', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU231', 243, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SEXUAL SATISFACTION-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1175', 1135, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#20');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1175', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU647', 607, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU907', 867, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU590', 556, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU591', 557, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU619', 579, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP MANIC SYND-NO.EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU618', 578, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE PSY SYND-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU594', 558, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU595', 559, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU596', 560, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU597', 561, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU613', 573, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:ALCOHOL ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU612', 572, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:OBS-COMP BEH.');

add_assessment_score(v_id1, owner_id, owner_id, 'PU611', 571, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:ANTISOCIAL BEH.');

add_assessment_score(v_id1, owner_id, owner_id, 'PU610', 570, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:ANXIOUS MOOD');

add_assessment_score(v_id1, owner_id, owner_id, 'PU617', 577, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE PSY SYND-CURRENTLY');

add_assessment_score(v_id1, owner_id, owner_id, 'PU616', 576, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE PSY SYND-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU615', 575, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE PSY SYND-NO.EPISODES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU614', 574, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:DRUG ABUSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU605', 1298, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU368', 380, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU368', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU368', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU368', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU368', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU368', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1208', 1168, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1208', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1209', 1169, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#2');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1209', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1206', 1166, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#25');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1206', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1207', 1167, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#26');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1207', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU230', 242, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SEXUAL SATISFACTION-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1205', 1165, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#24');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1205', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1202', 1162, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#21');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1202', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1080', 1040, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1200', 1160, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#19');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1200', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU447', 459, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUB JUDGMENT OF NON-SOMATIC TX');

add_assessment_score(v_id1, owner_id, owner_id, 'PU114', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED WITH SPOUSE/MATE-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU115', 127, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED WITH SPOUSE/MATE-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU116', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED WITH SPOUSE/MATE-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU117', 129, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED WITH SPOUSE/MATE-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU110', 122, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FATHER-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU111', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT LIVED W/FATHER-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU299', 311, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU299', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU299', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU299', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU299', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU298', 310, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU298', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU298', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU298', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU298', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU298', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU297', 309, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU297', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU296', 308, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DISCHARGE DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU295', 307, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:ADMIT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU294', 306, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU294', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU294', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU294', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU294', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU293', 305, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU293', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU293', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU293', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU293', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU293', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU292', 304, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU292', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU291', 303, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DISCHARGE DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU290', 302, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:ADMIT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU476', 480, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU475', 479, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU474', 478, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU473', 1254, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU472', 1253, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU471', 477, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU470', 476, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU233', 245, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SEXUAL SATISFACTION-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1052', 1012, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU480', 482, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1144', 1104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU275', 287, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GLOBAL SOCIAL ADJUSTMENT-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU274', 286, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GLOBAL SOCIAL ADJUSTMENT-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU277', 289, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GAS RATING-MONTH 1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU277', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU276', 288, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GLOBAL SOCIAL ADJUSTMENT-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU271', 283, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GLOBAL SOCIAL ADJUSTMENT-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU270', 282, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LEVEL OF SATISFACTION-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU273', 285, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GLOBAL SOCIAL ADJUSTMENT-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU272', 284, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GLOBAL SOCIAL ADJUSTMENT-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU374', 386, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE ENDED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU375', 387, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU376', 388, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU376', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU376', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU376', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU376', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU376', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU377', 389, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU279', 291, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GAS RATING-MONTH 3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU279', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU371', 383, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:#OF TREATMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU372', 384, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:TYPE');
add_assessment_code(v_id1, owner_id, owner_id, 'PU372', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU372', 1, 'Unilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU372', 2, 'Bilateral', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU372', 3, 'Both', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU372', 4, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU373', 385, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP COURSES OF ECT:DATE BEGAN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU688', 648, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU689', 649, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU818', 778, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU684', 644, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU685', 645, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU686', 646, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU687', 647, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU680', 640, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU251', 263, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUICIDAL INTENT-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU682', 642, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU683', 643, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-DAY OF WEEK #22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU709', 669, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU58', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FROM UNEMPLOYED TO EMPLOYED-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU250', 262, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF ATTEMPTS-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU52', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RETIRED/LEAVE OF ABSENCE-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU53', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RETIRED/LEAVE OF ABSENCE-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU50', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RETIRED/LEAVE OF ABSENCE-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU51', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RETIRED/LEAVE OF ABSENCE-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU56', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FROM UNEMPLOYED TO EMPLOYED-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU57', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FROM UNEMPLOYED TO EMPLOYED-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU54', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RETIRED/LEAVE OF ABSENCE-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU55', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FROM UNEMPLOYED TO EMPLOYED-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1105', 1065, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1044', 1004, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU312', 324, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS-PAST 6 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU280', 292, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GAS RATING-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU280', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU313', 325, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU313', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU730', 690, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1116', 1076, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU259', 271, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP ACTUAL MEDICAL THREAT-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1104', 1064, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU873', 833, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU872', 832, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU871', 831, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU311', 323, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DISCHARGE DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU877', 837, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU876', 836, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU875', 835, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU747', 707, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU972', 932, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU701', 661, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU879', 839, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU878', 838, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU976', 936, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU977', 937, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU974', 934, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU700', 660, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1285', 1245, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#25');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1285', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1285', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1285', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1285', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU314', 326, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU314', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU314', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU314', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU314', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU314', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU702', 662, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1145', 1105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1283', 1243, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#23');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1283', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1283', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1283', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1283', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1280', 1240, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#20');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1280', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1280', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1280', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1280', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1281', 1241, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:OBS-COMP-WK#21');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1281', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1281', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1281', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1281', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU957', 917, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1031', 991, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1030', 990, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1033', 993, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1032', 992, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1035', 995, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1034', 994, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1037', 997, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1036', 996, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1039', 999, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1038', 998, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1106', 1066, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1164', 1124, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#9');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1164', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1235', 1195, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1235', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1235', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1235', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1235', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU64', 76, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SOURCE OF INCOME-MONTH 4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 0, 'Subject employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 1, 'Spouse/Mate employment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 2, 'Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 3, 'Dependent Children', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 4, 'Employment and Social Agency', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 5, 'Parents', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 6, 'Relatives', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 7, 'No Income', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 8, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU64', 9, 'Unknown', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU454', 1247, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU763', 723, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU181', 193, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/SPOUSE/MATE-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU229', 241, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PRIMARY SEXUAL ORIENTATION');
add_assessment_code(v_id1, owner_id, owner_id, 'PU229', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU229', 1, 'Heterosexual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU229', 2, 'Homosexual', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU229', 3, 'Bisexual', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU39', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP QUIT A JOB-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU187', 199, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/CHILDREN-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU638', 598, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU554', 532, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU555', 533, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU556', 1281, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU557', 1282, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU129', 141, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN>13YRS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU128', 140, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN>13YRS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU659', 619, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU553', 531, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU125', 137, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN>13YRS-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU124', 136, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN<13YRS-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU127', 139, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN>13YRS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU126', 138, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN>13YRS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU121', 133, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN<13YRS-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU559', 535, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU123', 135, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN<13YRS-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU650', 610, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1242', 1202, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#8');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1242', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1242', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1242', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1242', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU4', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CURRENT PSYCHIATRIC TX STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'PU4', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU4', 1, 'Inpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU4', 2, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU4', 3, 'Other', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU4', 4, 'Nonpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU4', 5, 'Outpatient/Day Tx', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1240', 1200, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1240', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1240', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1240', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1240', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1241', 1201, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#7');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1241', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1241', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1241', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1241', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1246', 1206, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#12');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1246', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1246', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1246', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1246', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1247', 1207, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#13');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1247', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1247', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1247', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1247', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1244', 1204, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#10');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1244', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1244', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1244', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1244', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU634', 594, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG ABUSE-DURATION(WKS)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1118', 1078, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU580', 1289, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1248', 1208, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#14');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1248', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1248', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1248', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1248', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1249', 1209, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIAL-WK#15');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1249', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1249', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1249', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1249', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU189', 201, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/CHILDREN-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1177', 1137, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#22');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1177', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1084', 1044, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1085', 1045, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1086', 1046, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU7', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP CAUSE OF DEATH');

add_assessment_score(v_id1, owner_id, owner_id, 'PU707', 667, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU769', 729, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1082', 1042, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1083', 1043, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU226', 238, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS WIDOWED-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU768', 728, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1088', 1048, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1089', 1049, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1129', 1089, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU227', 239, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS WIDOWED-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU158', 170, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/MOTHER-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU159', 171, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/MOTHER-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU633', 593, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG ABUSE-CURRENTLY IN EPISODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU150', 162, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/ ASSIGNED ROOMMATE-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU151', 163, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/ ASSIGNED ROOMMATE-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU152', 164, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/ ASSIGNED ROOMMATE-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU225', 237, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBJECT WAS WIDOWED-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU154', 166, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/ ASSIGNED ROOMMATE-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU155', 167, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/MOTHER-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU156', 168, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/MOTHER-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU157', 169, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/MOTHER-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU330', 342, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU330', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU330', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU330', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU330', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU331', 343, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU332', 344, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU333', 345, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU333', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU334', 346, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU334', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU334', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU334', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU334', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU334', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU335', 347, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU335', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU335', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU335', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU335', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU336', 348, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU337', 349, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU338', 350, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU338', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU339', 351, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU339', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU339', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU339', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU339', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU339', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU888', 848, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU889', 849, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:AVOLITION-WK20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1114', 1074, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU821', 781, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU762', 722, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU239', 251, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECREATIONAL ACTIVITIES-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU238', 250, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECREATIONAL ACTIVITIES-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU729', 689, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU728', 688, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1168', 1128, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#13');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1168', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU723', 683, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU722', 682, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU721', 681, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU720', 680, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:DELUSIONS-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU235', 247, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SEXUAL SATISFACTION-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU234', 246, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SEXUAL SATISFACTION-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU237', 249, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECREATIONAL ACTIVITIES-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU236', 248, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FREQUENCY OF SEXUAL ACTIVITIES');
add_assessment_code(v_id1, owner_id, owner_id, 'PU236', 0, 'Never', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU236', 1, 'Once Monthly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU236', 2, 'Once Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU236', 3, '3 Times Weekly', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1210', 1170, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1210', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1110', 1070, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU18', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP REASON FOR NON-EMPLOYMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PU19', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN EMPLOYMENT-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU16', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER SOURCE OF INFORMATION');

add_assessment_score(v_id1, owner_id, owner_id, 'PU17', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP EMPLOYMENT/SELF-EMPLOYMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'PU14', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RESEARCH NOTES');

add_assessment_score(v_id1, owner_id, owner_id, 'PU15', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RECORDS FROM OTHER INSTITUTIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU12', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PHONE INTERVIEW W/RELATIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU13', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITAL RECORDS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU10', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LETTER FROM SUBJECT');

add_assessment_score(v_id1, owner_id, owner_id, 'PU11', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FACE TO FACE INTERVIEWW/RELATIVE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1182', 1142, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:DRUG USE-WK#1');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1182', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1158', 1118, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:ALCOHOL USE-WK#3');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1158', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1005', 965, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU569', 1286, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU604', 1297, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU823', 783, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU345', 357, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU345', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU345', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU345', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU345', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU344', 356, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU344', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU344', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU344', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU344', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU344', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU347', 359, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU346', 358, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT:NO.VISITS PAST 6MO');

add_assessment_score(v_id1, owner_id, owner_id, 'PU428', 440, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU429', 441, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MO UNK');

add_assessment_score(v_id1, owner_id, owner_id, 'PU343', 355, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU343', 25, 'Health maintenance', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU342', 354, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OUTPATIENT VISITS:MO/YR');

add_assessment_score(v_id1, owner_id, owner_id, 'PU424', 436, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU425', 437, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU426', 438, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU427', 439, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU420', 432, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU421', 433, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU422', 434, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:FAMILY-MONTH UNKNOWN');

add_assessment_score(v_id1, owner_id, owner_id, 'PU423', 435, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP THERAPY:OTHER/UNCERTAIN-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU983', 943, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU552', 530, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU639', 599, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU824', 784, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU658', 618, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU81', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP STUDENT WORK-PAST 6 MONTHS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU657', 617, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU83', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN SCHOOL WORK-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU82', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP REASON FOR NO STUDENT WORK');

add_assessment_score(v_id1, owner_id, owner_id, 'PU85', 97, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN SCHOOL WORK-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU84', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN SCHOOL WORK-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU87', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN SCHOOL WORK-MO.5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU86', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN SCHOOL WORK-MO.4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU89', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TYPE OF DWELLING-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU88', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP IMPAIRMENT IN SCHOOL WORK-MO.6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU562', 1283, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU655', 615, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU982', 942, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU969', 929, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU654', 614, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU825', 785, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU968', 928, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU656', 616, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU558', 534, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU120', 132, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN<13YRS-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU551', 1280, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1000', 960, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU651', 611, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1152', 1112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU122', 134, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP LIVED W/CHILDREN<13YRS-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU981', 941, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU903', 863, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU902', 862, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU901', 861, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU900', 860, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU826', 786, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU906', 866, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU905', 865, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU904', 864, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU909', 869, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU908', 868, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEG SX:AFFECT FLATTENING-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1109', 1069, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU952', 912, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU837', 797, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1127', 1087, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#24');

add_assessment_score(v_id1, owner_id, owner_id, 'PU752', 712, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#13');

add_assessment_score(v_id1, owner_id, owner_id, 'PU953', 913, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1126', 1086, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#23');

add_assessment_score(v_id1, owner_id, owner_id, 'PU954', 914, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU980', 940, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#7');

add_assessment_score(v_id1, owner_id, owner_id, 'PU690', 650, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-YEAR OF WEEK #3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1122', 1082, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU955', 915, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#8');

add_assessment_score(v_id1, owner_id, owner_id, 'PU518', 508, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU519', 509, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1124', 1084, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU956', 916, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#9');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1108', 1068, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:MANIC SYNDROME-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU510', 502, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU511', 503, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU512', 504, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU513', 505, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU514', 1267, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU515', 1268, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU516', 506, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU517', 507, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU753', 713, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU967', 927, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU959', 919, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU966', 926, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SX:INAPPR AFFECT-WK#19');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1065', 1025, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:POS PSYCHOTIC-WK#14');

add_assessment_score(v_id1, owner_id, owner_id, 'PU635', 595, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP FIRST DAY OF FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'PU828', 788, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU288', 300, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:DESCRIPTOR');
add_assessment_code(v_id1, owner_id, owner_id, 'PU288', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU288', 1, 'Infection', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU288', 2, 'Malignancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU288', 3, 'Trauma', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU288', 4, 'Not applicable', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU653', 613, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1251', 1211, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP OTHER BEHAVIOR:ANTISOCIALH-WK#17');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1251', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1251', 1, 'Mild', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1251', 2, 'Moderate', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1251', 3, 'Severe', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU289', 301, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:REASON');
add_assessment_code(v_id1, owner_id, owner_id, 'PU289', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU289', 1, 'New condition/flair up of old condition', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU289', 2, 'Receiving treatment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU289', 3, 'Routine followup', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1040', 1000, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#15');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1041', 1001, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#16');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1042', 1002, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1043', 1003, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#18');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1003', 963, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:DEPRESSED MOOD-WK4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1045', 1005, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#20');

add_assessment_score(v_id1, owner_id, owner_id, 'PU750', 710, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#11');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1047', 1007, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:ANXIOUS MOOD-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'PU829', 789, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU652', 612, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU819', 779, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU606', 566, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU607', 567, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:SCHIZOPHRENIC SX');

add_assessment_score(v_id1, owner_id, owner_id, 'PU600', 562, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU601', 563, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU602', 564, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU603', 565, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU767', 727, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU766', 726, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:BIZARRE BEHAV.-WK#1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU765', 725, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#26');

add_assessment_score(v_id1, owner_id, owner_id, 'PU764', 724, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#25');

add_assessment_score(v_id1, owner_id, owner_id, 'PU608', 568, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:MANIC SYMPTOMS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU609', 569, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP PSYCHOPATHOLOGY:DEPRESSED SX');

add_assessment_score(v_id1, owner_id, owner_id, 'PU761', 721, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#22');

add_assessment_score(v_id1, owner_id, owner_id, 'PU760', 720, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU169', 181, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP MOTHER-MO.3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1087', 1047, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#10');

add_assessment_score(v_id1, owner_id, owner_id, 'PU985', 945, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP AFFECTIVE SX:MANIC MOOD-WK#12');

add_assessment_score(v_id1, owner_id, owner_id, 'PU568', 1285, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU168', 180, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP MOTHER-MO.2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU565', 539, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DRUG CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU564', 538, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:CHANGE IN DOSE');

add_assessment_score(v_id1, owner_id, owner_id, 'PU567', 541, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU566', 540, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU561', 537, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU560', 536, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU563', 1284, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE ENDED (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1081', 1041, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:NEG PSYCHOTIC-WK#4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU459', 469, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:ROUTE/INTERVAL');

add_assessment_score(v_id1, owner_id, owner_id, 'PU496', 1261, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DATE BEGAN (MMDDYY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1150', 1110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SYNDROMES:DEPRESSED SYND-WK#21');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1219', 1179, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#12');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1219', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1218', 1178, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#11');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1218', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU458', 468, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP DRUG RECORD:DOSE (MG/DAY)');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1215', 1175, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#8');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1215', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1214', 1174, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#7');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1214', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU756', 716, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP POSITIVE SX:HALLUCINATIONS-WK#17');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1216', 1176, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#9');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1216', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1211', 1171, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#4');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1211', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU822', 782, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NEGATIVE SYMPTOMS:ALOGIA-WK#5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1213', 1173, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#6');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1213', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU1212', 1172, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP SUBSTANCE USE:TX STATUS-WK#5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 1, 'Occasional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 2, 'Occasional Heavy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 3, 'Mild impairment', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 4, 'Moderate imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 5, 'Severe imparement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 6, 'Outpatient', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU1212', 7, 'Inpatient', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU161', 173, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FATHER-MONTH 1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU160', 172, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/MOTHER-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU163', 175, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FATHER-MONTH 3');

add_assessment_score(v_id1, owner_id, owner_id, 'PU162', 174, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FATHER-MONTH 2');

add_assessment_score(v_id1, owner_id, owner_id, 'PU165', 177, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FATHER-MONTH 5');

add_assessment_score(v_id1, owner_id, owner_id, 'PU164', 176, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FATHER-MONTH 4');

add_assessment_score(v_id1, owner_id, owner_id, 'PU167', 179, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/STEP MOTHER-MO.1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU166', 178, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELATIONSHIP W/FATHER-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU636', 596, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TIMELINE-MONTH OF WEEK #1');

add_assessment_score(v_id1, owner_id, owner_id, 'PU281', 293, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GAS RATING-MONTH 5');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 1, 'Needs constant supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 2, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 3, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 4, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 5, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 6, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 7, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 8, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 9, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 10, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 11, 'Needs some supervision', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 12, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 13, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 14, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 15, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 16, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 17, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 18, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 19, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 20, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 21, 'Unable to function in most areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 22, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 23, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 24, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 25, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 26, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 27, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 28, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 29, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 30, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 31, 'Major impairment in several areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 32, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 33, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 34, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 35, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 36, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 37, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 38, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 39, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 40, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 41, 'Serious symptomology requiring Tx', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 42, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 43, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 44, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 45, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 46, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 47, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 48, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 49, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 50, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 51, 'Moderate symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 52, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 53, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 54, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 55, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 56, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 57, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 58, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 59, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 60, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 61, 'Mild symptoms', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 62, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 63, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 64, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 65, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 66, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 67, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 68, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 69, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 70, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 71, 'Slight impairment in functioning', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 72, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 73, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 74, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 75, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 76, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 77, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 78, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 79, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 80, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 81, 'Good functioning in all areas', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 82, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 83, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 84, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 85, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 86, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 87, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 88, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 89, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 90, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU281', 91, 'Superior functioning', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'PU282', 294, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP GAS RATING-MONTH 6');

add_assessment_score(v_id1, owner_id, owner_id, 'PU283', 295, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP RELIABILITY &''||'' COMPLETENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU284', 296, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NON-PSYCHIATRIC HOSPITALIZATION');

add_assessment_score(v_id1, owner_id, owner_id, 'PU285', 297, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP NUMBER OF HOSPITALIZATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'PU286', 298, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP TOTAL DAYS HOSPITALIZED');

add_assessment_score(v_id1, owner_id, owner_id, 'PU287', 299, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'PSYCHUP HOSPITALIZATIONS:MED CATEGORY');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 1, 'Immune disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 2, 'Collagen disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 3, 'Joint disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 4, 'Neurologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 5, 'Respiratory', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 6, 'Cardiovescular', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 7, 'Renal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 8, 'Digestive system', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 9, 'Nutritional', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 10, 'Hematologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 11, 'Metabolic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 12, 'Endocrine', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 13, 'Skeletal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 14, 'Dermatological', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 15, 'Hereditary', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 16, 'Gynecologic', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 17, 'Sensory organ', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 18, 'Not specific diagnosis', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 19, 'Breast', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 20, 'Coronary artery disease', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 21, 'Hypertension', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 22, 'Migrane headaches', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 23, 'Diabetes mellitus', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 24, 'Pregnancy', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PU287', 25, 'Health maintenance', 'integer');

commit;
END;
/
