
--Add sansap
create or replace procedure sansap(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('sansap', 'sansap', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS67', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DISTRACTIBLE SPEECH');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SECOND CHECKER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS8', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SOURCE (FRIENDS)');

add_assessment_score(v_id1, owner_id, owner_id, 'SS54', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS THOUGHT WITHDRAWAL');

add_assessment_score(v_id1, owner_id, owner_id, 'SS44', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DELUSIONS OF JEALOUSY');

add_assessment_score(v_id1, owner_id, owner_id, 'SS5', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SOURCE (INTERVIEW)');

add_assessment_score(v_id1, owner_id, owner_id, 'SS4', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP MEDICATION STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS7', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SOURCE (FAMILY)');

add_assessment_score(v_id1, owner_id, owner_id, 'SS6', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SOURCE (STAFF)');

add_assessment_score(v_id1, owner_id, owner_id, 'SS3', 15, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP PATIENT STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 1, 'Normal Control', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 2, 'Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 3, 'Neuroleptic Non-Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 4, 'Almost Neuroleptic Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 5, 'Totally Psychoactive Drug Naive', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS3', 6, 'Other', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SS61', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DERAILMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'SS20', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS POVERTY OF CONTENT OF SPEECH');

add_assessment_score(v_id1, owner_id, owner_id, 'SS28', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS RECREATIONAL INTERESTS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS22', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS INCR LATENCY OF RESPONSE');

add_assessment_score(v_id1, owner_id, owner_id, 'SS23', 35, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS GLOBAL RATING OF ALOGIA');

add_assessment_score(v_id1, owner_id, owner_id, 'SS24', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS GROOMING AND HYGIENE');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP RELIABILITY CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SS27', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS GLOBAL RATING OF AVOLITION-APATHY');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'SS9', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SOURCE (OTHER)');

add_assessment_score(v_id1, owner_id, owner_id, 'SS45', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DELUSIONS OF GUILT OR SIN');

add_assessment_score(v_id1, owner_id, owner_id, 'SS53', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS THOUGHT INSERTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SS39', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS SOMATIC OR TACTILE HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP ASSESSMENT CODE');

add_assessment_score(v_id1, owner_id, owner_id, 'SS59', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS REPETITIVE OR STEREOTYPED BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'SS48', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS SOMATIC DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS38', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS VOICES CONVERSING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS68', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS CLANGING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS69', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS GLOBAL RATING THOUGHT DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS42', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS GLOBAL RATING OF HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS43', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS PERSECUTORY DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS32', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS GLOBAL RATING OF ASOCIALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SS41', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS VISUAL HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS46', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS GRANDIOSE DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS47', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS RELIGIOUS DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS26', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS PHYSICAL ANERGIA');

add_assessment_score(v_id1, owner_id, owner_id, 'SS14', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS POOR EYE CONTACT');

add_assessment_score(v_id1, owner_id, owner_id, 'SS62', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS TANGENTIALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SS52', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS THOUGHT BROADCASTING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS49', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DELUSIONS OF REFERENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS29', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS SEXUAL ACTIVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SS56', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS CLOTHING AND APPEARANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS63', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS INCOHERENCE');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'SS19', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS POVERTY OF SPEECH');

add_assessment_score(v_id1, owner_id, owner_id, 'SS18', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS INAPPROPRIATE AFFECT');

add_assessment_score(v_id1, owner_id, owner_id, 'SS31', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS RELATIONSHIP WITH FRIENDS &''||'' PEERS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS30', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS ABILITY TO FEEL INTIMACY');

add_assessment_score(v_id1, owner_id, owner_id, 'SS37', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS VOICES COMMENTING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS36', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS AUDITORY HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS35', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS GLOBAL RATING OF ATTENTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SS34', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS INATTENTIVE DURING MENTAL TESTING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS11', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS FACIAL EXPRESSION');

add_assessment_score(v_id1, owner_id, owner_id, 'SS10', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP INTRVW RELIABILITY');
add_assessment_code(v_id1, owner_id, owner_id, 'SS10', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS10', 1, 'Very Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS10', 2, 'Good', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS10', 3, 'Fair', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS10', 4, 'Poor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SS10', 5, 'Very Poor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SS13', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS EXPRESSIVE GESTURES');

add_assessment_score(v_id1, owner_id, owner_id, 'SS12', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS SPONTANEOUS MOVEMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'SS15', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS AFFECTIVE NONRESPONSIVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS17', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS AFFECTV FLATTENING - GLOBAL RATING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS16', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS LACK VOCAL INFLECTIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS66', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS PRESSURE OF SPEECH');

add_assessment_score(v_id1, owner_id, owner_id, 'SS33', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS SOCIAL INATTENTIVENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SS21', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS BLOCKING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS55', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS GLOBAL RATING OF DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS57', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS SOCIAL AND SEXUAL BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'SS58', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS AGGRESSIVE AND AGITATED BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP FIRST ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'SS64', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS ILLOGICALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP SECOND ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'SS65', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS CIRCUMSTANTIALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SS51', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DELUSIONS OF MIND READING');

add_assessment_score(v_id1, owner_id, owner_id, 'SS60', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS GLOBAL RATING OF BIZARRE BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANSAP PROCEDURE CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'HMPAO -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'HMPAO -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'DI-SPECT -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'DI-SPECT -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 9, 'Behavioral -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 10, 'Behavioral -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 11, 'PET/150 H2O -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 12, 'Pet/150 H2O -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 13, 'Thalamus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SS40', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS OLFACTORY HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'SS50', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SAPS DELUSIONS OF BEING CONTROLLED');

add_assessment_score(v_id1, owner_id, owner_id, 'SS25', 37, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SANS IMPERSISTENCE AT WORK OR SCHOOL');

commit;
END;
/
