
--Add simpson
create or replace procedure simpson(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('simpson', 'simpson', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON WEEK NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'USG', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON URINE SPECIFIC GRAVITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SI110', 38, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON AKATHISIA');
add_assessment_code(v_id1, owner_id, owner_id, 'SI110', 0, 'Absent', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI110', 1, 'Mild, occasional restlessness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI110', 2, 'Moderate, continuous restlessness', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI110', 3, 'Marked, patient in and out of chair durring examination', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI110', 4, 'Extreme, heightened activity, panic', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'SI11', 30, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON HEAD DROPPING');
add_assessment_code(v_id1, owner_id, owner_id, 'SI11', 0, 'Head falls completely with thump as it hits the table', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI11', 1, 'Slight slowing in fall, mainly noted by lack of thump', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI11', 2, 'Head falls stiffly and slowly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI11', 3, 'Head does not reach examining table', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI112', 40, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON COOPERATIVENESS');
add_assessment_code(v_id1, owner_id, owner_id, 'SI112', 0, 'Cooperative', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI112', 1, 'Some resistance', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI112', 2, 'Uncooperative', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI112', 3, 'Very uncooperative', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI104', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON MAJOR JOINTS RIGIDITY - LEFT');

add_assessment_score(v_id1, owner_id, owner_id, 'SI105', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON MAJOR JOINTS RIGIDITY - OVERALL');

add_assessment_score(v_id1, owner_id, owner_id, 'SI106', 32, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON TREMOR - RIGHT');
add_assessment_code(v_id1, owner_id, owner_id, 'SI106', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI106', 1, 'Mild finger tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI106', 2, 'Hand/Arm tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI106', 3, 'Persistent tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI106', 4, 'Whole body tremor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI107', 33, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON TREMOR - LEFT');
add_assessment_code(v_id1, owner_id, owner_id, 'SI107', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI107', 1, 'Mild finger tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI107', 2, 'Hand/Arm tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI107', 3, 'Persistent tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI107', 4, 'Whole body tremor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI100', 22, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON COGWHEELING - RIGHT');
add_assessment_code(v_id1, owner_id, owner_id, 'SI100', 0, 'Not Present', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI100', 1, 'Very mild/questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI100', 2, 'Definitely present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI101', 23, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON COGWHEELING - LEFT');
add_assessment_code(v_id1, owner_id, owner_id, 'SI101', 0, 'Not Present', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI101', 1, 'Very mild/questionable', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI101', 2, 'Definitely present', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'SI103', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON MAJOR JOINTS RIGIDITY - RIGHT');

add_assessment_score(v_id1, owner_id, owner_id, 'SI14', 35, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON SALIVATION');
add_assessment_code(v_id1, owner_id, owner_id, 'SI14', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI14', 1, 'Excess salivation to the extent that pooling takes place', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI14', 2, 'Excess salivation occasionaly leading to difficulty in speaking', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI14', 3, 'Speaking with difficulty because of excess salivation', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI14', 4, 'Frank drooling', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI13', 34, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON TREMOR');
add_assessment_code(v_id1, owner_id, owner_id, 'SI13', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI13', 1, 'Mild finger tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI13', 2, 'Hand/Arm tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI13', 3, 'Persistent tremor', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI13', 4, 'Whole body tremor', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 13, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 9, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI10', 29, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON LEG PENDULOUSNESS');
add_assessment_code(v_id1, owner_id, owner_id, 'SI10', 0, 'Legs swing freely', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI10', 1, 'Slight diminution in the swing of the legs', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI10', 2, 'Moderate resistance to swing', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI10', 3, 'Marked resistance and damping of swing', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI10', 4, 'Complete absence of swing', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 12, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON INTERVIEW DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 11, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SI109', 37, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON AKINESIA');
add_assessment_code(v_id1, owner_id, owner_id, 'SI109', 0, 'None', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI109', 1, 'Mild, apathetic spontaneous speed is decreased', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI109', 2, 'Moderate, poverty of movement', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI109', 3, 'Marked, difficulty initiating movement and speech', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI109', 4, 'Extreme, moves with great effort of frozen; mute', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 16, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON MEDICATION STATUS');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI108', 36, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON BALANCE');
add_assessment_code(v_id1, owner_id, owner_id, 'SI108', 0, 'Normal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI108', 1, 'Questionably abnormal', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI108', 2, 'Definitely abnormal', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SI6', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON ARM DROPPING');

add_assessment_score(v_id1, owner_id, owner_id, 'SI5', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON GAIT');

add_assessment_score(v_id1, owner_id, owner_id, 'SI9', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON FIXATION OF POS/WRIST RIGIDITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SI8', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON ELBOW RIGIDITY');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'DRUGSTAT', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON PATIENT STATUS');

add_assessment_score(v_id1, owner_id, owner_id, 'SI111', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON ACUTE DYSTONIC REACTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SI7', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON SHOULDER SHAKING');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON PROCEDURE CODE');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'Xenon -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Xenon -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'IMP -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'IMP -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 5, 'HMPAO -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 6, 'HMPAO -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 7, 'DI-SPECT -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 8, 'DI-SPECT -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 9, 'Behavioral -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 10, 'Behavioral -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 11, 'PET/150 H2O -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 12, 'Pet/150 H2O -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 13, 'Thalamus', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SI102', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON COGWHEELING - OVERALL');

add_assessment_score(v_id1, owner_id, owner_id, 'SI12', 31, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SIMPSON GLABELLA TAP');
add_assessment_code(v_id1, owner_id, owner_id, 'SI12', 0, '0 to 5 blinks', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI12', 1, '6 to 10 blinks', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI12', 2, '11 to 15 blinks', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI12', 3, '16 to 20 blinks', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SI12', 4, '21 or more blinks', 'integer');

commit;
END;
/
