
--Add simpson
create or replace procedure add_simpson_value(
experiment_ID_in number, visit_ID_in number,
segment_ID_in number, owner_id_in number, subject_id_in varchar2,
time_stamp_in TIMESTAMP,
BATCHNUM varchar2,
DOCNUM varchar2,
ENT1 float,
ENT2 float,
ID varchar2,
ASS float,
WEEK float,
PROC integer,
REL integer,
FRM varchar2,
VER float,
DATE varchar,
RATER float,
RATER2 float,
DRUGSTAT float,
MED integer,
USG float,
SI5 float,
SI6 float,
SI7 float,
SI8 float,
SI100 integer,
SI101 integer,
SI102 float,
SI103 float,
SI104 float,
SI105 float,
SI9 float,
SI10 integer,
SI11 integer,
SI12 integer,
SI106 integer,
SI107 integer,
SI13 integer,
SI14 integer,
SI108 integer,
SI109 integer,
SI110 integer,
SI111 float,
SI112 integer)
is
  v_assessment_ID number;
  v_stored_A_ID number;
  v_rc number;

BEGIN

   v_assessment_ID := get_assessment_id('simpson');

   if owner_id_in < 0 then
      Raise_application_error(-20113,'ERROR: v_owner_id_in < 0');
   end if;

   if v_assessment_ID < 0 then
      Raise_application_error(-20113,'ERROR: v_assessment_ID < 0');
   end if;

   if experiment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: experiment_ID_in < 0');
   end if;

   if visit_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: visit_ID_in < 0');
   end if;

   if segment_ID_in < 0 then
      Raise_application_error(-20113,'ERROR: segment_ID_in < 0');
   end if;

   v_stored_A_ID := add_stored_assessment(v_assessment_ID, owner_id_in, owner_id_in,
     visit_ID_in, experiment_ID_in, segment_ID_in, subject_id_in, time_stamp_in, subject_id_in, 'self');

-- adding data
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'BATCHNUM', 'varchar', 1, NULL, batchnum, NULL, batchnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'WEEK', 'float', 7, week, to_char(week), week, to_char(week), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'USG', 'float', 17, usg, to_char(usg), usg, to_char(usg), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI110', 'integer', 38, si110, to_char(si110), si110, to_char(si110), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER2', 'float', 14, rater2, to_char(rater2), rater2, to_char(rater2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI11', 'integer', 30, si11, to_char(si11), si11, to_char(si11), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI112', 'integer', 40, si112, to_char(si112), si112, to_char(si112), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI104', 'float', 26, si104, to_char(si104), si104, to_char(si104), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI105', 'float', 27, si105, to_char(si105), si105, to_char(si105), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI106', 'integer', 32, si106, to_char(si106), si106, to_char(si106), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI107', 'integer', 33, si107, to_char(si107), si107, to_char(si107), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI100', 'integer', 22, si100, to_char(si100), si100, to_char(si100), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI101', 'integer', 23, si101, to_char(si101), si101, to_char(si101), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'FRM', 'varchar', 10, NULL, frm, NULL, frm, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI103', 'float', 25, si103, to_char(si103), si103, to_char(si103), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI14', 'integer', 35, si14, to_char(si14), si14, to_char(si14), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI13', 'integer', 34, si13, to_char(si13), si13, to_char(si13), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'RATER', 'float', 13, rater, to_char(rater), rater, to_char(rater), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'REL', 'integer', 9, rel, to_char(rel), rel, to_char(rel), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI10', 'integer', 29, si10, to_char(si10), si10, to_char(si10), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DATE', 'timestamp', 12, NULL, date, NULL, date, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'VER', 'float', 11, ver, to_char(ver), ver, to_char(ver), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ID', 'varchar', 5, NULL, id, NULL, id, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI109', 'integer', 37, si109, to_char(si109), si109, to_char(si109), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ASS', 'float', 6, ass, to_char(ass), ass, to_char(ass), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'MED', 'integer', 16, med, to_char(med), med, to_char(med), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI108', 'integer', 36, si108, to_char(si108), si108, to_char(si108), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DOCNUM', 'varchar', 2, NULL, docnum, NULL, docnum, NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI6', 'float', 19, si6, to_char(si6), si6, to_char(si6), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI5', 'float', 18, si5, to_char(si5), si5, to_char(si5), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI9', 'float', 28, si9, to_char(si9), si9, to_char(si9), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI8', 'float', 21, si8, to_char(si8), si8, to_char(si8), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT1', 'float', 3, ent1, to_char(ent1), ent1, to_char(ent1), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'ENT2', 'float', 4, ent2, to_char(ent2), ent2, to_char(ent2), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'DRUGSTAT', 'float', 15, drugstat, to_char(drugstat), drugstat, to_char(drugstat), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI111', 'float', 39, si111, to_char(si111), si111, to_char(si111), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI7', 'float', 20, si7, to_char(si7), si7, to_char(si7), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'PROC', 'integer', 8, proc, to_char(proc), proc, to_char(proc), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI102', 'float', 24, si102, to_char(si102), si102, to_char(si102), NULL, '', NULL, 0, 0, subject_id_in, 0);
   v_rc := store_assessment_value(v_assessment_ID, v_stored_A_ID, owner_id_in, owner_id_in, 'SI12', 'integer', 31, si12, to_char(si12), si12, to_char(si12), NULL, '', NULL, 0, 0, subject_id_in, 0);
EXCEPTION
   WHEN OTHERS THEN
      dbms_output.put_line('add_simpson_value for subject: ' || subject_id_in || ' failed!');
      raise;

commit;
END;
/
