
--Add sumd
create or replace procedure sumd(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('sumd', 'sumd', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'HALLUCIN', 16, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD HALLUCINATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'WEEK', 9, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'RITUAL', 21, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD STEREOTYPIC OR RITUALISTIC BEHAVIOR');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 15, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD6B', 41, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD THOUGHT DISORDER ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD18', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD CONFUSION-DISORIENT. AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD15B', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD AVOLITION-APATHY ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD19B', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD UNUSUAL EYE CONTACT ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 14, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD RATER WHO FILLED OUT THE FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 10, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD RELIABILITY NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'type', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'DATE', 13, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD DATE THE FORM WAS FILLED OUT');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD11B', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR CONTROL AGGRESSIVE ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD17B', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR ATTENTION ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'THGHTDIS', 18, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD THOUGHT DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'AVOLIT', 27, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD AVOLITION-APATHY');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 6, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ASSESSMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'POORATTN', 29, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR ATTENTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD19', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD UNUSUAL EYE CONTACT AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD9B', 47, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD RITUALISTIC BEHAVIOR ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD1', 33, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD AWARENESS OF MENTAL DISORDER');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD2', 34, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD AWARENESS OF MEDICATION EFFECTS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD3', 35, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD AWARENESS OF SOCIAL CONSEQUENCES');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD3', 0, 'Cannot be assessed', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD3', 1, 'Aware', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD3', 2, 'Aware', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD3', 3, 'Somewhat', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD3', 4, 'Somewhat', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD3', 5, 'Unaware', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD4', 36, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD HALLUCINATIONS AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD5', 38, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD DELUSIONS AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD6', 40, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD THOUGHT DISORDER AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD7', 42, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD INAPPROPRIATE AFFECT AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD12', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR CONTROL SEXUAL AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD13', 54, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ALOGIA AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD10', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR SOCIAL JUDGEMENT AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD11', 50, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR CONTROL AGGRESSIVE AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD16', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ANHEDONIA OR ASOCIALITY AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD17', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR ATTENTION AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD14', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD FLAT OR BLUNT AFFECT AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD15', 58, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD AVOLITION-APATHY AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'ALOGIA', 25, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ALOGIA');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD7B', 43, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD INAPPROPRIATE AFFECT ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'INAPPAFF', 19, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD INAPPROPRIATE AFFECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CONFUS', 30, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD CONFUSION-DISORIENTATION');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'POORJUDG', 22, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR SOCIAL JUDGEMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD13B', 55, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ALOGIA ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 12, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'FLATAFF', 26, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD FLAT OR BLUNT AFFECT');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD9', 46, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD RITUALISTIC BEHAVIOR AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 7, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'DELUSION', 17, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD DELUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 11, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD FORM NAME');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD8', 44, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD UNUSUAL APPERANCE AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD16B', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ANHEDONIA OR ASOCIALITY ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'UNUSAPP', 20, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD UNUSUAL DRESS OR APPEARANCE');

add_assessment_score(v_id1, owner_id, owner_id, 'POORREL', 32, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR SOCIAL RELATIONSHIPS');

add_assessment_score(v_id1, owner_id, owner_id, 'POORSEX', 24, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR CONTROL OF SEXUAL IMPULSES');

add_assessment_score(v_id1, owner_id, owner_id, 'ANHEDON', 28, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD ANHEDONIA-ASOCIALITY');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD10B', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR SOCIAL JUDGEMENT ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD 7-DIGIT HOSPITAL ID NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'UNUSEYE', 31, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD UNUSUAL EYE CONTACT');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD12B', 53, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR CONTROL SEXUAL ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD5B', 39, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD DELUSIONS ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD8B', 45, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD UNUSUAL APPERANCE ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'POORAGGR', 23, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR CONTROL OF AGGRESSIVE IMPULSES');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 3, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD FIRST DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD18B', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD CONFUSION-DISORIENT. ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD20B', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR SOCIAL RELATION. ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 4, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD SECOND DATA ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD20', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD POOR SOCIAL RELATION. AWARENESS');

add_assessment_score(v_id1, owner_id, owner_id, 'PROC', 8, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD PROCEDURE NUMBER');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 0, 'Weekly', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 1, 'At admission', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 2, 'Pet -on meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 3, 'Pet -off meds', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'PROC', 4, 'At Discharge', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD14B', 57, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD FLAT OR BLUNT AFFECT ATTRIBUTION');

add_assessment_score(v_id1, owner_id, owner_id, 'SUMD4B', 37, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'SUMD HALLUCINATIONS ATTRIBUTION');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD4B', 0, 'Cannot be assessed/not relevant', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD4B', 1, 'Correct', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD4B', 2, 'Correct', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD4B', 3, 'Partial', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD4B', 4, 'Partial', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'SUMD4B', 5, 'Incorrect', 'integer');

commit;
END;
/
