/*=auto=========================================================================

  Portions (c) Copyright 2008 Brigham and Women's Hospital (BWH) All Rights Reserved.

  See Doc/copyright/copyright.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Program:   3D Slicer
  Module:    $RCSfile: vtkExampleLoadableGuiLessModuleLogic.h,v $
  Date:      $Date: 2006/03/19 17:12:29 $
  Version:   $Revision: 1.3 $

=========================================================================auto=*/
#ifndef __vtkExampleLoadableGuiLessModuleLogic_h
#define __vtkExampleLoadableGuiLessModuleLogic_h

#include "vtkSlicerModuleLogic.h"
#include "vtkMRMLScene.h"

#include "vtkExampleLoadableGuiLessModule.h"
#include "vtkMRMLExampleLoadableGuiLessModuleNode.h"


class vtkITKGradientAnisotropicDiffusionImageFilter;

class VTK_EXAMPLELOADABLEGUILESSMODULE_EXPORT vtkExampleLoadableGuiLessModuleLogic : public vtkSlicerModuleLogic
{
  public:
  static vtkExampleLoadableGuiLessModuleLogic *New();
  vtkTypeMacro(vtkExampleLoadableGuiLessModuleLogic,vtkSlicerModuleLogic);
  void PrintSelf(ostream& os, vtkIndent indent);

  // TODO: do we need to observe MRML here?
  virtual void ProcessMrmlEvents ( vtkObject *caller, unsigned long event,
                                   void *callData ){};

  // Description: Get/Set MRML node storing parameter values
  vtkGetObjectMacro (ExampleLoadableGuiLessModuleNode, vtkMRMLExampleLoadableGuiLessModuleNode);
  void SetAndObserveExampleLoadableGuiLessModuleNode(vtkMRMLExampleLoadableGuiLessModuleNode *n) 
    {
    vtkSetAndObserveMRMLNodeMacro( this->ExampleLoadableGuiLessModuleNode, n);
    }

  // The method that creates and runs VTK or ITK pipeline
  void Apply();
  
protected:
  vtkExampleLoadableGuiLessModuleLogic();
  virtual ~vtkExampleLoadableGuiLessModuleLogic();
  vtkExampleLoadableGuiLessModuleLogic(const vtkExampleLoadableGuiLessModuleLogic&);
  void operator=(const vtkExampleLoadableGuiLessModuleLogic&);

  vtkMRMLExampleLoadableGuiLessModuleNode* ExampleLoadableGuiLessModuleNode;
  vtkITKGradientAnisotropicDiffusionImageFilter* GradientAnisotropicDiffusionImageFilter;

};

#endif

