/*=========================================================================
  Example module that can be built against either a Slicer3 build tree
  or a Slicer3 installation.  This example uses ITK filtering.  The
  example demonstrates how to support multiple input pixel types.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#ifdef __BORLANDC__
#define ITK_LEAN_AND_MEAN
#endif

#include "itkPluginUtilities.h"

#include "itkImage.h"
#include "itkOrientedImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageRegionIterator.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkConstNeighborhoodIterator.h"

#include "ExampleModuleCLP.h"

template<class T> int DoIt( int argc, char * argv[], T )
{
  PARSE_ARGS;

  typedef itk::Image<T, 3> ImageType;

  // Set up a reader for the input image
  typedef itk::ImageFileReader<ImageType> ImageReader;
  typename ImageReader::Pointer reader = ImageReader::New();
  reader->SetFileName(InputImage.c_str());

  // Attach progress and abort back into main application
  itk::PluginFilterWatcher readerWatcher(reader, "Reading",
    CLPProcessInformation);


  // Insert code here to filter the image.
  //
  

  
  // Set up a writer for the output image
  typedef itk::ImageFileWriter<ImageType> ImageWriter;
  typename ImageWriter::Pointer writer = ImageWriter::New();
  writer->SetFileName(OutputImage.c_str());
  writer->SetInput(reader->GetOutput());

  // Attach progress and abort back into main application
  itk::PluginFilterWatcher writerWatcher(writer, "Writing",
    CLPProcessInformation);

  // Run the pipeline
  writer->Update();
  
  return EXIT_SUCCESS;
}


int main( int argc, char * argv[] )
{
  // Print out the arguments (need to add --echo to the argument list 
  // 
  std::vector<char *> vargs;
  for (int vi=0; vi < argc; ++vi) vargs.push_back(argv[vi]);
  vargs.push_back("--echo");
  
  argc = vargs.size();
  argv = &(vargs[0]);

  // Parse the command line arguments
  PARSE_ARGS;

  // Peek into the file to determine the pixel type of the input and
  // then delegate to an appropriate implementation
  itk::ImageIOBase::IOPixelType pixelType;
  itk::ImageIOBase::IOComponentType componentType;

  try
    {
    itk::GetImageType (InputImage, pixelType, componentType);

    // This filter handles all types
    switch (componentType)
      {
      case itk::ImageIOBase::UCHAR:
        return DoIt( argc, argv, static_cast<unsigned char>(0));
        break;
      case itk::ImageIOBase::CHAR:
        return DoIt( argc, argv, static_cast<char>(0));
        break;
      case itk::ImageIOBase::USHORT:
        return DoIt( argc, argv, static_cast<unsigned short>(0));
        break;
      case itk::ImageIOBase::SHORT:
        return DoIt( argc, argv, static_cast<short>(0));
        break;
      case itk::ImageIOBase::UINT:
        return DoIt( argc, argv, static_cast<unsigned int>(0));
        break;
      case itk::ImageIOBase::INT:
        return DoIt( argc, argv, static_cast<int>(0));
        break;
      case itk::ImageIOBase::ULONG:
        return DoIt( argc, argv, static_cast<unsigned long>(0));
        break;
      case itk::ImageIOBase::LONG:
        return DoIt( argc, argv, static_cast<long>(0));
        break;
      case itk::ImageIOBase::FLOAT:
        return DoIt( argc, argv, static_cast<float>(0));
        break;
      case itk::ImageIOBase::DOUBLE:
        return DoIt( argc, argv, static_cast<double>(0));
        break;
      case itk::ImageIOBase::UNKNOWNCOMPONENTTYPE:
      default:
        std::cout << "unknown component type" << std::endl;
        break;
      }
    }
  catch( itk::ExceptionObject &excep)
    {
    std::cerr << argv[0] << ": exception caught !" << std::endl;
    std::cerr << excep << std::endl;
    return EXIT_FAILURE;
    }
  return EXIT_FAILURE;
}
