function reseed

%
% RESEED seeds the uniform and normal random generators, RAND and RANDN
% with the current time obtained with NOW.
%
% See also: RAND, RANDN, NOW.

% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/reseed.m $
% $Revision: 45 $
% $Date: 2011-04-18 12:53:38 -0400 (Mon, 18 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------

umethod = 'twister';
nmethod = 'state';

s = typecast(now,'uint32');
rand(umethod, double( s(1) )); %Using the least significant 4 bytes of the value returned by now

randn( nmethod, double( swapbytes( s(1) ) ) ); %using swapbytes so that the randn and rand seeds are
                                             %at least somewhat arbitrary
                                             %with respect to each other.
                                             


