function trialdata = setTrialData(h,trialdata)


%  setTrialData(h,trialdata)
%
% Associates the trialdata with current data set
% and brings up the trial data window
%
% trialdata is a structure returned by MAKETRIALDATA
%
% See also makeTrialData

% ----------- SVN REVISION INFO ------------------
% $URL: file:///var/lib/gforge/svnroot/gazereader/0.1/setTrialData.m $
% $Revision: 61 $
% $Date: 2011-04-28 12:38:03 -0400 (Thu, 28 Apr 2011) $
% $Author: ckovach $
% ------------------------------------------------



if nargin < 1 || isempty(h) || ~ishandle(h)    
    h = GazeReader;
end



if nargin > 1
    setappdata(h,'trialData',trialdata);
elseif nargout > 0
    trialdata = getappdata(h,'trialData');
end
handles = guidata(h);

GazeReader('Trial_Manager_Callback',h,[],handles);

tmfun = getappdata(h,'trialManagerFunctions');

if ~isempty(tmfun)
      tmfun.updateAllDataSets();
 %   tmfun.update();
end


