function list_conversion_table(Labels)

%Labels = readtable('C:\tutkimus\omat_paperit\FuSeISC\FuSe\forest\atlas_labels_abbr.csv');
%Labels(1,3)
%Labels(1,4)

Labels2 = Labels(1:117,:);
[s4,si] = sort(lower(table2array(Labels2(:,4))));
s4 = table2array(Labels2(si,4));
s3 = table2array(Labels2(si,3));
s2 = table2array(Labels2(si,2));
s1 = table2array(Labels2(si,1));
clear S
for mm = 1:size(s1,1)
   S{mm,1} = s1(mm); 
   S{mm,2} = s2{mm}; 
   S{mm,3} = s3{mm}; 
   S{mm,4} = s4{mm}; 
end
poista = zeros(1,size(S,1));
for m = 1:size(S,1)
    if strcmp(S{m,4}(end-1:end),'.L')
        poista(m) = 1;
    end
 if strcmp(S{m,4},'cx.R')
        poista(m) = 1;        
    end
    if strcmp(S{m,4},'cw.R')
        poista(m) = 1;        
    end    
end
S(find(poista),:) = [];

Labels = array2table(S);

disp(' ')
disp(' ')
disp(' ')
clc
disp(' ')
disp(' ')
disp(' ')
disp(' ')
disp(' ')
disp(' ')
disp('\begin{table}[htb]')
disp('\caption{Abbreviations used in this paper which denote the full region names of the Harvard-Oxford brain atlas. We additionally use the shorthand notations ``L'' and ``R'' to denote the left and right sides of the brain, respectively. For instance, the abbreviation ``frp.L'' corresponds to the Left Frontal Pole.}')
disp('\centering')
disp('\singlespacing')
disp('\tiny')
disp('\begin{tabular}{l l | l l |}')

Na = ['\textbf{Abbr} & \textbf{Brain region} & \textbf{Abbr} & \textbf{Brain region} \\ \hline'];
disp(Na)


ite = 1;
areas = [1:2:96 97 99:107];% 97 99:108 110:117];

%Labels = Labels(1:2:length(areas),:);

ite = 1;
clear TT1 TT2
for m = 1:2:size(Labels,1)
        
    T1 = table2array(Labels(m,3));
    T1 = T1{1};
    T2 = table2array(Labels(m,4));
    T2 = T2{1};
    if strcmp(T1(1),'R')
        T1 = T1(7:end);
        T2 = T2(1:end-2);
    elseif strcmp(T1(1),'L')
        T1 = T1(6:end);
        T2 = T2(1:end-2);
    end
    
%    if areas(m) == 51
%        T1 = T1(1:35);
%    end
%    if areas(m) == 52
%        T1 = T1(1:35);
%    end
    
    if m == size(Labels,1)
        T3 = '';
        T4 = '';
    else
        T3 = table2array(Labels(m+1,3));
        T3 = T3{1};
        T4 = table2array(Labels(m+1,4));
        T4 = T4{1};
    if strcmp(T3(1),'R')
        T3 = T3(7:end);
        T4 = T4(1:end-2);
    elseif strcmp(T3(1),'L')
        T3 = T3(6:end);
        T4 = T4(1:end-2);
    end

        %if m+1 == 51
        %    T3 = T3(1:35);
        %end
        %if areas(m+1) == 52
        %    T3 = T3(1:35);
        %end
    end
    TT1{ite,1} = T2;
    TT1{ite,2} = T1;
    TT2{ite,1} = T4;
    TT2{ite,2} = T3;
    ite = ite + 1;
end
TT = cell(size(TT1,1)+size(TT2,1),2);
TT(1:2:end,:) = TT1;
TT(2:2:end,:) = TT2;

TTT = [TT(1:round(size(TT,1)/2),:) TT((round(size(TT,1)/2)+1):size(TT,1),:)];
TTT{17,4} = TTT{17,4}(1:30);

for m = 1:size(TTT,1)        
    disp([ TTT{m,1}  '&' TTT{m,2} '&' TTT{m,3} '&' TTT{m,4} ' \\'])
end
disp('\hline')
disp('\end{tabular}')
disp('\label{table:name_conversion}')
disp('\end{table}')


disp(' ')
disp(' ')
disp(' ')



