function [Clust,X] = runFuSe(Params,k) % script to compute FuSeISC clustering
% This script runs Functional segmentation of the brain based on ISC mean 
% and variability features. After running the function, visualization of 
% the results can be performed using the function "plotSegmentationResults".
%
% Inputs:
%
% Params - a parameter struct of the ISC project.
% k - neighborhood size k
%
% See also:
% CLUSTERISC
% LOADSEGMENTATIONRESULTS
% PLOT_SEGMENT
% PLOTSEGMENTATIONRESULTS

%
% Juha Pajula and Jukka-Pekka Kauppi, 29.6.2016.
disp(datestr(now))

overwrite_GMM = 0;
overwrite_all = 0;

Pub = Params.PublicParams;
Priv = Params.PrivateParams;

%test if k is given,otherwise use the one from params
%the k param is ment for sweaping over multiple k values -JP
if nargin == 2
    Pub.FuSe_K = k;
else
    k = Pub.FuSe_K;
end
% the script assumes that X is defined by StdEstimate script before this
% script is run

featureSet = Pub.FuSe_FSet;
regul_opt = Pub.FuSe_reg_opt;

FuSeFolder = [Params.PublicParams.dataDestination 'FuSe/'];
if exist(FuSeFolder) ~= 7
    mkdir(FuSeFolder)
end

disp(datestr(now))
%generate Jackknife estimates and feature matrix
Xpath = [Params.PublicParams.dataDestination 'FuSe/X.mat'];
if exist(Xpath,'file') == 2
    disp('ISC features already computed, loading data matrix...')
    load(Xpath);
else
    disp('Extracting Features...')
    X = generateJackKnifeEstimates(Params);
    save(Xpath, 'X' );
end
if Pub.FuSe_mask
%    toolboxpath=which('ISCanalysis');toolboxpath=toolboxpath(1:end-25);
%    load([toolboxpath 'brain_activation_areas.mat']);
    Fmask = load(Pub.FuSeMaskPath);
    Fnames = fieldnames(Fmask);
    brainMask = load_nii(Priv.brainMask);
    FuSeMask = Fmask.(Fnames{1});
    inds_brain = find(brainMask.img);
    inds_mask = find(FuSeMask);
    [commonI,B] = intersect(inds_brain,inds_mask);
    X = X(B,:);
    inds = inds_mask;
else
    brainMask = load_nii(Priv.brainMask);
    inds = find(brainMask.img);
end

if(regul_opt)
    reg_txt = 'Regularized';
else
    reg_txt = 'NonRegularized';
end

if(Pub.FuSe_Diag)
    diag_txt = 'Diagonal';
else
    diag_txt = 'Full';
end

ClustPath = [Params.PublicParams.dataDestination 'FuSe/FuSeClusters_Fset' ...
    num2str(featureSet) '_K' num2str(Pub.FuSe_K) '_' diag_txt '_' reg_txt '.mat'];
if ( exist(ClustPath,'file') == 2 ) && ( overwrite_all == 0 ) && ( overwrite_GMM == 0 )
    disp('Segmentation already computed, loading results...');
    load(ClustPath)
else    
    %define the path for temporary results:
    %tmpPath = '/home/pajula2/fuseISCresults/'; % save k-NN graph in this folder. NOTE! absolute path
    tmpPath = [Pub.dataDestination 'FuSe'];
    % Load binary map of the ISC analysis
    if strcmp(Pub.fileFormat,'nii')
        if strcmp(Priv.brainMask(end-2:end),'nii')
            bmask = load_nii([Priv.brainMask]); % changed 18.2.2017 JPK
        else
            bmask = load_nii([Priv.brainMask '.nii']); 
        end
        bmask = single(bmask.img);
    elseif strcmp(Pub.fileFormat,'mat')
        bmask = load(Priv.brainMask);
        fiel = fields(bmask);
        bmask = bmask.(fiel{1});
        bmask = single(bmask);
    else
        error('Mask must be mat- or nii-file!')
    end
    bmask = logical(bmask);
    
    %find the common brain voxels
    brain_voxels = find(bmask == 1);
    
    %compileSNN_mex; % first compile necessary c-functions.
    %    k = Pub.FuSe_K; % set neighborhood size k
    %    TH = k;
    %featureSet = 3; % use all the original features of the data with weighted variability features
    % use 3 to only ISC mean features
    % use 4 to only Variability features
    
    [bestMu,idx,GMM,SNN,KNN] = clusterISC(X,k,featureSet,tmpPath,Pub.FuSe_Diag, regul_opt,overwrite_all,overwrite_GMM); % run clustering.
    Clust = struct('bestMu',bestMu, 'idx', idx, 'GMM', GMM, 'SNN', SNN, 'KNN', KNN, 'brainVoxels',inds);
    % save clustering results:
    disp('Saving FuSeISC results in the Clust-structure...')
    V = version;
    if strcmp(V(1),'7')
        save(ClustPath,'-struct','Clust');
    else
        save(ClustPath,'-struct', 'Clust','-v7.3')
    end
end
