function varargout = compSettings(varargin)
% COMPSETTINGS MATLAB code for compSettings.fig
%      COMPSETTINGS, by itself, creates a new COMPSETTINGS or raises the existing
%      singleton*.
%
%      H = COMPSETTINGS returns the handle to a new COMPSETTINGS or the handle to
%      the existing singleton*.
%
%      COMPSETTINGS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in COMPSETTINGS.M with the given input arguments.
%
%      COMPSETTINGS('Property','Value',...) creates a new COMPSETTINGS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before compSettings_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to compSettings_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help compSettings

% Last Modified by GUIDE v2.5 09-Mar-2018 00:53:08

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @compSettings_OpeningFcn, ...
                   'gui_OutputFcn',  @compSettings_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before compSettings is made visible.
function compSettings_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to compSettings (see VARARGIN)

handles.Pub = varargin{1};

set(handles.editSessionPerm,'Enable','on')
set(handles.popupmenuComparisonType,'Enable','on')
set(handles.popupmenuCluster,'Enable','on')
if handles.Pub.clusterThreshold <= 0
    set(handles.editPrimaryTh,'Enable','off')
else
    set(handles.editPrimaryTh,'Enable','on')
end
if handles.Pub.pairedSessionComp == 1
    set(handles.popupmenuGroupPermutation,'Enable','off')
    set(handles.checkboxStudentization,'Enable','off')
    set(handles.checkbox_globalCorrCorr,'Enable','off')
    set(handles.popupmenuCluster,'Enable','off')
    set(handles.popupmenuCluster,'Value',1)
    handles.Pub.clusterCorrType = 0;
    set(handles.editPrimaryTh,'Enable','off')    
else
    set(handles.popupmenuGroupPermutation,'Enable','on')
    set(handles.checkboxStudentization,'Enable','on')
    set(handles.checkboxStudentization,'Value',handles.Pub.studentize)
    set(handles.checkbox_globalCorrCorr,'Enable','on')
    set(handles.checkbox_globalCorrCorr,'Value',handles.Pub.globalCorrCorrection)
    set(handles.popupmenuCluster,'Enable','on')
    set(handles.popupmenuCluster,'Value',handles.Pub.clusterCorrType)
end

set(handles.editSessionPerm,'String',num2str(handles.Pub.permutSessionComp));
set(handles.editPrimaryTh,'String',num2str(handles.Pub.clusterThreshold));
set(handles.editSessionPerm,'Enable','on')
set(handles.popupmenuComparisonType,'Enable','on')

if handles.Pub.pairedSessionComp == 1 % is the comparison paired or not
    set(handles.popupmenuComparisonType,'Value',1)    
elseif handles.Pub.pairedSessionComp == 0
    set(handles.popupmenuComparisonType,'Value',2)    
else
   error('PairedSessionComp parameter must be either "true" or "false"!') 
end

if handles.Pub.clusterThreshold <= 0
    handles.Pub.clusterThreshold = 0;
    handles.Pub.clusterCorrType = 0;
    set(handles.editPrimaryTh,'String','0')
end
switch handles.Pub.clusterCorrType
    case 0
        set(handles.popupmenuCluster,'Value',1)
        set(handles.editPrimaryTh,'Enable','off')
    case 1 % 1 cluster extent correction (the only one implemented at the moment)
        set(handles.popupmenuCluster,'Value',2)
        set(handles.editPrimaryTh,'Enable','on')
    case 2 % 2 cluster mass correction
        set(handles.popupmenuCluster,'Value',3)        
        set(handles.editPrimaryTh,'Enable','on')
    case 3 % 3 TFCE correction (not implemented yet -> add to fig when implemented )
         set(handles.popupmenuCluster,'Value',4)
        set(handles.editPrimaryTh,'Enable','on')
    otherwise
        error('Unknown cluster correction type!')
end

set(handles.popupmenuGroupPermutation,'Value',handles.Pub.permutationType)

% Choose default command line output for corrSettings
handles.output = handles.Pub;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes corrSettings wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = compSettings_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if(isfield(handles, 'output'))
    varargout{1} = handles.output;
    delete(handles.figure1)
else
    varargout{1} = [];
end


% --- Executes on button press in pushbuttonOK.
function pushbuttonOK_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonOK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.output = handles.Pub;
guidata(hObject, handles);
uiresume(handles.figure1)

% --- Executes on button press in pushbuttonCancel.
function pushbuttonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
uiresume(handles.figure1)


% --- Executes on selection change in popupmenuComparisonType.
function popupmenuComparisonType_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuComparisonType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuComparisonType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuComparisonType

if get(hObject,'Value') == 1
    handles.Pub.pairedSessionComp = 1;
else
    if handles.Pub.nrFreqBands == 0 && handles.Pub.freqCompOn == 0 && handles.Pub.winOn == 0
        handles.Pub.pairedSessionComp = 0;    
    else 
        disp('NOTE: Group comparison cannot be selected with time window or frequency band analyses!')
        set(hObject,'Value',1)
    end
end

if handles.Pub.pairedSessionComp == 1
    set(handles.popupmenuGroupPermutation,'Enable','off')
    set(handles.checkboxStudentization,'Enable','off')
    set(handles.checkbox_globalCorrCorr,'Enable','off')
    
    set(handles.popupmenuCluster,'Enable','off')
    set(handles.popupmenuCluster,'Value',1)
    handles.Pub.clusterCorrType = 0;
    set(handles.editPrimaryTh,'String','0','Enable','off')
    handles.Pub.clusterThreshold = 0;
else
    set(handles.popupmenuGroupPermutation,'Enable','on')
    set(handles.checkboxStudentization,'Enable','on')
    set(handles.popupmenuCluster,'Enable','on')
    set(handles.checkbox_globalCorrCorr,'Enable','on')

end

    

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuComparisonType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuComparisonType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkboxCluster.
function checkboxCluster_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxCluster (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxCluster
switch get(hObject,'Value')
    case 1
        handles.Pub.clusterCorrType = 1;
        set(handles.editPrimaryTh,'String','0','Enable','off')
        handles.Pub.clusterThreshold = 0;
    case 2     
        handles.Pub.clusterCorrType = 1;
        set(handles.editPrimaryTh,'Enable','on')
        if handles.Pub.clusterThreshold == 0
            handles.Pub.clusterThreshold = 2.3;
            set(handles.editPrimaryTh,'String',num2str(handles.Pub.clusterThreshold))            
        end
    case 3
        handles.Pub.clusterCorrType = 2;
        set(handles.editPrimaryTh,'Enable','on')
        if handles.Pub.clusterThreshold == 0
            handles.Pub.clusterThreshold = 2.3;
            set(handles.editPrimaryTh,'String',num2str(handles.Pub.clusterThreshold))            
        end
    otherwise
        error('Unknown MCC type!')
end
guidata(hObject, handles);


function editPrimaryTh_Callback(hObject, eventdata, handles)
% hObject    handle to editPrimaryTh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editPrimaryTh as text
%        str2double(get(hObject,'String')) returns contents of editPrimaryTh as a double

val = str2double(get(hObject,'String'));
if isnan(val) || val <= 0
   set(hObject,'String',num2str(handles.Pub.clusterThreshold))
else
    handles.Pub.clusterThreshold = val;
    set(hObject,'String',num2str(val))
end

guidata(hObject, handles);

% --- Executes on selection change in popupmenuCluster.
function popupmenuCluster_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuCluster (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuCluster contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuCluster

if get(hObject,'Value') == 1
    set(handles.editPrimaryTh,'Enable','off','String','0')
    handles.Pub.clusterThreshold = 0;
else
    handles.Pub.clusterThreshold = 2.3;
    set(handles.editPrimaryTh,'Enable','on','String',num2str(handles.Pub.clusterThreshold))
end
tmp = get(hObject,'Value') - 1;
if handles.Pub.nrFreqBands == 0
   handles.Pub.clusterCorrType = tmp;
else
   disp('NOTE: Only Voxel based multiple comparison correction (MCC) is allowed when Frequency specific analysis is selected')
   handles.Pub.clusterCorrType = 0;
   set(hObject,'Value',1);
   set(handles.editPrimaryTh,'Enable','off','String','0')
   handles.Pub.clusterThreshold = 0;
end

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuCluster_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuCluster (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuGroupPermutation.
function popupmenuGroupPermutation_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuGroupPermutation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuGroupPermutation contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuGroupPermutation

handles.Pub.permutationType = get(hObject,'Value');

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuGroupPermutation_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuGroupPermutation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function editSessionPerm_Callback(hObject, eventdata, handles)
% hObject    handle to editSessionPerm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSessionPerm as text
%        str2double(get(hObject,'String')) returns contents of editSessionPerm as a double

val = ceil(str2double(get(hObject,'String')));
if isnan(val) || val <= 0 || isinf(val)
   set(hObject,'String',num2str(handles.Pub.permutSessionComp))
else
    handles.Pub.permutSessionComp = val;
    set(hObject,'String',num2str(val))
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editPrimaryTh_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editPrimaryTh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function editSessionPerm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSessionPerm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkboxStudentization.
function checkboxStudentization_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxStudentization (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxStudentization
handles.Pub.studentize = get(hObject,'Value');

guidata(hObject, handles);


% --- Executes on button press in checkbox_globalCorrCorr.
function checkbox_globalCorrCorr_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_globalCorrCorr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_globalCorrCorr
handles.Pub.globalCorrCorrection = get(hObject,'Value');

guidata(hObject, handles);
