% This function assumes two groups and that the memory mapped images have
% been kept. In future this will be expanded to work on the original
% images. 
% S

function [corrmap,zcorrmap] = debugGroupComparison(Params,subj1,group1,subj2,group2)

Pub = Params.PublicParams;
Priv = Params.PrivateParams;

doDebug = 0; % This is to prevent problems with the correlation overflows. 
             % It forces the correlation values to be smaller than 1 (in absolute value)
             % It also prints a message urging to check the data.
             % However, this probably slows down the code a bit and these problems have been rare 
             % so this feature can be turned off
epsilon1 = 0.99999999;
epsilon0 = 0.0000001;
dispDebugLim = 0; % this limits the number of debug messages
dispDebug = 0;

if any(Priv.dummies(:) > 0)
   error('Currently does not handle unequal group sizes');
end

maskfileformat = Pub.fileFormat;
if strcmp(maskfileformat(end-2:end),'nii') || strcmp(maskfileformat,'nii.gz')
    bmask = load_nii(Priv.brainMask);
    bmask = single(bmask.img);
else
    bmask = load(Priv.brainMask);
    fiel = fields(bmask);
    bmask = bmask.(fiel{1});
    bmask = single(bmask);
end
bandNr = 0;

load([Pub.dataDestination 'memMaps'])
for h = 1:Priv.nrSessions
    % fMRI-data (source data):
   mMap.(['sess' num2str(h)]) = memMaps.(Priv.origMapName).([Priv.prefixSession num2str(h)]);
end
clear memMaps

corrmap = zeros(size(bmask));
zcorrmap = zeros(size(bmask));


% if strcmp(Pub.fileFormatSubj,'nii')
%    I = load_nii(Pub.subjectSource{m,k});
%    I = single(I.img);
% else
%    I = load(Pub.subjectSource{m,k});
%    fiel = fields(I);
%    I = I.(fiel{1});
%    I = single(I);
% end

for xx = 1:Priv.dataSize(1,1)
    disp(['x: ' num2str(xx) '/' num2str(Priv.dataSize(1,1))])
    % init result matrix for across session data
    % process only non-zero x-slices:
    if sum(sum(squeeze(bmask(xx,:,:)))) > 0
        % init source time-series matrix:
        cDat = zeros([Priv.dataSize(1,[4 2 3]),2]);
        % read multi-band time-series of the subjects:
        
        cDat(:,:,:,1) = mMap.(['sess' num2str(group1)]).([Priv.prefixSubject num2str(subj1)]).Data(xx).tyz; % time*y*z*sessions*subjects
        cDat(:,:,:,2) = mMap.(['sess' num2str(group2)]).([Priv.prefixSubject num2str(subj2)]).Data(xx).tyz; % time*y*z*sessions*subjects
          
        n1 = size(cDat,1);
        N = Priv.dataSize(1,4); % number of time points
		denom = N - 1;
        for yy = 1:Priv.dataSize(1,2)
            ziter = 0;
            for zz = 1:Priv.dataSize(1,3)
                if bmask(xx,yy,zz)
                   ziter = ziter + 1;
                    ts = squeeze(cDat(:,yy,zz,:)); % subj1 
                   
					ts = bsxfun(@minus,ts,sum(ts)/N);  % de-meaning here (JT)
					tsvar = sum(abs(ts).^2) ./ denom;  %  compute time-wise variance
                    tsvar = tsvar + (tsvar == 0); % make sure that no division by zeros
					ts = bsxfun(@rdivide,ts,sqrt(tsvar));
                    
                    r1 = ts(:,1)'*ts(:,2)/denom;
                    if doDebug
                      if(abs(r1) > epsilon1)
                       % disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                         r1 = r1/(abs(r1) + epsilon0);
                      end
                    end
                    corrmap(xx,yy,zz) = r1;
                    z12 = 0.5*(log((1+r1)./(1-r1)));
                    zcorrmap(xx,yy,zz) = z12;
                
                end
            end
        end
    end
end
code1 = group1*100 + subj1;
code2 = group2*100 + subj2;

save(fullfile(Pub.dataDestination,'GroupCompDebug',strcat('GroupCompDebug_',num2str(code1),num2str(code2))),'corrmap','zcorrmap');