%input: P is a vector of p-values, q is a scalar which
%control the false discovery rate, lambda is a parameter usually set as 0.5  
% Storey, Taylor, Siegmund 2004 J.R Stattist Soc. B (2004)
% Storey, Tibshirani, PNAS 2003
function [crit_p,qvals] =fdr_storey(P,q,lambda)

if nargin < 3
    lambda = 0.5;
end
sz = size(P);
if sz(1) < sz(2)
    P = P';
end

N=length(P);

m0=(length(find(P>lambda)))/(1 - lambda);
pi0 = m0/N;
[P_sor]=sort(P);
infdr = m0*P_sor./([1:N]');
sidx = find(infdr < q);
qvals = ones(N,1);
if isempty(sidx)
    crit_p = NaN;
else
    crit_p = max(P_sor(sidx));
end
qvals(N) = (m0/N)*P_sor(N);
for i =(N - 1):(-1):1
    qvals(i) = min(qvals(i + 1),m0*P_sor(i)/i);
end
end



