function ISCmatrix = returnFullCorrMat(corMats,xyz)

% function ISCmatrix = returnFullCorrMat(corMats,xyz)
% This function constructs full ISC correlation matrices from the 
% vectorized ISC matrix data.
%
% Inputs: 
%
% corMats - structure formed using RETURNCORRMAT-function. 
% Structure contains ISC correlation matrix data for each voxel in a 
% vector form separately for each session.
%
% xyz - Matlab voxel index for which correlation matrix is returned. 
% Must be a 3-element vector [x, y, z].
%
% Outputs:
%
% ISCmatrix - a structure containing ISC matrix for a given voxel in each 
% session.
%
% Jukka-Pekka Kauppi, 13.6.2016.
%
% SEE ALSO:
% 
% RETURNCORRMAT

nrSessions = length(fieldnames(corMats));
for m = 1:nrSessions
    Dat = corMats.(['Session' num2str(m)]);
    Dat_vox = squeeze(Dat(xyz(1),xyz(2),xyz(3),:));
    nrSubjectPairs = length(Dat_vox); % number of subject pairs
    n = (1 + sqrt(1 + 4*2*nrSubjectPairs))/2; % number of subjects
    Mat = ones(n);
    fi = find(triu(ones(n),1));
    Mat(fi) = Dat_vox;
    Mat_triu = triu(Mat,1);
    Mat_tril = Mat_triu';
    Mat = eye(n) + Mat_triu + Mat_tril;
    ISCmatrix.(['Session' num2str(m)]) = Mat;
end
