function handles = setSubjectBox(handles)

disp(' ')
disp('Currently selected subject source files:')
disp(' ')
L = get(handles.editSubj,'String');
%disp(L)


% set subject's filenames to params-struct, for the active session:
for h = 1:size(handles.Pub.subjectSource,2)
    handles.Pub.subjectSource{get(handles.popupmenuSession,'Value'),h} = [];
end
for h = 1:size(L,1)
    if ischar(L)
        handles.Pub.subjectSource{get(handles.popupmenuSession,'Value'),h} = L(h,:);
    else
        handles.Pub.subjectSource{get(handles.popupmenuSession,'Value'),h} = L{h};
    end
end

nrSessions = size(handles.Pub.subjectSource,1);
flagEmpty = true*ones(1,nrSessions);
for s = 1:nrSessions
    for k = 1:size(handles.Pub.subjectSource,2)
        if ~isempty(handles.Pub.subjectSource{s,k})
            flagEmpty(s) = false;
            break
        end
    end
end

F = find(flagEmpty == false);
if ~isempty(F)
    for h = 1:(F(end)+1)
        D{h} = ['Session' num2str(h)];
    end
    set(handles.popupmenuSession,'Value',max(length(D)-1,1))
    for h = 1:size(handles.Pub.subjectSource,2)
        D2{h} = handles.Pub.subjectSource{max(length(D)-1,1),h};
    end
    set(handles.editSubj,'String',D2)    
    set(handles.popupmenuSession,'String',D)
    SubjSour{1} = [];
    for s = 1:F(end)
        for k = 1:size(handles.Pub.subjectSource,2)
            SubjSour{s,k} = handles.Pub.subjectSource{s,k};
        end
    end
    handles.Pub.subjectSource = SubjSour;    
else
    set(handles.popupmenuSession,'Value',1)
    set(handles.popupmenuSession,'String','Session 1')
    handles.Pub.subjectSource = cell(1);
end


for a1 = 1:size(handles.Pub.subjectSource,1)
    disp(['Session ' num2str(a1) ':'])
    disp(' ')
    for a2 = 1:size(handles.Pub.subjectSource,2)
        disp(handles.Pub.subjectSource{a1,a2})
    end
    disp(' ')
end

if(size(handles.Pub.subjectSource,1)==1)
    if handles.Pub.sessionCompOn == 1
     disp(['Warning: Add subjects at least in two separated sessions,' ...
            ' before selecting the session comparison!']);
    %        set(handles.editSessionPerm,'Enable','off');
    end
    %set(handles.checkboxSessionComp,'Value', 0);
    %handles.Pub.sessionCompOn = 0;        
   
end

flag = 0;
flag2 = 0;
handles.Pub.fileFormatSubj = '';
ff_old = handles.Pub.fileFormatSubj;
for m = 1:size(handles.Pub.subjectSource,1)
    for n = 1:size(handles.Pub.subjectSource,2)
        fname = handles.Pub.subjectSource{m,n};
        if ~isempty(fname)
            if length(fname) >= 5
                fileExt = fname(end-2:end);
                if strcmp(fileExt,'mat')
                    if ~isempty(ff_old) && ~strcmp(ff_old,'mat')
                        flag2 = 1;
                    else
                        handles.Pub.fileFormatSubj = 'mat';
                        ff_old = 'mat';
                        flag = 1;
                    end                    
                elseif strcmp(fileExt,'nii')
                    if ~isempty(ff_old) && ~strcmp(ff_old,'nii')
                        flag2 = 1;
                    else
                        handles.Pub.fileFormatSubj = 'nii';
                        ff_old = 'nii';
                        flag = 1;
                    end

                elseif strcmp(fileExt,'.gz') && length(fname) >= 6 
                    if ~isempty(ff_old) && ~strcmp(ff_old,'nii.gz')
                        flag2 = 1;
                    else
                        handles.Pub.fileFormatSubj = 'nii.gz';
                        ff_old = 'nii.gz';
                        flag = 1;
                    end
                else
                    
                end               
            end
        end
    end
end
if flag == 0
    handles.Pub.fileFormatSubj = '';
    warning('Source file extension must be "mat", "nii", or "nii.gz"!!')
else
    if flag2 == 1
        handles.Pub.fileFormatSubj = '';
        warning('All source file extensions must be "mat", "nii", or "nii.gz"!!')
    end
end
