function varargout = fMRI_GUI_export_2(varargin)
% FMRI_GUI_EXPORT_2 M-file for fMRI_GUI_export_2.fig
%      FMRI_GUI_EXPORT_2, by itself, creates a new FMRI_GUI_EXPORT_2 or raises the existing
%      singleton*.
%
%      H = FMRI_GUI_EXPORT_2 returns the handle to a new FMRI_GUI_EXPORT_2 or the handle to
%      the existing singleton*.
%
%      FMRI_GUI_EXPORT_2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FMRI_GUI_EXPORT_2.M with the given input arguments.
%
%      FMRI_GUI_EXPORT_2('Property','Value',...) creates a new FMRI_GUI_EXPORT_2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before fMRI_GUI_export_2_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to fMRI_GUI_export_2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help fMRI_GUI_export_2

% Last Modified by GUIDE v2.5 07-Sep-2009 01:47:25

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @fMRI_GUI_export_2_OpeningFcn, ...
                   'gui_OutputFcn',  @fMRI_GUI_export_2_OutputFcn, ...
                   'gui_LayoutFcn',  @fMRI_GUI_export_2_LayoutFcn, ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before fMRI_GUI_export_2 is made visible.
% --- Executes just before fMRI_GUI_export is made visible.
function fMRI_GUI_export_2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to fMRI_GUI_export (see VARARGIN)

handles = disablePanels(handles);



flag = 1;
if ~isempty(varargin)
  flag = 0;
  if length(varargin) == 1
    if ischar(varargin{1})
      if exist(varargin{1}) == 2
        handles.paramFile = varargin{1};
        handles = getParams(handles);
        guidata(hObject, handles);
        handles = enablePanels(handles);
        guidata(hObject, handles);

        flag = 1;
      end
    end
  end
end


% Choose default command line output for fMRI_GUI_export
handles.output = hObject;

if ~flag
  disp(' ')
  disp('Error!!! --> Input must be a single mat-file!')
  disp(' ')
  uiresume(handles.figure1);
end

set(gcf,'Name','LSA tool 1.0')

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes fMRI_GUI_export wait for user response (see UIRESUME
 uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = fMRI_GUI_export_2_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
delete(handles.figure1)

% --- Executes on button press in pushbuttonUpdate.
function pushbuttonUpdate_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonUpdate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function sliderLayer_Callback(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
switch handles.activeAxes
    case 1
        set(handles.textAxial,'String',['z = ' num2str( handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)) )])
        set(handles.editLayer,'String',['z = ' num2str( handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)) )])
    case 2
        set(handles.textCoronal,'String',['y = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(2)))])
        set(handles.editLayer,'String',['y = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(2)))])
    case 3
        set(handles.textSagittal,'String',['x = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)))])
        set(handles.editLayer,'String',['x = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)))])        
end

handles.layerVal = round(get(hObject,'Value'));
%set(handles.editLayer,'String',num2str(handles.layerVal));
%handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function sliderLayer_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --- Executes on selection change in listboxAtlas.
function listboxAtlas_Callback(hObject, eventdata, handles)
% hObject    handle to listboxAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listboxAtlas contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listboxAtlas

handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function listboxAtlas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listboxAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function editLayer_Callback(hObject, eventdata, handles)
% hObject    handle to editLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editLayer as text
%        str2double(get(hObject,'String')) returns contents of editLayer as a double


% --- Executes during object creation, after setting all properties.
function editLayer_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editAtlasScaleMin_Callback(hObject, eventdata, handles)
% hObject    handle to editAtlasScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editAtlasScaleMin as text
%        str2double(get(hObject,'String')) returns contents of editAtlasScaleMin as a double

handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editAtlasScaleMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editAtlasScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function edit1ScaleMin_Callback(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1ScaleMin as text
%        str2double(get(hObject,'String')) returns contents of edit1ScaleMin as a double

if handles.freqCompOn
    Val = round(str2double(get(hObject,'String')));
    if ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 ...
            || Val > 66 || Val < 1 || Val >= handles.ScaleMaxPF )
        handles = update_params(handles);
        setFigureColorMap(handles);
        handles = update_figs(handles);
        guidata(hObject, handles);
    else
        set(hObject,'String',num2str(handles.ScaleMinPF))
    end
else
    Val = str2double(get(hObject,'String'));
    if ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 ...
            || Val > 1 || Val < 0 || Val >= handles.ScaleMax1 )
        handles = update_params(handles);
        setFigureColorMap(handles);
        set(handles.Colbar1,'XLim',[round(handles.ScaleMin1*64) round(handles.ScaleMax1*64)])
        handles = update_figs(handles);
        guidata(hObject, handles);
    else
        set(hObject,'String',num2str(handles.ScaleMin1))
    end

end


% --- Executes during object creation, after setting all properties.
function edit1ScaleMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit1ScaleMax_Callback(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1ScaleMax as text
%        str2double(get(hObject,'String')) returns contents of edit1ScaleMax as a double

if handles.freqCompOn
    Val = round(str2double(get(hObject,'String')));
    if ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 || ...
            Val > 66 || Val < 1 || Val <= handles.ScaleMinPF )
        handles = update_params(handles);
        setFigureColorMap(handles);
        handles = update_figs(handles);
        guidata(hObject, handles);
    else
        set(hObject,'String',num2str(handles.ScaleMaxPF))
    end
else
    Val = str2double(get(hObject,'String'));
    if ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 || ...
            Val > 1 || Val < 0.02 || Val <= handles.ScaleMin1 )
        handles = update_params(handles);
        
        setFigureColorMap(handles);
        set(handles.Colbar1,'XLim',[round(handles.ScaleMin1*64) round(handles.ScaleMax1*64)])
        
        handles = update_figs(handles);
        guidata(hObject, handles);
    else
        set(hObject,'String',num2str(handles.ScaleMax1))
    end

end

% --- Executes during object creation, after setting all properties.
function edit1ScaleMax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuFreqBand.
function popupmenuFreqBand_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuFreqBand contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuFreqBand
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);




% --- Executes during object creation, after setting all properties.
function popupmenuFreqBand_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuWavCoefs.
% function popupmenuWavCoefs_Callback(hObject, eventdata, handles)
% % hObject    handle to popupmenuWavCoefs (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% % Hints: contents = get(hObject,'String') returns popupmenuWavCoefs contents as cell array
% %        contents{get(hObject,'Value')} returns selected item from popupmenuWavCoefs
% handles = update_params(handles);
% handles = update_figs(handles);
% guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
% function popupmenuWavCoefs_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to popupmenuWavCoefs (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
% 
% % Hint: popupmenu controls usually have a white background on Windows.
% %       See ISPC and COMPUTER.
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end


% --- Executes on selection change in popupmenuSimilarityMeasure.
function popupmenuSimilarityMeasure_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuSimilarityMeasure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuSimilarityMeasure contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuSimilarityMeasure
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuSimilarityMeasure_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuSimilarityMeasure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuOrient.
function popupmenuOrient_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuOrient (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuOrient contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuOrient

contents = get(hObject,'String');
handles.orient = contents{get(hObject,'Value')};
switch handles.orient
    case 'axial'
        set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,1),'Value',get(handles.sliderAxial,'Value'));
        axes(handles.axes1)
        set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,2),handles.datasize(handles.dataset,1)));axis image;
        axes(handles.axesAtlas)
        set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,2),handles.datasize(handles.dataset,1)));axis image;
    case 'coronal'
        set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,2),'Value',get(handles.sliderCoronal,'Value'));
        axes(handles.axes1)
        set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,1)));axis image;
        axes(handles.axesAtlas)
        set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,1)));axis image;
    case 'sagittal'
        set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,3),'Value',get(handles.sliderSagittal,'Value'));
        axes(handles.axes1)
        set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,2)));axis image;
        axes(handles.axesAtlas)
        set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,2)));axis image;
end

handles.activeAxes = get(hObject,'Value');
switch handles.activeAxes
    case 1
        set(handles.textAxial,'String',['z = ' num2str( handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)) )])
        set(handles.editLayer,'String',['z = ' num2str( handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)) )])
    case 2
        set(handles.textCoronal,'String',['y = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(2)))])
        set(handles.editLayer,'String',['y = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(2)))])
    case 3
        set(handles.textSagittal,'String',['x = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)))])
        set(handles.editLayer,'String',['x = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)))])
        
end

handles = update_params(handles);
handles = update_figs(handles);




guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuOrient_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuOrient (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in checkboxPixVal1.
function checkboxPixVal1_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxPixVal1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inds = [];
if get(hObject,'Value') == 0
    ww = get(gcf,'Children');
    for kk = 1:length(ww);
        if strcmp(get(ww(kk),'Tag'),'pixelinfo panel')
            inds = [inds kk];
        end
    end
    delete(ww(inds))
else
    impixelinfo;
end


function checkboxSwapBytes_Callback(hObject, eventdata, handles)

if get(hObject,'Value') == 1
    handles.swapBytesOn = 1;
else
    handles.swapBytesOn = 0;
end
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

function pushbuttonupdateAtlasList_Callback(hObject, eventdata, handles)
% update atlas listbox information:

handles = updateAtlasList(handles);
guidata(hObject, handles);

% --- Executes on button press in pushbuttonLocate.
function pushbuttonLocate_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonLocate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% handles = update_params(handles);
% switch handles.coefType
%     case 1
%         data = handles.dataD1;
%     case 2
%         data = handles.dataA1;
% end
% 
% switch handles.SimMeasure
%     case 1
%         data = data.cor;
%     case 2
%         data = data.ken;
% end
% 
% [L SubCort Cort dataset2 txtCort TS] = findLocalMaxima(data,handles.LocalMaximaThreshold);
% guidata(hObject, handles);

% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --- Executes on button press in pushbuttonPlotTimeSeries.
function pushbuttonPlotTimeSeries_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonPlotTimeSeries (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles = update_params(handles);
H = handles;
% remove unnecessary, memory consuming fields:
H = rmfield(H,'dataAt');
H = rmfield(H,'dataT');
set(hObject,'Enable','off')
% call temporal analysis -GUI:
H = plotTimeSeries_GUI(H);
handles.H = H;
set(hObject,'Enable','on')

% --- Executes on selection change in popupmenuAtlas.
function popupmenuAtlas_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch handles.AtlasThreshold
    case 1
        ind = 1;
    case 2
        ind = 3;
    case 3
        ind = 5;
end
if get(hObject,'Value') == 1
    set(handles.listboxAtlas,'Value',1)
    set(handles.listboxAtlas,'String',handles.txtCort)
    set(handles.listboxAtlas,'Value',1)
else
    set(handles.listboxAtlas,'Value',1)
    set(handles.listboxAtlas,'String',handles.txtSub)
    set(handles.listboxAtlas,'Value',1)
    ind = ind + 1;
end
handles.At = get(hObject,'Value');
handles.dataAt = load_nii(handles.Priv.brainAtlases{ind});
handles.dataAt = handles.dataAt.img;
handles.dataAt(find(handles.dataAt)) = handles.dataAt(find(handles.dataAt)) + 141;
  
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);
  
% --- Executes during object creation, after setting all properties.
function popupmenuAtlas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in popupmenuAtlasThreshold.
function popupmenuAtlasThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlasThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuAtlasThreshold contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuAtlasThreshold

switch get(hObject,'Value')
  case 1
    ind = 1;
  case 2
    ind = 3;
  case 3
    ind = 5;
end

if handles.At == 2
  ind = ind + 1;
end

handles.dataAt = load_nii(handles.Priv.brainAtlases{ind});
handles.dataAt = handles.dataAt.img;
handles.dataAt(find(handles.dataAt)) = handles.dataAt(find(handles.dataAt)) + 141;
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuAtlasThreshold_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlasThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --------------------------------------------------------------------
function menuFile_Callback(hObject, eventdata, handles)
% hObject    handle to menuFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function fileMenuDatatoWS_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

prompt = {'Enter variable name:'};
title = 'Assign data to workspace';
lines = 1;
def = {'Im1'};
answer = inputdlg(prompt,title,lines,def);
T.img = handles.SegIm;
T.colMap = handles.colMap;
%T.info = handles.info;
assignin('base',answer{1},T);

% --------------------------------------------------------------------
function menu_Callback(hObject, eventdata, handles)
% hObject    handle to menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function sliderTime_Callback(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider



handles.timeVal = round(get(hObject,'Value'));
intVal = calcInterval(handles.timeVal);
set(handles.editTime,'String',intVal);
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function sliderTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


function editTime_Callback(hObject, eventdata, handles)
% hObject    handle to editTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editTime as text
%        str2double(get(hObject,'String')) returns contents of editTime as a double


% --- Executes during object creation, after setting all properties.
function editTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuSession.
function popupmenuSession_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuSession (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuSession contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuSession

handles.dataset = get(hObject,'Value');
handles.timeVal = 1;
intVal = calcInterval(handles.timeVal);
set(handles.editTime,'String',intVal);
set(handles.sliderTime,'Value',1)
set(handles.sliderTime,'max',handles.Priv.nrTimeIntervals(handles.dataset))
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuSession_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuSession (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in radiobuttonIsolationNoIsolation.
function radiobuttonIsolationNoIsolation_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonIsolationNoIsolation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobuttonIsolationNoIsolation
set(hObject,'Value',1)
set(handles.radiobuttonIsolationAtlas,'Value',0)
set(handles.radiobuttonIsolationThreshold,'Value',0)
set(handles.editThreshold,'Enable','off')
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on button press in radiobuttonIsolationAtlas.
function radiobuttonIsolationAtlas_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonIsolationAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobuttonIsolationAtlas
set(hObject,'Value',1)
set(handles.radiobuttonIsolationNoIsolation,'Value',0)
set(handles.radiobuttonIsolationThreshold,'Value',0)
set(handles.editThreshold,'Enable','off')
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes on button press in radiobuttonIsolationThreshold.
function radiobuttonIsolationThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonIsolationThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobuttonIsolationThreshold
set(hObject,'Value',1)
set(handles.radiobuttonIsolationAtlas,'Value',0)
set(handles.radiobuttonIsolationNoIsolation,'Value',0)
set(handles.editThreshold,'Enable','on')
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);
    
function editThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to editThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editThreshold as text
%        str2double(get(hObject,'String')) returns contents of editThreshold as a double
Val = str2double(get(hObject,'String'));

if handles.freqCompOn
    Val = round(Val);
    acond = ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 || Val > 66 || Val < 1);
else
    acond = ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 || Val > 1 || Val < 0.02);
end
if acond
    handles = update_params(handles);
    handles = update_figs(handles);
    guidata(hObject, handles);
else
    set(hObject,'String',num2str(handles.Threshold))
end

% --- Executes during object creation, after setting all properties.
function editThreshold_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in pushbuttonNewFigure.
function pushbuttonNewFigure_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonNewFigure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% get plotting parameters:
H = gui_window_figure(handles);

handles.rowPlot = H.rowPlot;
handles.colPlot = H.colPlot;
handles.plotColbar = H.plotColbar;
handles.newFigure = H.newFigure;
handles.figureBand = H.figureBand;
handles.figureSim = H.figureSim;
handles.figureSet = H.figureSet;
handles.annotationsOn = H.annotationsOn;

if handles.newFigure
    handles.figureData{1} = find(handles.figureBand);
    handles.figureData{2} = find(handles.figureSim);
    handles.figureData{3} = find(handles.figureSet);
    iter = 1;
    CurrentDataTmp = handles.CurrentData;
    SimMeasureTmp = handles.SimMeasure;
    freqBandTmp = handles.freqBand;
    datasetTmp = handles.dataset;
    freqCompTmp = handles.freqComp;
    changeInCurrentAxesTmp = handles.changeInCurrentAxes;
    %HF = figure;
    if handles.freqCompOn
        K = 1;
    else
        K = length(handles.figureData{handles.rowPlot});
    end
    for k = 1:K
        for m = 1:length(handles.figureData{handles.colPlot})
            % set(0,'CurrentFigure',HF)
            %        subplot(length(simM),length(bands),iter)
            if handles.rowPlot == 1
                handles.freqBand = handles.figureData{1}(k);
            end
            if handles.colPlot == 1
                handles.freqBand = handles.figureData{1}(m);
            end
            if handles.rowPlot == 2
                handles.SimMeasure = handles.figureData{2}(k);
            end
            if handles.colPlot == 2
                handles.SimMeasure = handles.figureData{2}(m);
            end
            if handles.rowPlot == 3
                handles.dataset = handles.figureData{3}(k);
            end
            if handles.colPlot == 3
                handles.dataset = handles.figureData{3}(m);
            end
%            handles.SimMeasure = simM(k);
            handles.freqComp = zeros(1,6);
            handles.freqComp(handles.figureData{1}(m)) = 1;
            handles.changeInCurrentAxes = 1;
            handles = update_figs(handles);
            iter = iter + 1;
            handles.newFigure = iter;
        end
    end
    for mm = 1:length(handles.CurrentData)
        figure;axis off;
%        colMap = setFigureColorMap(handles);
        %montage(handles.CurrentData,colMap);
        %handles.CurrentData;
%         G = cat(zeros(size(handles.CurrentData,1),size(handles.CurrentData,2),size(handles.CurrentData,3));
%         G(:,:,:) = handles.CurrentData(:,:,:,mm);
        montageModif(handles.CurrentData{mm},handles.colMap,...
            length(handles.figureData{handles.rowPlot}),...
            length(handles.figureData{handles.colPlot}));
        if handles.annotationsOn
            switch handles.activeAxes
                case 1
                    STR = [get(handles.textAxial,'String')];
                case 2
                    STR = [get(handles.textCoronal,'String')];
                case 3
                    STR = [get(handles.textSagittal,'String')];
            end
            for m = 1:length(handles.figureData{handles.colPlot})
                for k = 1:length(handles.figureData{handles.rowPlot})
                    text(4+(m-1)*size(handles.CurrentData,2),6+(k-1)*size(handles.CurrentData,1),STR,'Color','w');
                end
            end
        end
        if handles.plotColbar
        %figure;
        %setFigureColorMap(handles);axis off;
            if handles.freqCompOn
                mi = handles.ScaleMinPF;
                Ma = handles.ScaleMaxPF;
            else
                mi = handles.ScaleMin1;
                Ma = handles.ScaleMax1;
            end
            figure;colormap(hot);M=colorbar;
            set(M,'YTick',[1 65],'YTickLabel',[mi Ma]);
            axis off;set(gcf,'Position',[843   378   157   418]);
        end
    end
        handles.SimMeasure = SimMeasureTmp;
        handles.CurrentData = CurrentDataTmp;
        handles.freqComp = freqCompTmp;
        handles.dataset = datasetTmp;
        handles.freqBand = freqBandTmp;
        changeInCurrentAxes = changeInCurrentAxesTmp;
        handles.newFigure = 0;
        guidata(hObject, handles);
end



% --- Executes on button press in checkboxCompareFreqs.
function checkboxCompareFreqs_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxCompareFreqs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxCompareFreqs
% if ~get(hObject,'Value') % inactivate frequency comparison:
%     set(handles.radiobuttonMid,'Enable','off')
%     set(handles.radiobuttonLow,'Enable','off')
%     set(handles.radiobuttonHigh,'Enable','off')
%     set(handles.radiobuttonMidLow,'Enable','off')
%     set(handles.radiobuttonVeryLow,'Enable','off')
%     set(handles.radiobuttonOrig,'Enable','off')
%     set(handles.popupmenuSimilarityMeasure,'Enable','on')
%     set(handles.checkboxTimeWindow,'Enable','on')
%     set(handles.edit1ScaleMax,'String',num2str(handles.ScaleMax1))
%     set(handles.edit1ScaleMin,'String',num2str(handles.ScaleMin1))
%     set(handles.editThreshold,'String',num2str(handles.Threshold))
%     if handles.win
%         set(handles.pushbuttonPlotTimeSeries,'Enable','on')
%         set(handles.sliderTime,'Visible','on')
%         set(handles.editTime,'Visible','on')
%         set(handles.textTime,'Visible','on')
%     end
% else
%     set(handles.radiobuttonMid,'Enable','on')
%     set(handles.radiobuttonLow,'Enable','on')
%     set(handles.radiobuttonHigh,'Enable','on')
%     set(handles.radiobuttonMidLow,'Enable','on')
%     set(handles.radiobuttonVeryLow,'Enable','on')
%     set(handles.radiobuttonOrig,'Enable','on')
%     set(handles.pushbuttonPlotTimeSeries,'Enable','off')
%     set(handles.sliderTime,'Visible','off')
%     set(handles.editTime,'Visible','off')
%     set(handles.textTime,'Visible','off')
%     set(handles.popupmenuSimilarityMeasure,'Enable','off')
%     set(handles.checkboxTimeWindow,'Enable','off')
%     set(handles.editThreshold,'String',num2str(handles.ThresholdPF))
%     set(handles.edit1ScaleMax,'String',num2str(handles.ScaleMaxPF))
%     set(handles.edit1ScaleMin,'String',num2str(handles.ScaleMinPF))
% end

% --- Executes on button press in checkboxTimeWindow.
function checkboxTimeWindow_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxTimeWindow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxTimeWindow

if get(hObject,'Value')
    set(handles.sliderTime,'Visible','on')
    set(handles.editTime,'Visible','on')
    set(handles.textTime,'Visible','on')
    set(handles.pushbuttonPlotTimeSeries,'Enable','on')
    handles.win = 1;
else
    handles.timeVal = 1;
    set(handles.sliderTime,'Visible','off','Value',1)
    set(handles.editTime,'Visible','off')
    set(handles.textTime,'Visible','off')
    set(handles.pushbuttonPlotTimeSeries,'Enable','off')
    handles.win = 0;
end

handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on button press in pushbuttonInspectRegion.
function pushbuttonInspectRegion_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonInspectRegion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of pushbuttonNewFigure
%Q=get(handles.dataImage);
%E=Q.CData;
%E(find(E<65)) = round(100*(E(find(E<65))./64))./100;
%figure;H = image;
%set(H,'CData',E)

hpanel = impixelregion(handles.dataImage);
%set(hpanel, 'Position', [0 0 .5 .5])
%guidata(hObject, handles);


% --- Executes on button press in checkboxLargeFigure.
function checkboxLargeFigure_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxLargeFigure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxLargeFigure

if get(hObject,'Value')
    set(handles.axialImage,'Visible','off')
    set(handles.coronalImage,'Visible','off')
    set(handles.sagittalImage,'Visible','off')
    set(handles.axesAxial,'Visible','off')
    set(handles.axesSagittal,'Visible','off')
    set(handles.axesCoronal,'Visible','off')
   % set(handles.textSlice,'Visible','on')
    set(handles.uipanelAxes,'Visible','off')
    set(handles.axes1,'Visible','on')
    set(handles.axesAtlas,'Visible','on')
    set(handles.sliderLayer,'Visible','on')
    set(handles.editLayer,'Visible','on')
    set(handles.popupmenuOrient,'Visible','on')
%    set(handles.uipanel1,'Visible','on')
    set(handles.dataImage,'Visible','on')
    set(handles.atlasImage,'Visible','on')
    set(handles.popupmenuOrient,'Value',handles.activeAxes)
    handles.currentView = 1;
 %   set(handles.ColbarAtlas,'Visible','on');
    axes(handles.axes1)
    switch handles.activeAxes
        case 1
            set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,1),'Value',get(handles.sliderAxial,'Value'))
            set(handles.editLayer,'String',['z = ' num2str( handles.voxelsize*(round(get(handles.sliderAxial,'Value'))+handles.coordinateShift(1)) )])
            set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,2),handles.datasize(handles.dataset,1)));axis image;
            axes(handles.axesAtlas)
            set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,2),handles.datasize(handles.dataset,1)));axis image;
        case 2
            set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,2),'Value',get(handles.sliderCoronal,'Value'))
            set(handles.editLayer,'String',['y = ' num2str(handles.voxelsize*(round(get(handles.sliderCoronal,'Value'))+handles.coordinateShift(2)))])
            set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,1)));axis image;
            axes(handles.axesAtlas)
            set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,1)));axis image;
        case 3
            set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,3),'Value',get(handles.sliderSagittal,'Value'))
            set(handles.editLayer,'String',['x = ' num2str(handles.voxelsize*(round(get(handles.sliderSagittal,'Value'))+handles.coordinateShift(1)))])
            set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,2)));axis image;
            axes(handles.axesAtlas)
            set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,2)));axis image;
    end
else
  %  set(handles.ColbarAtlas,'Visible','off');
    handles.currentView = 0;
   % set(handles.textSlice,'Visible','off')
    set(handles.axialImage,'Visible','on')
    set(handles.coronalImage,'Visible','on')
    set(handles.sagittalImage,'Visible','on')
    set(handles.uipanelAxes,'Visible','on')
    set(handles.axes1,'Visible','off')
    set(handles.axesAtlas,'Visible','off')
    set(handles.sliderLayer,'Visible','off')
    set(handles.editLayer,'Visible','off')
    set(handles.popupmenuOrient,'Visible','off')
 %   set(handles.uipanel1,'Visible','off')
    set(handles.dataImage,'Visible','off')
    set(handles.atlasImage,'Visible','off')
    set(handles.axesAxial,'Visible','on')
    set(handles.axesSagittal,'Visible','on')
    set(handles.axesCoronal,'Visible','on')
end
handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function sliderAxial_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

handles.layerVals(1) = round(get(handles.sliderAxial,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderSagittal,'Value'));

handles.activeAxes = 1;
set(handles.textAxial,'String',['z = ' num2str( handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)) )])

%set(handles.editLayer,'String',num2str(handles.layerVal));
%handles = update_params(handles);
handles = update_figs(handles);

guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function sliderAxial_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function sliderCoronal_Callback(hObject, eventdata, handles)
% hObject    handle to sliderCoronal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
handles.layerVals(1) = round(get(handles.sliderAxial,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderSagittal,'Value'));


set(handles.textCoronal,'String',['y = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(2)))])
handles.activeAxes = 2;

%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function sliderCoronal_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderCoronal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function sliderSagittal_Callback(hObject, eventdata, handles)
% hObject    handle to sliderSagittal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
handles.layerVals(1) = round(get(handles.sliderAxial,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderSagittal,'Value'));

set(handles.textSagittal,'String',['x = ' num2str(handles.voxelsize*(round(get(hObject,'Value'))+handles.coordinateShift(1)))])
handles.activeAxes = 3;

%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function sliderSagittal_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderSagittal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --------------------------------------------------------------------
function view_Callback(hObject, eventdata, handles)
% hObject    handle to view (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Image_Callback(hObject, eventdata, handles)
% hObject    handle to Image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function help_Callback(hObject, eventdata, handles)
% hObject    handle to help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function tools_Callback(hObject, eventdata, handles)
% hObject    handle to tools (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function FileOpen_Callback(hObject, eventdata, handles)
% hObject    handle to FileOpen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[filename, pathname] = uigetfile({'*.mat','MAT-files (*.mat)'},'Pick a file');
if ~isequal(filename,0)    
    handles.paramFile = fullfile(pathname, filename);
    handles = getParams(handles);
    handles = enablePanels(handles);
    guidata(hObject, handles);
end

function handles = enablePanels(handles)

set(handles.uipanelFrequency,'Visible','on')
set(handles.uipanelSimMeasure,'Visible','on')
set(handles.uipanelOrientation,'Visible','on')
set(handles.uipanelAtlas,'Visible','on')
set(handles.uipanelSegment,'Visible','on')
set(handles.uipanelButtons,'Visible','on')

set(handles.axialImage,'Visible','on')
set(handles.coronalImage,'Visible','on')
set(handles.sagittalImage,'Visible','on')
set(handles.axesAxial,'Visible','on')
set(handles.axesSagittal,'Visible','on')
set(handles.axesCoronal,'Visible','on')
set(handles.listboxAtlas,'Visible','on')
set(handles.sliderSagittal,'Visible','on')
set(handles.sliderCoronal,'Visible','on')
set(handles.sliderAxial,'Visible','on')
set(handles.checkboxSwapBytes,'Visible','on')
set(handles.edit1ScaleMax,'Visible','on')
set(handles.edit1ScaleMin,'Visible','on')
%set(h82,'Visible','on')


function handles = disablePanels(handles)

set(handles.uipanelFrequency,'Visible','off')
set(handles.uipanelSimMeasure,'Visible','off')
set(handles.uipanelOrientation,'Visible','off')
set(handles.uipanelAtlas,'Visible','off')
set(handles.uipanelSegment,'Visible','off')
set(handles.uipanelButtons,'Visible','off')
set(handles.listboxAtlas,'Visible','off')
%set(h82,'Visible','off')

set(handles.edit1ScaleMax,'Visible','off')
set(handles.edit1ScaleMin,'Visible','off')
set(handles.editLayer,'Visible','off')
set(handles.editTime,'Visible','off')

set(handles.axesAxial,'Visible','off')
set(handles.axes1,'Visible','off')
set(handles.axesAtlas,'Visible','off')
set(handles.sliderLayer,'Visible','off')
set(handles.sliderTime,'Visible','off')
set(handles.sliderSagittal,'Visible','off')
set(handles.sliderCoronal,'Visible','off')
set(handles.sliderAxial,'Visible','off')
set(handles.checkboxSwapBytes,'Visible','off')

set(handles.axesSagittal,'Visible','off')
set(handles.axesCoronal,'Visible','off')




% --- Executes on selection change in popupmenuFreqBandComp.
function popupmenuFreqBandComp_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBandComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuFreqBandComp contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuFreqBandComp


% --- Executes during object creation, after setting all properties.
function popupmenuFreqBandComp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBandComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkboxStatTh.
function checkboxStatTh_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxStatTh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxStatTh


% --- Executes on selection change in popupmenuStatTh.
function popupmenuStatTh_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuStatTh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuStatTh contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuStatTh


% --- Executes during object creation, after setting all properties.
function popupmenuStatTh_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuStatTh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Creates and returns a handle to the GUI figure. 
function h1 = fMRI_GUI_export_2_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

appdata = [];
appdata.GUIDEOptions = struct(...
    'active_h', [], ...
    'taginfo', struct(...
    'figure', [], ...
    'slider', 10, ...
    'edit', 11, ...
    'axes', 6, ...
    'uipanel', 16, ...
    'listbox', [], ...
    'radiobutton', 22, ...
    'text', 26, ...
    'pushbutton', 7, ...
    'popupmenu', 14, ...
    'checkbox', 8), ...
    'override', [], ...
    'release', 13, ...
    'resize', 'simple', ...
    'accessibility', 'callback', ...
    'mfile', [], ...
    'callbacks', [], ...
    'singleton', [], ...
    'syscolorfig', [], ...
    'blocking', 0, ...
    'lastSavedFile', 'D:\Tutkimus\HBM2009\codes\GUI\fMRI_GUI_export_2.m', ...
    'lastFilename', 'C:\fMRI data\GUI\fMRI_GUI.fig');
appdata.lastValidTag = 'figure1';
appdata.GUIDELayoutEditor = [];

h1 = figure(...
'Units','characters',...
'PaperUnits',get(0,'defaultfigurePaperUnits'),...
'Color',[0.941176470588235 0.941176470588235 0.941176470588235],...
'Colormap',[0 0 0.5625;0 0 0.625;0 0 0.6875;0 0 0.75;0 0 0.8125;0 0 0.875;0 0 0.9375;0 0 1;0 0.0625 1;0 0.125 1;0 0.1875 1;0 0.25 1;0 0.3125 1;0 0.375 1;0 0.4375 1;0 0.5 1;0 0.5625 1;0 0.625 1;0 0.6875 1;0 0.75 1;0 0.8125 1;0 0.875 1;0 0.9375 1;0 1 1;0.0625 1 1;0.125 1 0.9375;0.1875 1 0.875;0.25 1 0.8125;0.3125 1 0.75;0.375 1 0.6875;0.4375 1 0.625;0.5 1 0.5625;0.5625 1 0.5;0.625 1 0.4375;0.6875 1 0.375;0.75 1 0.3125;0.8125 1 0.25;0.875 1 0.1875;0.9375 1 0.125;1 1 0.0625;1 1 0;1 0.9375 0;1 0.875 0;1 0.8125 0;1 0.75 0;1 0.6875 0;1 0.625 0;1 0.5625 0;1 0.5 0;1 0.4375 0;1 0.375 0;1 0.3125 0;1 0.25 0;1 0.1875 0;1 0.125 0;1 0.0625 0;1 0 0;0.9375 0 0;0.875 0 0;0.8125 0 0;0.75 0 0;0.6875 0 0;0.625 0 0;0.5625 0 0],...
'IntegerHandle','off',...
'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
'MenuBar','none',...
'Name','fMRI_GUI',...
'NumberTitle','off',...
'PaperPosition',get(0,'defaultfigurePaperPosition'),...
'PaperSize',[20.98404194812 29.67743169791],...
'PaperType',get(0,'defaultfigurePaperType'),...
'Position',[5.6 8.76923076923077 246 56.5384615384615],...
'ResizeFcn','fMRI_GUI_export_2(''figure1_ResizeFcn'',gcbo,[],guidata(gcbo))',...
'HandleVisibility','callback',...
'Tag','figure1',...
'UserData',[],...
'Behavior',get(0,'defaultfigureBehavior'),...
'Visible','on',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'uipanelOrientation';

h2 = uipanel(...
'Parent',h1,...
'Title','Orientation',...
'Tag','uipanelOrientation',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.0138211382113821 0.0122448979591837 0.116260162601626 0.0938775510204081],...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'popupmenuOrient';

h3 = uicontrol(...
'Parent',h2,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuOrient_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.143884892086331 0.39622641509434 0.712230215827338 0.433962264150943],...
'String','-----',...
'Style','popupmenu',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuOrient_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuOrient',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'listboxAtlas';

h4 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''listboxAtlas_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.539837398373984 0.751020408163265 0.395934959349594 0.194557823129252],...
'String',' ',...
'Style','listbox',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''listboxAtlas_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','listboxAtlas',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'editLayer';

h5 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.949019607843137 0.949019607843137 0.949019607843137],...
'Callback','fMRI_GUI_export_2(''editLayer_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.85609756097561 0.0625850340136054 0.0308943089430894 0.0285714285714286],...
'String','50',...
'Style','text',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''editLayer_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','editLayer',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'axes1';

h6 = axes(...
'Parent',h1,...
'Position',[0.154471544715447 0.0938775510204081 0.336585365853659 0.657142857142857],...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.25594596919316 0.109524315302329 0.18703743902577 0.0746756695243154],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axes1',...
'Behavior',get(0,'defaultaxesBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h7 = get(h6,'title');

set(h7,...
'Parent',h6,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.498792270531401 1.01345755693582 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h8 = get(h6,'xlabel');

set(h8,...
'Parent',h6,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.498792270531401 -0.0486542443064184 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h9 = get(h6,'ylabel');

set(h9,...
'Parent',h6,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.0688405797101449 0.497929606625259 1.00005459937205],...
'Rotation',90,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h10 = get(h6,'zlabel');

set(h10,...
'Parent',h6,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.460144927536232 1.37577639751553 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'edit1ScaleMin';

h11 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''edit1ScaleMin_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.156910569105691 0.00816326530612245 0.0317073170731707 0.0285714285714286],...
'String','0',...
'Style','edit',...
'TooltipString','Set colorbar minimum scale',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''edit1ScaleMin_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','edit1ScaleMin',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'edit1ScaleMax';

h12 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''edit1ScaleMax_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.463414634146341 0.00816326530612245 0.0333333333333333 0.0285714285714286],...
'String','1',...
'Style','edit',...
'TooltipString','Set colorbar maximum scale',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''edit1ScaleMax_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','edit1ScaleMax',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'axesAtlas';

h13 = axes(...
'Parent',h1,...
'Position',[0.513821138211382 0.0938775510204081 0.338211382113821 0.653061224489796],...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.240188734523724 0.10931925547997 0.175522536767337 0.0745358560090703],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axesAtlas',...
'Behavior',get(0,'defaultaxesBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h14 = get(h13,'title');

set(h14,...
'Parent',h13,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.498798076923077 1.01354166666667 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h15 = get(h13,'xlabel');

set(h15,...
'Parent',h13,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.498798076923077 -0.0489583333333334 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h16 = get(h13,'ylabel');

set(h16,...
'Parent',h13,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.0685096153846152 0.496875 1.00005459937205],...
'Rotation',90,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h17 = get(h13,'zlabel');

set(h17,...
'Parent',h13,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-1.52043269230769 1.384375 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], appdata} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'textSlice';

h18 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.85609756097561 0.0326530612244898 0.0357723577235772 0.0285714285714286],...
'String','Slice',...
'Style','text',...
'Tag','textSlice',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text9';

h19 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.19349593495935 0.0108843537414966 0.0130081300813008 0.0204081632653061],...
'String','min',...
'Style','text',...
'Tag','text9',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text10';

h20 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.43739837398374 0.00952380952380952 0.0227642276422764 0.0204081632653061],...
'String','max',...
'Style','text',...
'Tag','text10',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text13';

h21 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.243089430894309 0.0571428571428571 0.13739837398374 0.0163265306122449],...
'String','COLORBAR IS HERE',...
'Style','text',...
'Tag','text13',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text15';

h22 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.622764227642276 0.0585034013605442 0.138211382113821 0.017687074829932],...
'String','COLORBAR IS HERE',...
'Style','text',...
'Tag','text15',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'Untitled_2';

h23 = uicontextmenu(...
'Parent',h1,...
'Callback','fMRI_GUI_export_2(''Untitled_2_Callback'',gcbo,[],guidata(gcbo))',...
'Tag','Untitled_2',...
'Behavior',get(0,'defaultuicontextmenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'menu';

h24 = uimenu(...
'Parent',h1,...
'Callback','fMRI_GUI_export_2(''menu_Callback'',gcbo,[],guidata(gcbo))',...
'Label','File',...
'Tag','menu',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'FileOpen';

h25 = uimenu(...
'Parent',h24,...
'Accelerator','O',...
'Callback','fMRI_GUI_export_2(''FileOpen_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Open...',...
'Separator','on',...
'Tag','FileOpen',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'fileMenuDatatoWS';

h26 = uimenu(...
'Parent',h24,...
'Callback','fMRI_GUI_export_2(''fileMenuDatatoWS_Callback'',gcbo,[],guidata(gcbo))',...
'Label','data to workspace',...
'Tag','fileMenuDatatoWS',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'sliderLayer';

h27 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.9 0.9 0.9],...
'Callback','fMRI_GUI_export_2(''sliderLayer_Callback'',gcbo,[],guidata(gcbo))',...
'Max',100000,...
'Position',[0.865040650406504 0.102040816326531 0.0130081300813008 0.651700680272109],...
'String',{  'Slider' },...
'Style','slider',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''sliderLayer_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','sliderLayer',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'sliderTime';

h28 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[0.9 0.9 0.9],...
'Callback','fMRI_GUI_export_2(''sliderTime_Callback'',gcbo,[],guidata(gcbo))',...
'Max',100000,...
'Min',[],...
'Position',[0.963414634146341 0.102040816326531 0.0121951219512195 0.527891156462585],...
'String',{  'Slider' },...
'Style','slider',...
'SliderStep',[0.04 0.4],...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''sliderTime_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','sliderTime',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'editTime';

h29 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''editTime_Callback'',gcbo,[],guidata(gcbo))',...
'Enable','inactive',...
'Position',[0.922764227642276 0.0598639455782313 0.0634146341463415 0.0285714285714286],...
'String','----',...
'Style','edit',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''editTime_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','editTime',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'textTime';

h30 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.928455284552846 0.0285714285714286 0.0512195121951219 0.0326530612244898],...
'String','Time interval',...
'Style','text',...
'Tag','textTime',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'pushbuttonUpdate';

h31 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''pushbuttonUpdate_Callback'',gcbo,[],guidata(gcbo))',...
'CData',[],...
'Position',[0.879674796747967 0.922448979591837 0.0869918699186992 0.0476190476190476],...
'String','Update',...
'Tag','pushbuttonUpdate',...
'UserData',[],...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'uipanelAtlas';

h32 = uipanel(...
'Parent',h1,...
'Title','Atlas tools',...
'Tag','uipanelAtlas',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.0121951219512195 0.11156462585034 0.121138211382114 0.163265306122449],...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'popupmenuAtlas';

h33 = uicontrol(...
'Parent',h32,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuAtlas_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0827586206896552 0.673076923076923 0.806896551724138 0.278846153846154],...
'String','------',...
'Style','popupmenu',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuAtlas_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuAtlas',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'popupmenuAtlasThreshold';

h34 = uicontrol(...
'Parent',h32,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuAtlasThreshold_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0758620689655172 0.336538461538462 0.813793103448276 0.278846153846154],...
'String','------',...
'Style','popupmenu',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuAtlasThreshold_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuAtlasThreshold',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'checkboxLargeFigure';

h35 = uicontrol(...
'Parent',h32,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''checkboxLargeFigure_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0827586206896552 0.163461538461538 0.524137931034483 0.144230769230769],...
'String','Show atlas',...
'Style','checkbox',...
'Tag','checkboxLargeFigure',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'uipanelSegment';

h36 = uipanel(...
'Parent',h1,...
'Title','Segment region',...
'Tag','uipanelSegment',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.00894308943089431 0.293877551020408 0.12520325203252 0.259863945578231],...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'radiobuttonIsolationAtlas';

h37 = uicontrol(...
'Parent',h36,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''radiobuttonIsolationAtlas_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.1 0.708571428571429 0.7 0.131428571428571],...
'String','Atlas based',...
'Style','radiobutton',...
'TooltipString','Threshold synchronization map according to active brain region',...
'Tag','radiobuttonIsolationAtlas',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'radiobuttonIsolationThreshold';

h38 = uicontrol(...
'Parent',h36,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''radiobuttonIsolationThreshold_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.1 0.605714285714286 0.826666666666667 0.0857142857142857],...
'String','Threshold based',...
'Style','radiobutton',...
'TooltipString','Threshold synchronization map based on some value',...
'Tag','radiobuttonIsolationThreshold',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'editThreshold';

h39 = uicontrol(...
'Parent',h36,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''editThreshold_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.24 0.44 0.406666666666667 0.125714285714286],...
'String','------',...
'Style','edit',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''editThreshold_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','editThreshold',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'radiobuttonIsolationNoIsolation';

h40 = uicontrol(...
'Parent',h36,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''radiobuttonIsolationNoIsolation_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.1 0.84 0.7 0.131428571428571],...
'String','No segmentation',...
'Style','radiobutton',...
'Tag','radiobuttonIsolationNoIsolation',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'checkboxStatTh';

h41 = uicontrol(...
'Parent',h36,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''checkboxStatTh_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0933333333333333 0.262857142857143 0.82 0.0857142857142857],...
'String','statistical threshold',...
'Style','checkbox',...
'Tag','checkboxStatTh',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'popupmenuStatTh';

h42 = uicontrol(...
'Parent',h36,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''popupmenuStatTh_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.2 0.0971428571428571 0.66 0.125714285714286],...
'String',{  'p = 0.05'; 'p = 0.005' },...
'Style','popupmenu',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuStatTh_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuStatTh',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'uipanelFrequency';

h43 = uipanel(...
'Parent',h1,...
'Title','Frequency Band',...
'Tag','uipanelFrequency',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.00894308943089431 0.813605442176871 0.130894308943089 0.152380952380952],...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'checkboxCompareFreqs';

h44 = uicontrol(...
'Parent',h43,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''checkboxCompareFreqs_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0620689655172414 0.445544554455446 0.689655172413793 0.148514851485148],...
'String','Compare against:',...
'Style','checkbox',...
'Tag','checkboxCompareFreqs',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'popupmenuFreqBand';

h45 = uicontrol(...
'Parent',h43,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuFreqBand_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0413793103448276 0.702970297029703 0.917241379310345 0.217821782178218],...
'String','---------',...
'Style','popupmenu',...
'TooltipString','Choose frequency band for synchronization map',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuFreqBand_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuFreqBand',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'popupmenuFreqBandComp';

h46 = uicontrol(...
'Parent',h43,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuFreqBandComp_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0482758620689655 0.108910891089109 0.903448275862069 0.217821782178218],...
'String','---------',...
'Style','popupmenu',...
'TooltipString','Choose frequency band for synchronization map',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuFreqBandComp_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuFreqBandComp',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'uipanelSimMeasure';

h47 = uipanel(...
'Parent',h1,...
'Title','',...
'Tag','uipanelSimMeasure',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.00975609756097561 0.578231292517007 0.123577235772358 0.219047619047619],...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'popupmenuSimilarityMeasure';

h48 = uicontrol(...
'Parent',h47,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuSimilarityMeasure_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0405405405405405 0.660377358490566 0.945945945945946 0.138364779874214],...
'String','----------',...
'Style','popupmenu',...
'TooltipString','Choose intersubject similarity measure for synchronization map',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuSimilarityMeasure_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuSimilarityMeasure',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'popupmenuSession';

h49 = uicontrol(...
'Parent',h47,...
'Units','normalized',...
'BackgroundColor',[],...
'Callback','fMRI_GUI_export_2(''popupmenuSession_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0472972972972973 0.352201257861635 0.554054054054054 0.125786163522013],...
'String','------------',...
'Style','popupmenu',...
'Value',[],...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''popupmenuSession_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','popupmenuSession',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'text18';

h50 = uicontrol(...
'Parent',h47,...
'Units','normalized',...
'Position',[0 0.484276729559748 0.364864864864865 0.113207547169811],...
'String','Session',...
'Style','text',...
'Tag','text18',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text21';

h51 = uicontrol(...
'Parent',h47,...
'Units','normalized',...
'Position',[0.0337837837837838 0.811320754716981 0.621621621621622 0.106918238993711],...
'String','Similarity measure',...
'Style','text',...
'Tag','text21',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'checkboxTimeWindow';

h52 = uicontrol(...
'Parent',h47,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''checkboxTimeWindow_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0472972972972973 0.188679245283019 0.736486486486487 0.113207547169811],...
'String','Temporal analysis',...
'Style','checkbox',...
'Tag','checkboxTimeWindow',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'pushbuttonPlotTimeSeries';

h53 = uicontrol(...
'Parent',h47,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''pushbuttonPlotTimeSeries_Callback'',gcbo,[],guidata(gcbo))',...
'CData',[],...
'Position',[0.0540540540540541 0.0377358490566038 0.763513513513514 0.138364779874214],...
'String','Temporal analysis',...
'TooltipString','Launch temporal analysis tool',...
'Tag','pushbuttonPlotTimeSeries',...
'UserData',[],...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'uipanelButtons';

h54 = uipanel(...
'Parent',h1,...
'Title','',...
'Tag','uipanelButtons',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.867479674796748 0.778231292517007 0.116260162601626 0.201360544217687],...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'pushbuttonInspectRegion';

h55 = uicontrol(...
'Parent',h54,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''pushbuttonInspectRegion_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0935251798561151 0.410958904109589 0.784172661870504 0.26027397260274],...
'String','Inspect Region',...
'Tag','pushbuttonInspectRegion',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'pushbuttonNewFigure';

h56 = uicontrol(...
'Parent',h54,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''pushbuttonNewFigure_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0791366906474821 0.116438356164384 0.798561151079137 0.232876712328767],...
'String','New Figure',...
'Tag','pushbuttonNewFigure',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'uipanelAxes';

h57 = uipanel(...
'Parent',h1,...
'Title','',...
'Tag','uipanelAxes',...
'Behavior',get(0,'defaultuipanelBehavior'),...
'Clipping','on',...
'Position',[0.154471544715447 0.145578231292517 0.780487804878049 0.487074829931973],...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'axesAxial';

h58 = axes(...
'Parent',h57,...
'Position',[0.0135983263598326 0.154494382022472 0.309623430962343 0.808988764044944],...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.488990825688074 0.434677419354839 0.357339449541285 0.296370967741936],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axesAxial',...
'UserData',[],...
'Behavior',get(0,'defaultaxesBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

h59 = get(h58,'title');

set(h59,...
'Parent',h58,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.498310810810811 1.02256944444444 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h60 = get(h58,'xlabel');

set(h60,...
'Parent',h58,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.498310810810811 -0.0815972222222225 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h61 = get(h58,'ylabel');

set(h61,...
'Parent',h58,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.0962837837837839 0.494791666666667 1.00005459937205],...
'Rotation',90,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h62 = get(h58,'zlabel');

set(h62,...
'Parent',h58,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.694256756756757 1.97743055555556 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'axesCoronal';

h63 = axes(...
'Parent',h57,...
'Position',[0.341004184100418 0.154494382022472 0.31694560669456 0.811797752808989],...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.488990825688074 0.434677419354839 0.357339449541284 0.296370967741936],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axesCoronal',...
'Behavior',get(0,'defaultaxesBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

h64 = get(h63,'title');

set(h64,...
'Parent',h63,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.5 1.02249134948097 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h65 = get(h63,'xlabel');

set(h65,...
'Parent',h63,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.496699669966997 -0.0813148788927334 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h66 = get(h63,'ylabel');

set(h66,...
'Parent',h63,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.0940594059405944 0.496539792387543 1.00005459937205],...
'Rotation',90,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h67 = get(h63,'zlabel');

set(h67,...
'Parent',h63,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-1.71122112211221 1.97058823529412 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'axesSagittal';

h68 = axes(...
'Parent',h57,...
'Position',[0.673640167364016 0.160112359550562 0.312761506276151 0.811797752808989],...
'CameraPosition',[0.5 0.5 9.16025403784439],...
'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
'Color',get(0,'defaultaxesColor'),...
'ColorOrder',get(0,'defaultaxesColorOrder'),...
'LooseInset',[0.488990825688073 0.434677419354839 0.357339449541284 0.296370967741936],...
'XColor',get(0,'defaultaxesXColor'),...
'YColor',get(0,'defaultaxesYColor'),...
'ZColor',get(0,'defaultaxesZColor'),...
'Tag','axesSagittal',...
'Behavior',get(0,'defaultaxesBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

h69 = get(h68,'title');

set(h69,...
'Parent',h68,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.5 1.02249134948097 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h70 = get(h68,'xlabel');

set(h70,...
'Parent',h68,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[0.496655518394649 -0.0813148788927334 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','cap',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h71 = get(h68,'ylabel');

set(h71,...
'Parent',h68,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','center',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-0.0953177257525084 0.496539792387544 1.00005459937205],...
'Rotation',90,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','bottom',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','on',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

h72 = get(h68,'zlabel');

set(h72,...
'Parent',h68,...
'Units','data',...
'FontUnits','points',...
'BackgroundColor','none',...
'Color',[0 0 0],...
'EdgeColor','none',...
'EraseMode','normal',...
'DVIMode','auto',...
'FontAngle','normal',...
'FontName','Helvetica',...
'FontSize',10,...
'FontWeight','normal',...
'HorizontalAlignment','right',...
'LineStyle','-',...
'LineWidth',0.5,...
'Margin',[],...
'Position',[-2.79765886287625 1.9636678200692 1.00005459937205],...
'Rotation',0,...
'String','',...
'Interpreter','tex',...
'VerticalAlignment','middle',...
'ButtonDownFcn',[],...
'CreateFcn', {@local_CreateFcn, [], ''} ,...
'DeleteFcn',[],...
'BusyAction','queue',...
'HandleVisibility','off',...
'HelpTopicKey','',...
'HitTest','on',...
'Interruptible','on',...
'SelectionHighlight','on',...
'Serializable','on',...
'Tag','',...
'UserData',[],...
'Behavior',struct(),...
'Visible','off',...
'XLimInclude','on',...
'YLimInclude','on',...
'ZLimInclude','on',...
'CLimInclude','on',...
'ALimInclude','on',...
'Clipping','off');

appdata = [];
appdata.lastValidTag = 'sliderAxial';

h73 = uicontrol(...
'Parent',h57,...
'Units','normalized',...
'BackgroundColor',[0.9 0.9 0.9],...
'Callback','fMRI_GUI_export_2(''sliderAxial_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.0146443514644351 0.0758426966292135 0.311715481171548 0.0365168539325843],...
'String',{  'Slider' },...
'Style','slider',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''sliderAxial_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','sliderAxial',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'sliderCoronal';

h74 = uicontrol(...
'Parent',h57,...
'Units','normalized',...
'BackgroundColor',[0.9 0.9 0.9],...
'Callback','fMRI_GUI_export_2(''sliderCoronal_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.342050209205021 0.0758426966292135 0.317991631799163 0.0365168539325843],...
'String',{  'Slider' },...
'Style','slider',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''sliderCoronal_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','sliderCoronal',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'sliderSagittal';

h75 = uicontrol(...
'Parent',h57,...
'Units','normalized',...
'BackgroundColor',[0.9 0.9 0.9],...
'Callback','fMRI_GUI_export_2(''sliderSagittal_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.674686192468619 0.0786516853932584 0.311715481171548 0.0365168539325843],...
'String',{  'Slider' },...
'Style','slider',...
'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export_2(''sliderSagittal_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
'Tag','sliderSagittal',...
'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'textAxial';

h76 = uicontrol(...
'Parent',h57,...
'Units','normalized',...
'Position',[0.0146443514644351 0.0280898876404494 0.0564853556485355 0.0337078651685393],...
'String','MNI',...
'Style','text',...
'Tag','textAxial',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'textCoronal';

h77 = uicontrol(...
'Parent',h57,...
'Units','normalized',...
'Position',[0.342050209205021 0.0337078651685393 0.0564853556485355 0.0337078651685393],...
'String',{  'Static Text' },...
'Style','text',...
'Tag','textCoronal',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'textSagittal';

h78 = uicontrol(...
'Parent',h57,...
'Units','normalized',...
'Position',[0.673640167364016 0.0365168539325843 0.0564853556485355 0.0337078651685393],...
'String',{  'Static Text' },...
'Style','text',...
'Tag','textSagittal',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'checkboxPixVal1';

h79 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Callback','fMRI_GUI_export_2(''checkboxPixVal1_Callback'',gcbo,[],guidata(gcbo))',...
'Position',[0.283739837398374 0.0258503401360544 0.0926829268292683 0.0204081632653061],...
'String','Show Pixel Values',...
'Style','checkbox',...
'Tag','checkboxPixVal1',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'Visible','off',...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'Image';

h80 = uimenu(...
'Parent',h1,...
'Callback','fMRI_GUI_export_2(''Image_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Image',...
'Tag','Image',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'view';

h81 = uimenu(...
'Parent',h1,...
'Callback','fMRI_GUI_export_2(''view_Callback'',gcbo,[],guidata(gcbo))',...
'Label','View',...
'Tag','view',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'tools';

h82 = uimenu(...
'Parent',h1,...
'Callback','fMRI_GUI_export_2(''tools_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Tools',...
'Tag','tools',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'help';

h83 = uimenu(...
'Parent',h1,...
'Callback','fMRI_GUI_export_2(''help_Callback'',gcbo,[],guidata(gcbo))',...
'Label','Help',...
'Tag','help',...
'Behavior',get(0,'defaultuimenuBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'text25';

h84 = uicontrol(...
'Parent',h1,...
'Units','normalized',...
'Position',[0.539024390243902 0.945578231292517 0.114634146341463 0.0258503401360544],...
'String','Currently visible brain areas:',...
'Style','text',...
'Tag','text25',...
'Behavior',get(0,'defaultuicontrolBehavior'),...
'CreateFcn', {@local_CreateFcn, '', appdata} );


hsingleton = h1;


% --- Set application data first then calling the CreateFcn. 
function local_CreateFcn(hObject, eventdata, createfcn, appdata)

if ~isempty(appdata)
   names = fieldnames(appdata);
   for i=1:length(names)
       name = char(names(i));
       setappdata(hObject, name, getfield(appdata,name));
   end
end

if ~isempty(createfcn)
   eval(createfcn);
end


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)


%   GUI_MAINFCN provides these command line APIs for dealing with GUIs
%
%      FMRI_GUI_EXPORT_2, by itself, creates a new FMRI_GUI_EXPORT_2 or raises the existing
%      singleton*.
%
%      H = FMRI_GUI_EXPORT_2 returns the handle to a new FMRI_GUI_EXPORT_2 or the handle to
%      the existing singleton*.
%
%      FMRI_GUI_EXPORT_2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FMRI_GUI_EXPORT_2.M with the given input arguments.
%
%      FMRI_GUI_EXPORT_2('Property','Value',...) creates a new FMRI_GUI_EXPORT_2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before untitled_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to untitled_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".

%   Copyright 1984-2004 The MathWorks, Inc.
%   $Revision: 1.4.6.10.2.1 $ $Date: 2005/01/14 21:54:21 $

gui_StateFields =  {'gui_Name'
                    'gui_Singleton'
                    'gui_OpeningFcn'
                    'gui_OutputFcn'
                    'gui_LayoutFcn'
                    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);        
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [gui_State.(gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % FMRI_GUI_EXPORT_2
    % create the GUI
    gui_Create = 1;
elseif isequal(ishandle(varargin{1}), 1) && ispc && iscom(varargin{1}) && isequal(varargin{1},gcbo)
    % FMRI_GUI_EXPORT_2(ACTIVEX,...)    
    vin{1} = gui_State.gui_Name;
    vin{2} = [get(varargin{1}.Peer, 'Tag'), '_', varargin{end}];
    vin{3} = varargin{1};
    vin{4} = varargin{end-1};
    vin{5} = guidata(varargin{1}.Peer);
    feval(vin{:});
    return;
elseif ischar(varargin{1}) && numargin>1 && isequal(ishandle(varargin{2}), 1)
    % FMRI_GUI_EXPORT_2('CALLBACK',hObject,eventData,handles,...)
    gui_Create = 0;
else
    % FMRI_GUI_EXPORT_2(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = 1;
end

if gui_Create == 0
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else
        feval(varargin{:});
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.
    
    % Do feval on layout code in m-file if it exists
    if ~isempty(gui_State.gui_LayoutFcn)
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);
        % openfig (called by local_openfig below) does this for guis without
        % the LayoutFcn. Be sure to do it here so guis show up on screen.
        movegui(gui_hFigure,'onscreen')
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);            
        end
    end
    
    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);

    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    
    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig 
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end

        % Generate HANDLES structure and store with GUIDATA. If there is
        % user set GUI data already, keep that also.
        data = guidata(gui_hFigure);
        handles = guihandles(gui_hFigure);
        if ~isempty(handles)
            if isempty(data)
                data = handles;
            else
                names = fieldnames(handles);
                for k=1:length(names)
                    data.(char(names(k)))=handles.(char(names(k)));
                end
            end
        end
        guidata(gui_hFigure, data);
    end
    
    % If user specified 'Visible','off' in p/v pairs, don't make the figure
    % visible.
    gui_MakeVisible = 1;
    for ind=1:2:length(varargin)
        if length(varargin) == ind
            break;
        end
        len1 = min(length('visible'),length(varargin{ind}));
        len2 = min(length('off'),length(varargin{ind+1}));
        if ischar(varargin{ind}) && ischar(varargin{ind+1}) && ...
                strncmpi(varargin{ind},'visible',len1) && len2 > 1
            if strncmpi(varargin{ind+1},'off',len2)
                gui_MakeVisible = 0;
            elseif strncmpi(varargin{ind+1},'on',len2)
                gui_MakeVisible = 1;
            end
        end
    end
    
    % Check for figure param value pairs
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end
        try set(gui_hFigure, varargin{index}, varargin{index+1}), catch break, end
    end

    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end
    
    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});
    
    if ishandle(gui_hFigure)
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
        
        % Make figure visible
        if gui_MakeVisible
            set(gui_hFigure, 'Visible', 'on')
            if gui_Options.singleton 
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end

        % Done with GUI initialization
        rmappdata(gui_hFigure,'InGUIInitialization');
    end
    
    % If handle visibility is set to 'callback', turn it on until finished with
    % OutputFcn
    if ishandle(gui_hFigure)
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end
    
    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end
    
    if ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end    

function gui_hFigure = local_openfig(name, singleton)

% this application data is used to indicate the running mode of a GUIDE
% GUI to distinguish it from the design mode of the GUI in GUIDE.
setappdata(0,'OpenGuiWhenRunning',1);

% openfig with three arguments was new from R13. Try to call that first, if
% failed, try the old openfig.
try 
    gui_hFigure = openfig(name, singleton, 'auto');
catch
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
end
rmappdata(0,'OpenGuiWhenRunning');

