function [bestMu,idx,GMM] = estimateGMM(features,Centroids)

maxIterGMM = 200;
maxIterKM = 500;
covoption = 0; % full covariance
%covoption = 1; % diagonal covariance

Ce = size(Centroids,1);

% run K-means based on obtained initial cluster centers:    
V = version;
[IDX, C] = kmeans(features,[],'Start',Centroids,'EmptyAction','drop','MaxIter',maxIterKM,'OnlinePhase','off','Display','Iter');

if covoption == 0
  Sigmas = zeros(size(C,2),size(C,2),size(C,1)); % 1 by d by k    
else
  Sigmas = zeros(1,size(C,2),size(C,1)); % 1 by d by k
end

p = zeros(1,size(C,1));
for m = 1:size(C,1)
   if covoption == 0
       Sigmas(:,:,m) = cov(features(IDX==m,:));
   else
       Sigmas(1,:,m) = var(features(IDX==m,:),[],1);
   end
    p(m) = sum(IDX==m)/size(features,1);
 end

initVal.mu = Centroids;
initVal.Sigma = Sigmas;
initVal.PComponents = p;
    
Opt = statset;
Opt.Display = 'iter';
Opt.MaxIter = maxIterGMM;
if covoption == 0
    cv = 'full';
else
    cv = 'diagonal';
end

% run GMM-based on K-means solution:
gm = gmdistribution.fit(features,size(initVal.mu,1),'Start',initVal,'CovType',cv,'Options',Opt);

% get final cluster indices:    
idx = cluster(gm,features);
 
clear initVal
GMM.Sigmas = gm.Sigma;
GMM.mu = gm.mu;
GMM.PComponents = gm.PComponents;

bestMu = GMM.mu;

% save results:
%if exist(fn) == 0
  %    save(fn,'gm','initVal','IDX','C','Opt','covoption','GMM')
%else
   %    save(fn,'gm','initVal','IDX','C','Opt','covoption','GMM','-append')        
%end

% This is an additional component removal step if needed using the method from Figuereido and Jain:
%[bestk,bestpp,bestmu,bestcov,dl,countf] = GMMreduc(features',10,Ce,1e-6,1e-3,covoption,initVal);
%
%if exist(fn) == 0
%    save(fn,'bestmu','bestcov','bestpp','bestk','dl','countf','gm','initVal','IDX','C','Opt','covoption')
%else
%    save(fn,'bestmu','bestcov','bestpp','bestk','dl','countf','gm','initVal','IDX','C','Opt','covoption','-append')
%end
%
%end


