/* computeKNNGraph2_mex.c */
/* This function can be used to compute k-nearest neighbor list even for very large data set.
/*  $Date: 2011/08/01 18:26:49 $ Written by Jukka-Pekka Kauppi */

#include "mex.h"
#include <math.h>
#include <string.h>

/* Euclidean distance: d = sqrt(sum((XI-XJ).^2,2)); */
void eucdist(double *x, int m, int n, int startInd, int endInd, int K, double *d, double *nlist, double *indlist)
{
    
    int i,j,k,z,h;
    double theSum,Y,dtmp,iter;
    double *XI, *XJ, *XI0;
    double *nlist2, *nlist0;
    double *indlist2, *indlist0;
    
    XI = x + (startInd-1)*n;
    XJ = x;
    for (i=0; i<(endInd-startInd+1); i++) {
        
        /* We keep sorted list of k nearest neighbor (k-NN) distances of every point during
        distance computations. First we initialize the k-NN list of every
         % point with high values to help book-keeping of the first K values. */
        for (h = 0; h < K+1; h++) {
            *(nlist++) = 100000;
            indlist++;
        }
        
        nlist0 = nlist;
        indlist0 = indlist;
        
        XI0 = XI;
        iter = 0;
        for (j=0; j<m; j++) { /* get data point (j+1) */
            
            
            iter = iter + 1;
            XI = XI0;
            theSum = 0;
            /* get other data points and compute distances: */
            for (k=0;k<n;k++,XI++,XJ++){
                Y = (*XI)-(*XJ);
                theSum += Y*Y;
            }
            *(d++) = sqrt(theSum);
            
            
            /* update k-NN list and keep it sorted: */
            dtmp = sqrt(theSum);
            for (z=0; z<K+1; z++) {
                nlist2 = nlist - 1;
                indlist2 = indlist - 1;
                if ( dtmp < *nlist2 ) {
                    *nlist = *nlist2;
                    *indlist = *indlist2;
                    nlist--;
                    indlist--;
                    *nlist = dtmp;
                    *indlist = iter;
                    
                } else {
                    break;
                }
            }
            nlist = nlist0;
            indlist = indlist0;
        }
        XJ = x;
        nlist++;
        indlist++;
    }
}

/* Correlation distance: d = 1 - sum(XI.*XJ,2); */
void cordist(double *x, int m, int n, int startInd, int endInd, int K, double *d, double *nlist, double *indlist)
{
    
    
    int i,j,k,z,h;
    double theSum,dtmp,iter;
    double *XI, *XJ, *XI0;
    double *nlist2, *nlist0;
    double *indlist2, *indlist0;
    
    XI = x + (startInd-1)*n;
    XJ = x;
    for (i=0; i<(endInd-startInd+1); i++) {
        
        /* We keep sorted list of k nearest neighbor (k-NN) distances of every point during
        distance computations. First we initialize the k-NN list of every
         % point with high values to help book-keeping of the first K values. */
        for (h = 0; h < K+1; h++) {
            *(nlist++) = 100000;
            indlist++;
        }
        
        nlist0 = nlist;
        indlist0 = indlist;
        
        XI0 = XI;
        iter = 0;
        for (j=0; j<m; j++) { /* get data point (j+1) */
            iter = iter + 1;
            XI = XI0;
            theSum = 0;
            /* get other data points and compute distances: */
            for (k=0;k<n;k++,XI++,XJ++){
                theSum += (*XI)*(*XJ);
            }
            *(d++) = 1-theSum;

            /* update k-NN list and keep it sorted: */
            dtmp = 1-theSum;
            for (z=0; z<K+1; z++) {
                nlist2 = nlist - 1;
                indlist2 = indlist - 1;
                if ( dtmp < *nlist2 ) {
                    *nlist = *nlist2;
                    *indlist = *indlist2;
                    nlist--;
                    indlist--;
                    *nlist = dtmp;
                    *indlist = iter;
                    
                } else {
                    break;
                }
            }
            nlist = nlist0;
            indlist = indlist0;
        }
        XJ = x;
        nlist++;
        indlist++;
    }
}






#define START_IND prhs[2]
#define END_IND prhs[3]
#define K_PARAM prhs[4]

/* the gateway function */
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    int     status,numCoords,numPoints,startInd,endInd,K;
    char	metric[4];
    
  /*  check for proper number of arguments */
  /* NOTE: You do not need an else statement when using mexErrMsgTxt
     within an if statement, because it will never get to the else
     statement if mexErrMsgTxt is executed. (mexErrMsgTxt breaks you out of
     the MEX-file) */
    if (nrhs<5) {
        mexErrMsgIdAndTxt("computeKNNgraph_mex.c:TooFewInputs",
        "Five input arguments required.");
    } else if(nrhs>5) {
        mexErrMsgIdAndTxt("computeKNNgraph_mex.c:TooFewInputs",
        "Five input arguments required.");
    } else if(nlhs>3) {
        mexErrMsgIdAndTxt("computeKNNgraph_mex.c:TooManyOutputs",
        "Too many output arguments.");
    }
    
    /*  get the metric */
    status = mxGetString(prhs[1],metric,4);
    
    if (mxIsDouble(prhs[0])) {
        double *x,*d,*nlist,*indlist;
  /*  create a pointer to the input matrix */
        x = mxGetPr(prhs[0]);
        
  /*  get the dimensions of the matrix input */
        numCoords = mxGetM(prhs[0]);
        numPoints = mxGetN(prhs[0]);
        
        startInd = (int) mxGetScalar(START_IND);
        endInd = (int) mxGetScalar(END_IND);
        K = (int) mxGetScalar(K_PARAM);
        
  /*  set the output pointer to the output matrix */
        plhs[0] = mxCreateDoubleMatrix(1,(numPoints * (endInd - startInd + 1)), mxREAL);
        plhs[1] = mxCreateDoubleMatrix((K+2),(endInd - startInd + 1), mxREAL);
        plhs[2] = mxCreateDoubleMatrix((K+2),(endInd - startInd + 1), mxREAL);
        
  /*  create a pointer to a copy of the output matrix */
        d = mxGetPr(plhs[0]);
        nlist = mxGetPr(plhs[1]);
        indlist = mxGetPr(plhs[2]);
        
  /*  call the appropriate distance subroutine */
        if (strcmp(metric,"euc") == 0) {
            eucdist(x,numPoints,numCoords,startInd,endInd,K,d,nlist,indlist);
        } else if (strcmp(metric,"cor") == 0) {
            cordist(x,numPoints,numCoords,startInd,endInd,K,d,nlist,indlist);
        } else {
            mexErrMsgIdAndTxt("computeKNNgraph_mex.c:BadInput","distance must be either euc or cor.");
        }
        
    } else {
        mexErrMsgIdAndTxt("computeKNNgraph_mex.c:BadInputType",
        "computeKNNgraph_mex only supports real DOUBLE data.");
    }
    
}
