function [nearestNeighborInds,nearestNeighborDists] = computeKNNgraph(X,distType,blockSize,k)

[n,d] = size(X);
X = double(X);

if ~strcmp(distType,'euc') && ~strcmp(distType,'cor')
    error('Distance must be either ''euc'' or ''cor''')
    return
end

switch distType
    case 'cor' % Correlation        
        % normalize:
        X = X - repmat(mean(X,2),1,d);
        Xnorm = sqrt(sum(X.^2, 2));
        if min(Xnorm) <= eps(max(Xnorm))
        error('computeKNNgraph:InappropriateDistance',...
              ['Some points have small relative standard deviations, making ', ...
               'them effectively constant.\nEither remove those points, or ', ...
               'choose a distance other than correlation.'], []);
        end
        X = X ./ Xnorm(:,ones(1,d));
end


nrBlocks = ceil(n/blockSize);

disp(['Number of samples ' num2str(n)])

nearestNeighborInds = zeros(size(X,1),k);
nearestNeighborDists = nearestNeighborInds;
for m = 0:nrBlocks-1
%    tic
    disp(['Processing block ' num2str(m+1) '/' num2str(nrBlocks)])
    startInd = int32(1+blockSize*m);
    endInd = min(int32(blockSize+blockSize*m),int32(size(X,1)));

    if endInd > size(X,1)
        endInd = size(X,1);
    end
    
    if ~isinteger(startInd) | ~isinteger(endInd)
        error('Indices must be integers!!')
        return
    end
    
    if ~isnumeric(startInd) | ~isnumeric(endInd)
        error('Indices must be numeric!!')
        return
    end
    if ( ( length(startInd) ~= 1 ) | ( length(endInd) ~= 1 ) )
        error('end and start indices must be scalars!!')
        return
    end
    if startInd > endInd
        error('end index must be greater than start index!!')
        return
    elseif startInd <= 0
        error('start index must be at least one!!')
        return
    else            
         % compute knn-graph of one block: 
         [Y,cd,cd2] = computeKNNgraph_mex(X',distType,startInd,endInd,k);

         % post-process graph to suitable form:
         cd = cd';
         cd(:,1) = [];
         cd(:,end) = [];
         cd2 = cd2';
         cd2(:,1) = [];
         cd2(:,end) = [];
         
         % construct final nearest neighbor distance and index matrices:
         nearestNeighborDists(startInd:endInd,:) = cd;
         nearestNeighborInds(startInd:endInd,:) = cd2;
         
%         a = reshape(Y',n,endInd-startInd+1)';
 %       toc 
    end   
end

