function [totSSE,SSE,miInd,miInd2] = computeMSE(data,distType,centroids,centroidType)


if ~strcmp(distType,'euc') && ~strcmp(distType,'cor')
    error('Distance must be either ''euc'' or ''cor''')
    return
end

X = [centroids;data];

[n,d] = size(X);

switch distType
    case 'cor' % Correlation        
        % normalize:
        X = X - repmat(mean(X,2),1,d);
        Xnorm = sqrt(sum(X.^2, 2));
        if min(Xnorm) <= eps(max(Xnorm))
        error('computeKNNgraph:InappropriateDistance',...
              ['Some points have small relative standard deviations, making ', ...
               'them effectively constant.\nEither remove those points, or ', ...
               'choose a distance other than correlation.'], []);
        end
        X = X ./ Xnorm(:,ones(1,d));
end

X = double(X);

%disp(['Number of samples ' num2str(size(X,1))])

startInd = int32(1);
endInd = int32(size(centroids,1));

if ~isinteger(startInd) | ~isinteger(endInd)
    error('Indices must be integers!!')
    return
end

if ~isnumeric(startInd) | ~isnumeric(endInd)
    error('Indices must be numeric!!')
    return
end
if ( ( length(startInd) ~= 1 ) | ( length(endInd) ~= 1 ) )
    error('end and start indices must be scalars!!')
    return
end
if startInd > endInd % this happens if only one centroid is provided.
  warning('end index must be greater than start index!!')
  totSSE=NaN;SSE=NaN;miInd=NaN;miInd2=NaN;
    return
elseif startInd <= 0
    error('start index must be at least one!!')
    return
elseif endInd > size(X,1)
    error('end index must be smaller than the number of samples!!')
    return
else
    %tic
    Y = computeDistMtxBlocks_mex(X',distType,startInd,endInd);
    a = reshape(Y',size(X,1),endInd-startInd+1)';    
    a(:,1:endInd) = [];
  
    % now we have c*n distance matrix where c is the number of
    % centroids and n is the number of samples
    % tic
    [mi miInd] = min(a);
    [mi2 miInd2] = min(a');
%    SSE = zeros(1,endInd);
%    for h = 1:endInd
%       SSE(h) = sum(a(h,miInd == h).^2);
%    end
%    totSSE = sum(SSE);
R1 = repmat(miInd,size(centroids,1),1);
R2 = repmat([1:size(centroids,1)]',1,size(a,2));
SSE = sum(a(R1 == R2).^2 );
totSSE = sum(SSE);
%SSE=[];totSSE=[];

    % ssef = toc
end
