/* $Revision: 1.1.6.3 $  $Date: 2004/01/24 09:36:23 $ */

#include "mex.h"
#include <math.h>
#include <string.h>

/* Euclidean distance */

void  connComp(double *d,int numPoints,int numNeighbors,double *c,double *a)
{
    
    int i,j,k,ind,currentMax,korvattu;
    double *D0,*D1,*C0,*C1,*C2,*Ctmp,val,*A0,*A2;
    
    A0 = a;
    A2 = a;
    
    D0 = d;
    C0 = c;
    C1 = c;
    Ctmp = c;
    currentMax = 0;
        
    for ( i = 0; i < numPoints; i++, C1++ ) {
        D1 = D0 + i*numNeighbors;
/*        printf("Tutkittava piste A: %i\n",i+1);*/
        if ( *C1 == 0 ) {
            currentMax++;
            *C1 = currentMax;
        }
/*        printf("Asetetaan pisteen A klusteri: %i\n",(int)*C1);*/

        for ( j = 0; j < numNeighbors; j++, D1++ ) {
/*            printf("*Tutkittava piste B: %i\n",(int)*D1);*/
            if ( *D1 > 0 ) {
                C2 = C0 + (int)*D1 - 1;
/*                printf("*Piste B kuuluu klusteriin: %i\n",(int)*C2);*/
                if ( *C1 != *C2 ) {
                   if ( *C2 == 0 ) { /* does not belong to any cluster yet */
                       *C2 = *C1;
/*                    printf("  Asetetaan pisteen B klusteri: %i\n",(int)*C2);*/
                   } else { /* already belongs to some cluster */
                            val = *C2;
/*                            printf("  Klusteri olemassa: %i\n",(int)val);*/
                        for ( k = 0; k < numPoints; k++, Ctmp++ ) {
                            if ( *Ctmp == val ) {
/*                            printf("  Korvataan: %i\n",(int)val);*/
                                *Ctmp = *C1;
/*                            printf("  Klusterilla: %i\n",(int)*Ctmp);*/
                            }
                        }
                        Ctmp = C0;
                   }
                }

            }   
        }
    }

    C1 = C0;
    C2 = C0;
    ind = 1;
    korvattu = 0;
    for ( i = 0; i < numPoints; i++, C1++ ) {
        if (korvattu == 1) {
            ind++;
            korvattu = 0;
        }
        val = *C1;
/*        printf("Lytyi paikasta A: %i\n",i);
        printf("Arvo: %i\n",(int)val);*/
        if ( val != 0 ) {
            for ( j = 0; j < numPoints; j++, A2++, C2++ ) {
                
/*              printf("Lytyi paikasta B: %i\n",(int)j+1);
                printf("Arvo: %i\n",(int)*C2);*/
                if ( *C2 == val ) {
                korvattu = 1;
                *A2 = ind;
/*                printf("Korvataan: %i\n",(int)*A2);*/
                *C2 = 0;
                }
            }    
        }
/*        printf("stop: %i\n");*/
        A2 = A0;
        C2 = C0;
    }
    
    
    
    
    
}

/* the gateway function */
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    
    int numNeighbors,numPoints;
    
    
    
  /*  check for proper number of arguments */
  /* NOTE: You do not need an else statement when using mexErrMsgTxt
     within an if statement, because it will never get to the else
     statement if mexErrMsgTxt is executed. (mexErrMsgTxt breaks you out of
     the MEX-file) */
    if (nrhs<1) {
        mexErrMsgIdAndTxt("connComp.c:TooFewInputs",
        "One input argument required.");
    } else if (nrhs>1) {
        mexErrMsgIdAndTxt("connComp.c:TooManyInputs",
        "One input argument required.");
    } else if(nlhs>1) {
        mexErrMsgIdAndTxt("connComp.c:TooManyOutputs",
        "Too many output arguments.");
    }
    
  /* Check the type of the input array */
    if (mxIsDouble(prhs[0])) {
        double *d,*c,*a;
        
  /*  create a pointer to the input matrix y */
        d = mxGetPr(prhs[0]);
        
  /*  get the dimensions of the matrix input y */
        numPoints = mxGetN(prhs[0]);
        numNeighbors = mxGetM(prhs[0]);
        
        
  /*  set the output pointer to the output matrix */
        plhs[0] = mxCreateDoubleMatrix(1,numPoints, mxREAL);
        plhs[1] = mxCreateDoubleMatrix(1,numPoints, mxREAL);
        
/*
        plhs[0] = mxCreateNumericArray(numPoints,numNeighbors,mxUINT16_CLASS,
                                  mxREAL);*/
        
  /*  create a pointer to a copy of the output matrix */
        a = mxGetPr(plhs[0]);
        c = mxGetPr(plhs[1]);


        connComp(d,numPoints,numNeighbors,c,a);
        
    } else {
        mexErrMsgIdAndTxt("computeSNN.c:BadInputType",
        "computeSNN.c only supports real DOUBLE data.");
    }
    
}
