function [clustInd2,clustInd] = postProcessClusters(idx,k,X,featureSet,brain)
%
% function to lear too small clusters off from the result
% Usage: [clustInd2,clustInd] = postProcessClusters(idx,k,X,featureSet,brain)
% idx is the indexes from FuSeclustering
% k is the neighbourghood size
% X is the orignal feature matrix
% feature set defines the used features see "help returnFeatures"
% brain is the binary 3D template of the used brain area  
%
% Jukka-Pekka Kauppi 31.10.2014

X = returnFeatures(X,featureSet);

%find the common brain voxels
brain_voxels = find(brain.img == 1);

% set clusters to anatomical image:
brainsize = size(brain.img);
%map the results back to the spatial domain
result = zeros(brainsize);
result(brain_voxels)=idx;

% for each cluster m, find their subclusters:
clear clustCent clustInd densestPoint
TH = k % threshold to remove too small spatial regions, this could correspond to k.
L = unique(nonzeros(result));
for m = 1:max(L)
   BW = result == L(m);
   CC = bwconncomp(BW);
   ite = 1;
   for n = 1:length(CC.PixelIdxList)
      if length(CC.PixelIdxList{n}) >= TH
     [I,i1] = intersect(brain_voxels,CC.PixelIdxList{n});
     clustCent{m,ite} = mean(X(i1,:),1);
         clustInd{m,ite} = CC.PixelIdxList{n};
         ite = ite + 1;
      end
   end
end

% if ALL subclusters for some main cluster are smaller than k, remove the entire main cluster:
retain = zeros(size(clustInd,1),1);
for m = 1:size(clustInd,1)
    if ~isempty(clustInd{m,1})
     retain(m)  = 1;
    end
end
clI = [];
ite = 1;
for m = 1:size(clustInd,1)
   if retain(m)
       for n = 1:size(clustInd,2)
            clI{ite,n} = clustInd{m,n};
       end
       ite = ite + 1;
   end
end
clustInd = clI;


% collect also indices of the main clusters for visualization:
clear clustInd2
for m = 1:size(clustInd,1)
    clustInd2{m} = [];
    for n = 1:size(clustInd,2)
        clustInd2{m} = [clustInd2{m} ;clustInd{m,n}];
    end
end
