function [clustMedBest,nrClusters,SSEtot,clustMedBest2,SSEtot2,clustMedPointsBest] = SNNinitialize4(Data,k,distType,nearestNeighborInds,nearestNeighborDists,stepTh)

DataOrig = Data;
clustMedBest2 = [];
clustMedBest = [];
nrClusters = [];
SSEtot = [];
switch distType
    case 'cor' % Correlation
%        Data = normData(Data);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% For every distinct parameter k obtain SNN graph and SNN densities:
disp(['k = ' num2str(k)])
densVals = computeSNNgraph_mex(nearestNeighborInds');
densVals=densVals';
snnInds = nearestNeighborInds;
snnInds(densVals==0) = 0;
snnDensities = sum(densVals,2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Obtain sparsification thresholds based on SNN densities:
Ths = unique(snnDensities);Ths = Ths(1:end-1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Find initialization points using graph sparsification.

% The maximum possible number of sparsification thresholds is k^2.
% Thus, when k is very small, it is wise to go through every threshold
% to guarantee good approximation:
clustMedBest = [];
ThSteps = 1:stepTh:length(Ths);
nrSteps = length(ThSteps);
nrClusters = NaN*zeros(1,length(Ths));
SSEtot = NaN*zeros(1,length(Ths));
currentMin = inf;
iter = 0;
for m = ThSteps
    iter = iter + 1;
        % disp(['Th ' num2str(iter) '/' num2str(nrSteps) ': ' num2str(Ths(m)) '(' num2str(Ths(end)) ')'])
        % Sparsify SNN graph, get connected components:
        % [nrClusters(m),clustMed] = getInitPoints(snnDensities,Ths(m),snnInds,nearestNeighborDists);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % SNN graph sparsification:
        sparsVals = double(snnDensities < Ths(m)); % obtain sparsified data points
        ZZ = sparsifyGraph_mex(snnInds',sparsVals'); % sparsify SNN graph
        connC = connComp_mex(ZZ); % get labels of connected components
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Compute initialization points and SSE. Consider only non-singleton clusters:
        nrSamples = hist(connC,min(connC):max(connC));
        clusterIndicesNoSingletons = find(nrSamples~=1);
        clustMed = zeros(length(clusterIndicesNoSingletons),1);
        clustMed2 = zeros(length(clusterIndicesNoSingletons),size(Data,1));
        clustMed3 = clustMed2;
        clear clustMedPoints
        if length(clusterIndicesNoSingletons) >= 2
            for n = 1:length(clusterIndicesNoSingletons)
                % get connected points:
                densestPoints = find(connC == clusterIndicesNoSingletons(n));
                % take the densest point:
                [mi mii] = min(nearestNeighborDists(densestPoints));
                clustMed(n,:) = densestPoints(mii);
                % take mean of the connected points:
               Mea = mean(Data(:,densestPoints),2)';
               if strcmp(distType,'cor')
                   Mea = Mea - mean(Mea);
                   Mnorm = sqrt(sum(Mea.^2));
                   Mea = Mea./Mnorm(:,ones(1,size(Mea,2)));
               end
               clustMed2(n,:) = Mea;
               clustMed3(n,:) = mean(DataOrig(:,densestPoints),2)';
               clustMedPoints{n} = densestPoints;
            end
            nrClusters(m) = length(clusterIndicesNoSingletons);
%            SSEtot(m) = computeMSE2(Data',distType,clustMed2,'datapoint');
             SSEtot2(m) = computeMSE(Data',distType,clustMed2);
             SSEtot(m) = computeMSE(Data',distType,Data(:,clustMed)');
            disp(['Number of clusters found: ' num2str(nrClusters(m))])
        else
            nrClusters(m) = NaN;
            SSEtot(m) = NaN;
            SSEtot2(m) = NaN;
        end
        
    % update current best solution:
    if SSEtot(m) < currentMin
        currentMin = SSEtot(m);
        clustMedBest = clustMed;
        clustMedBest2 = clustMed3;
        clustMedPointsBest = clustMedPoints;
    end
end

clustMed = [];

% After finding approximate solutions, find the final solution between
% the two best approximate solutions:

if stepTh > 1
    totSSEtmp = SSEtot;
    [miSSE1 miIndSSE1] = min(totSSEtmp)
    totSSEtmp(miIndSSE1) = NaN;
    [miSSE2 miIndSSE2] = min(totSSEtmp)
    iter = 0;
    sortedInds = sort([miIndSSE1 miIndSSE2])
    nrSteps = length(sortedInds(1):floor(k/10):sortedInds(2));

    disp(' ')
    disp(['Get final threholds...'])
    for v = sortedInds(1):floor(k/10):sortedInds(2)
        iter = iter + 1;
        disp(['Th ' num2str(iter) '/' num2str(nrSteps) ': ' num2str(Ths(v)) '(' num2str(Ths(sortedInds(2))) ')'])

        % Sparsify SNN graph, get connected components, find their
        % medians and compute SSE:
        % [nrClusters(m),clustMed] = getInitPoints(snnDensities,Ths(v),snnInds,nearestNeighborDists);

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % SNN graph sparsification:
        sparsVals = double(snnDensities < Ths(v)); % obtain sparsified data points
        ZZ = sparsifyGraph_mex(snnInds',sparsVals'); % sparsify SNN graph
        connC = connComp_mex(ZZ); % get labels of connected components
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Compute initialization points and SSE. Consider only non-singleton clusters:
        nrSamples = hist(connC,min(connC):max(connC));
        clusterIndicesNoSingletons = find(nrSamples~=1);
        clustMed = zeros(length(clusterIndicesNoSingletons),1);
        clustMed2 = zeros(length(clusterIndicesNoSingletons),size(Data,1));
        clustMed3 = clustMed2;
        clear clustMedPoints
        if length(clusterIndicesNoSingletons) >= 2
            for n = 1:length(clusterIndicesNoSingletons)
                % get connected points:
                densestPoints = find(connC == clusterIndicesNoSingletons(n));
                % take median of the connected points:
                [mi mii] = min( nearestNeighborDists(densestPoints) );
                
                clustMed(n,:) = densestPoints(mii);
                Mea = mean(Data(:,densestPoints),2)';
                if strcmp(distType,'cor')
                    Mea = Mea - mean(Mea);
                    Mnorm = sqrt(sum(Mea.^2));
                    Mea = Mea./Mnorm(:,ones(1,size(Mea,2)));
                end
                clustMed2(n,:) = Mea;
                clustMedPoints{n} = densestPoints;
                clustMed3(n,:) = mean(DataOrig(:,densestPoints),2)';
            end
            nrClusters(v) = length(clusterIndicesNoSingletons);
            %SSEtot(v) = computeMSE(Data',distType,clustMed);
            %SSEtot(v) = computeMSE2(Data',distType,clustMed2,'datapoint');
            SSEtot2(v) = computeMSE(Data',distType,clustMed2);
            SSEtot(v) = computeMSE(Data',distType,Data(:,clustMed)');

            
            %            disp(['Number of clusters found: ' num2str(nrClusters(m))])
        else
            nrClusters(v) = NaN;
            SSEtot(v) = NaN;
            SSEtot2(v) = NaN;
        end
                
        % update current best solution:
        if SSEtot(v) < currentMin
            currentMin = SSEtot(v);
            clustMedBest = clustMed;
            clustMedBest2 = clustMed3;
            clustMedPointsBest = clustMedPoints;
        end
    end

end



