/* computeDistMtxBlocks_mex.c
 The computation of specified rows of the distance matrix.
*/

/* Date: 2011/08/01 18:23:23 $ */

#include "mex.h"
#include <math.h>
#include <string.h>

/* Euclidean distance */
void eucdist(double *x, int m, int n, int startInd, int endInd, double *d)
{
    
    int i,j,k;
    double theSum,Y;
    double *XI, *XJ, *XI0;
    
    
    XI = x + (startInd-1)*n;
    XJ = x;
    for (i=0; i<(endInd-startInd+1); i++) {
        
        XI0 = XI;
        for (j=0; j<m; j++) {
            XI = XI0;
            theSum = 0;
            for (k=0;k<n;k++,XI++,XJ++){
                Y = (*XI)-(*XJ);
                theSum += Y*Y;
            }
            *(d++) = sqrt(theSum);
            
        }
        XJ = x;
    }
}


/* Cosine and Correlation distances */
void cordist(double *x, int m, int n, int startInd, int endInd, double *d)
{
    int i,j,k;
    double theSum;
    double *XI, *XJ, *XI0;
    
    
    XI = x + (startInd-1)*n;
    XJ = x;
    for (i=0; i<(endInd-startInd+1); i++) {
        
        XI0 = XI;
        for (j=0; j<m; j++) {
            XI = XI0;
            theSum = 0;
            for (k=0;k<n;k++,XI++,XJ++){
                theSum += (*XI)*(*XJ);
            }
            *(d++) = 1-theSum;
            
        }
        XJ = x;
    }
    
}

#define START_IND prhs[2]
#define END_IND prhs[3]

/* the gateway function */
void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    int     status,numCoords,numPoints,startInd,endInd;
    char	metric[4];
    
  /*  check for proper number of arguments */
  /* NOTE: You do not need an else statement when using mexErrMsgTxt
     within an if statement, because it will never get to the else
     statement if mexErrMsgTxt is executed. (mexErrMsgTxt breaks you out of
     the MEX-file) */
    if (nrhs<4) {
        mexErrMsgIdAndTxt("computeDistMtxBlocks_mex.c:TooFewInputs",
        "Four input arguments required.");
    } else if(nrhs>4) {
            mexErrMsgIdAndTxt("computeDistMtxBlocks_mex.c:TooManyInputs",
            "Four input arguments required.");
        } else if(nlhs>1) {
            mexErrMsgIdAndTxt("computeDistMtxBlocks_mex.c:TooManyOutputs",
            "Too many output arguments.");
        }
        
    /*  get the metric */
        status = mxGetString(prhs[1],metric,4);
        
  /* Check the type of the input array */
        if (mxIsDouble(prhs[0])) {
            double *x,*d;
  /*  create a pointer to the input matrix y */
            x = mxGetPr(prhs[0]);
            
  /*  get the dimensions of the matrix input y */
            numCoords = mxGetM(prhs[0]);
            numPoints = mxGetN(prhs[0]);
            
            startInd = (int) mxGetScalar(START_IND);
            endInd = (int) mxGetScalar(END_IND);
            
  /*  set the output pointer to the output matrix */
            plhs[0] = mxCreateDoubleMatrix(1,(numPoints * (endInd - startInd + 1)), mxREAL);
            
  /*  create a pointer to a copy of the output matrix */
            d = mxGetPr(plhs[0]);
            
  /*  call the appropriate distance subroutine */
            if (strcmp(metric,"euc") == 0)
                eucdist(x,numPoints,numCoords,startInd,endInd,d);
            else if(strcmp(metric,"cor") == 0)
                cordist(x,numPoints,numCoords,startInd,endInd,d);
            else {
                mexErrMsgIdAndTxt("computeDistMtxBlocks_mex:BadInputType",
                "distance must be either euc or cor.");
            }
    /* deal with non double types */
        } else {
            mexErrMsgIdAndTxt("computeDistMtxBlocks_mex.c:BadInputType",
            "computeDistMtxBlocks_mex only supports real DOUBLE data.");
        }
        
    }
