function [Clust,X] = load_files(Params)

if Params.PublicParams.FuSe_reg_opt
    reguType = 'Regularized';
else
    reguType = 'NonRegularized';
end
if Params.PublicParams.FuSe_Diag
    covType = 'Diagonal';
else
    covType = 'Full';
end
Fset = Params.PublicParams.FuSe_FSet;

if Params.PublicParams.FuSe_multiK
    kvals = Params.PublicParams.FuSe_minK:Params.PublicParams.FuSe_stepK:Params.PublicParams.FuSe_maxK;
    disp('Multiple k-values evaluated, choose one of them based on the shown graph.')
    ite = 1;
    nrClust = zeros(1,length(kvals));
    for k = kvals
        fil = ['FuSeClusters_Fset' num2str(Fset) '_K' num2str(k) '_' covType ...
            '_' reguType '.mat'];
        file2 = [Params.PublicParams.dataDestination 'FuSe/' fil];
        if exist(file2) == 2
            load(file2,'SNN');
            nrClust(ite) = size(SNN.clustCent,1);
            ite = ite + 1;
        else
            disp('FuSeISC results missing!')
            disp(['Cannot find file: ' file2])
            return
        end
    end
    figure,plot(kvals,nrClust,'bo-');grid on;
    xlabel('Neighborhood size (k)');
    ylabel('Number of clusters')
    set(gca,'XTick',kvals)
    
    prompt = {'Enter k-value:'};
    title = 'FuSeISC input';
    lines = 1;
    
    [mi,mii] = min(nrClust);
    
    def = {num2str(kvals(mii))};
    flag = 1;
    while flag
        answer = inputdlg(prompt,title,lines,def);
        if isempty(answer)
            flag = 0;
            k = kvals(end);
        else
            res = str2double(answer);
            if length(res) == 1
                fi = find(kvals == res);
                if length(fi) == 1
                    flag = 0;
                    k = kvals(fi);
                end
            end
        end
    end
else
    k = Params.PublicParams.FuSe_K;
end
disp(['Loading segmentation result for k = ' num2str(k) '...'])

fil = ['FuSeClusters_Fset' num2str(Fset) '_K' num2str(k) '_' covType ...
    '_' reguType '.mat'];

file1 = [Params.PublicParams.dataDestination 'FuSe/X.mat'];
file2 = [Params.PublicParams.dataDestination 'FuSe/' fil];

if exist(file1) == 2
    load(file1)
else
    disp('FuSeISC mean and variability features missing!')
    disp(['Cannot find file: ' file1])
    return
end

if exist(file2) == 2
    Clust = load(file2);
else
    disp('FuSeISC results missing!')
    disp(['Cannot find file: ' file2])
    return
end
