function plot_GMM_centers(Clust,results,IM,colM,clustersToVisualize,Di,Me,E,clipNames)

data = Clust.GMM.mu;

plotCorr = 0;

if plotCorr
    rows = 5;
else
    rows = 4;
end
IM = squeeze(IM);
IM = rot90(rot90(rot90(IM)));
im = unique(IM);
cl_ind = sort(im(1:length(clustersToVisualize))');
IM(IM > cl_ind(end)) = 0;
un = unique(IM);
ite = 1;
for m = 1:length(un)
    if un(m) > 0
        IM(IM==un(m)) = ite;
        ite = ite + 1;
    end
end

Nam = results.clusterNames;

nr_clust = length(clustersToVisualize);
Tick = 1:nr_clust;
%% draw the figure
figure
S1 = subplot(rows,1,1);
hold on
for nn = 1:nr_clust
    bar(nn,0.5,'facecolor',colM(nn+2,:),'edgecolor',colM(nn+2,:));
end
xlim([0.5 nr_clust+0.5])
set(gca,'XTick',Tick,'XTickLabel',results.clusterNumbers,'YTick',[])
set(gcf,'Units','Normalized')
pos = get(gcf,'Position');
set(gcf,'Position',[0.1 0.1 0.7 0.7])

PO1 = get(S1,'Position');
if plotCorr
    set(S1,'Position',[PO1(1) 0.92 PO1(3) 0.04],'Visible','off')
end
lineSettings = {'linestyle','none','color','k'};
barSettings = {'stacked'};
lineSettings = {};
S2 = subplot(rows,1,2);
[b,e] = errorbarbar(Tick,data(clustersToVisualize,2:2:end),E(clustersToVisualize,2:2:end),barSettings,lineSettings);
ylabel('mean')
set(gca,'XTick',Tick,'XTickLabel',results.clusterNumbers)
set(gca,'XTick',1:nr_clust,'XTickLabel',[])
if plotCorr
    set(gca,'Position',[PO1(1) 0.75 PO1(3) PO1(4)])
else
    set(gca,'Position',[0.1300 0.65 0.7750 0.33])    
end
grid on
xlim([0.5 nr_clust+0.5])
l2 = legend(clipNames,'Orientation','horizontal','Location','NorthWest');
lp2 = get(l2,'Position');
%set(l2,'Position',[lp2(1) 0.70 lp2(3) 0.04])

S3=subplot(rows,1,3);
MM=data(clustersToVisualize,2:2:end);
VV=data(clustersToVisualize,1:2:end);
%DD=MM./VV;
DD=VV./MM;

[b,e, colM2] = errorbarbar(Tick,DD,E(clustersToVisualize,1:2:end),barSettings,lineSettings);
%[b,e, colM2] = errorbarbar(Tick,data(clustersToVisualize,1:2:end),E(clustersToVisualize,1:2:end),barSettings,lineSettings);
%colM2 = [1 0 0; 0 1 0; 0 0 1; 1 0.6 0; 0 1 1];
%colM2 = colormap(cool(5));
ylabel('variability')
% set(gca,'XTick',Tick,'XTickLabel',results.clusterNumbers)
set(gca,'XTick',1:nr_clust,'XTickLabel',[])
if plotCorr
    set(gca,'Position',[PO1(1) 0.52 PO1(3) PO1(4)])
else
   set(gca,'Position',[0.1300 0.28 0.7750 0.33]) 
end   
grid on
%ylim([0 0.7])
xlim([0.5 nr_clust+0.5]);
l3=legend(clipNames,'Orientation','horizontal','Location','NorthWest');
lp3 = get(l3,'Position');
if plotCorr
    set(l3,'Position',[lp3(1) 0.47 lp3(3) 0.04])
end
if plotCorr
    S4 = subplot(rows,1,4);
    hold on
    C = zeros(size(Clust.GMM.Sigmas));
    Di = zeros(size(Clust.GMM.Sigmas,3),size(Clust.GMM.Sigmas,2)-1);
    for mm = 1:size(Clust.GMM.Sigmas,3)
        S = Clust.GMM.Sigmas(:,:,mm);
        for nn = 1:size(S,1)
            for hh = 1:size(S,2)
                st1 = sqrt(S(nn,nn));
                st2 = sqrt(S(hh,hh));
                C(nn,hh,mm) = S(nn,hh)/(st1*st2);
            end
        end
        Di(mm,:) = diag(C(:,:,mm),1);
    end
    
    Ma{1} = 'o';Ma{2} = 's';Ma{3} = 'd';Ma{4} = 'x';Ma{5} = '+';
    Ma{6} = '^';Ma{7} = '<';Ma{8} = '>';Ma{9} = 'v';Ma{10} = '.';
    Ma{11} = 'o';Ma{12} = 's';Ma{13} = 'd';Ma{14} = 'x';Ma{15} = '+';
    Ma{16} = '^';Ma{17} = '<';Ma{18} = '>';Ma{19} = 'v';Ma{20} = '.';
    
    Fea = Di(clustersToVisualize,1:2:end)';
    
    Me = mean(Fea,1);
    plot(Me,'k','LineWidth',2)
    hold on
    for nn = 1:size(Fea,1)
        plot(Fea(nn,:),'Color',colM2(nn,:),'Marker',Ma{nn},'LineStyle','none')
    end
    ylabel('correlation')
    grid on
    xlim([0.5 nr_clust+0.5])
    nam2 = cell(1,length(clipNames)+1);
    nam2{1} = 'mean';
    nam2(2:end) = clipNames;
    l4 = legend(nam2,'Orientation','horizontal','Location', 'NorthWest');
    
    %set(gca,'XTick',1:nr_clust,'XTickLabel',results.clusterNumbers)
    set(gca,'XTick',1:nr_clust,'XTickLabel',[],'Position',[PO1(1) 0.30 PO1(3) PO1(4)])
    grid on
    ylim([-1.01 1.01])
    xlim([0.5 nr_clust+0.5])
    
    lp4 = get(l4,'Position');
    set(l4,'Position',[lp4(1) 0.25 lp4(3) 0.04])
    
end

if plotCorr
    S5=subplot(rows,1,5);
else
    S5=subplot(rows,1,4);
end

hold on
for nn = 1:nr_clust
    bar(nn,1,'facecolor',colM(nn+2,:),'edgecolor',colM(nn+2,:))
end
xlim([0.5 nr_clust+0.5])
set(gca,'YTick',[],'XTick',Tick,'XTickLabel',Nam,'XTickLabelRotation',15)
PO2 = get(S5,'Position');
set(S5,'Position',[PO2(1) 0.15 PO2(3) 0.04])

