function [IM,colM,LL,Zval2,clust_ind] = plot_clusters(clust_ind,results,brain,leikkeet,AffMat,textOffset,style,Th,contrast_val,nrColumns,Dat,rem_noise,plot_best,dataName)

clusterNames = results.clusterNames;

switch style
    case 'ISCcomb'
        
        quant_factor = 100; % isc map quant factor
        figure
        colM = [1 0 0; 0 1 0; 0 0 1; 1 0.6 0; 0 1 1];
        
        for mm = 1:size(brain.img,3)
            brain.img(:,:,mm) = quant(brain.img(:,:,mm),contrast_val);
        end
        
        colM = [[0 0 0];colM];
        Un = nonzeros(unique(brain.img));
        Br_tmp = brain.img;
        for mm = 1:length(Un)
            Br_tmp(find(brain.img==Un(mm))) = mm;
        end
        brain.img = Br_tmp;
        
        nr_intens_lev = length(brain.img);
        Cm = colormap(gray(nr_intens_lev));
        FirstGrayLev = size(colM,1);
        colM = [colM;Cm];
        set(gcf,'Colormap',colM)
        D = double(brain.img);
        D = D + FirstGrayLev;
        D = D + 1;
        D_isc_map = D; % + 100 - FirstGrayLev;
        
        Im = clust_ind;
        D_isc_map(Im.img>0) = Im.img(Im.img>0);
        D_isc_map(D==7) = 0;
        ISCmap = zeros(size(brain.img,2),size(brain.img,1),1,size(brain.img,3));
        for mm = 1:size(brain.img,3)
            ISCmap(:,:,mm) = rot90(D_isc_map(:,:,mm));
        end
        
        ISCmap = squeeze(ISCmap);
        IM = ISCmap;
        IM2 = IM;
        IM = IM + 1;
        IM2 = IM2 + 1;
        
    case 'ISCmap'
        
        nr_clust = 60;
        quant_factor = 100; % isc map quant factor
        figure
        colM = colormap(hot(nr_clust));
        
        for mm = 1:size(brain.img,3)
            brain.img(:,:,mm) = quant(brain.img(:,:,mm),contrast_val);
        end
        
        colM = [[0 0 0];[1 1 1]*0.8;colM];
        Un = nonzeros(unique(brain.img));
        Br_tmp = brain.img;
        for mm = 1:length(Un)
            Br_tmp(find(brain.img==Un(mm))) = mm;
        end
        brain.img = Br_tmp;
        
        nr_intens_lev = length(brain.img);
        Cm = colormap(gray(nr_intens_lev));
        FirstGrayLev = size(colM,1);
        colM = [colM;Cm];
        set(gcf,'Colormap',colM)
        D = double(brain.img);
        D = D + FirstGrayLev;
        D = D + 1;
        
        D_isc_map = D; % + 100 - FirstGrayLev;
        
        % ISC kartta:
        %        Im = load_nii('ISCcorrmapBand0Session1.nii');
        Im = clust_ind;
        P = Im.img > Th;
        Th = Th*quant_factor;
        Im.img = round(Im.img*quant_factor);
        D_isc_map(P) = Im.img(P);
        isc_val = Im.img(P);
        mima = [min(isc_val(:)) max(isc_val(:))];
        D_isc_map(D_isc_map==101) = 0;
        ISCmap = zeros(size(brain.img,2),size(brain.img,1),1,size(brain.img,3));
        for mm = 1:size(brain.img,3)
            ISCmap(:,:,mm) = rot90(D_isc_map(:,:,mm));
        end
        ISCmap = squeeze(ISCmap);
        IM = ISCmap;
        IM2 = IM;
        
    case 'clustermap'
        
        plotCentres = 0;
        
        clust = results.clustInd(clust_ind);
        nr_clust = length(results.clustInd);
        figure;set(gcf,'Units','Normalized','Position',[0.03 0.1 0.9 0.7])
        Nr_clust = nr_clust+2;
        %        Nr_clust = 24;
        colM = distinguishable_colors(Nr_clust+10);
        %        rp = randperm(size(colM,1));
        %        colM = colM(rp,:);
        
        colM(find(sum(colM,2)<0.5),:) = [];
        colM = colM(1:(Nr_clust+3),:);
        
        colM_clusters = colM(1:Nr_clust,:);
        colM_other = colM((Nr_clust+1):end,:);
        colM_clusters = colM_clusters(clust_ind,:);
        colM = [colM_clusters;colM_other];
        
        ind = [1 2];
        colM(ind(1),:) = colM(ind(1),:) - 0.2;
        colM(ind(1),colM(ind(1),:) < 0) = 0;
        colM(ind(2),:) = colM(ind(2),:) + 0.2;
        colM(ind(2),colM(ind(2),:) > 1) = 1;
        
        for mm = 1:size(brain.img,3)
            brain.img(:,:,mm) = quant(brain.img(:,:,mm),contrast_val);
        end
        
        %clust_ind1 = clust_ind;
        %save clust_ind1 clust_ind1
        
        %clust_ind2 = clust_ind;
        %save clust_ind2 clust_ind2
        %subclust1 = results.subclusters;
        %save subclust1 subclust1
        %        colM = colM(7:end,:);
        %        MNI_com2 = results.MNI_com;
        %        clust_ind2 = clust_ind;
        %        save MNI_com2 MNI_com2 clust_ind2
        %Dat = 1;
        %rem_noise = 1;
        %plot_best = 1;
%        load colM
%save colMr colM
%return

        if ~isempty(Dat)
            
            if Dat == 1
                subclust1 = results.subclusters;
                %    save colM colM
                if strcmp(dataName,'restingstate')
                    load colMr
                else
                    load colM                
                end
                
                if plot_best == 1
                    load(['clust_ind1_' dataName '.mat'])
                elseif plot_best == 0
                    load(['clust_ind1w_' dataName '.mat'])
%                    colM = colM(9:end,:);
                elseif plot_best == -1
                    load(['clust_ind1r_' dataName '.mat'])
 %                   colM = colM(15:end,:);
                else
                    error
                end
                clust_ind = clust_ind1;
                load(['V_' dataName '.mat'])
                if rem_noise                    
                    fi = [];
                    for nn = 1:length(results.removedInd)
                        fi = [fi;find(clust_ind == results.removedInd(nn))];
                    end
                    clust_ind(fi) = [];
                    V(fi) = [];
                end
                removed_clusts1 = results.removedInd;
                save(['V2_' dataName '.mat'],'V','clust_ind','removed_clusts1','subclust1')
                %   results = create_cluster_names(results,clust_ind);
            else
                
                if strcmp(dataName,'restingstate')
                    load colMr
                else
                    load colM                
                end
                if plot_best == 1
                    load(['clust_ind1_' dataName '.mat'])
                    load(['clust_ind2_' dataName '.mat'])
                elseif plot_best == 0
                    load(['clust_ind1w_' dataName '.mat'])
                    load(['clust_ind2w_' dataName '.mat'])
%                    colM = colM(9:end,:);
                else
                    error
                end
                
                if rem_noise

                    load(['V2_' dataName '.mat'],'removed_clusts1','subclust1')
                    subclust2 = results.subclusters;

                    for nn = 1:length(removed_clusts1)
                        clust_ind1(clust_ind1 == removed_clusts1(nn)) = [];
                    end                    
                    for nn = 1:length(results.removedInd)
                        clust_ind2(clust_ind2 == results.removedInd(nn)) = [];
                    end                    
                                        
                end
                
                clust_ind = clust_ind2;
                %    load colM colM
                colM = match_colors(colM,clust_ind1,clust_ind2,subclust1,subclust2);
                %    results = create_cluster_names(results,clust_ind);
            end
        end
        colM = [[0 0 0];[1 1 1]*0.8;colM];
        Un = nonzeros(unique(brain.img));
        Br_tmp = brain.img;
        for mm = 1:length(Un)
            Br_tmp(find(brain.img==Un(mm))) = mm;
        end
        brain.img = Br_tmp;
        
        nr_intens_lev = length(brain.img);
        Cm = colormap(gray(nr_intens_lev));
        FirstGrayLev = size(colM,1);
        colM = [colM;Cm];
        
        set(gcf,'Colormap',colM)
        D = double(brain.img);
        D = D + FirstGrayLev;
        D = D + 1;
        
        % listn klusterit:
        clear LL
        for mm = 1:length(clust_ind)
            D(find(D==FirstGrayLev)) = 0;
            for mmm = 1:length(results.subclusters{clust_ind(mm)})
                D(results.subclusters{clust_ind(mm)}{mmm}) = mm + 2;
            end
            %            D(results.clustInd{clust_ind(mm)}) = mm+2;%nn+1;%clust_ind(nn) + 1;
            LL(mm) = length(results.clustInd{clust_ind(mm)});
        end
        
        IM = zeros(size(brain.img,2),size(brain.img,1),1,size(brain.img,3));
        for mm = 1:size(brain.img,3)
            IM(:,:,mm) = rot90(D(:,:,mm));
        end
        
        IM2 = IM;
        un = unique(IM);
        un = un(find(un > 1 & un < nr_clust+3));
        for s = 1:length(un)
            IM2(IM==un(s)) = (s+1);
        end
end

Ha = gca;
ite = 1;
IM2 = squeeze(IM);
IMvol = IM2;


IM2 = IM2(:,:,leikkeet);
ZZ = size(IM2,3);
IM2 = IM2(:,:,ZZ:-1:1);

% plot images:
NN = floor(ZZ/nrColumns);
L = 2;
offset_y = 8;
offset_x = textOffset;

Dtot = [];
for m = 1:NN
    D = [];
    for n = 1:nrColumns
        D = [D size(colM,1)*ones(size(squeeze(IM2(:,:,ite)),1),L) squeeze(IM2(:,:,ite))];
        paikka_x(m,n) = size(D,2)-size(IM2,2)-L + 1 + offset_x;
        paikka_y(m,n) = offset_y + (size(IM2,1)+L)*(m-1);
        ite = ite + 1;
    end
    D = [D size(colM,1)*ones(size(IM2,1),L)];
    D = [D;size(colM,1)*ones(L,size(D,2))];
    Dtot = [Dtot;D];
end
% Dtot = [size(colM,1)*ones(L,size(Dtot,2));Dtot];
%
% if nrColumns == 1
%     sizeR = size(Dtot,1);
%     sizeIm = floor(sizeR/3);
%     Dtot2 = [Dtot(1:sizeIm,:) Dtot((sizeIm+1):(2*sizeIm),:) Dtot((2*sizeIm+1):(3*sizeIm),:)];
%     Dtot = Dtot2;
% end

image(Dtot);

Voxel_index_of_mni_origin = round(inv(AffMat)*[0 0 0 1]')+1;
vox_ind = [Voxel_index_of_mni_origin(1)*ones(size(brain.img,3),1)-1 Voxel_index_of_mni_origin(2)*ones(size(brain.img,3),1)-1 (1:size(brain.img,3))'-1 ones(size(brain.img,3),1)];
B = AffMat*(vox_ind)';

Zval2 = round(B(3,:)*10)/10;
Zval2 = Zval2(leikkeet);
Zval2 = Zval2(length(Zval2):-1:1);

switch style
    case 'ISCcomb'
        
        nr_clips = length(clusterNames);
        H = colorbar('peer',Ha);
        %set(H,'YTick',yt,'YTickLabel',clusterNames,'YLim',[2.5 max(yt)+0.5])
        set(H,'Direction','reverse')
        yt = (size(get(gcf,'Colormap'),1)-nr_clips):(size(get(gcf,'Colormap'),1));
        set(H,'YLim',[yt(1) yt(end)])
        set(H,'YTick',yt+0.5,'YTickLabel',clusterNames)
        
    case 'ISCmap'
        
        H = colorbar('peer',Ha);
        set(H,'YLim',[Th nr_clust])
        yt = 0:10:nr_clust;
        %yt = sort([Th yt]);
        ytl = yt/quant_factor;
        set(H,'YTick',yt,'YTickLabel',ytl)
    case 'clustermap'
        H = colorbar('peer',Ha);
        yt = 3:(length(clust_ind)+2);
        % set(H,'YTick',yt,'YTickLabel',clusterNames,'YLim',[2.5 max(yt)+0.5])
        set(H,'Direction','reverse')
        yt = (size(get(gcf,'Colormap'),1)-length(clust_ind)-1):(size(get(gcf,'Colormap'),1)-1);
        set(H,'YLim',[yt(1) yt(end)])
        set(H,'YTick',yt+0.5,'YTickLabel',clusterNames)
end

hold on;

ite = 1;
for m = 1:NN
    for n = 1:nrColumns
        fl = 0;
        if Zval2(ite) > 0
            %            S = '+';
            S = '';
        else
            S = char(hex2dec('2212'));
            fl = 1;
            %            S = texlabel('\textemdash');
        end
        if Zval2(ite) == round(Zval2(ite))
            D = '.0';
        else
            D = '';
        end
        Zval2(ite) = abs(Zval2(ite));
        if length([S num2str(Zval2(ite)) D]) < 4
            paikka_x(m,n) = paikka_x(m,n) + 5;
        elseif length([S num2str(Zval2(ite)) D]) == 5
            paikka_x(m,n) = paikka_x(m,n) - 7;
            
        elseif length([S num2str(Zval2(ite)) D]) == 4 && fl
            paikka_x(m,n) = paikka_x(m,n) - 3;
        else
            
        end
        %      text(paikka_x(m,n),paikka_y(m,n),['z = ' S num2str(Zval2(ite)) D ' mm'],'Color',[1 1 1]*1,'Units','data','FontSize',7)
        text(paikka_x(m,n),paikka_y(m,n),[S num2str(Zval2(ite)) D],'Color',[1 1 1]*1,'Units','data','FontSize',7)
        ite = ite + 1;
    end
end


axis tight
axis equal
axis off
zoom on


if 0
    figure,subplot(121);
    I = ARIs_stability{3};
    I=tril(I);
    imagesc(KK,KK,rot90(I),[0 1]);
    xlabel('k');ylabel('k');set(gca,'XTick',KK,'YTick',KK);
    axis equal;H=colorbar;R=get(H,'XLabel');
    set(R,'String','ARI');xlim([min(KK)-12.5 max(KK)+12.5]);
    ylim([min(KK)-12.5 max(KK)+12.5]);
    I = ARIs_stability{1};
    I=tril(I);
    subplot(122);imagesc(KK,KK,rot90(I),[0 1]);
    set(gca,'XTick',KK,'YTick',KK);xlabel('k');ylabel('k');
    axis equal;H=colorbar;R=get(H,'XLabel');set(R,'String','ARI');
    xlim([min(KK)-12.5 max(KK)+12.5]);ylim([min(KK)-12.5 max(KK)+12.5])
end

