function plot_segment(Fuse,cluster_index,slices_z)
% This function allows visualization of the Fuse segments one at a time.
% Inputs:
% Fuse - a struct containing the Fuse map (see loadSegmentationResults).
% cluster_index (scalar) - index of the segment to visualize (e.g. 1,2,3...).
% slices_z (vector) - a vector axial slices used to plot the anatomical
% images.
% 
% Example:
% [Fuse,R] = loadSegmentationResults(Params);
% plot first 6 segments:
% for m = 1:6
%   plot_segment(Fuse,m,[10:10:80]) 
% end

load colMap_large.mat
colM = [[0 0 0];[1 1 1]*0.8;colM];
brain_img = Fuse.brain_MNI.img;
for mm = 1:size(brain_img,3)
    brain_img(:,:,mm) = quant(brain_img(:,:,mm),45);
end
Un = nonzeros(unique(brain_img));
Br_tmp = brain_img;
for mm = 1:length(Un)
    Br_tmp(find(brain_img==Un(mm))) = mm;
end
brain_img = Br_tmp;
nr_intens_lev = length(Un);
Cm = colormap(gray(nr_intens_lev));
FirstGrayLev = size(colM,1);
colM = [colM;Cm];
set(gcf,'Colormap',colM)
D = double(brain_img);
D = D + FirstGrayLev;
D = D + 1;
for m = 1:size(D,3)
    segMap = Fuse.map(:,:,m);
    D2 = D(:,:,m);
    D2(segMap == cluster_index) = cluster_index + 2;
    D(:,:,m) = D2;
end
D2 = [];
for m = 1:length(slices_z)
    D2 = [D2 rot90(D(:,:,slices_z(m)))];
end
figure;image(D2);axis equal;set(gcf,'Colormap',colM)

axis off
title(['Segment #' num2str(cluster_index)])
