function log_path = initScriptsFolder(Params)
%Function to initialize the scripts folder for log files and cluster
%scripts
% Juha Pajula, 30.10.2017

if ~exist([Params.PublicParams.dataDestination,'scripts'],'dir')
    mkdir([Params.PublicParams.dataDestination,'scripts']); %create folder for scripts
else %if the folder already exists the old analysis is run again -> delete old logs and scripts 
    disp('Clearing the log and script files from scripts directory')
    flag = 0;
    try 
        rmdir([Params.PublicParams.dataDestination,'scripts/'],'s'); %this may fail sometimes due to filesystem problems -> move folder to new name "scripts_old"
    catch
        warning('scripts/ folder cannot be deleted, changing the name of the folder to scripts_old/')
        flag = 1;
    end
    if flag
        try
            movefile([Params.PublicParams.dataDestination,'scripts/'], [Params.PublicParams.dataDestination,'scripts_old/'])
        catch
            disp(lasterr)
        end
    end
    mkdir([Params.PublicParams.dataDestination,'scripts']);
end
log_path=[Params.PublicParams.dataDestination,'scripts'];