function permutationPFAcrossSessions(Params,nrBand,sessBlock)
% This function generates null distribution for sum ZPF
% statistic. The sign of the ZPF statistic of the subject
% pairs is randomly flipped and summed up several times. At
% single iteration, same randomization is used across all brain
% voxels and maximum across the voxels is selected to obtain final
% realization. This procedure takes automatically care of the multiple
% comparisons.
%
% See also: RUNANALYSIS, INITPARAMS

% Last updated: 6.3.2018 by Jukka-Pekka Kauppi

showTime(1);
saveDebugInfo = 0;
saveDebugInfo2 = 0;
fineTuneIter = 10; %the number of fine tuning iterations
fineTuneIterMult = 5; % This gives the number of iterations to fine the voxel-by
                   % voxel p-values. It is given as the multiplicative
                   % factor to the number of total iterations. E.g. when
                   % the fineTuneIter = 10 and the number of iterations is
                   % 10000, then the number of fine tuning iterations is
                   % 100000
fineTuneThr = [0.02 0.02 0.01 0.01 0.005 0.005 0.0025 0.0025 0.0025 0.0025]; % the p-value threshold of voxels whose p-value is fine tuned
                    % by additional iterations                   
                   
                    
Priv = Params.PrivateParams;
Pub = Params.PublicParams;
studentize = Pub.studentize;
if ~isfield(Pub,'globalCorrCorrection')
    Pub.globalCorrCorrection = 0;
end


globalCorrCorrection = Pub.globalCorrCorrection;  % turns on/off the correction for the global 
                          % mean correlation between the subject pairs


% This parameter is now implemented in the start-up GUI:
%if isfield(Pub,'studentize')
%    studentize = Pub.studentize;
%else
%    studentize = 0; % 0 is standard way to compute, switch this to 1 to do the computations with studentized statistics
%end

% This parameter is not implemented in the start-up GUI:
if isfield(Pub,'sregularization') % 
  sregularization = Pub.sregularization;
else  
  sregularization = -0.0025; % coefficient used for regularizing the computation of the studentisized statistics
end                          % values smaller than zero refer to quantiles of the standard deviation distribution
                            % the default is to use 2.5 % quantile

                            
if studentize
    disp(strcat('Studentization with regularization',num2str(sregularization)));
end

if Pub.sessionCompOn == 0
    disp('Sum ZPF map computation across sessions not selected...')
    return
end

if ~Pub.corOn
    disp('Correlation coefficient needs to be selected in order to compute sum ZPF maps...')
    return
end

if ~Pub.calcStandard
    disp('Correlation coefficient needs to be selected in order to compute sum ZPF maps...')
    return
end

for xx = 1:Priv.nrSessions
    za(xx) = Priv.dataSize(xx,4);
end
if length(unique(za)) ~= 1
    disp('Each session must have same number of data points in order to compute sum ZPF maps across sessions, calculation skipped...')
    return
end

if Priv.nrSessions < 2
    disp('Only one session specified, sumZPF across sessions cannot be computed...')
    return
end

for fc = 1:length(sessBlock)
    Fi = [Priv.PFsessionDestination 'band' num2str(nrBand) 'valsPFsessComp' num2str(sessBlock(fc)) '.mat'];
    if exist(Fi) == 2
        disp(['File ' Fi ' already exists, sum ZPF permutation test skipped...'])
        return
    end
end

% elementWise = 0; % type of the permutation test, element-wise or subject-wise

elementWise = 0; % should have the same value in PearsonFilonFAcrossSessions
fullSubjectWise = 0;
limSubjectWise = 0;

if ~Pub.pairedSessionComp  % if paired session comparison; no alternatives w.r.t. permutation type
    if Pub.permutationType == 1 
         elementWise = 1;
    end
	if Pub.permutationType == 2 
         limSubjectWise = 1;
    end
	if Pub.permutationType == 3 
        fullSubjectWise = 1;  % note that this implies heavy memory consumption
    end
end

% if elementWise & studentize & Pub.pairedSessionComp == 0
%    disp('Studentization does not work with elementwise permutations');
%    return;
% end

trueNrSubjects = zeros(Priv.nrSessions,1);
trueNrSubjectPairs = zeros(Priv.nrSessions,1);
for ses = 1:Priv.nrSessions
    trueNrSubjects(ses) = sum(Priv.dummies(ses,:) == 0);
    trueNrSubjectPairs(ses) = trueNrSubjects(ses)*(trueNrSubjects(ses) - 1)/2;
end

load([Pub.dataDestination 'memMaps'])

nrPerm = Pub.permutSessionComp;
nrSubjectPairs = (Priv.nrSubjects^2-Priv.nrSubjects)/2;
nrSubjects = Priv.nrSubjects;
if Pub.pairedSessionComp 
    if any(Priv.dummies(:) > 0)
        error('In the paired comparison, the numbers of subjects in the groups must be all equal');
    end
end

% % load mask:
% if Pub.useTemplate
%   bmask = load_nii(Priv.brainMask);
%   bmask = single(bmask.img);
% else
%   bmask = load(Priv.brainMask);
%   fiel = fields(bmask);
%   bmask = bmask.(fiel{1});
%   bmask = single(bmask);
% end
% bmask = logical(bmask);


maskfileformat = Pub.fileFormat;
if strcmp(maskfileformat(end-2:end),'nii') || strcmp(maskfileformat,'nii.gz')
    bmask = load_nii(Priv.brainMask);
    bmask = single(bmask.img);
elseif strcmp(maskfileformat(end-2:end),'mat') || strcmp(maskfileformat,'mat')
    bmask = load(Priv.brainMask);
    fiel = fields(bmask);
    bmask = bmask.(fiel{1});
    bmask = single(bmask);
else
    error('Mask must be mat- or nii-file!')
end
bmask = logical(bmask);


% remove zero-planes from data to easy computational burden:

% find zero-planes:
IDX = [1 1 1 1 1 1];
for s = 1:Priv.dataSize(1,1)
    if sum(sum(squeeze(bmask(s,:,:)))) == 0
        IDX(1) = IDX(1)+1;
    else
        break
    end
end
for s = Priv.dataSize(1,1):-1:1
    if sum(sum(squeeze(bmask(s,:,:)))) == 0
        IDX(2) = IDX(2)+1;
    else
        break
    end
end
for s = 1:Priv.dataSize(1,2)
    if sum(sum(squeeze(bmask(:,s,:)))) == 0
        IDX(3) = IDX(3)+1;
    else
        break
    end
end
for s = Priv.dataSize(1,2):-1:1
    if sum(sum(squeeze(bmask(:,s,:)))) == 0
        IDX(4) = IDX(4)+1;
    else
        break
    end
end
for s = 1:Priv.dataSize(1,3)
    if sum(sum(squeeze(bmask(:,:,s)))) == 0
        IDX(5) = IDX(5)+1;
    else
        break
    end
end
for s = Priv.dataSize(1,3):-1:1
    if sum(sum(squeeze(bmask(:,:,s)))) == 0
        IDX(6) = IDX(6)+1;
    else
        break
    end
end
% remove planes:
indbmaskorig = find(bmask);	
bmask3D = bmask;
bmask = bmask(IDX(1):end-(IDX(2)-1),IDX(3):end-(IDX(4)-1),...
    IDX(5):end-(IDX(6)-1));
smallerSize = size(bmask);	
Vs3D = zeros(smallerSize);
indbmask = find(bmask);	
% vectorize mask:

bmask = bmask(:);

sessBandTable = createSessBandTable( sessBlock,Priv.nrSessions );

% do permutation for each session comparison pair given in sessionComp:
for fc = 1:length(sessBlock)
    g = sessBandTable(1,fc);
    h = sessBandTable(2,fc);
    disp(['Session comparison ' num2str(sessBlock(fc)) '....'])
    % generate the lookup table for subject wise permutations
    [LUT,triuind1,triuind2] = generateLUT(trueNrSubjects(g),trueNrSubjects(h));
    % get ZPF data matrices for each subject pair:
    PFdata = memMaps.(Priv.PFmatMapSessionName).whole.([...
        Priv.prefixFreqBand num2str(nrBand)]).cor.([...
        Priv.prefixSessComp num2str(sessBlock(fc))]).Data.xyzc; 
    PFsize = size(PFdata);
    
    if ~Pub.pairedSessionComp
       % get rid off unnecessary zeros created for dummy subjects 
       ind1 = 1:trueNrSubjectPairs(g);
       ind2 = (nrSubjectPairs + 1):(nrSubjectPairs + trueNrSubjectPairs(h));
       ind3 = (2*nrSubjectPairs + 1):(2*nrSubjectPairs + trueNrSubjects(h)*trueNrSubjects(g));
       totNrSubjectPairs = trueNrSubjectPairs(g) + trueNrSubjectPairs(h);
       totNrSubjects = trueNrSubjects(g) + trueNrSubjects(h);
       if fullSubjectWise
            PFdata = PFdata(:,:,:,[ind1 ind2 ind3]);
            nrTestStatisticValues = totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h);
       else
            PFdata = PFdata(:,:,:,[ind1 ind2]);
            nrTestStatisticValues = totNrSubjectPairs;
       end
       PFsize = size(PFdata);
       ind1 = 1:trueNrSubjectPairs(g);
       ind2 = (length(ind1) + 1):(length(ind1) + trueNrSubjectPairs(h));
       ind3 = (length(ind1) + length(ind2) + 1):(length(ind1) + length(ind2) + trueNrSubjects(h)*trueNrSubjects(g)); 
    end
	if saveDebugInfo2
        mkdir(Priv.PFsessionDestination,'PFdata');
        save(fullfile(Priv.PFsessionDestination,'PFdata','PFdata'),'PFdata','-v7.3');
    end
    if globalCorrCorrection % remove the correlations summed over the brain from the correlation matrices
        meanPF = zeros(PFsize(4),1);
        nvox = length(indbmask);
        for xxx = 1:PFsize(1)
            for yyy = 1:PFsize(2)
                for zzz = 1:PFsize(3)
                    if bmask3D(xxx,yyy,zzz) > 0
                        nanidx = find(~isfinite(PFdata(xxx,yyy,zzz,:))); % one cd more check for Nans and Infs
                        if ~isempty(nanidx)
                            PFdata(xxx,yyy,zzz,nanidx) = 0;
                        end
                        meanPF = meanPF + (1/nvox)*squeeze(PFdata(xxx,yyy,zzz,:)); % note that minus signs are
						                                                           % implicitly taken into account
                    end
                end
            end
        end
        for xxx = 1:PFsize(1)
            for yyy = 1:PFsize(2)
                for zzz = 1:PFsize(3)
                    if bmask3D(xxx,yyy,zzz) > 0
                        PFdata(xxx,yyy,zzz,:) = squeeze(PFdata(xxx,yyy,zzz,:)) - meanPF;
                    end
                end
            end
        end
        
        
    end
    % compute the standard deviation map
    % note that this is a standard deviation map and not a standard error
    % map
    if ~Pub.pairedSessionComp 
%         partData = zeros([PFsize(1:3) trueNrSubjects(g)]);
%         for k = 1:trueNrSubjects(g)
%             proto = LUT; %all subjects selected
%             proto(k,:) = 0; %removing subject k from selection vertical
%             proto(:,k) = 0; %removing subject k from selection horisontal
%             proto = proto(triuind1); %selecting the upper triangular matrix
%             loc1{k} = nonzeros(proto); % get the indexes for the correlations
%             partData(:,:,:,k) = mean(PFdata(:,:,:,loc1{k}),4);   %          
%         end
 %       jkStd = (trueNrSubjects(g) - 1)*std(partData,0,4);
        jkStd = std(PFdata(:,:,:,ind1),0,4);
        save([Priv.PFsessionDestination 'band' num2str(nrBand) 'jkStdMap' ...
             num2str(g)],'jkStd');
        jkStd1 = jkStd; 
%         partData = zeros([PFsize(1:3) trueNrSubjects(h)]);
%         for k = 1:trueNrSubjects(h)
%             proto = LUT; %all subjects selected
%             proto(k + trueNrSubjects(g),:) = 0; %removing subject k from selection vertical
%             proto(:,trueNrSubjects(g) + k) = 0; %removing subject k from selection horisontal
%             proto = proto(triuind2); %selecting the upper triangular matrix
%             loc2{k} = nonzeros(proto); % get the indexes for the correlations
%             partData(:,:,:,k) = mean(PFdata(:,:,:,loc2{k}),4);   %          
%         end
%         jkStd = (trueNrSubjects(h) - 1)*std(partData,0,4);  
        jkStd = std(PFdata(:,:,:,ind2),0,4); 
        save([Priv.PFsessionDestination 'band' num2str(nrBand) 'jkStdMap' ...
             num2str(h)],'jkStd');
        jkStd2 = jkStd;
        % produce averaged estimate of the standard error akin to Welch
        % test and a t map
        jkwSE = sqrt(jkStd1.^2/trueNrSubjects(g) + jkStd2.^2/trueNrSubjects(h));
        jkwSE = jkwSE + (jkwSE == 0);
        if sregularization < 0
            if abs(sregularization) < 1
                sjkwSE = sort(jkwSE(indbmaskorig));
                srtmp = sjkwSE(round(length(sjkwSE)*abs(sregularization)));
                sregularization = srtmp;
            else
                sregularization = 0;
            end
        end
        
        tdata3D = (sum(PFdata(:,:,:,ind1),4)/trueNrSubjectPairs(g) + ...
                sum(PFdata(:,:,:,ind2),4)/trueNrSubjectPairs(h))./(jkwSE + sregularization);

         % COMMENTED ON 25/1/2018 JT
          %  this will only mess things up; instead statistics are computed
          %  with studentization
          %  if studentize 
          %      for ijij = 1:size(PFdata,4)
          %          PFdata(:,:,:,ijij) = PFdata(:,:,:,ijij)./(jkwSE + sregularization); % added the regularization JT 21.11.17
          %     end
          %  end
        save([Priv.PFsessionDestination 'band' num2str(nrBand) 'standardizedPF' ...
             num2str(sessBlock(fc))],'tdata3D','jkwSE');
         clear partData;
         
    end
    
    if Pub.pairedSessionComp 
        PFsmaller = PFdata(IDX(1):end-(IDX(2)-1),IDX(3):end-(IDX(4)-1),...
            IDX(5):end-(IDX(6)-1),:);
        nrTestStatisticValues = nrSubjectPairs;
    else % take unnecessary zeros out 
        
        if fullSubjectWise
            PFsmaller = PFdata(IDX(1):end-(IDX(2)-1),IDX(3):end-(IDX(4)-1),...
            IDX(5):end-(IDX(6)-1),:); 
            nrTestStatisticValues = totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h);
        else
            PFsmaller = PFdata(IDX(1):end-(IDX(2)-1),IDX(3):end-(IDX(4)-1),...
            IDX(5):end-(IDX(6)-1),:);
            nrTestStatisticValues = totNrSubjectPairs;
        end        
    end

    siz = prod(size(bmask));
    PFsmaller = reshape(PFsmaller,siz,nrTestStatisticValues);
    PFsmaller(bmask==0,:) = [];
    siz = sum(bmask);

    disp('Generating randomization matrix...')
    
    if Pub.pairedSessionComp
        % flip ZPF values randomly (-1 or 1):
        randVals = 2*(rand(nrPerm-1,nrSubjectPairs) >= 0.5)-1;
        % add also the original combination:
        randVals = [ones(1,nrSubjectPairs);randVals];
    else 
	    if elementWise
            randVals = ones(nrPerm,totNrSubjectPairs);
            denomVec = ones(nrPerm,totNrSubjectPairs)*trueNrSubjectPairs(g);
            denomVec(1,(trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = trueNrSubjectPairs(h);
            origsigns = ones(1,totNrSubjectPairs);
            origsigns((trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = -1;
            pg1vec = zeros(nrPerm,trueNrSubjectPairs(g));
            pg2vec = zeros(nrPerm,trueNrSubjectPairs(h));
            pg1vec(1,:) = 1:trueNrSubjectPairs(g);
            pg2vec(1,:) = trueNrSubjectPairs(g) + (1:trueNrSubjectPairs(h));
            for k = 2:(nrPerm)
                tmp = randsample(totNrSubjectPairs,trueNrSubjectPairs(h));
                randVals(k,tmp) = (-1);
                randVals(k,:) = origsigns.*randVals(k,:); % this is needed as 
                                                     % to compensate for
                                                     % the signs placed in
                                                     % PearsonFilonAcrossSessions
                denomVec(k,tmp) = trueNrSubjectPairs(h); 
                pg1vec(k,:) = setdiff(1:totNrSubjectPairs,tmp);
                pg2vec(k,:) = tmp; 
                                    
            end
	    else 
     		% subject-wise swaps between the groups; note that randVals 
			if limSubjectWise
			    origsigns = ones(1,totNrSubjectPairs);
                origsigns((trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = -1;
                denomVec = ones(nrPerm,totNrSubjectPairs);
                denomVec(1,:) = trueNrSubjectPairs(g);
                denomVec(1,(trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = trueNrSubjectPairs(h);
               	randVals = zeros(nrPerm,totNrSubjectPairs);
                randVals(1,1:totNrSubjectPairs) = 1;
                npVec = zeros(nrPerm,totNrSubjects);
                npVec(1,:) = 1:totNrSubjects;
               pg1vec = zeros(nrPerm,trueNrSubjectPairs(g));
               pg2vec = zeros(nrPerm,trueNrSubjectPairs(h));
               pg1vec(1,:) = 1:trueNrSubjectPairs(g);
               pg2vec(1,:) = trueNrSubjectPairs(g) + (1:trueNrSubjectPairs(h));
 			    for k = 2:(nrPerm)
                    np = randperm(totNrSubjects); % Subject permutation
                    pLUT = LUT(np,np);
					pg1s = pLUT(triuind1);  % group 1 subjects
					pg2s =  pLUT(triuind2);  % group 2 subjects
					pg1s = nonzeros(pg1s.*(pg1s < (totNrSubjectPairs + 1)));  % ignore too
					pg2s = nonzeros(pg2s.*(pg2s < (totNrSubjectPairs + 1)));  % large indexes
					randVals(k,pg1s) = origsigns(pg1s)*1;
					randVals(k,pg2s) = origsigns(pg2s)*(-1);
                    denomVec(k,pg1s) = length(pg1s); 
                    denomVec(k,pg2s) = length(pg2s);
                    npVec(k,:) = np;
                    pg1vec(k,1:length(pg1s)) = pg1s;
                    pg2vec(k,1:length(pg2s)) = pg2s;
 				end
            end
			if fullSubjectWise
			    origsigns = ones(1,totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h));
                origsigns((trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = -1;
                denomVec = ones(nrPerm,totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h));
                denomVec(1,:) = trueNrSubjectPairs(g);
                denomVec(1,(trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = trueNrSubjectPairs(h);
			    randVals = zeros(nrPerm,totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h));
			    randVals(1,1:totNrSubjectPairs) = 1;
                
                npVec = zeros(nrPerm,totNrSubjects);
                npVec(1,:) = 1:totNrSubjects;
                pg1vec = zeros(nrPerm,trueNrSubjectPairs(g));
                pg2vec = zeros(nrPerm,trueNrSubjectPairs(h));
                pg1vec(1,:) = 1:trueNrSubjectPairs(g);
                pg2vec(1,:) = trueNrSubjectPairs(g) + (1:trueNrSubjectPairs(h));
			    for k = 2:(nrPerm)
                    np = randperm(totNrSubjects); % Subject permutation
                    pLUT = LUT(np,np);
					pg1s = pLUT(triuind1);  % group 1 subjects
					pg2s =  pLUT(triuind2);  % group 2 subjects
			        randVals(k,pg1s) = origsigns(pg1s)*1;
					randVals(k,pg2s) = origsigns(pg2s)*(-1);
                    denomVec(k,pg1s) = trueNrSubjectPairs(g);
                    denomVec(k,pg2s) = trueNrSubjectPairs(h);
                    npVec(k,:) = np;
                    pg1vec(k,:) = pg1s;
                    pg2vec(k,:) = pg2s;
				end
			end	
				
        end
    end
    % First we do few permutations in order to define the cluster extent threshold 
    
    if ((Params.PublicParams.clusterThreshold > 0) & (Params.PublicParams.clusterThreshold < 0.05)) % computing preliminary cluster thresholds
        disp('Generating the cluster extent thresholds');
        nrPerm = Pub.permutSessionComp;
        nrPermInit = min(nrPerm,250);
        reportIntVal = max(1,(round((nrPermInit/100))));
        clusterThvals = zeros(1,nrPermInit);
        for k = 1:nrPermInit   % the comments about the permutation procedure can be found below when the full set of permutations are run 
            if Pub.pairedSessionComp
                denom = 1; % nrSubjectPairs; % changed to 1 to avoid division thinking visutool JT 23.8.2017
            else 
                denom = denomVec(k,:);
            end
%             partData = zeros([siz trueNrSubjects(g)]);
%             for jjj = 1:trueNrSubjects(g)
%                 proto = LUT(npVec(k,:),npVec(k,:)); %all subjects selected
%                 proto(jjj,:) = 0; %removing subject jjj from selection vertical
%                 proto(:,jjj) = 0; %removing subject jjj from selection horisontal
%                 proto = proto(triuind1); %selecting the upper triangular matrix
%                 loc1{jjj} = nonzeros(proto); % get the indexes for the correlations
%                 partData(:,jjj) = mean(bsxfun(@times,PFsmaller(:,loc1{jjj}),origsigns(loc1{jjj})),2);   %          
%             end
            nppg = nonzeros(pg1vec(k,:)); 
            jkStdperm1 = std(bsxfun(@times,PFsmaller(:,nppg),origsigns(nppg)),0,2);                          
%             partData = zeros([siz trueNrSubjects(h)]);
%             for jjj = 1:trueNrSubjects(h)
%                 proto = LUT(npVec(k,:),npVec(k,:)); %all subjects selected
%                 proto(jjj + trueNrSubjects(g),:) = 0; %removing subject k from selection vertical
%                 proto(:,trueNrSubjects(g) + jjj) = 0; %removing subject k from selection horisontal
%                 proto = proto(triuind2); %selecting the upper triangular matrix
%                 loc2{jjj} = nonzeros(proto); % get the indexes for the correlations
%                 partData(:,jjj) = mean(bsxfun(@times,PFsmaller(:,loc2{jjj}),origsigns(loc2{jjj})),2);   %          
%             end
            nppg = nonzeros(pg2vec(k,:)); 
            jkStdperm2 =  std(bsxfun(@times,PFsmaller(:,nppg),origsigns(nppg)),0,2);
            jkwSEperm = sqrt(jkStdperm1.^2/trueNrSubjects(g) + jkStdperm2.^2/trueNrSubjects(h));
            jkwSEperm = jkwSEperm + (jkwSEperm == 0);
            r = repmat(randVals(k,:)./denom,siz,1);        
            Vs = sum(PFsmaller.*r,2);

            if studentize && Pub.pairedSessionComp == 0
                Vs = Vs./(jkwSEperm + sregularization);
            end
            Vs(isnan(Vs)) = 0;
            if saveDebugInfo
                if k == 1
                    mkdir(Priv.PFsessionDestination,'debug');
                end
                save(fullfile(Priv.PFsessionDestination,'debug',['permmap' num2str(k)]),'Vs');
                save(fullfile(Priv.PFsessionDestination,'debug',['sepermmap' num2str(k)]),'jkwSEperm');
            end
            
            sVs = sort(Vs,'descend');
            IDX = round(Params.PublicParams.clusterThreshold*size(PFsmaller,1));
            if IDX == 0
                clusterThvals(k) = NaN;
            else
                clusterThvals(k) =  sVs(IDX); % we assume symmetry around zero
            end
            if mod(k,reportIntVal) == 0
                disp(['Iteration: ' num2str(k) '/' num2str(nrPermInit)])
                tic
                toc
            end
            
        end 
        clusterTh = mean(clusterThvals);
    else
        clusterTh = Params.PublicParams.clusterThreshold;
        
    end 
    save([Priv.PFsessionDestination 'band' num2str(nrBand) 'clusterExtentTh' num2str(sessBlock(fc))],'clusterTh')
   
    pVs = zeros(size(PFsmaller,1),1);
    
    if Pub.pairedSessionComp 
        PFdata3D = sum(PFdata,4)/nrSubjectPairs; % JT , this changed from previous commit; there was an obvious bug 
    else
        PFdata3D = sum(PFdata(:,:,:,ind1),4)/trueNrSubjectPairs(g) + ...
             sum(PFdata(:,:,:,ind2),4)/trueNrSubjectPairs(h);
        if studentize && Pub.pairedSessionComp == 0
            PFdata3D = PFdata3D./(jkwSE + sregularization);
        end
    end
    save([Priv.PFsessionDestination 'band' num2str(nrBand) 'ZsumStat' num2str(sessBlock(fc))],'PFdata3D')
    if Params.PublicParams.clusterThreshold > 0  % computing clusters for cluster extent correction
       PFconncompNeg = bwconncomp(PFdata3D < (-clusterTh));
	   PFconncompPos = bwconncomp(PFdata3D > clusterTh);
       if PFconncompNeg.NumObjects > 0
           PFconncompLabelsNeg = labelmatrix(PFconncompNeg);
           numVoxelsNeg = cellfun(@numel,PFconncompNeg.PixelIdxList);
           if Pub.clusterCorrType == 2 % cluster mass correction
               for nn = 1:PFconncompNeg.NumObjects
                  numVoxelsNeg(nn) = abs(sum(PFdata3D(PFconncompNeg.PixelIdxList{nn}) + ... 
                                     clusterTh));
               end
           end
           PFconncompSizeNeg = labels2stat(PFconncompLabelsNeg,numVoxelsNeg);
       else
           PFconncompSizeNeg = zeros(size(PFdata3D));
           disp('No negative suprathreshold clusters');
       end
       if PFconncompPos.NumObjects > 0
	      PFconncompLabelsPos = labelmatrix(PFconncompPos);
	      numVoxelsPos = cellfun(@numel,PFconncompPos.PixelIdxList);
          if Pub.clusterCorrType == 2 % cluster mass correction
              for nn = 1:PFconncompPos.NumObjects
                  numVoxelsPos(nn) = abs(sum(PFdata3D(PFconncompPos.PixelIdxList{nn}) - ... 
                                     clusterTh));
              end
          end
	      PFconncompSizePos = labels2stat(PFconncompLabelsPos,numVoxelsPos);
       else
           PFconncompSizePos = zeros(size(PFdata3D));
           disp('No positive suprathreshold clusters');
       end
       % this saves the cluster extent maps in a mat file
       % every suprathreshold voxel has a value corresponding
       % to cluster extent
       % at some point adding a text file with the cluster information 
       % might be useful
       % visutool is not thought about in this process 
	   save([Priv.PFsessionDestination 'band' num2str(nrBand) 'clustersPFsessComp' ...
             num2str(sessBlock(fc))],'PFconncompSizeNeg','PFconncompSizePos')
    end  
    clear PFdata

    vals1 = single(NaN*zeros(1,nrPerm));
    vals2 = vals1;
    reportIntVal = max(1,(round((nrPerm/100))));

	cvalsNeg = single(NaN*zeros(1,nrPerm));
    cvalsPos = cvalsNeg;
	
    disp('Generating null distribution for z-PF matrices...')
    tic
    
    if Pub.pairedSessionComp
        denom = 1; % nrSubjectPairs; % changed to 1 to avoid division thinking visutool JT 23.8.2017
    else 
        denom = denomVec(1,:);
%        denom = repmat(denom,size(PFsmaller,1),1);
    end
    r = repmat(randVals(1,:)./denom,siz,1);         % two groups 
    
    origVs = sum(PFsmaller.*r,2);
    if studentize && Pub.pairedSessionComp == 0
        origVs = origVs./(jkwSE(indbmaskorig) + sregularization);
    end
    origVs(isnan(origVs)) = 0; 
    batchSize = min(size(PFsmaller,1),1000);
    batchSize_1 = 1/batchSize;
    pVs = zeros(size(PFsmaller,1),1);
    pVsindvox = zeros(size(PFsmaller,1),1);
 %    pVs_neg = zeros(size(PFsmaller,1),3);
    
    for k = 1:nrPerm        
        if Pub.pairedSessionComp
            denom = 1; % nrSubjectPairs; % changed to 1 to avoid division thinking visutool JT 23.8.2017
        else 
            denom = denomVec(k,:);
        end
		                                        % if limSubjectWise then denominator  
                                           % is those non-zero values divided by 2 due to
        r = repmat(randVals(k,:)./denom,siz,1);         % two groups 
        
        
        if Pub.pairedSessionComp == 0
            %         partData = zeros([siz trueNrSubjects(g)]);
            %         for jjj = 1:trueNrSubjects(g)
            %             proto = LUT(npVec(k,:),npVec(k,:)); %all subjects selected
            %             proto(jjj,:) = 0; %removing subject jjj from selection vertical
            %             proto(:,jjj) = 0; %removing subject jjj from selection horisontal
            %             proto = proto(triuind1); %selecting the upper triangular matrix
            %             loc1{jjj} = nonzeros(proto); % get the indexes for the correlations
            %             partData(:,jjj) = mean(bsxfun(@times,PFsmaller(:,loc1{jjj}),orgisigns(loc1{jjj})),2);   %
            %         end
            nppg = nonzeros(pg1vec(k,:)); 
            jkStdperm1 = std(bsxfun(@times,PFsmaller(:,nppg),origsigns(nppg)),0,2);
            
            %         partData = zeros([siz trueNrSubjects(h)]);
            %         for jjj = 1:trueNrSubjects(h)
            %             proto = LUT(npVec(k,:),npVec(k,:)); %all subjects selected
            %             proto(jjj + trueNrSubjects(g),:) = 0; %removing subject k from selection vertical
            %             proto(:,trueNrSubjects(g) + jjj) = 0; %removing subject k from selection horisontal
            %             proto = proto(triuind2); %selecting the upper triangular matrix
            %             loc2{jjj} = nonzeros(proto); % get the indexes for the correlations
            %             partData(:,jjj) = mean(bsxfun(@times,PFsmaller(:,loc2{jjj}),origsigns(loc2{iii})),2);   %
            %         end
            nppg = nonzeros(pg2vec(k,:)); 
            jkStdperm2 =  std(bsxfun(@times,PFsmaller(:,nppg),origsigns(nppg)),0,2);
            %  jkStdperm2 = (trueNrSubjects(h) - 1)*std(partData,0,2);
            jkwSEperm = sqrt(jkStdperm1.^2/trueNrSubjects(g) + jkStdperm2.^2/trueNrSubjects(h));
            jkwSEperm = jkwSEperm + (jkwSEperm == 0);
            
        end

        if ~Pub.pairedSessionComp
            Vs = sum(PFsmaller.*r,2);          % added division by nrSubjectPairs JT 23/02/16
        else
            Vs = sum(PFsmaller.*r,2);          % no division in case of paired comparison JPK 12.8.2017            
        end
        if studentize && Params.PublicParams.pairedSessionComp == 0
            Vs = Vs./(jkwSEperm + sregularization);
        end
        Vs(isnan(Vs)) = 0;
        rrr = randperm(size(PFsmaller,1),batchSize);
        % for kk = 1:size(PFsmaller,1)
        %     pVs(kk) = pVs(kk) + batchSize_1*sum(Vs(rrr) > origVs(kk));  % this might be slow, it could be possible to make it faster           
        % end   
       % OLD VERSION, NEW VERSION REMOVES ABSOLUTE VALUES :		
       % pVs = pVs + batchSize_1*sum(double(bsxfun(@gt,abs(Vs(rrr)),abs(origVs'))))'; % this computes the p-values for the positive side
	     pVs = pVs + batchSize_1*sum(double(bsxfun(@gt,Vs(rrr),origVs')))';
      %  if k > 1
	     % OLD VERSION, THE NEW VERSION REMOVES ABSOLUTE VALUES
        %   pVsindvox = pVsindvox + double(abs(Vs) >= abs(origVs));
		   pVsindvox = pVsindvox + double(Vs >= origVs);
      %  end
        
        vals1(k) = single(max(Vs));               % making statistic closer to standard Z
        vals2(k) = single(min(Vs));               % note that mean won't work for unpaired test
		if  Params.PublicParams.clusterThreshold > 0 
		    Vs3D(indbmask) = Vs;
			ccNeg = bwconncomp(Vs3D < (-clusterTh));
	        ccPos = bwconncomp(Vs3D > clusterTh);
	        numVoxelsNeg = cellfun(@numel,ccNeg.PixelIdxList);
            if isempty(numVoxelsNeg)
                numVoxelsNeg = 0;
            else
                if Pub.clusterCorrType == 2
                    for nn = 1:ccNeg.NumObjects
                        numVoxelsNeg(nn) = abs(sum(Vs3D(ccNeg.PixelIdxList{nn}) + ... 
                                     clusterTh));
                    end
                end
            end
            
                    
   	        numVoxelsPos = cellfun(@numel,ccPos.PixelIdxList);
            if isempty(numVoxelsPos)
                numVoxelsPos = 0;
            else
                if Pub.clusterCorrType == 2
                    for nn = 1:ccPos.NumObjects
                        numVoxelsPos(nn) = abs(sum(Vs3D(ccPos.PixelIdxList{nn}) - ... 
                                     clusterTh));
                    end
                end
            end
            
			cvalsNeg(k) = max(numVoxelsNeg);
			cvalsPos(k) = max(numVoxelsPos);
		end
        if mod(k,reportIntVal) == 0
            disp(['Iteration: ' num2str(k) '/' num2str(nrPerm)])
            toc
            tic
        end
    end
    pVs = pVs/nrPerm;
	% THIS IS FOR THE NEW VERSION
    pVs = min(1 - pVs,pVs)*2; % two-sided p-values
    pVsindvox = (pVsindvox - 1).*((pVsindvox/nrPerm) > 0.5) + (pVsindvox).*((pVsindvox/nrPerm) <= 0.5);  % to correct for asymmetry 
    pVsindvox = pVsindvox/nrPerm; 
    if fineTuneIter & ~Pub.pairedSessionComp & ~elementWise % start additional iterations, not implemented for element-wise permutations
        disp('Fine tuning smallest p-values');
        save([Priv.PFsessionDestination 'band' num2str(nrBand) 'pvalmaps3Dindvox_intermediate' num2str(sessBlock(fc))],'pVsindvox','indbmaskorig','PFsize')
        nrPermTot = nrPerm;
        nrPermOld = nrPerm;
        for fti = 1:fineTuneIter
            disp(['Fine tuning iteration' num2str(fti)])
            % idxFineTuned = find(pVsindvox < fineTuneThr(fti));
			idxFineTuned = find((min(pVsindvox,1 - pVsindvox)*2) < fineTuneThr(fti));
            if isempty(idxFineTuned)
                break;
            end
            
            pVsindvoxFt = pVsindvox(idxFineTuned)*nrPermTot;
            nrPermFt = min(fineTuneIterMult*nrPermOld,25000);           
            nrPerm = nrPermFt;
            PFstillsmaller = PFsmaller(idxFineTuned,:);
            siz = length(idxFineTuned);
           % aOVs = abs(origVs(idxFineTuned));
		    aOVs = origVs(idxFineTuned);
            disp('Generating new randomization matrix');
            if limSubjectWise
               origsigns = ones(1,totNrSubjectPairs);
               origsigns((trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = -1;
               denomVec = ones(nrPerm,totNrSubjectPairs);
               denomVec(1,:) = trueNrSubjectPairs(g);
               denomVec(1,(trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = trueNrSubjectPairs(h);
               randVals = zeros(nrPerm,totNrSubjectPairs);
               randVals(1,1:totNrSubjectPairs) = 1;
               npVec = zeros(nrPerm,totNrSubjects);
               npVec(1,:) = 1:totNrSubjects;
               pg1vec = zeros(nrPerm,trueNrSubjectPairs(g));
               pg2vec = zeros(nrPerm,trueNrSubjectPairs(h));
               pg1vec(1,:) = 1:trueNrSubjectPairs(g);
               pg2vec(1,:) = trueNrSubjectPairs(g) + (1:trueNrSubjectPairs(h));
                for k = 2:(nrPerm)
                    np = randperm(totNrSubjects); % Subject permutation
                    pLUT = LUT(np,np);
                    pg1s = pLUT(triuind1);  % group 1 subjects
                    pg2s =  pLUT(triuind2);  % group 2 subjects
                    pg1s = nonzeros(pg1s.*(pg1s < (totNrSubjectPairs + 1)));  % ignore too
                    pg2s = nonzeros(pg2s.*(pg2s < (totNrSubjectPairs + 1)));  % large indexes
                    randVals(k,pg1s) = origsigns(pg1s)*1;
                    randVals(k,pg2s) = origsigns(pg2s)*(-1);
                    denomVec(k,pg1s) = length(pg1s); 
                    denomVec(k,pg2s) = length(pg2s);
                    npVec(k,:) = np;
                    pg1vec(k,1:length(pg1s)) = pg1s;
                    pg2vec(k,1:length(pg2s)) = pg2s;
                end
            end
            if fullSubjectWise
                origsigns = ones(1,totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h));
                origsigns((trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = -1;
                denomVec = ones(nrPerm,totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h));
                denomVec(1,:) = trueNrSubjectPairs(g);
                denomVec(1,(trueNrSubjectPairs(g) + 1):(totNrSubjectPairs)) = trueNrSubjectPairs(h);
                randVals = zeros(nrPerm,totNrSubjectPairs + trueNrSubjects(g)*trueNrSubjects(h));
                randVals(1,1:totNrSubjectPairs) = 1;

                npVec = zeros(nrPerm,totNrSubjects);
                npVec(1,:) = 1:totNrSubjects;
                pg1vec = zeros(nrPerm,trueNrSubjectPairs(g));
                pg2vec = zeros(nrPerm,trueNrSubjectPairs(h));
                pg1vec(1,:) = 1:trueNrSubjectPairs(g);
                pg2vec(1,:) = trueNrSubjectPairs(g) + (1:trueNrSubjectPairs(h));
                for k = 2:(nrPerm)
                    np = randperm(totNrSubjects); % Subject permutation
                    pLUT = LUT(np,np);
                    pg1s = pLUT(triuind1);  % group 1 subjects
                    pg2s =  pLUT(triuind2);  % group 2 subjects
                    randVals(k,pg1s) = origsigns(pg1s)*1;
                    randVals(k,pg2s) = origsigns(pg2s)*(-1);
                    denomVec(k,pg1s) = trueNrSubjectPairs(g);
                    denomVec(k,pg2s) = trueNrSubjectPairs(h);
                    npVec(k,:) = np;
                    pg1vec(k,:) = pg1s;
                    pg2vec(k,:) = pg2s;
                end
            end	
            for k = 2:nrPerm    % don't use the first permutation as that has been already used    
                denom = denomVec(k,:);
                r = repmat(randVals(k,:)./denom,siz,1);         % two groups 
                nppg = nonzeros(pg1vec(k,:)); 
                jkStdperm1 = std(bsxfun(@times,PFstillsmaller(:,nppg),origsigns(nppg)),0,2);          
                nppg = nonzeros(pg2vec(k,:)); 
                jkStdperm2 =  std(bsxfun(@times,PFstillsmaller(:,nppg),origsigns(nppg)),0,2);

                jkwSEperm = sqrt(jkStdperm1.^2/trueNrSubjects(g) + jkStdperm2.^2/trueNrSubjects(h));
                jkwSEperm = jkwSEperm + (jkwSEperm == 0);
                Vs = sum(PFstillsmaller.*r,2);          
                if studentize && Params.PublicParams.pairedSessionComp == 0
                    Vs = Vs./(jkwSEperm + sregularization);
                end
                Vs(isnan(Vs)) = 0;    
               %  pVsindvoxFt = pVsindvoxFt + double(abs(Vs) >= aOVs);
			    pVsindvoxFt = pVsindvoxFt + double(Vs >= aOVs);
                if mod(k,reportIntVal) == 0
                    disp(['Iteration: ' num2str(k) '/' num2str(nrPerm)])
                    toc
                    tic
                end
            end
            nrPermTot = (nrPermTot + nrPerm - 1);
            pVsindvoxFt = pVsindvoxFt/(nrPermTot); % -1 is because the first
            pVsindvox(idxFineTuned)  = pVsindvoxFt;             % permutation                                      % permutation
        end                                                    % is not used

    end    

        
    % NEW VERSION Comment this for old
    pVsindvox = min(1 - pVsindvox,pVsindvox)*2;
    toc
    % save null distributions of minimal and maximal sumZPF statistic:
    save([Priv.PFsessionDestination 'band' num2str(nrBand) 'valsPFsessComp' num2str(sessBlock(fc))],'vals1','vals2')
	save([Priv.PFsessionDestination 'band' num2str(nrBand) 'clustervalsPFsessComp' num2str(sessBlock(fc))],'cvalsNeg','cvalsPos')
    save([Priv.PFsessionDestination 'band' num2str(nrBand) 'pvalmaps3D' num2str(sessBlock(fc))],'pVs','indbmaskorig','PFsize')
    save([Priv.PFsessionDestination 'band' num2str(nrBand) 'pvalmaps3Dindvox' num2str(sessBlock(fc))],'pVsindvox','indbmaskorig','PFsize')
end

showTime(0);

end % end of the function

% This subfunction generates the lookup-table matching subject-wise permutations
% to the correlation values. This is needed to reduce the memory consumption (so 
% that symmetry of the correlation matrix can be utilized).
% The idea is to permute the lookuptable instead permuting the correlation matrices 
% The elements in the permuted lookup table then provide the indeces to
% the vectorized correlation values
% triu1 and triu2 provide the indeces to extract the correlation values 
% corresponding to the two groups 

function [lookuptable,triuind1,triuind2] = generateLUT(nrSubjects1,nrSubjects2)
   nrSubjectsTot = nrSubjects1 + nrSubjects2;
   lookuptable = zeros(nrSubjectsTot,nrSubjectsTot);
   % nrSubjPairs = ((nrSubjects)^2-(nrSubjects))/2;
   
   % triuind1 and triuind2 are the indeces to two groups; only required 
   % for fullSubjectWise   
   ct1 = zeros(nrSubjects1 + nrSubjects2);
   ct1(1:nrSubjects1,1:nrSubjects1) = 1;
   triuind1 = find(triu(ct1,1));
   ct1 = zeros(nrSubjects1 + nrSubjects2);
   ct1((nrSubjects1 +1):(nrSubjects1 + nrSubjects2),(nrSubjects1 +1):(nrSubjects1 + nrSubjects2)) = 1;
   triuind2 = find(triu(ct1,1));
   
   % first group
    subjpairInd = 0;
    for m = 1:nrSubjects1
        for n = 1:nrSubjects1
            if n > m
                subjpairInd = subjpairInd + 1;
                lookuptable(n,m) = subjpairInd;
                lookuptable(m,n) = subjpairInd;
            
            end
        end
    end
    % second group
    
    for m = 1:nrSubjects2
        for n = 1:nrSubjects2
            if n > m
                subjpairInd = subjpairInd + 1;
                lookuptable(nrSubjects1 + n,nrSubjects1 + m) = subjpairInd;
                lookuptable(nrSubjects1 + m,nrSubjects1 + n) = subjpairInd;
            
            end
        end
    end
    
    % subjpairInd = subjpairInd + nrSubjPairs;
    for m = 1:nrSubjects1
        for n = 1:nrSubjects2
		    subjpairInd = subjpairInd + 1;
            lookuptable(m,nrSubjects1 + n) = subjpairInd;
            lookuptable(nrSubjects1 + n,m) = subjpairInd;
        
        end
    end
end

