
function saveNiiResults(Params)
% function generates nii files from the computed results
% Juha Pajula, 14.4.2015

disp('Saving results to nii:')
Priv = Params.PrivateParams;
Pub = Params.PublicParams;

nrSubjectPairs = (Priv.nrSubjects^2-Priv.nrSubjects)/2;

%load Memmaps and one original source nii to get the voxel dimensions
load([Pub.dataDestination 'memMaps'])

if(strcmp(Pub.fileFormatSubj,'nii')) %if the data is nii and it is possible to get the correct voxel dimensions and origin
    nii_orighdr = load_nii(Pub.subjectSource{1});
    voxdim = nii_orighdr.hdr.dime.pixdim(2:4);
    origin = nii_orighdr.hdr.hist.originator(1:3)-1; %note matlab indexing fix -1
else %if the data is matlab mat files there is no information for header available
    voxdim=[];
    origin=[];
end

disp('   Saving the correlation statistics')
for nrBand = 0:Pub.nrFreqBands
    disp(['      Band ' num2str(nrBand)])
    for nrSession = 1:Priv.nrSessions
        disp(['         Session ' num2str(nrSession)])
        %read the data from the memmaps
        img=memMaps.resultMap.whole.(['band' num2str(nrBand)]).(['Session' num2str(nrSession)]).cor.Data.xyz;
        
        % generate nii structure
        nii_out = make_nii(img, voxdim,origin,[],'ISCtoolbox');
        %nii_out = make_nii(img, Priv.dataSize(nrSession,1:3) ,[],[],'ISCtoolbox');
        
        % save the nii to the result folder of destination
        save_nii(nii_out,[Priv.resultsDestination 'ISCcorrmapBand' num2str(nrBand) 'Session' num2str(nrSession) '.nii']);
        
        if(Priv.nrTimeIntervals(nrSession) ~= 0)
            disp('   Saving the timewindow correlation maps')
            img = zeros([memMaps.resultMap.win.([Priv.prefixFreqBand num2str(nrBand)]).([Priv.prefixSession num2str(nrSession)]).cor.Format{2} Priv.nrTimeIntervals(nrSession)]);
            
            for wfr = 1:Priv.nrTimeIntervals(nrSession)
                disp(['         Time window ' num2str(wfr)])
                img(:,:,:,wfr) = memMaps.resultMap.win.([Priv.prefixFreqBand num2str(nrBand)]).([Priv.prefixSession num2str(nrSession)]).cor.Data(wfr).xyz;
                %nii_out = make_nii(img, [Priv.dataSize(nrSession,1:3)] ,[],[],'ISCtoolbox');
            end
            
            nii_out = make_nii(img, voxdim,origin,[],'ISCtoolbox');
            
            % save the nii to the result folder of destination
            save_nii(nii_out,[Priv.resultsDestination 'ISCcorrmapTimeWinBand' num2str(nrBand) 'Session' num2str(nrSession) '.nii']);
        end
    end
end



if Params.PublicParams.freqCompOn
    disp('   Saving the frequency band comparisons')
    freqComps = ((Priv.maxScale+2)^2-(Priv.maxScale+2))/2;
    % nrSubjPairs = ((Priv.nrSubjects)^2-(Priv.nrSubjects))/2;
    % here comes the save nii based on:
    % PearsonFilon(Params,nrSession,freqComp);
    
    for nrSession = 1:Priv.nrSessions
        disp(['      Session ' num2str(nrSession)])
        mMapmatResultWhole = memMaps.(Priv.PFmatMapName).whole.([Priv.prefixSession num2str(nrSession)]).cor;
        for fr = 1:freqComps
            disp(['         Frequency comparison ' num2str(fr)])
            %get the data
            img=mMapmatResultWhole.([Priv.prefixFreqComp num2str(fr)]).Data.xyzc;
            % generate nii structure
            %nii_out = make_nii(img, [Priv.dataSize(nrSession,1:3)] ,[],[],'ISCtoolbox');
            nii_out = make_nii(img, voxdim,origin,[],'ISCtoolbox');
            
            
            % save the nii to the result folder of destination
            save_nii(nii_out,[Priv.resultsDestination 'ISCPFmatMapFreqComp' num2str(fr) 'Session' num2str(nrSession) '.nii']);
            
        end
    end
end

if Params.PublicParams.calcCorMatrices
    % here comes the save nii based on:
    % calculateCorMats(Params,nrBand,nrSession);
    %
end

if Params.PublicParams.calcStats
    % here comes the save nii based on:
    % calculateStatsMaps(Params,nrBand,nrSession);
    %
    disp('   Saving the extra statistics maps')
    mMapStat = memMaps.(Priv.statMapName);
    map_labels = {'meanFisher','stdFisher', 'lowerQuarter', 'median', 'upperQuarter'};
    for nrBand = 0:Pub.nrFreqBands
        disp(['      Band ' num2str(nrBand)])
        for nrSession = 1:Priv.nrSessions
            disp(['         Session ' num2str(nrSession)])
            img = mMapStat.whole.([Priv.prefixFreqBand num2str(nrBand)]).([Priv.prefixSession num2str(nrSession)]).cor.Data.xyz;
            nii_out = make_nii(img, voxdim,origin,[],'ISCtoolbox');
            %           nii_out = make_nii(img, [Priv.dataSize(nrSession,1:3)] ,[],[],'ISCtoolbox');
            
            % save the nii to the result folder of destination
            save_nii(nii_out,[Priv.resultsDestination 'ISCstatmapBand' num2str(nrBand) 'Session' num2str(nrSession) '.nii']);
            
            %if time window analysis is selected
            if(Priv.nrTimeIntervals(nrSession) ~= 0)
                img = zeros([mMapStat.win.([Priv.prefixFreqBand num2str(nrBand)]).([Priv.prefixSession num2str(nrSession)]).cor.Format{2}, Priv.nrTimeIntervals(nrSession)]);
                for wfr = 1:Priv.nrTimeIntervals(nrSession)
                    disp(['         Time window ' num2str(wfr)])
                    img(:,:,:,:,wfr) = mMapStat.win.([Priv.prefixFreqBand num2str(nrBand)]).([Priv.prefixSession num2str(nrSession)]).cor.Data(wfr).xyz;
                end
                for k = 1:5
                    img_tmp = squeeze(img(:,:,:,k,:));
                    %nii_out = make_nii(img, [Priv.dataSize(nrSession,1:3)] ,[],[],'ISCtoolbox');
                    nii_out = make_nii(img_tmp, voxdim,origin,[],'ISCtoolbox');
                    % save the nii to the result folder of destination
                    %                save_nii(nii_out,[Priv.resultsDestination 'ISCstatmapWin' num2str(wfr) 'Band' num2str(nrBand) 'Session' num2str(nrSession) '.nii']);
                    save_nii(nii_out,[Priv.resultsDestination 'ISCstatmapTimeWinBand' num2str(nrBand) 'Session' num2str(nrSession), map_labels{k} '.nii']);
                end
            end
        end
    end
end

if Params.PublicParams.calcPhase
    % here comes the save nii based on:
    % calculatePhaseSynch(Params,nrBand,nrSession);
    %
end

if Params.PublicParams.calcPhase || Params.PublicParams.winOn
    % here comes the save nii based on:
    % calculateSynchCurves(Params,nrBand,nrSession);
end

if Params.PublicParams.sessionCompOn
    disp('   Saving the session comparison maps')
    sessBlock = 1:((Priv.nrSessions)^2-(Priv.nrSessions))/2;
    sessBandTable = createSessBandTable( sessBlock,Priv.nrSessions );
    % create look-up table for session comparisons:
    
    trueNrSubjects = zeros(Priv.nrSessions,1);
    for ses = 1:Priv.nrSessions
        trueNrSubjects(ses) = sum(Priv.dummies(ses,:) == 0);
        trueNrSubjectPairs(ses) = trueNrSubjects(ses)*(trueNrSubjects(ses) - 1)/2;
    end
    
    for nrBand = 0:Pub.nrFreqBands
        for fr = 1:length(sessBlock)
            g = sessBandTable(1,fr);
            h = sessBandTable(2,fr);
            mMapmatResultWhole = memMaps.(Priv.PFmatMapSessionName).whole.([Priv.prefixFreqBand num2str(nrBand)]).cor;
            img = mMapmatResultWhole.([Priv.prefixSessComp num2str(sessBlock(fr))]).Data.xyzc;
            if Pub.pairedSessionComp 
	             img_tmp = sum(img,4)/nrSubjectPairs; % JT
            else
                load([Priv.PFsessionDestination 'band' num2str(nrBand) 'ZsumStat' num2str(sessBlock(fr))],'PFdata3D')
                img_tmp = PFdata3D; % JT 19.1.2018 
                % it is more safe to proceed this way as there may
                % be studentization and the thresholds correspond to the studentisized versions 
                
%                 ind1 = 1:trueNrSubjectPairs(g);
%                 ind2 = (nrSubjectPairs + 1):(nrSubjectPairs + trueNrSubjectPairs(h));
%                 img_tmp = sum(img(:,:,:,ind1),4)/trueNrSubjectPairs(g) + ...
%                  sum(img(:,:,:,ind2),4)/trueNrSubjectPairs(h);
            end 
             % added division by nrSubjectPairs by JT 23/02/16
             % for making test stat
             % more like standard Z
             % note that mean won't work for unpaired test
             
             % Commented this for now as session comparsion fullstats nii
             % is hardly needed by anyone JT 18/5/2017
            % nii_out = make_nii(img, voxdim,origin,[],'ISCtoolbox');
            % save the nii to the result folder of destination
            % save_nii(nii_out,[Priv.resultsDestination 'ISCSessionComp' num2str(fr) 'Band' num2str(nrBand) '.nii']);
            
            Zsumimg = img_tmp;
            nii_out = make_nii(img_tmp, voxdim,origin,[],'ISCtoolbox');
            save_nii(nii_out,[Priv.resultsDestination 'ISCSessionComp' num2str(fr) 'Band' num2str(nrBand) 'ZSumstat.nii']);
            if Params.PublicParams.clusterThreshold > 0
               load([Priv.PFsessionDestination 'band' num2str(nrBand) 'clustersPFsessComp' num2str(sessBlock(fr))],'PFconncompSizeNeg','PFconncompSizePos');
%               load([Priv.PFsessionDestination 'band' num2str(nrBand) 'clustervalsPFsessComp' num2str(sessBlock(fr))],'PFconncompSizeNeg','PFconncompSizePos');
               nii_out = make_nii(PFconncompSizeNeg, voxdim,origin,[],'ISCtoolbox');
                
               save_nii(nii_out,[Priv.resultsDestination 'ISCSessionCompNegClusters' num2str(fr) 'Band' num2str(nrBand) '.nii']);
               nii_out = make_nii(PFconncompSizePos, voxdim,origin,[],'ISCtoolbox');
                
               save_nii(nii_out,[Priv.resultsDestination 'ISCSessionCompPosClusters' num2str(fr) 'Band' num2str(nrBand) '.nii']);
            end
            if  ~Pub.pairedSessionComp 
                load([Priv.PFsessionDestination 'band' num2str(nrBand) 'standardizedPF' num2str(sessBlock(fr))],'tdata3D','jkwSE');
                nii_out = make_nii(tdata3D, voxdim,origin,[],'ISCtoolbox');
                save_nii(nii_out,[Priv.PFsessionDestination 'standardizedPF' num2str(fr) 'Band' num2str(nrBand) '.nii']);
                nii_out = make_nii(jkwSE, voxdim,origin,[],'ISCtoolbox');
                save_nii(nii_out,[Priv.PFsessionDestination 'standardErrorPF' num2str(fr) 'Band' num2str(nrBand) '.nii']);
                load([Priv.PFsessionDestination 'band' num2str(nrBand) 'pvalmaps3D' num2str(sessBlock(fr))]);
                tmp_img = ones(PFsize(1:3));
                tmp_img(indbmaskorig) = pVs;
                nii_out = make_nii(tmp_img, voxdim,origin,[],'ISCtoolbox');
                save_nii(nii_out,[Priv.PFsessionDestination 'pvalmaps3D' num2str(fr) 'Band' num2str(nrBand) '.nii']);
                load([Priv.PFsessionDestination 'band' num2str(nrBand) 'pvalmaps3Dindvox' num2str(sessBlock(fr))]);
                tmp_img = ones(PFsize(1:3));
                tmp_img(indbmaskorig) = pVsindvox;
                nii_out = make_nii(tmp_img, voxdim,origin,[],'ISCtoolbox');
                save_nii(nii_out,[Priv.PFsessionDestination 'pvalmapsindvox3D' num2str(fr) 'Band' num2str(nrBand) '.nii']);
                % make z-transform of p-values; note that p-values are
                % 2-sided: multiply by sign of the original statistic to
                % make z directional
                z_nonparametric = zeros(PFsize(1:3));
                pVsindvox = pVsindvox + (pVsindvox == 0)*eps;
                z_nonparametric(indbmaskorig) = -sqrt(2).*erfcinv(2*(1 - pVsindvox/2));
                z_nonparametric(indbmaskorig) = z_nonparametric(indbmaskorig).*sign(Zsumimg(indbmaskorig));
                save([Priv.PFsessionDestination 'band' num2str(nrBand) 'Z_nonparametric' num2str(sessBlock(fr))],'z_nonparametric')
                nii_out = make_nii(z_nonparametric, voxdim,origin,[],'ISCtoolbox');
                save_nii(nii_out,[Priv.PFsessionDestination 'z_nonparametric' num2str(fr) 'Band' num2str(nrBand) '.nii']);
            end   
        end
    end
end

if Params.PublicParams.FuSeOn
    disp('Saving the Functional Segmentation Clusters Nifti')
    %this part creates nifti results from FuSe clustering
    reg = {'NonRegularized','Regularized'};
    diag = {'Full','Diagonal'};
    if Pub.FuSe_multiK
        Kval = Pub.FuSe_minK:Pub.FuSe_stepK:Pub.FuSe_maxK;
    else
        Kval = Pub.FuSe_K;
    end
    for K = Kval;
        disp(['Saving K = ' num2str(K)])
        ClustPath = [Params.PublicParams.dataDestination 'FuSe/FuSeClusters_Fset' ...
        num2str(Pub.FuSe_FSet) '_K' num2str(K) '_' diag{Pub.FuSe_Diag+1} '_' ...
        reg{Pub.FuSe_reg_opt+1} '.mat'];
        %load(ClustPath,'Clust');
        Clust = load(ClustPath);
        if strcmp(Pub.fileFormat,'nii')
            bmask = load_nii([Priv.brainMask]);
            bmaskImg = single(bmask.img);
        elseif strcmp(Pub.fileFormat,'mat')
            bmask = load(Priv.brainMask);
            fiel = fields(bmask);
            bmask = bmask.(fiel{1});
            bmaskImg = single(bmask);
        else
            error('Mask must be mat- or nii-file!')
        end
        bmaskImg = logical(bmaskImg);

        %find the common brain voxels
        %brain_voxels = find(bmaskImg == 1);

        % set clusters to anatomical image:
        brainsize = size(bmaskImg);
        %map the results back to the spatial domain
        result = zeros(brainsize);
        
        if Pub.FuSe_mask
            Fmask = load(Pub.FuSeMaskPath);
            Fnames = fieldnames(Fmask);
            result(logical(Fmask.(Fnames{1}))) = Clust.idx;
        else
            result(bmaskImg)=Clust.idx;
        end
        
        bmask.img = uint32(result);
        bmask.hdr.dime.datatype = 768;

        save_nii(bmask,[Priv.resultsDestination 'FuSeClusters_Fset_' num2str(Pub.FuSe_FSet) ...
            '_K_' num2str(K) '_' diag{Pub.FuSe_Diag+1} '_' reg{Pub.FuSe_reg_opt+1} '.nii'])
    end
end
clear memMaps;