function Params = testParamsMat(Params)
% function tests if all fields exits in the Params struct
% This function maintains the backward compatibility of ISCToolbox
% In the case of older analysis the setup file Params struct does not 
% contain all requested fields of the newer version
% 
% Changes in Params-struct over versions:
% after r312 (2018), added switch for studentization, GSR and GCC (06/04/18 JPK)
% after r221 (2016), added stuff for the group comparisons (13/12/16 JT)
% Version 1.2 (2012), added field for gridComputing and two removal fields
% Version 1.1 (2011), original struct 
% Version 1.0 (2010), original struct 

%Priv = Params.PrivateParams;
Pub = Params.PublicParams;

disp('Testing the compatibility of the loaded Parameters...')

if(~isfield(Pub,'disableGrid'))
    disp('Field disableGrid not found: adding the field...')
    Params.PublicParams.disableGrid = ispc; %If Windows, the grid is disabled
end

if(~isfield(Pub,'gridParams'))
    disp('Field gridParams not found: adding the field...')
    Params.PublicParams.gridParams = '--partition=normal --mem=10096 --time=2-0'; %If Windows, the grid is disabled
end

if(~isfield(Pub,'removeMemmaps'))
    disp('Field removeMemmaps not found: adding the field...')
    Params.PublicParams.removeMemmaps = false;
end

if(~isfield(Pub,'removeFiltermaps'))
        disp('Field removeFiltermaps not found: adding the field...')
    Params.PublicParams.removeFiltermaps = false;
end

if(~isfield(Pub,'permutSessionComp'))
        disp('Field permutSessionComp not found: adding the field...')
    Params.PublicParams.permutSessionComp = 25000;
end

if(~isfield(Pub,'sessionCompOn'))
        disp('Field sessionCompOn not found: adding the field...')
    Params.PublicParams.sessionCompOn = false;
end

if(~isfield(Pub,'permutFreqComp'))
        disp('Field permutFreqComp not found: adding the field...')
    Params.PublicParams.permutFreqComp = 25000;
end

%is the following field the same as earlier nrPermutationsZPF?
if(~isfield(Pub,'freqCompOn'))
        disp('Field freqCompOn not found: adding the field...')
    Params.PublicParams.freqCompOn = false;
end

if(~isfield(Pub,'FuSeOn'))
        disp('Field FuSeOn not found: adding the field...')
    Params.PublicParams.FuSeOn = false;
end

if(~isfield(Pub,'clusterThreshold'))
    disp('Field clusterThreshold not found: adding the field...')
    Params.PublicParams.clusterThreshold = 0; % set to 0 if the cluster based correction is not desired 
end

if(~isfield(Pub,'clusterCorrType'))
    disp('Field clusterCorrType not found: adding the field...')
    Params.PublicParams.clusterCorrType = 1; % 1 cluster extent correction (the only one implemented at the moment)
end                                 % 2 cluster mass correction
								  % 3 TFCE correction (not implemented yet) 
if(~isfield(Pub,'pairedSessionComp'))	
    disp('Field pairedSessionComp not found: adding the field...')							  
    Params.PublicParams.pairedSessionComp = 1; % is the comparison paired or not
end
if(~isfield(Pub,'permutationType'))
     disp('Field permutationType not found: adding the field...')
     Params.PublicParams.permutationType = 1;
end

if(~isfield(Pub,'FuSe_K'))
     disp('Field FuSe_K_temp not found: adding the field...')
     Params.PublicParams.FuSe_K = 275;
end
if(~isfield(Pub,'FuSe_minK'))
     disp('Field FuSe_minK not found: adding the field...')
     Params.PublicParams.FuSe_minK = 50;
end
if(~isfield(Pub,'FuSe_maxK'))
     disp('Field FuSe_maxK not found: adding the field...')
     Params.PublicParams.FuSe_maxK = 275;
end
if(~isfield(Pub,'FuSe_stepK'))
     disp('Field FuSe_stepK not found: adding the field...')
     Params.PublicParams.FuSe_stepK = 10;
end
if(~isfield(Pub,'FuSe_multiK'))
     disp('Field FuSe_multiK not found: adding the field...')
     Params.PublicParams.FuSe_multiK = false;
end
if(~isfield(Pub,'FuSe_mask'))
     disp('Field FuSe_mask not found: adding the field...')
     Params.PublicParams.FuSe_mask = false;
end
if(~isfield(Pub,'FuSe_Diag'))
     disp('Field FuSe_Diag not found: adding the field...')
     Params.PublicParams.FuSe_Diag = false;
end
if(~isfield(Pub,'FuSe_FSet'))
     disp('Field FuSe_FSet not found: adding the field...')
     Params.PublicParams.FuSe_FSet = 2;
end
if(~isfield(Pub,'FuSe_reg'))
     disp('Field FuSe_reg not found: adding the field...')
     Params.PublicParams.FuSe_reg = false;
end
if(~isfield(Pub,'FuSe_remove_temp'))
     disp('Field FuSe_remove_temp not found: adding the field...')
     Params.PublicParams.FuSe_remove_temp = false;
end
if(~isfield(Pub,'FuSeMaskPath'))
     disp('Field FuSeMaskPath not found: adding the field...')
     Params.PublicParams.FuSeMaskPath = '/home/path/to/fuse/mask.mat';
end
if(~isfield(Pub,'mainProcessGrid'))
     disp('Field mainProcessGrid not found: adding the field...')
     Params.PublicParams.mainProcessGrid = false;
end
if(~isfield(Pub,'gridType'))
    disp('Field gridType not found: adding the field...')
    Params.PublicParams.gridType = '';
end 
if(~isfield(Pub,'noParallelization'))
    disp('Field noParallelization not found: adding the field...')
    Params.PublicParams.noParallelization = false;
end 

if ~isfield(Pub,'globalCorrCorrection')
    Params.PublicParams.globalCorrCorrection = 0;
end
if ~isfield(Pub,'GSR')
    Params.PublicParams.GSR = 0;
end
if ~isfield(Pub,'studentize')
    Params.PublicParams.studentize = 0;
end
