% This function updates the Params struct for the older version of the toolbox
% to contain necessary fields for the new version. It reads the Params
% struct in the file Paramsfn, embeds the new fields, and saves the new Params struct.
% Jussi Tohka 13th March 2018
% Currently only adds the fields GSR, globalCorrCorrection, studentize 

function Params = updateParams(Paramsfn)

load(Paramsfn);
Pub = Params.PublicParams; 

if ~isfield(Pub,'globalCorrCorrection')
    Pub.globalCorrCorrection = 0;
end
if ~isfield(Pub,'GSR')
    Pub.GSR = 0;
end
if ~isfield(Pub,'studentize')
    Pub.studentize = 0;
end

Params.PublicParams = Pub;
save(Paramsfn,'Params');

